/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.ReplaceableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J!\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\tR\u0016\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/indexing/shared/platform/impl/ReplaceableZipStorage;", "Lcom/intellij/indexing/shared/platform/api/ReplaceableSharedIndexStorage;", "chunkId", "", "lineup", "storageDir", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;)V", "getChunkId", "()Ljava/lang/String;", "closed", "", "deleted", "<set-?>", "", "generation", "getGeneration", "()J", "setGeneration", "(J)V", "generation$delegate", "Lkotlin/properties/ReadWriteProperty;", "getLineup", "storagePath", "kotlin.jvm.PlatformType", "zipStorage", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "close", "", "deleteStorage", "ensureValid", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getChunkRoot", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "openZip", "readGeneration", "chunkRoot", "replaceChunk", "newChunk", "intellij.indexing.shared"})
public final class ReplaceableZipStorage
implements ReplaceableSharedIndexStorage {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Path storagePath;
    private UncompressedZipFileSystem zipStorage;
    @NotNull
    private final ReadWriteProperty generation$delegate;
    private boolean deleted;
    private boolean closed;
    @NotNull
    private final String chunkId;
    @NotNull
    private final String lineup;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ReplaceableZipStorage.class, "generation", "getGeneration()J", 0))};
    }

    @Override
    public long getGeneration() {
        return ((Number)this.generation$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    public void setGeneration(long l) {
        this.generation$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)l);
    }

    @Override
    public void replaceChunk(@NotNull Path newChunk) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newChunk, (String)"newChunk");
        this.ensureValid((Function0)new Function0<Unit>(this, newChunk){
            final /* synthetic */ ReplaceableZipStorage this$0;
            final /* synthetic */ Path $newChunk;

            public final void invoke() {
                ReplaceableZipStorage.access$getZipStorage$p(this.this$0).close();
                Path path = ReplaceableZipStorage.access$getStoragePath$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"storagePath");
                PathKt.copy((Path)this.$newChunk, (Path)path);
                ReplaceableZipStorage.access$openZip(this.this$0);
            }
            {
                this.this$0 = replaceableZipStorage;
                this.$newChunk = path;
                super(0);
            }
        });
    }

    private final void openZip() {
        UncompressedZipFileSystem uncompressedZipFileSystem = UncompressedZipFileSystem.create(this.storagePath);
        Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"UncompressedZipFileSystem.create(storagePath)");
        UncompressedZipFileSystem uncompressedZipFileSystem2 = this.zipStorage = uncompressedZipFileSystem;
        if (uncompressedZipFileSystem2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipStorage");
        }
        Path path = uncompressedZipFileSystem2.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"zipStorage.rootDirectory");
        this.setGeneration(this.readGeneration(path));
    }

    @Override
    public void deleteStorage() {
        this.ensureValid((Function0)new Function0<Unit>(this){
            final /* synthetic */ ReplaceableZipStorage this$0;

            public final void invoke() {
                this.this$0.close();
                ReplaceableZipStorage.access$setDeleted$p(this.this$0, true);
            }
            {
                this.this$0 = replaceableZipStorage;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        return (SharedIndexStats)this.ensureValid((Function0)new Function0<SharedIndexStats>(this){
            final /* synthetic */ ReplaceableZipStorage this$0;

            @NotNull
            public final SharedIndexStats invoke() {
                Object object;
                Object object2 = this.this$0;
                try {
                    ReplaceableZipStorage $this$runCatching = object2;
                    boolean bl = false;
                    Path path = ReplaceableZipStorage.access$getStoragePath$p($this$runCatching);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"storagePath");
                    object = Result.constructor-impl((Object)PathKt.size((Path)path));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                object = 0L;
                long size = ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).longValue();
                return new SharedIndexStats(size, 1);
            }
            {
                this.this$0 = replaceableZipStorage;
                super(0);
            }
        });
    }

    @Override
    public boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return (Boolean)this.ensureValid((Function0)new Function0<Boolean>(this, chunkId){
            final /* synthetic */ ReplaceableZipStorage this$0;
            final /* synthetic */ String $chunkId;

            public final boolean invoke() {
                return Intrinsics.areEqual((Object)this.this$0.getChunkId(), (Object)this.$chunkId);
            }
            {
                this.this$0 = replaceableZipStorage;
                this.$chunkId = string;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public Path getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Object t = this.ensureValid((Function0)new Function0<Path>(this){
            final /* synthetic */ ReplaceableZipStorage this$0;

            @NotNull
            public final Path invoke() {
                return ReplaceableZipStorage.access$getZipStorage$p(this.this$0).getRootDirectory();
            }
            {
                this.this$0 = replaceableZipStorage;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"ensureValid {\n    zipStorage.rootDirectory\n  }");
        return (Path)t;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private final <T> T ensureValid(Function0<? extends T> operation) {
        boolean bl;
        boolean bl2 = bl = !this.closed && !this.deleted;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (T)operation.invoke();
    }

    private final long readGeneration(Path chunkRoot) {
        Object object = SharedIndexMetadata.Companion.readSharedIndexMetadata(chunkRoot);
        if (object == null || (object = ((SharedIndexMetadata)object).getSharedIndexInfo()) == null || (object = ((SharedIndexMetadataInfo)object).getLineup()) == null) {
            throw (Throwable)new IOException("can't read generation stamp");
        }
        return ((SharedIndexLineup)object).getCreationStamp();
    }

    @Override
    @NotNull
    public String getChunkId() {
        return this.chunkId;
    }

    @Override
    @NotNull
    public String getLineup() {
        return this.lineup;
    }

    public ReplaceableZipStorage(@NotNull String chunkId, @NotNull String lineup, @NotNull Path storageDir) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)lineup, (String)"lineup");
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        this.chunkId = chunkId;
        this.lineup = lineup;
        this.storagePath = storageDir.resolve(this.getChunkId() + "-" + this.getLineup() + ".ijx");
        this.generation$delegate = Delegates.INSTANCE.notNull();
        this.openZip();
    }

    @Override
    @NotNull
    public String getStorageId() {
        return ReplaceableSharedIndexStorage.DefaultImpls.getStorageId(this);
    }

    @Override
    public boolean containsChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        return ReplaceableSharedIndexStorage.DefaultImpls.containsChunk(this, chunkId);
    }

    public static final /* synthetic */ UncompressedZipFileSystem access$getZipStorage$p(ReplaceableZipStorage $this) {
        UncompressedZipFileSystem uncompressedZipFileSystem = $this.zipStorage;
        if (uncompressedZipFileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipStorage");
        }
        return uncompressedZipFileSystem;
    }

    public static final /* synthetic */ void access$setZipStorage$p(ReplaceableZipStorage $this, UncompressedZipFileSystem uncompressedZipFileSystem) {
        $this.zipStorage = uncompressedZipFileSystem;
    }

    public static final /* synthetic */ Path access$getStoragePath$p(ReplaceableZipStorage $this) {
        return $this.storagePath;
    }

    public static final /* synthetic */ void access$openZip(ReplaceableZipStorage $this) {
        $this.openZip();
    }

    public static final /* synthetic */ boolean access$getDeleted$p(ReplaceableZipStorage $this) {
        return $this.deleted;
    }

    public static final /* synthetic */ void access$setDeleted$p(ReplaceableZipStorage $this, boolean bl) {
        $this.deleted = bl;
    }
}

