/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generate;

import com.google.common.collect.Maps;
import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class StubHashBasedIndexGenerator
extends HashBasedIndexGenerator<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubHashBasedIndexGenerator.class);
    private final Map<StubIndexKey<?, ?>, HashBasedIndexGenerator<?, ?>> myStubIndexesGeneratorMap;
    @NotNull
    private final Set<FileType> myNoStubTreeFileTypes;

    public StubHashBasedIndexGenerator(@NotNull Path chunkRoot, @NotNull List<StubIndexExtension<?, ?>> stubIndexExtensions, @NotNull Set<FileType> noStubTreeFileTypes) {
        if (chunkRoot == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(0);
        }
        if (stubIndexExtensions == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(1);
        }
        if (noStubTreeFileTypes == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(2);
        }
        super(new StubUpdatingIndex(), chunkRoot);
        this.myStubIndexesGeneratorMap = new HashMap();
        for (StubIndexExtension<?, ?> stubIndexExtension : stubIndexExtensions) {
            this.myStubIndexesGeneratorMap.put(stubIndexExtension.getKey(), this.createGenerator(stubIndexExtension));
        }
        this.myNoStubTreeFileTypes = noStubTreeFileTypes;
        LOG.info("Stub trees will not be saved for " + this.myNoStubTreeFileTypes + " file types");
    }

    @NotNull
    private <K, V extends PsiElement> HashBasedIndexGenerator<K, Void> createGenerator(StubIndexExtension<K, V> stubIndexExtension) {
        FileBasedIndexExtension extension2 = StubIndexEx.wrapStubIndexExtension(stubIndexExtension);
        return new HashBasedIndexGenerator(extension2, this.getIndexRoot());
    }

    @NotNull
    public List<HashBasedIndexGenerator<?, ?>> getStubGenerators() {
        return new ArrayList(this.myStubIndexesGeneratorMap.values());
    }

    @Override
    protected void visitInputData(int hashId, @NotNull InputData<Integer, SerializedStubTree> data) throws StorageException {
        if (data == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(3);
        }
        super.visitInputData(hashId, data);
        SerializedStubTree tree = (SerializedStubTree)ContainerUtil.getFirstItem(data.getKeyValues().values());
        if (tree == null) {
            return;
        }
        Map map = tree.getStubIndicesValueMap();
        for (Map.Entry entry : map.entrySet()) {
            StubIndexKey key = (StubIndexKey)entry.getKey();
            Map value = (Map)entry.getValue();
            MapReduceIndex index2 = (MapReduceIndex)this.myStubIndexesGeneratorMap.get(key).getIndex();
            Map reducedValue = Maps.asMap(value.keySet(), k -> null);
            UpdateData updateData = new UpdateData(hashId, reducedValue, () -> new EmptyInputDataDiffBuilder(hashId), index2.getExtension().getName(), null);
            index2.updateWithMap((AbstractUpdateData)updateData);
        }
    }

    @Override
    @NotNull
    protected Map<Integer, SerializedStubTree> transformIndexedData(@NotNull Map<Integer, SerializedStubTree> data, @NotNull FileContent content) {
        if (data == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(4);
        }
        if (content == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(5);
        }
        if (!this.myNoStubTreeFileTypes.contains(content.getFileType())) {
            Map<Integer, SerializedStubTree> map = data;
            if (map == null) {
                StubHashBasedIndexGenerator.$$$reportNull$$$0(6);
            }
            return map;
        }
        if (data.isEmpty()) {
            Map<Integer, SerializedStubTree> map = data;
            if (map == null) {
                StubHashBasedIndexGenerator.$$$reportNull$$$0(7);
            }
            return map;
        }
        SerializedStubTree tree = (SerializedStubTree)ContainerUtil.getFirstItem(data.values());
        if (tree == null) {
            Map<Integer, SerializedStubTree> map = data;
            if (map == null) {
                StubHashBasedIndexGenerator.$$$reportNull$$$0(8);
            }
            return map;
        }
        tree = tree.withoutStub();
        Integer id = (Integer)ContainerUtil.getFirstItem(data.keySet());
        Map<Integer, SerializedStubTree> map = Collections.singletonMap(id, tree);
        if (map == null) {
            StubHashBasedIndexGenerator.$$$reportNull$$$0(9);
        }
        return map;
    }

    @Override
    public void openIndex() throws IOException {
        super.openIndex();
        for (HashBasedIndexGenerator<?, ?> generator : this.myStubIndexesGeneratorMap.values()) {
            generator.openIndex();
        }
    }

    @Override
    public void closeIndex() throws IOException {
        super.closeIndex();
        for (Map.Entry<StubIndexKey<?, ?>, HashBasedIndexGenerator<?, ?>> entry : this.myStubIndexesGeneratorMap.entrySet()) {
            entry.getValue().closeIndex();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexExtensions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noStubTreeFileTypes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/generate/StubHashBasedIndexGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/generate/StubHashBasedIndexGenerator";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "transformIndexedData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitInputData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "transformIndexedData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

