/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.metadata.Metadata;

public final class DeployResult {
    private final DeployRequest request;
    private Collection<Artifact> artifacts;
    private Collection<Metadata> metadata;

    public DeployResult(DeployRequest request) {
        this.request = Objects.requireNonNull(request, "deploy request cannot be null");
        this.artifacts = Collections.emptyList();
        this.metadata = Collections.emptyList();
    }

    public DeployRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public DeployResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? Collections.emptyList() : artifacts;
        return this;
    }

    public DeployResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            if (this.artifacts.isEmpty()) {
                this.artifacts = new ArrayList<Artifact>();
            }
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public DeployResult setMetadata(Collection<Metadata> metadata2) {
        this.metadata = metadata2 == null ? Collections.emptyList() : metadata2;
        return this;
    }

    public DeployResult addMetadata(Metadata metadata2) {
        if (metadata2 != null) {
            if (this.metadata.isEmpty()) {
                this.metadata = new ArrayList<Metadata>();
            }
            this.metadata.add(metadata2);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

