/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.ArtifactType;

public final class DefaultArtifact
extends AbstractArtifact {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public DefaultArtifact(String coords) {
        this(coords, Collections.emptyMap());
    }

    public DefaultArtifact(String coords, Map<String, String> properties2) {
        Matcher m = COORDINATE_PATTERN.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.extension = DefaultArtifact.get(m.group(4), "jar");
        this.classifier = DefaultArtifact.get(m.group(6), "");
        this.version = m.group(7);
        this.file = null;
        this.properties = DefaultArtifact.copyProperties(properties2);
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    public DefaultArtifact(String groupId, String artifactId, String extension, String version) {
        this(groupId, artifactId, "", extension, version);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier2, String extension, String version) {
        this(groupId, artifactId, classifier2, extension, version, null, (File)null);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier2, String extension, String version, ArtifactType type2) {
        this(groupId, artifactId, classifier2, extension, version, null, type2);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier2, String extension, String version, Map<String, String> properties2, ArtifactType type2) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = classifier2 != null || type2 == null ? DefaultArtifact.emptify(classifier2) : DefaultArtifact.emptify(type2.getClassifier());
        this.extension = extension != null || type2 == null ? DefaultArtifact.emptify(extension) : DefaultArtifact.emptify(type2.getExtension());
        this.version = DefaultArtifact.emptify(version);
        this.file = null;
        this.properties = DefaultArtifact.merge(properties2, type2 != null ? type2.getProperties() : null);
    }

    private static Map<String, String> merge(Map<String, String> dominant, Map<String, String> recessive) {
        Map<String, String> properties2;
        if ((dominant == null || dominant.isEmpty()) && (recessive == null || recessive.isEmpty())) {
            properties2 = Collections.emptyMap();
        } else {
            properties2 = new HashMap();
            if (recessive != null) {
                properties2.putAll(recessive);
            }
            if (dominant != null) {
                properties2.putAll(dominant);
            }
            properties2 = Collections.unmodifiableMap(properties2);
        }
        return properties2;
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier2, String extension, String version, Map<String, String> properties2, File file) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier2);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = DefaultArtifact.copyProperties(properties2);
    }

    DefaultArtifact(String groupId, String artifactId, String classifier2, String extension, String version, File file, Map<String, String> properties2) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier2);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = properties2;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

