/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0016J\b\u0010*\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "i", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "reader", "Ljava/io/Reader;", "_source", "", "(Ljava/io/Reader;[C)V", "<set-?>", "", "source", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "threshold", "", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeKeyString", "", "consumeNextToken", "", "ensureHaveChars", "indexOf", "char", "", "startPos", "prefetchOrEof", "position", "preload", "spaceLeft", "substring", "endPos", "tryConsumeComma", "kotlinx-serialization-json"})
public final class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final Reader reader;
    @NotNull
    private char[] _source;
    private int threshold;
    @NotNull
    private CharSequence source;

    public ReaderJsonLexer(@NotNull Reader reader, @NotNull char[] _source) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(_source, "_source");
        this.reader = reader;
        this._source = _source;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this._source);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(Reader reader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = new char[16384];
        }
        this(reader, cArray);
    }

    public ReaderJsonLexer(@NotNull InputStream i, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Reader reader = new InputStreamReader(i, charset);
        int n = 262144;
        this(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n), null, 2, null);
    }

    public /* synthetic */ ReaderJsonLexer(InputStream inputStream, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(inputStream, charset);
    }

    @Override
    @NotNull
    protected CharSequence getSource() {
        return this.source;
    }

    public void setSource(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "<set-?>");
        this.source = charSequence;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int spaceLeft) {
        int actual;
        char[] buffer = this._source;
        System.arraycopy(buffer, this.currentPosition, buffer, 0, spaceLeft);
        int sizeTotal = this._source.length;
        for (int read = spaceLeft; read != sizeTotal; read += actual) {
            actual = this.reader.read(buffer, read, sizeTotal - read);
            if (actual != -1) continue;
            char[] cArray = Arrays.copyOf(this._source, read);
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(this, newSize)");
            this._source = cArray;
            this.setSource(new ArrayAsSequence(this._source));
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || this.getSource().length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void ensureHaveChars() {
        int oldSize = this._source.length;
        int cur = this.currentPosition;
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                this.fail$kotlinx_serialization_json((byte)1);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        char[] src = this._source;
        int n = src.length;
        for (int i = startPos; i < n; ++i) {
            if (src[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return new String(this._source, startPos, endPos - startPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        this.getEscapedString().append(this._source, fromIndex, toIndex - fromIndex);
    }
}

