/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml;

import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereTabWithMl;
import com.intellij.ide.actions.searcheverywhere.ml.settings.SearchEverywhereMlSettings;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SearchEverywhereMlExperiment {
    private static final int NUMBER_OF_GROUPS = 4;
    private final boolean myIsExperimentalMode = StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();
    private final Set<String> myTabsWithEnabledLogging;
    private final Map<SearchEverywhereTabWithMl, Experiment> myTabExperiments = SearchEverywhereMlExperiment.createExperiments();

    public SearchEverywhereMlExperiment() {
        this.myTabsWithEnabledLogging = ContainerUtil.newHashSet((Object[])new String[]{SearchEverywhereTabWithMl.ACTION.getTabId(), SearchEverywhereTabWithMl.FILES.getTabId(), ClassSearchEverywhereContributor.class.getSimpleName(), SymbolSearchEverywhereContributor.class.getSimpleName(), "SearchEverywhereContributor.All"});
    }

    private static HashMap<SearchEverywhereTabWithMl, Experiment> createExperiments() {
        return new HashMap<SearchEverywhereTabWithMl, Experiment>(3){
            {
                this.put(SearchEverywhereTabWithMl.ACTION, new Experiment().addExperiment(ExperimentType.NO_ML, 1).addExperiment(ExperimentType.USE_EXPERIMENTAL_MODEL, 2));
                this.put(SearchEverywhereTabWithMl.FILES, new Experiment().addExperiment(ExperimentType.USE_EXPERIMENTAL_MODEL, 3));
            }
        };
    }

    public boolean isAllowed() {
        SearchEverywhereMlSettings settings = (SearchEverywhereMlSettings)ApplicationManager.getApplication().getService(SearchEverywhereMlSettings.class);
        return settings.isSortingByMlEnabledInAnyTab() || !this.isDisableLoggingAndExperiments();
    }

    public boolean isLoggingEnabledForTab(@NotNull String tabId) {
        if (tabId == null) {
            SearchEverywhereMlExperiment.$$$reportNull$$$0(0);
        }
        return this.myTabsWithEnabledLogging.contains(tabId);
    }

    @NotNull
    public ExperimentType getExperimentForTab(@NotNull SearchEverywhereTabWithMl tab) {
        if (tab == null) {
            SearchEverywhereMlExperiment.$$$reportNull$$$0(1);
        }
        if (this.isDisableLoggingAndExperiments() || SearchEverywhereMlExperiment.isDisableExperiments(tab)) {
            ExperimentType experimentType = ExperimentType.NO_EXPERIMENT;
            if (experimentType == null) {
                SearchEverywhereMlExperiment.$$$reportNull$$$0(2);
            }
            return experimentType;
        }
        Experiment tabExperiment = this.myTabExperiments.get((Object)tab);
        if (tabExperiment == null) {
            ExperimentType experimentType = ExperimentType.NO_EXPERIMENT;
            if (experimentType == null) {
                SearchEverywhereMlExperiment.$$$reportNull$$$0(3);
            }
            return experimentType;
        }
        ExperimentType experimentType = tabExperiment.getExperimentByGroup(this.getExperimentGroup());
        if (experimentType == null) {
            SearchEverywhereMlExperiment.$$$reportNull$$$0(4);
        }
        return experimentType;
    }

    private boolean isDisableLoggingAndExperiments() {
        return !this.myIsExperimentalMode || Registry.is((String)"search.everywhere.force.disable.logging.ml");
    }

    private static boolean isDisableExperiments(@NotNull SearchEverywhereTabWithMl tab) {
        if (tab == null) {
            SearchEverywhereMlExperiment.$$$reportNull$$$0(5);
        }
        String key = String.format("search.everywhere.force.disable.experiment.%s.ml", tab.name().toLowerCase(Locale.ROOT));
        return Registry.is((String)key);
    }

    public int getExperimentGroup() {
        if (!this.myIsExperimentalMode) {
            return -1;
        }
        int experimentGroup = EventLogConfiguration.getInstance().getBucket() % 4;
        int registryExperimentGroup = Registry.intValue((String)"search.everywhere.ml.experiment.group");
        return registryExperimentGroup >= 0 ? registryExperimentGroup : experimentGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ml/SearchEverywhereMlExperiment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ml/SearchEverywhereMlExperiment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExperimentForTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLoggingEnabledForTab";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExperimentForTab";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDisableExperiments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Experiment {
        private final Map<Integer, ExperimentType> myExperiments = new HashMap<Integer, ExperimentType>(3);

        private Experiment() {
        }

        @NotNull
        Experiment addExperiment(@NotNull ExperimentType type, int group) {
            if (type == null) {
                Experiment.$$$reportNull$$$0(0);
            }
            this.myExperiments.put(group, type);
            Experiment experiment = this;
            if (experiment == null) {
                Experiment.$$$reportNull$$$0(1);
            }
            return experiment;
        }

        @NotNull
        public ExperimentType getExperimentByGroup(int group) {
            ExperimentType experimentType = this.myExperiments.getOrDefault(group, ExperimentType.NO_EXPERIMENT);
            if (experimentType == null) {
                Experiment.$$$reportNull$$$0(2);
            }
            return experimentType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ml/SearchEverywhereMlExperiment$Experiment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ml/SearchEverywhereMlExperiment$Experiment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addExperiment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExperimentByGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addExperiment";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ExperimentType {
        NO_EXPERIMENT,
        NO_ML,
        USE_EXPERIMENTAL_MODEL;

    }
}

