/*
 * Decompiled with CFR 0.152.
 */
package tlschannel.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tlschannel.NeedsReadException;
import tlschannel.NeedsTaskException;
import tlschannel.NeedsWriteException;
import tlschannel.TlsChannelCallbackException;
import tlschannel.TrackingAllocator;
import tlschannel.WouldBlockException;
import tlschannel.impl.BufferHolder;
import tlschannel.impl.ByteBufferSet;
import tlschannel.util.Util;

public class TlsChannelImpl
implements ByteChannel {
    private static final Logger logger = LoggerFactory.getLogger(TlsChannelImpl.class);
    public static final int buffersInitialSize = 4096;
    public static final int maxTlsPacketSize = 17408;
    private final ReadableByteChannel readChannel;
    private final WritableByteChannel writeChannel;
    private final SSLEngine engine;
    private final BufferHolder inEncrypted;
    private final Consumer<SSLSession> initSessionCallback;
    private final boolean runTasks;
    private final TrackingAllocator encryptedBufAllocator;
    private final TrackingAllocator plainBufAllocator;
    private final boolean waitForCloseConfirmation;
    private final Lock initLock = new ReentrantLock();
    private final Lock readLock = new ReentrantLock();
    private final Lock writeLock = new ReentrantLock();
    private volatile boolean negotiated = false;
    private volatile boolean invalid = false;
    private volatile boolean shutdownSent = false;
    private volatile boolean shutdownReceived = false;
    private final BufferHolder inPlain;
    private final BufferHolder outEncrypted;
    private ByteBufferSet suppliedInPlain;
    private int bytesToReturn;
    private final ByteBufferSet dummyOut = new ByteBufferSet(new ByteBuffer[]{ByteBuffer.allocate(0)});

    public TlsChannelImpl(ReadableByteChannel readChannel, WritableByteChannel writeChannel, SSLEngine engine, Optional<BufferHolder> inEncrypted, Consumer<SSLSession> initSessionCallback, boolean runTasks, TrackingAllocator plainBufAllocator, TrackingAllocator encryptedBufAllocator, boolean releaseBuffers, boolean waitForCloseConfirmation) {
        this.readChannel = readChannel;
        this.writeChannel = writeChannel;
        this.engine = engine;
        this.inEncrypted = inEncrypted.orElseGet(() -> new BufferHolder("inEncrypted", Optional.empty(), encryptedBufAllocator, 4096, 17408, false, releaseBuffers));
        this.initSessionCallback = initSessionCallback;
        this.runTasks = runTasks;
        this.plainBufAllocator = plainBufAllocator;
        this.encryptedBufAllocator = encryptedBufAllocator;
        this.waitForCloseConfirmation = waitForCloseConfirmation;
        this.inPlain = new BufferHolder("inPlain", Optional.empty(), plainBufAllocator, 4096, 17408, true, releaseBuffers);
        this.outEncrypted = new BufferHolder("outEncrypted", Optional.empty(), encryptedBufAllocator, 4096, 17408, false, releaseBuffers);
    }

    public Consumer<SSLSession> getSessionInitCallback() {
        return this.initSessionCallback;
    }

    public TrackingAllocator getPlainBufferAllocator() {
        return this.plainBufAllocator;
    }

    public TrackingAllocator getEncryptedBufferAllocator() {
        return this.encryptedBufAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBufferSet dest) throws IOException, NeedsTaskException {
        TlsChannelImpl.checkReadBuffer(dest);
        if (!dest.hasRemaining()) {
            return 0L;
        }
        this.handshake();
        this.readLock.lock();
        try {
            if (this.invalid || this.shutdownSent) {
                throw new ClosedChannelException();
            }
            long originalDestPosition = dest.position();
            this.suppliedInPlain = dest;
            int n = this.bytesToReturn = this.inPlain.nullOrEmpty() ? 0 : this.inPlain.buffer.position();
            block14: while (true) {
                if (this.bytesToReturn > 0) {
                    if (this.inPlain.nullOrEmpty()) {
                        Util.assertTrue(dest.position() == originalDestPosition + (long)this.bytesToReturn);
                        long l = this.bytesToReturn;
                        return l;
                    }
                    Util.assertTrue(this.inPlain.buffer.position() == this.bytesToReturn);
                    long l = this.transferPendingPlain(dest);
                    return l;
                }
                if (this.shutdownReceived) {
                    long l = -1L;
                    return l;
                }
                Util.assertTrue(this.inPlain.nullOrEmpty());
                switch (this.engine.getHandshakeStatus()) {
                    case NEED_UNWRAP: 
                    case NEED_WRAP: {
                        this.writeAndHandshake();
                        continue block14;
                    }
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        this.readAndUnwrap();
                        if (!this.shutdownReceived) continue block14;
                        long l = -1L;
                        return l;
                    }
                    case NEED_TASK: {
                        this.handleTask();
                        continue block14;
                    }
                }
                break;
            }
            long l = -1L;
            return l;
        }
        catch (EofException e) {
            long l = -1L;
            return l;
        }
        finally {
            this.bytesToReturn = 0;
            this.suppliedInPlain = null;
            this.readLock.unlock();
        }
    }

    private void handleTask() throws NeedsTaskException {
        Runnable task = this.engine.getDelegatedTask();
        if (!this.runTasks) {
            logger.trace("task needed, throwing exception: {}", (Object)task);
            throw new NeedsTaskException(task);
        }
        logger.trace("delegating in task: {}", (Object)task);
        task.run();
    }

    private int transferPendingPlain(ByteBufferSet dstBuffers) {
        this.inPlain.buffer.flip();
        int bytes = dstBuffers.putRemaining(this.inPlain.buffer);
        this.inPlain.buffer.compact();
        boolean disposed = this.inPlain.release();
        if (!disposed) {
            this.inPlain.zeroRemaining();
        }
        return bytes;
    }

    private SSLEngineResult unwrapLoop() throws SSLException {
        ByteBufferSet effDest;
        if (this.suppliedInPlain != null) {
            effDest = this.suppliedInPlain;
        } else {
            this.inPlain.prepare();
            effDest = new ByteBufferSet(this.inPlain.buffer);
        }
        while (true) {
            Util.assertTrue(this.inPlain.nullOrEmpty());
            SSLEngineResult result = this.callEngineUnwrap(effDest);
            SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
            if (result.bytesProduced() > 0) {
                return result;
            }
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                return result;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                return result;
            }
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || status == SSLEngineResult.HandshakeStatus.NEED_TASK || status == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                return result;
            }
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            if (effDest == this.suppliedInPlain) {
                this.inPlain.prepare();
                if ((long)this.inPlain.buffer.capacity() <= this.suppliedInPlain.remaining()) {
                    this.inPlain.enlarge();
                }
            } else {
                this.inPlain.enlarge();
            }
            effDest = new ByteBufferSet(this.inPlain.buffer);
        }
    }

    private SSLEngineResult callEngineUnwrap(ByteBufferSet dest) throws SSLException {
        this.inEncrypted.buffer.flip();
        try {
            SSLEngineResult result = this.engine.unwrap(this.inEncrypted.buffer, dest.array, dest.offset, dest.length);
            if (logger.isTraceEnabled()) {
                logger.trace("engine.unwrap() result [{}]. engine status: {}; inEncrypted {}; inPlain: {}", new Object[]{Util.resultToString(result), this.engine.getHandshakeStatus(), this.inEncrypted, dest});
            }
            SSLEngineResult sSLEngineResult = result;
            return sSLEngineResult;
        }
        catch (SSLException e) {
            this.invalid = true;
            throw e;
        }
        finally {
            this.inEncrypted.buffer.compact();
        }
    }

    private void readFromChannel() throws IOException, EofException {
        try {
            TlsChannelImpl.callChannelRead(this.readChannel, this.inEncrypted.buffer);
        }
        catch (WouldBlockException e) {
            throw e;
        }
        catch (IOException e) {
            this.invalid = true;
            throw e;
        }
    }

    public static void callChannelRead(ReadableByteChannel readChannel, ByteBuffer buffer) throws IOException, EofException {
        Util.assertTrue(buffer.hasRemaining());
        logger.trace("Reading from channel");
        int c = readChannel.read(buffer);
        logger.trace("Read from channel; response: {}, buffer: {}", (Object)c, (Object)buffer);
        if (c == -1) {
            throw new EofException();
        }
        if (c == 0) {
            throw new NeedsReadException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBufferSet source) throws IOException {
        this.handshake();
        this.writeLock.lock();
        try {
            if (this.invalid || this.shutdownSent) {
                throw new ClosedChannelException();
            }
            long l = this.wrapAndWrite(source);
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private long wrapAndWrite(ByteBufferSet source) throws IOException {
        long bytesToConsume = source.remaining();
        this.outEncrypted.prepare();
        try {
            while (true) {
                this.writeToChannel();
                if (source.remaining() == 0L) {
                    long l = bytesToConsume;
                    return l;
                }
                this.wrapLoop(source);
            }
        }
        finally {
            this.outEncrypted.release();
        }
    }

    private void wrapLoop(ByteBufferSet source) throws SSLException {
        while (true) {
            SSLEngineResult result = this.callEngineWrap(source);
            switch (result.getStatus()) {
                case OK: 
                case CLOSED: {
                    return;
                }
                case BUFFER_OVERFLOW: {
                    Util.assertTrue(result.bytesConsumed() == 0);
                    this.outEncrypted.enlarge();
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private SSLEngineResult callEngineWrap(ByteBufferSet source) throws SSLException {
        try {
            SSLEngineResult result = this.engine.wrap(source.array, source.offset, source.length, this.outEncrypted.buffer);
            if (logger.isTraceEnabled()) {
                logger.trace("engine.wrap() result: [{}]; engine status: {}; srcBuffer: {}, outEncrypted: {}", new Object[]{Util.resultToString(result), result.getHandshakeStatus(), source, this.outEncrypted});
            }
            return result;
        }
        catch (SSLException e) {
            this.invalid = true;
            throw e;
        }
    }

    private void writeToChannel() throws IOException {
        if (this.outEncrypted.buffer.position() == 0) {
            return;
        }
        this.outEncrypted.buffer.flip();
        try {
            try {
                TlsChannelImpl.callChannelWrite(this.writeChannel, this.outEncrypted.buffer);
            }
            catch (WouldBlockException e) {
                throw e;
            }
            catch (IOException e) {
                this.invalid = true;
                throw e;
            }
        }
        finally {
            this.outEncrypted.buffer.compact();
        }
    }

    private static void callChannelWrite(WritableByteChannel channel, ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            logger.trace("calling channel.write({})", (Object)src);
            int c = channel.write(src);
            if (c != 0) continue;
            throw new NeedsWriteException();
        }
    }

    public void renegotiate() throws IOException {
        if (this.engine.getSession().getProtocol().compareTo("TLSv1.3") >= 0) {
            throw new SSLException("renegotiation not supported in TLS 1.3 or latter");
        }
        try {
            this.doHandshake(true);
        }
        catch (EofException e) {
            throw new ClosedChannelException();
        }
    }

    public void handshake() throws IOException {
        try {
            this.doHandshake(false);
        }
        catch (EofException e) {
            throw new ClosedChannelException();
        }
    }

    private void doHandshake(boolean force) throws IOException, EofException {
        block8: {
            if (!force && this.negotiated) {
                return;
            }
            this.initLock.lock();
            try {
                if (this.invalid || this.shutdownSent) {
                    throw new ClosedChannelException();
                }
                if (!force && this.negotiated) break block8;
                logger.trace("Calling SSLEngine.beginHandshake()");
                this.engine.beginHandshake();
                this.writeAndHandshake();
                if (this.engine.getSession().getProtocol().startsWith("DTLS")) {
                    throw new IllegalArgumentException("DTLS not supported");
                }
                try {
                    this.initSessionCallback.accept(this.engine.getSession());
                }
                catch (Exception e) {
                    logger.trace("client code threw exception in session initialization callback", (Throwable)e);
                    throw new TlsChannelCallbackException("session initialization callback failed", e);
                }
                this.negotiated = true;
            }
            finally {
                this.initLock.unlock();
            }
        }
    }

    private void writeAndHandshake() throws IOException, EofException {
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                Util.assertTrue(this.inPlain.nullOrEmpty());
                this.outEncrypted.prepare();
                try {
                    this.writeToChannel();
                    this.handshakeLoop();
                }
                finally {
                    this.outEncrypted.release();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void handshakeLoop() throws IOException, EofException {
        Util.assertTrue(this.inPlain.nullOrEmpty());
        block7: while (true) {
            switch (this.engine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    Util.assertTrue(this.outEncrypted.nullOrEmpty());
                    this.wrapLoop(this.dummyOut);
                    this.writeToChannel();
                    continue block7;
                }
                case NEED_UNWRAP: {
                    this.readAndUnwrap();
                    if (this.bytesToReturn <= 0) continue block7;
                    return;
                }
                case NOT_HANDSHAKING: {
                    return;
                }
                case NEED_TASK: {
                    this.handleTask();
                    continue block7;
                }
                case FINISHED: {
                    throw new IllegalStateException();
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void readAndUnwrap() throws IOException, EofException {
        this.inEncrypted.prepare();
        try {
            while (true) {
                Util.assertTrue(this.inPlain.nullOrEmpty());
                SSLEngineResult result = this.unwrapLoop();
                SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
                if (result.bytesProduced() > 0) {
                    this.bytesToReturn = result.bytesProduced();
                    return;
                }
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    this.shutdownReceived = true;
                    return;
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED || status == SSLEngineResult.HandshakeStatus.NEED_TASK || status == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return;
                }
                if (!this.inEncrypted.buffer.hasRemaining()) {
                    this.inEncrypted.enlarge();
                }
                this.readFromChannel();
            }
        }
        finally {
            this.inEncrypted.release();
        }
    }

    @Override
    public void close() throws IOException {
        this.tryShutdown();
        this.writeChannel.close();
        this.readChannel.close();
        this.readLock.lock();
        try {
            this.writeLock.lock();
            try {
                this.freeBuffers();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void tryShutdown() {
        block12: {
            if (!this.readLock.tryLock()) {
                return;
            }
            try {
                if (!this.writeLock.tryLock()) {
                    return;
                }
                try {
                    if (this.shutdownSent) break block12;
                    try {
                        boolean closed = this.shutdown();
                        if (!closed && this.waitForCloseConfirmation) {
                            this.shutdown();
                        }
                    }
                    catch (Throwable e) {
                        logger.debug("error doing TLS shutdown on close(), continuing: {}", (Object)e.getMessage());
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    public boolean shutdown() throws IOException {
        this.readLock.lock();
        try {
            block16: {
                this.writeLock.lock();
                try {
                    if (this.invalid) {
                        throw new ClosedChannelException();
                    }
                    if (this.shutdownSent) break block16;
                    this.shutdownSent = true;
                    this.outEncrypted.prepare();
                    try {
                        this.writeToChannel();
                        this.engine.closeOutbound();
                        this.wrapLoop(this.dummyOut);
                        this.writeToChannel();
                    }
                    finally {
                        this.outEncrypted.release();
                    }
                    if (this.shutdownReceived) {
                        this.freeBuffers();
                    }
                    boolean bl = this.shutdownReceived;
                    this.writeLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            if (!this.shutdownReceived) {
                try {
                    this.readAndUnwrap();
                    Util.assertTrue(this.shutdownReceived);
                }
                catch (EofException e) {
                    throw new ClosedChannelException();
                }
            }
            this.freeBuffers();
            boolean bl = true;
            this.writeLock.unlock();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void freeBuffers() {
        this.inEncrypted.dispose();
        this.inPlain.dispose();
        this.outEncrypted.dispose();
    }

    @Override
    public boolean isOpen() {
        return !this.invalid && this.writeChannel.isOpen() && this.readChannel.isOpen();
    }

    public static void checkReadBuffer(ByteBufferSet dest) {
        if (dest.isReadOnly()) {
            throw new IllegalArgumentException();
        }
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public boolean getRunTasks() {
        return this.runTasks;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBufferSet(dst));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBufferSet(src));
    }

    public boolean shutdownReceived() {
        return this.shutdownReceived;
    }

    public boolean shutdownSent() {
        return this.shutdownSent;
    }

    public ReadableByteChannel plainReadableChannel() {
        return this.readChannel;
    }

    public WritableByteChannel plainWritableChannel() {
        return this.writeChannel;
    }

    public static class EofException
    extends Exception {
        private static final long serialVersionUID = -3859156713994602991L;

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

