/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractCompoundRule
extends Rule {
    static final int MAX_TERMS = 5;
    private final String withHyphenMessage;
    private final String withoutHyphenMessage;
    private final String withOrWithoutHyphenMessage;
    private final String shortDesc;
    protected final LinguServices linguServices;
    protected final Language lang;
    protected boolean sentenceStartsWithUpperCase = true;

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public int estimateContextForSureMatch() {
        return 1;
    }

    public abstract CompoundRuleData getCompoundRuleData();

    public AbstractCompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig, String withHyphenMessage, String withoutHyphenMessage, String withOrWithoutHyphenMessage) throws IOException {
        this(messages, lang, userConfig, withHyphenMessage, withoutHyphenMessage, withOrWithoutHyphenMessage, null);
    }

    public AbstractCompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig, String withHyphenMessage, String withoutHyphenMessage, String withOrWithoutHyphenMessage, String shortMessage) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.withHyphenMessage = withHyphenMessage;
        this.withoutHyphenMessage = withoutHyphenMessage;
        this.withOrWithoutHyphenMessage = withOrWithoutHyphenMessage;
        this.shortDesc = shortMessage;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.lang = lang;
        this.linguServices = userConfig != null ? userConfig.getLinguServices() : null;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        RuleMatch prevRuleMatch = null;
        ArrayDeque<AnalyzedTokenReadings> prevTokens = new ArrayDeque<AnalyzedTokenReadings>(5);
        for (int i2 = 0; i2 < tokens.length + 5; ++i2) {
            AnalyzedTokenReadings token = i2 >= tokens.length ? new AnalyzedTokenReadings(new AnalyzedToken("", "", null), prevTokens.peek().getStartPos()) : tokens[i2];
            if (i2 == 0) {
                AbstractCompoundRule.addToQueue(token, prevTokens);
                continue;
            }
            if (token.isImmunized()) continue;
            AnalyzedTokenReadings firstMatchToken = prevTokens.peek();
            ArrayList<String> stringsToCheck = new ArrayList<String>();
            ArrayList<String> origStringsToCheck = new ArrayList<String>();
            Map<String, AnalyzedTokenReadings> stringToToken = this.getStringToTokenMap(prevTokens, stringsToCheck, origStringsToCheck);
            for (int k = stringsToCheck.size() - 1; k >= 0; --k) {
                String[] parts;
                String stringToCheck = (String)stringsToCheck.get(k);
                String origStringToCheck = (String)origStringsToCheck.get(k);
                if (!this.getCompoundRuleData().getIncorrectCompounds().contains(stringToCheck)) continue;
                AnalyzedTokenReadings atr = stringToToken.get(stringToCheck);
                String msg = null;
                List<String> replacement = new ArrayList<String>();
                if (this.getCompoundRuleData().getDashSuggestion().contains(stringToCheck) && !origStringToCheck.contains(" ")) break;
                if (this.getCompoundRuleData().getDashSuggestion().contains(stringToCheck)) {
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                }
                if (this.isNotAllUppercase(origStringToCheck) && this.getCompoundRuleData().getJoinedSuggestion().contains(stringToCheck)) {
                    replacement.add(this.mergeCompound(origStringToCheck, this.getCompoundRuleData().getJoinedLowerCaseSuggestion().stream().anyMatch(s -> stringToCheck.contains((CharSequence)s))));
                    msg = this.withoutHyphenMessage;
                }
                if ((parts = stringToCheck.split(" ")).length > 0 && parts[0].length() == 1) {
                    replacement.clear();
                    replacement.add(origStringToCheck.replace(' ', '-'));
                    msg = this.withHyphenMessage;
                } else if (replacement.isEmpty() || replacement.size() == 2) {
                    msg = this.withOrWithoutHyphenMessage;
                }
                replacement = this.filterReplacements(replacement, sentence.getText().substring(firstMatchToken.getStartPos(), atr.getEndPos()));
                if (replacement.isEmpty()) break;
                RuleMatch ruleMatch = new RuleMatch(this, sentence, firstMatchToken.getStartPos(), atr.getEndPos(), msg, this.shortDesc);
                ruleMatch.setSuggestedReplacements(replacement);
                if (prevRuleMatch != null && prevRuleMatch.getFromPos() == ruleMatch.getFromPos()) {
                    prevRuleMatch = ruleMatch;
                    break;
                }
                prevRuleMatch = ruleMatch;
                ruleMatches.add(ruleMatch);
                break;
            }
            AbstractCompoundRule.addToQueue(token, prevTokens);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected List<String> filterReplacements(List<String> replacements, String original) throws IOException {
        ArrayList<String> newReplacements = new ArrayList<String>();
        for (String replacement : replacements) {
            String newReplacement = replacement.replaceAll("\\-\\-+", "-");
            if (newReplacement.equals(original) || !this.isCorrectSpell(newReplacement)) continue;
            newReplacements.add(newReplacement);
        }
        return newReplacements;
    }

    private Map<String, AnalyzedTokenReadings> getStringToTokenMap(Queue<AnalyzedTokenReadings> prevTokens, List<String> stringsToCheck, List<String> origStringsToCheck) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, AnalyzedTokenReadings> stringToToken = new HashMap<String, AnalyzedTokenReadings>();
        int j = 0;
        boolean isFirstSentStart = false;
        for (AnalyzedTokenReadings atr : prevTokens) {
            if (atr.isWhitespaceBefore()) {
                sb.append(' ');
            }
            sb.append(atr.getToken());
            if (j == 0) {
                isFirstSentStart = atr.hasPosTag("SENT_START");
            }
            if (j >= 1 || j == 0 && !isFirstSentStart) {
                String stringToCheck = this.normalize(sb.toString());
                if (this.sentenceStartsWithUpperCase && isFirstSentStart) {
                    stringToCheck = StringUtils.uncapitalize((String)stringToCheck);
                }
                stringsToCheck.add(stringToCheck);
                origStringsToCheck.add(sb.toString().trim());
                if (!stringToToken.containsKey(stringToCheck)) {
                    stringToToken.put(stringToCheck, atr);
                }
            }
            ++j;
        }
        return stringToToken;
    }

    private String normalize(String inStr) {
        String str = inStr.trim();
        str = str.replace(" - ", " ");
        str = str.replace("-", " ");
        str = str.replaceAll("\\s+", " ");
        return str;
    }

    private boolean isNotAllUppercase(String str) {
        String[] parts;
        for (String part : parts = str.split(" ")) {
            if ("-".equals(part) || !StringTools.isAllUppercase(part)) continue;
            return false;
        }
        return true;
    }

    public String mergeCompound(String str, boolean uncapitalizeMidWords) {
        String[] stringParts = str.replaceAll("-", " ").split(" ");
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < stringParts.length; ++k) {
            if (k == 0) {
                sb.append(stringParts[0]);
                continue;
            }
            sb.append(uncapitalizeMidWords ? StringUtils.uncapitalize((String)stringParts[k]) : stringParts[k]);
        }
        return sb.toString();
    }

    private static void addToQueue(AnalyzedTokenReadings token, ArrayDeque<AnalyzedTokenReadings> prevTokens) {
        if (prevTokens.size() == 5) {
            prevTokens.poll();
        }
        prevTokens.offer(token);
    }

    private boolean isCorrectSpell(String word) throws IOException {
        if (this.linguServices == null) {
            return !this.isMisspelled(word);
        }
        return this.linguServices.isCorrectSpell(word, this.lang);
    }

    public boolean isMisspelled(String word) throws IOException {
        return false;
    }
}

