/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.languagetool.language.LanguageIdentifier;

public class NGramLangIdentifier {
    private static final double EPSILON = 1.0E-4;
    private final Map<String, Integer> vocab;
    private final List<String[]> codes;
    private final List<Map<String, Double>> knpBigramProbs;
    private final int thresholdsStart;
    private final List<double[]> thresholds;
    private final int maxLength;
    private final ZipFile zipFile;

    public NGramLangIdentifier(File sourceModelZip, int maxLength) throws IOException {
        this.maxLength = maxLength;
        this.zipFile = new ZipFile(sourceModelZip);
        this.codes = new ArrayList<String[]>();
        try (BufferedReader br2 = this.getReader("iso_codes.tsv");){
            String line;
            while ((line = br2.readLine()) != null) {
                String[] values = line.split("\t");
                if (!values[3].equals("1")) continue;
                this.codes.add(values);
            }
        }
        this.vocab = new HashMap<String, Integer>();
        br2 = this.getReader("vocab.txt");
        var4_4 = null;
        try {
            int i2 = 0;
            while ((line = br2.readLine()) != null) {
                this.vocab.put(line.split("\t")[0].trim(), i2);
                ++i2;
            }
        }
        catch (Throwable line) {
            var4_4 = line;
            throw line;
        }
        finally {
            if (br2 != null) {
                if (var4_4 != null) {
                    try {
                        br2.close();
                    }
                    catch (Throwable line) {
                        var4_4.addSuppressed(line);
                    }
                } else {
                    br2.close();
                }
            }
        }
        this.thresholds = new ArrayList<double[]>();
        br2 = this.getReader("thresholds.txt");
        var4_4 = null;
        try {
            this.thresholdsStart = Integer.parseInt(br2.readLine());
            while ((line = br2.readLine()) != null) {
                double[] vals = Arrays.stream(line.split(" ")).mapToDouble(Double::parseDouble).toArray();
                this.thresholds.add(vals);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (br2 != null) {
                if (var4_4 != null) {
                    try {
                        br2.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    br2.close();
                }
            }
        }
        this.knpBigramProbs = ((Stream)this.expectedFiles().stream().map(this::readLines).parallel()).map(NGramLangIdentifier::loadDict).collect(Collectors.toList());
    }

    public Map<String, Double> detectLanguages(String text2, List<String> additionalLanguageCodes) {
        List<Integer> enc = this.encode(text2);
        List<Object> finalProbs = new ArrayList<Double>();
        List<int[]> keys = this.keys(enc);
        for (int i2 = 0; i2 < this.codes.size(); ++i2) {
            double val = 0.0;
            for (int[] key : keys) {
                double prob = this.knpBigramProbs.get(i2).getOrDefault(key[0] + "_" + key[1], 1.0E-4);
                val += StrictMath.log(prob);
            }
            finalProbs.add(val);
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (text2.length() >= this.thresholdsStart) {
            int argMax = 0;
            for (int i3 = 1; i3 < finalProbs.size(); ++i3) {
                if (!((Double)finalProbs.get(i3) > (Double)finalProbs.get(argMax))) continue;
                argMax = i3;
            }
            int thresholdIndex = StrictMath.min(text2.length(), this.maxLength) - this.thresholdsStart;
            if ((Double)finalProbs.get(argMax) < this.thresholds.get(thresholdIndex)[argMax]) {
                result.put("zz", 100.0);
                return result;
            }
        }
        finalProbs = finalProbs.stream().map(StrictMath::exp).collect(Collectors.toList());
        finalProbs = this.normalize(finalProbs);
        for (int i4 = 0; i4 < this.codes.size(); ++i4) {
            String langCode;
            String string = langCode = this.codes.get(i4)[1].equals("NULL") ? this.codes.get(i4)[2] : this.codes.get(i4)[1];
            if (!LanguageIdentifier.canLanguageBeDetected(langCode, additionalLanguageCodes)) continue;
            result.put(langCode, (Double)finalProbs.get(i4));
        }
        return result;
    }

    private BufferedReader getReader(String fileName2) throws IOException {
        InputStream is = this.zipFile.getInputStream(this.zipFile.getEntry(fileName2));
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        return new BufferedReader(isr);
    }

    private List<String> readLines(String path) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader br2 = this.getReader(path);){
            String line;
            while ((line = br2.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static Map<String, Double> loadDict(List<String> lines) {
        HashMap<String, Double> tm = new HashMap<String, Double>();
        for (String line : lines) {
            String[] parts = line.trim().split(" ");
            String key = String.join((CharSequence)"_", Arrays.copyOfRange(parts, 0, parts.length - 1));
            tm.put(key, Double.parseDouble(parts[parts.length - 1]));
        }
        return tm;
    }

    private List<String> expectedFiles() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i2 = 0; i2 < this.codes.size(); ++i2) {
            String name = String.format("%02d.txt", i2);
            result.add(name);
        }
        return result;
    }

    private List<Integer> encode(String text2) {
        int ci;
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(1);
        if (text2.length() > this.maxLength) {
            text2 = text2.substring(0, this.maxLength);
        }
        text2 = Normalizer.normalize(text2, Normalizer.Form.NFKC).toLowerCase();
        text2 = text2.replaceAll("\\d+", "<NUM>");
        text2 = text2.replaceAll("[\\uac00-\\ud7a3]", "<KO>");
        text2 = text2.replaceAll("[\\u3040-\\u30ff]", "<JA>");
        text2 = text2.replaceAll("[\\u4e00-\\u9FFF]", "<ZH>");
        text2 = text2.replaceAll("[\\u1780-\\u17FF]", "<KM>");
        text2 = text2.replaceAll("[\\u1700-\\u171F]", "<TL>");
        text2 = text2.replaceAll("[\\u0530-\\u058F]", "<HY>");
        text2 = text2.replaceAll("[\\u0370-\\u03FF]", "<EL>");
        text2 = text2.replaceAll("[\\u0B80-\\u0BFF]", "<TA>");
        if ((text2 = text2.replaceAll("\\s+", "\u2581")).length() == 0) {
            return result;
        }
        text2 = "\u2581" + text2;
        for (int cur = 0; cur < text2.length(); cur += ci) {
            int tok = 0;
            ci = 1;
            for (int i2 = cur + 1; i2 <= text2.length(); ++i2) {
                int maybeTok = this.vocab.getOrDefault(text2.substring(cur, i2), -1);
                if (maybeTok <= -1) continue;
                tok = maybeTok;
                ci = i2 - cur;
            }
            result.add(tok);
        }
        return result;
    }

    private List<int[]> keys(List<Integer> enc) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int i2 = 1; i2 < enc.size(); ++i2) {
            result.add(new int[]{enc.get(i2 - 1), enc.get(i2)});
        }
        return result;
    }

    private List<Double> normalize(List<Double> vals) {
        double tot = vals.stream().mapToDouble(f -> f).sum();
        return vals.stream().map(n -> n / tot).collect(Collectors.toList());
    }
}

