/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.ISequenceEncoder;

public class TrimSuffixEncoder
implements ISequenceEncoder {
    private static final int REMOVE_EVERYTHING = 255;

    @Override
    public ByteBuffer encode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer target) {
        int sharedPrefix = BufferUtils.sharedPrefixLength(source2, target);
        int truncateBytes = source2.remaining() - sharedPrefix;
        if (truncateBytes >= 255) {
            truncateBytes = 255;
            sharedPrefix = 0;
        }
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, 1 + target.remaining() - sharedPrefix);
        assert (target.hasArray() && target.position() == 0 && target.arrayOffset() == 0);
        byte suffixTrimCode = (byte)(truncateBytes + 65);
        reuse.put(suffixTrimCode).put(target.array(), sharedPrefix, target.remaining() - sharedPrefix).flip();
        return reuse;
    }

    @Override
    public int prefixBytes() {
        return 1;
    }

    @Override
    public ByteBuffer decode(ByteBuffer reuse, ByteBuffer source2, ByteBuffer encoded) {
        assert (encoded.remaining() >= 1);
        byte suffixTrimCode = encoded.get(encoded.position());
        int truncateBytes = suffixTrimCode - 65 & 0xFF;
        if (truncateBytes == 255) {
            truncateBytes = source2.remaining();
        }
        int len1 = source2.remaining() - truncateBytes;
        int len2 = encoded.remaining() - 1;
        reuse = BufferUtils.clearAndEnsureCapacity(reuse, len1 + len2);
        assert (source2.hasArray() && source2.position() == 0 && source2.arrayOffset() == 0);
        assert (encoded.hasArray() && encoded.position() == 0 && encoded.arrayOffset() == 0);
        reuse.put(source2.array(), 0, len1).put(encoded.array(), 1, len2).flip();
        return reuse;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

