/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/grazie/text/CodeProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "textAround", "", "text", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
public final class CodeProblemFilter
extends ProblemFilter {
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"problem.highlightRanges");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    TextContent textContent = problem.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
                    CharSequence charSequence = textContent;
                    TextRange textRange = it;
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it");
                    if (!Text.INSTANCE.looksLikeCode(this.textAround(charSequence, textRange))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }
}

