/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram.impl;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.utils.collections.array.OneOptimizedFloatArray;
import com.intellij.grazie.detector.utils.collections.array.OptimizedFloatArray;
import com.intellij.grazie.detector.utils.collections.ngram.NgramArray;
import com.intellij.grazie.detector.utils.collections.ngram.NgramArrayKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B?\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;", "", "probabilities", "Ljava/util/HashMap;", "Lcom/intellij/grazie/detector/utils/collections/ngram/NgramArray;", "Lcom/intellij/grazie/detector/utils/collections/array/OptimizedFloatArray;", "Lkotlin/collections/HashMap;", "languages", "", "Lcom/intellij/grazie/detector/model/Language;", "statistics", "Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "(Ljava/util/HashMap;Ljava/util/List;Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Statistics;)V", "getLanguages", "()Ljava/util/List;", "getStatistics", "()Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "getLanguage", "pos", "", "getProbabilities", "ngram", "", "Companion", "Statistics", "nlp-detector"})
public final class NgramFrequencies {
    @NotNull
    private final List<Language> languages;
    private final HashMap<NgramArray, OptimizedFloatArray> probabilities;
    @NotNull
    private final Statistics statistics;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final Language getLanguage(int pos) {
        return this.languages.get(pos);
    }

    @NotNull
    public final OptimizedFloatArray getProbabilities(@NotNull String ngram) {
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        OptimizedFloatArray optimizedFloatArray = this.probabilities.get(NgramArrayKt.toNgramArray(ngram));
        if (optimizedFloatArray == null || (optimizedFloatArray = optimizedFloatArray.set(this.languages.size() - 1, 0.0f, (byte)this.languages.size())) == null) {
            optimizedFloatArray = new OneOptimizedFloatArray().set(this.languages.size() - 1, (float)this.statistics.getAverage(), (byte)this.languages.size());
        }
        return optimizedFloatArray;
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    public NgramFrequencies(@NotNull HashMap<NgramArray, OptimizedFloatArray> probabilities, @NotNull List<? extends Language> languages2, @NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        this.probabilities = probabilities;
        this.statistics = statistics;
        this.languages = CollectionsKt.plus((Collection)languages2, (Object)((Object)Language.UNKNOWN));
        boolean bl = !languages2.contains((Object)Language.UNKNOWN);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "UNKNOWN language should not be passed to NgramFrequencies";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "", "average", "", "(D)V", "getAverage", "()D", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "nlp-detector"})
    public static final class Statistics {
        private final double average;

        public final double getAverage() {
            return this.average;
        }

        public Statistics(double average) {
            this.average = average;
        }

        public final double component1() {
            return this.average;
        }

        @NotNull
        public final Statistics copy(double average) {
            return new Statistics(average);
        }

        public static /* synthetic */ Statistics copy$default(Statistics statistics, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = statistics.average;
            }
            return statistics.copy(d);
        }

        @NotNull
        public String toString() {
            return "Statistics(average=" + this.average + ")";
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.average);
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Statistics)) break block3;
                    Statistics statistics = (Statistics)object;
                    if (Double.compare(this.average, statistics.average) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies$Companion;", "", "()V", "create", "Lcom/intellij/grazie/detector/ngram/impl/NgramFrequencies;", "profiles", "", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfile;", "gramLengths", "", "nlp-detector"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NgramFrequencies create(@NotNull Collection<? extends LanguageProfile> profiles, @NotNull Collection<Integer> gramLengths) {
            Collection<Language> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void key;
            Object profile2;
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(gramLengths, (String)"gramLengths");
            Collection<? extends LanguageProfile> collection2 = profiles;
            boolean bl = false;
            boolean bl2 = !collection2.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "No language profiles provided!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection<Integer> collection3 = gramLengths;
            bl = false;
            boolean bl5 = !collection3.isEmpty();
            bl = false;
            bl3 = false;
            if (!bl5) {
                boolean bl6 = false;
                String string = "No gram lengths provided!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            HashMap probabilities = new HashMap();
            double sumOfAll = 0.0;
            int total = 0;
            boolean bl7 = false;
            for (Object profile2 : (Iterable)profiles) {
                void index;
                Iterator<Integer> iterator = gramLengths.iterator();
                while (iterator.hasNext()) {
                    int gramLength = ((Number)iterator.next()).intValue();
                    boolean bl8 = profile2.getGramLengths().contains(gramLength);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    if (!bl8) {
                        boolean bl11 = false;
                        String string = "The language profile for " + (Object)((Object)profile2.getLocale()) + " does not contain " + gramLength + "-grams!";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    Iterator<Map.Entry<String, Integer>> iterator2 = profile2.iterateGrams(gramLength).iterator();
                    while (iterator2.hasNext()) {
                        void ngram;
                        Map.Entry<String, Integer> entry;
                        Map.Entry<String, Integer> entry2 = entry = iterator2.next();
                        boolean bl12 = false;
                        String string = entry2.getKey();
                        entry2 = entry;
                        bl12 = false;
                        int frequency = ((Number)entry2.getValue()).intValue();
                        float prob = (float)frequency / (float)profile2.getNumGramOccurrences(ngram.length());
                        ++total;
                        sumOfAll += (double)prob;
                        OptimizedFloatArray optimizedFloatArray = (OptimizedFloatArray)probabilities.get(ngram);
                        if (optimizedFloatArray == null) {
                            optimizedFloatArray = new OneOptimizedFloatArray();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)optimizedFloatArray, (String)"probabilities[ngram] ?: OneOptimizedFloatArray()");
                        OptimizedFloatArray arr = optimizedFloatArray;
                        arr = arr.set((int)index, prob, (byte)profiles.size());
                        ((Map)probabilities).put(ngram, arr);
                    }
                }
                ++index;
            }
            HashMap<NgramArray, OptimizedFloatArray> optimized = new HashMap<NgramArray, OptimizedFloatArray>(profiles.size());
            Object gramLength = probabilities;
            boolean bl13 = false;
            Iterator<Object> iterator = gramLength.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = profile2 = (Map.Entry)iterator.next();
                boolean bl14 = false;
                gramLength = (String)object.getKey();
                object = profile2;
                bl14 = false;
                OptimizedFloatArray value = (OptimizedFloatArray)object.getValue();
                ((Map)optimized).put(NgramArrayKt.toNgramArray((String)key), value);
            }
            profile2 = profiles;
            HashMap<NgramArray, OptimizedFloatArray> hashMap = optimized;
            boolean $i$f$map = false;
            key = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageProfile frequency = (LanguageProfile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl15 = false;
                Language language = it.getLocale();
                collection.add(language);
            }
            collection = (List)destination$iv$iv;
            Statistics statistics = new Statistics(sumOfAll / (double)total);
            List list = collection;
            HashMap<NgramArray, OptimizedFloatArray> hashMap2 = hashMap;
            return new NgramFrequencies(hashMap2, list, statistics);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

