/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt;

import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J(\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/awt/PWindowUtils;", "", "()V", "HEADER_VISIBLE_HEIGHT_PX", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "createVisibleWindowBounds", "Ljava/awt/Rectangle;", "headerVisibleHeightPx", "targetWindowBounds", "screenBounds", "getVisibleWindowBoundsIfNeeded", "x", "y", "width", "height", "isWindowHeaderVisibleEnough", "", "windowBounds", "projector-awt-common"})
public final class PWindowUtils {
    @NotNull
    public static final PWindowUtils INSTANCE = new PWindowUtils();
    private static final int HEADER_VISIBLE_HEIGHT_PX = 10;
    @NotNull
    private static final Logger logger;

    private PWindowUtils() {
    }

    @Nullable
    public final Rectangle getVisibleWindowBoundsIfNeeded(int x, int y, int width, int height) {
        Rectangle newBounds = new Rectangle(x, y, width, height);
        Rectangle screenBounds = PGraphicsEnvironment.Companion.getDefaultDevice().getClientScreenBounds();
        if (this.isWindowHeaderVisibleEnough(10, newBounds, screenBounds)) {
            return null;
        }
        Rectangle visibleWindowBounds = this.createVisibleWindowBounds(10, newBounds, screenBounds);
        if (this.isWindowHeaderVisibleEnough(10, visibleWindowBounds, screenBounds)) {
            return visibleWindowBounds;
        }
        Logger.DefaultImpls.error$default(logger, null, (Function0)new Function0<String>(newBounds, screenBounds){
            final /* synthetic */ Rectangle $newBounds;
            final /* synthetic */ Rectangle $screenBounds;
            {
                this.$newBounds = $newBounds;
                this.$screenBounds = $screenBounds;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Can't create visible window bounds... (10, " + this.$newBounds + ", " + this.$screenBounds + ")";
            }
        }, 1, null);
        return null;
    }

    public final boolean isWindowHeaderVisibleEnough(int headerVisibleHeightPx, @NotNull Rectangle windowBounds, @NotNull Rectangle screenBounds) {
        Intrinsics.checkNotNullParameter((Object)windowBounds, (String)"windowBounds");
        Intrinsics.checkNotNullParameter((Object)screenBounds, (String)"screenBounds");
        Rectangle headerBounds = new Rectangle(windowBounds.x, windowBounds.y - headerVisibleHeightPx, windowBounds.width, headerVisibleHeightPx);
        int n = screenBounds.y;
        int n2 = screenBounds.y + screenBounds.height;
        int n3 = MathKt.roundToInt((double)headerBounds.getCenterY());
        if (!(n <= n3 ? n3 <= n2 : false)) {
            return false;
        }
        n = screenBounds.x;
        n2 = screenBounds.x + screenBounds.width;
        n3 = MathKt.roundToInt((double)headerBounds.getCenterX());
        return n <= n3 ? n3 <= n2 : false;
    }

    private final Rectangle createVisibleWindowBounds(int headerVisibleHeightPx, Rectangle targetWindowBounds, Rectangle screenBounds) {
        Rectangle headerBounds = new Rectangle(targetWindowBounds.x, targetWindowBounds.y - headerVisibleHeightPx, targetWindowBounds.width, headerVisibleHeightPx);
        Rectangle visibleWindowBounds = new Rectangle(targetWindowBounds);
        Point visibleHeaderPoint = new Point(MathKt.roundToInt((double)headerBounds.getCenterX()), MathKt.roundToInt((double)headerBounds.getCenterY()));
        if (visibleHeaderPoint.x > screenBounds.x + screenBounds.width) {
            visibleWindowBounds.x -= visibleHeaderPoint.x - (screenBounds.x + screenBounds.width);
        }
        if (visibleHeaderPoint.y > screenBounds.y + screenBounds.height) {
            visibleWindowBounds.y -= visibleHeaderPoint.y - (screenBounds.y + screenBounds.height);
        }
        if (visibleHeaderPoint.x < screenBounds.x) {
            visibleWindowBounds.x += screenBounds.x - visibleHeaderPoint.x;
        }
        if (visibleHeaderPoint.y < screenBounds.y) {
            visibleWindowBounds.y += screenBounds.y - visibleHeaderPoint.y;
        }
        return visibleWindowBounds;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PWindowUtils.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }
}

