/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError;
import org.eclipse.jgit.internal.fsck.FsckPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GitmoduleEntry;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class DfsFsck {
    private final DfsRepository repo;
    private final DfsObjDatabase objdb;
    private ObjectChecker objChecker = new ObjectChecker();
    private boolean connectivityOnly;

    public DfsFsck(DfsRepository repository2) {
        this.repo = repository2;
        this.objdb = this.repo.getObjectDatabase();
    }

    public FsckError check(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        FsckError errors = new FsckError();
        if (!this.connectivityOnly) {
            this.objChecker.reset();
            this.checkPacks(pm, errors);
        }
        this.checkConnectivity(pm, errors);
        return errors;
    }

    private void checkPacks(ProgressMonitor pm, FsckError errors) throws IOException, FileNotFoundException {
        try (DfsReader ctx = this.objdb.newReader();){
            for (DfsPackFile pack : this.objdb.getPacks()) {
                DfsPackDescription packDesc = pack.getPackDescription();
                if (packDesc.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) continue;
                try (ReadableChannel rc = this.objdb.openFile(packDesc, PackExt.PACK);){
                    this.verifyPack(pm, errors, ctx, pack, rc);
                }
                catch (MissingObjectException e) {
                    errors.getMissingObjects().add(e.getObjectId());
                }
                catch (CorruptPackIndexException e) {
                    errors.getCorruptIndices().add(new FsckError.CorruptIndex(pack.getPackDescription().getFileName(PackExt.INDEX), e.getErrorType()));
                }
            }
        }
        this.checkGitModules(pm, errors);
    }

    private void verifyPack(ProgressMonitor pm, FsckError errors, DfsReader ctx, DfsPackFile pack, ReadableChannel ch) throws IOException, CorruptPackIndexException {
        FsckPackParser fpp = new FsckPackParser((ObjectDatabase)this.objdb, ch);
        fpp.setObjectChecker(this.objChecker);
        fpp.overwriteObjectCount(pack.getPackDescription().getObjectCount());
        fpp.parse(pm);
        errors.getCorruptObjects().addAll(fpp.getCorruptObjects());
        fpp.verifyIndex(pack.getPackIndex(ctx));
    }

    private void checkGitModules(ProgressMonitor pm, FsckError errors) throws IOException {
        pm.beginTask(JGitText.get().validatingGitModules, this.objChecker.getGitsubmodules().size());
        for (GitmoduleEntry entry : this.objChecker.getGitsubmodules()) {
            AnyObjectId blobId = entry.getBlobId();
            ObjectLoader blob = this.objdb.open(blobId, 3);
            try {
                SubmoduleValidator.assertValidGitModulesFile(new String(blob.getBytes(), StandardCharsets.UTF_8));
            }
            catch (SubmoduleValidator.SubmoduleValidationException e) {
                FsckError.CorruptObject co = new FsckError.CorruptObject(blobId.toObjectId(), 3, e.getFsckMessageId());
                errors.getCorruptObjects().add(co);
            }
            pm.update(1);
        }
        pm.endTask();
    }

    private void checkConnectivity(ProgressMonitor pm, FsckError errors) throws IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        try (ObjectWalk ow = new ObjectWalk(this.repo);){
            for (Ref r : this.repo.getRefDatabase().getRefs()) {
                ObjectId objectId = r.getObjectId();
                if (objectId == null) continue;
                try {
                    RevObject tip = ow.parseAny(objectId);
                    if (r.getLeaf().getName().startsWith("refs/heads/") && tip.getType() != 1) {
                        errors.getNonCommitHeads().add(r.getLeaf().getName());
                    }
                    ow.markStart(tip);
                }
                catch (MissingObjectException e) {
                    errors.getMissingObjects().add(e.getObjectId());
                }
            }
            try {
                ow.checkConnectivity();
            }
            catch (MissingObjectException e) {
                errors.getMissingObjects().add(e.getObjectId());
            }
        }
        pm.endTask();
    }

    public void setObjectChecker(ObjectChecker objChecker) {
        this.objChecker = objChecker;
    }

    public void setConnectivityOnly(boolean connectivityOnly) {
        this.connectivityOnly = connectivityOnly;
    }
}

