/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepository;
import com.intellij.tasks.pivotal.model.PivotalTrackerStory;
import com.intellij.util.ArrayUtil;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PivotalTrackerTask
extends Task {
    @NotNull
    private final PivotalTrackerRepository myRepository;
    @NotNull
    private final PivotalTrackerStory myStory;

    public PivotalTrackerTask(@NotNull PivotalTrackerRepository repository, @NotNull PivotalTrackerStory story) {
        if (repository == null) {
            PivotalTrackerTask.$$$reportNull$$$0(0);
        }
        if (story == null) {
            PivotalTrackerTask.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myStory = story;
    }

    @NotNull
    public TaskRepository getRepository() {
        PivotalTrackerRepository pivotalTrackerRepository = this.myRepository;
        if (pivotalTrackerRepository == null) {
            PivotalTrackerTask.$$$reportNull$$$0(2);
        }
        return pivotalTrackerRepository;
    }

    @NotNull
    public String getId() {
        String string = this.myStory.getProjectId() + "-" + this.myStory.getId();
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableId() {
        String string = "#" + this.myStory.getId();
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getNumber() {
        String string = this.myStory.getId();
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myStory.getName();
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myStory.getDescription();
    }

    public Comment @NotNull [] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            PivotalTrackerTask.$$$reportNull$$$0(7);
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = IconLoader.getIcon((String)this.getCustomIcon(), (ClassLoader)PivotalTrackerRepository.class.getClassLoader());
        if (icon == null) {
            PivotalTrackerTask.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            PivotalTrackerTask.$$$reportNull$$$0(9);
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return TaskUtil.parseDate((String)this.myStory.getUpdatedAt());
    }

    @Nullable
    public Date getCreated() {
        return TaskUtil.parseDate((String)this.myStory.getCreatedAt());
    }

    public boolean isClosed() {
        return ArrayUtil.contains((String)this.myStory.getCurrentState(), (String[])new String[]{"accepted", "delivered", "finished"});
    }

    public boolean isIssue() {
        return true;
    }

    @NotNull
    public String getIssueUrl() {
        String string = this.myRepository.getUrl() + "/story/show/" + this.myStory.getId();
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getCustomIcon() {
        String string = "icons/pivotal/" + this.myStory.getStoryType() + ".png";
        if (string == null) {
            PivotalTrackerTask.$$$reportNull$$$0(11);
        }
        return string;
    }

    @TestOnly
    @NotNull
    public PivotalTrackerStory getStory() {
        PivotalTrackerStory pivotalTrackerStory = this.myStory;
        if (pivotalTrackerStory == null) {
            PivotalTrackerTask.$$$reportNull$$$0(12);
        }
        return pivotalTrackerStory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "story";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/pivotal/PivotalTrackerTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/pivotal/PivotalTrackerTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

