/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import com.intellij.tasks.jira.jql.codeinsight.JqlFieldType;
import com.intellij.tasks.jira.jql.codeinsight.JqlStandardField;
import com.intellij.tasks.jira.jql.codeinsight.JqlStandardFunction;
import com.intellij.tasks.jira.jql.psi.JqlClauseWithHistoryPredicates;
import com.intellij.tasks.jira.jql.psi.JqlFunctionCall;
import com.intellij.tasks.jira.jql.psi.JqlHistoryPredicate;
import com.intellij.tasks.jira.jql.psi.JqlIdentifier;
import com.intellij.tasks.jira.jql.psi.JqlList;
import com.intellij.tasks.jira.jql.psi.JqlNotClause;
import com.intellij.tasks.jira.jql.psi.JqlOrderBy;
import com.intellij.tasks.jira.jql.psi.JqlSortKey;
import com.intellij.tasks.jira.jql.psi.JqlSubClause;
import com.intellij.tasks.jira.jql.psi.JqlTerminalClause;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JqlCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(JqlCompletionContributor.class);
    private static final FilterPattern BEGINNING_OF_LINE = new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, @Nullable PsiElement context) {
            if (!(element instanceof PsiElement)) {
                return false;
            }
            PsiElement p = (PsiElement)element;
            PsiFile file = p.getContainingFile().getOriginalFile();
            char[] chars = file.textToCharArray();
            for (int offset = p.getTextOffset() - 1; offset >= 0; --offset) {
                char c = chars[offset];
                if (c == '\n') {
                    return true;
                }
                if (StringUtil.isWhiteSpace((char)c)) continue;
                return false;
            }
            return true;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    });
    private static final PsiElementPattern.Capture<PsiElement> AFTER_CLAUSE_WITH_HISTORY_PREDICATE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().and((ElementPattern)JqlCompletionContributor.rightAfterElement(JqlClauseWithHistoryPredicates.class));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_ANY_CLAUSE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{JqlCompletionContributor.rightAfterElement(JqlTerminalClause.class), JqlCompletionContributor.rightAfterElement(JqlSubClause.class)});
    private static final PsiElementPattern.Capture<PsiElement> AFTER_ORDER_KEYWORD = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.ORDER_KEYWORD));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_FIELD_IN_CLAUSE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().and((ElementPattern)JqlCompletionContributor.rightAfterElement((PsiElementPattern.Capture<? extends PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(JqlIdentifier.class).andNot((ElementPattern)PlatformPatterns.psiElement().inside(JqlFunctionCall.class))).andNot((ElementPattern)PlatformPatterns.psiElement().inside(JqlOrderBy.class)))));
    private static final PsiElementPattern.Capture<PsiElement> BEGINNING_OF_CLAUSE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{BEGINNING_OF_LINE, PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withElementType(JqlTokenTypes.AND_OPERATORS), PlatformPatterns.psiElement().withElementType(JqlTokenTypes.OR_OPERATORS), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(JqlTokenTypes.NOT_OPERATORS)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(JqlTerminalClause.class)), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(JqlTokenTypes.LPAR)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(JqlTerminalClause.class))}))});
    private static final PsiElementPattern.Capture<PsiElement> AFTER_KEYWORD_IN_HISTORY_PREDICATE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlHistoryPredicate.class)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JqlTokenTypes.HISTORY_PREDICATES));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_OPERATOR_EXCEPT_IS = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlTerminalClause.class)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withElementType(JqlTokenTypes.SIMPLE_OPERATORS), PlatformPatterns.psiElement((IElementType)JqlTokenTypes.WAS_KEYWORD), PlatformPatterns.psiElement((IElementType)JqlTokenTypes.IN_KEYWORD), PlatformPatterns.psiElement((IElementType)JqlTokenTypes.NOT_KEYWORD).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.WAS_KEYWORD))}));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_IS_OPERATOR = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlTerminalClause.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.IS_KEYWORD)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.NOT_KEYWORD).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.IS_KEYWORD)))});
    private static final PsiElementPattern.Capture<PsiElement> BEGINNING_OF_SORT_KEY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlOrderBy.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.COMMA)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.BY_KEYWORD))});
    private static final PsiElementPattern.Capture<PsiElement> AFTER_FIELD_IN_SORT_KEY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(JqlTokenTypes.VALID_FIELD_NAMES)).inside(JqlSortKey.class));
    private static final PsiElementPattern.Capture<PsiElement> INSIDE_LIST = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlList.class)).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement((IElementType)JqlTokenTypes.LPAR), PlatformPatterns.psiElement((IElementType)JqlTokenTypes.COMMA)})).andNot((ElementPattern)PlatformPatterns.psiElement().inside(JqlFunctionCall.class)));

    private static FilterPattern rightAfterElement(final PsiElementPattern.Capture<? extends PsiElement> pattern) {
        return new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (!(element instanceof PsiElement)) {
                    return false;
                }
                PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)((PsiElement)element));
                if (prevLeaf == null) {
                    return false;
                }
                PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)prevLeaf, element1 -> pattern.accepts(element1));
                if (parent == null) {
                    return false;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)parent)) {
                    return false;
                }
                return prevLeaf.getTextRange().getEndOffset() == parent.getTextRange().getEndOffset();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        });
    }

    private static FilterPattern rightAfterElement(Class<? extends PsiElement> aClass) {
        return JqlCompletionContributor.rightAfterElement((PsiElementPattern.Capture<? extends PsiElement>)PlatformPatterns.psiElement(aClass));
    }

    public JqlCompletionContributor() {
        this.addKeywordsCompletion();
        this.addFieldNamesCompletion();
        this.addFunctionNamesCompletion();
        this.addEmptyOrNullCompletion();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            JqlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JqlCompletionContributor.$$$reportNull$$$0(1);
        }
        LOG.debug(DebugUtil.psiToString((PsiElement)parameters.getOriginalFile(), (boolean)false));
        super.fillCompletionVariants(parameters, result);
    }

    private void addKeywordsCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_ANY_CLAUSE, new JqlKeywordCompletionProvider("and", "or", "order by"));
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_CLAUSE_WITH_HISTORY_PREDICATE, new JqlKeywordCompletionProvider("on", "before", "after", "during", "from", "to", "by"));
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_FIELD_IN_CLAUSE, new JqlKeywordCompletionProvider("was", "in", "not", "is", "changed"));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{BEGINNING_OF_CLAUSE, ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(JqlTerminalClause.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.WAS_KEYWORD)), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.IS_KEYWORD))})}), new JqlKeywordCompletionProvider("not"));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.NOT_KEYWORD).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)JqlTokenTypes.IS_KEYWORD)))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(JqlNotClause.class)), PlatformPatterns.psiElement((IElementType)JqlTokenTypes.WAS_KEYWORD)})), new JqlKeywordCompletionProvider("in"));
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_ORDER_KEYWORD, new JqlKeywordCompletionProvider("by"));
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_FIELD_IN_SORT_KEY, new JqlKeywordCompletionProvider("asc", "desc"));
    }

    private void addFieldNamesCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{BEGINNING_OF_CLAUSE, BEGINNING_OF_SORT_KEY}), new JqlFieldCompletionProvider(JqlFieldType.UNKNOWN));
    }

    private void addFunctionNamesCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().andOr(new ElementPattern[]{AFTER_OPERATOR_EXCEPT_IS, INSIDE_LIST, AFTER_KEYWORD_IN_HISTORY_PREDICATE}), new JqlFunctionCompletionProvider());
    }

    private void addEmptyOrNullCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_IS_OPERATOR, new JqlKeywordCompletionProvider("empty", "null"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/tasks/jira/jql/codeinsight/JqlCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JqlFieldCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final JqlFieldType myFieldType;

        private JqlFieldCompletionProvider(JqlFieldType fieldType) {
            this.myFieldType = fieldType;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                JqlFieldCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JqlFieldCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JqlFieldCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String field : JqlStandardField.allOfType(this.myFieldType)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)field));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/jira/jql/codeinsight/JqlCompletionContributor$JqlFieldCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JqlFunctionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private JqlFunctionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            JqlFieldType operandType;
            boolean listFunctionExpected;
            PsiElement curElem;
            JqlHistoryPredicate predicate;
            if (parameters == null) {
                JqlFunctionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JqlFunctionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JqlFunctionCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((predicate = (JqlHistoryPredicate)PsiTreeUtil.getParentOfType((PsiElement)(curElem = parameters.getPosition()), JqlHistoryPredicate.class)) != null) {
                listFunctionExpected = false;
                JqlHistoryPredicate.Type predicateType = predicate.getType();
                switch (predicateType) {
                    case BEFORE: 
                    case AFTER: 
                    case DURING: 
                    case ON: {
                        operandType = JqlFieldType.DATE;
                        break;
                    }
                    case BY: {
                        operandType = JqlFieldType.USER;
                        break;
                    }
                    default: {
                        operandType = JqlFunctionCompletionProvider.findTypeOfField(curElem);
                        break;
                    }
                }
            } else {
                operandType = JqlFunctionCompletionProvider.findTypeOfField(curElem);
                listFunctionExpected = JqlFunctionCompletionProvider.insideClauseWithListOperator(curElem);
            }
            for (String functionName : JqlStandardFunction.allOfType(operandType, listFunctionExpected)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)functionName).withInsertHandler((InsertHandler)ParenthesesInsertHandler.NO_PARAMETERS));
            }
        }

        private static JqlFieldType findTypeOfField(PsiElement element) {
            JqlTerminalClause clause = (JqlTerminalClause)PsiTreeUtil.getParentOfType((PsiElement)element, JqlTerminalClause.class);
            if (clause != null) {
                return JqlStandardField.typeOf(clause.getFieldName());
            }
            return JqlFieldType.UNKNOWN;
        }

        private static boolean insideClauseWithListOperator(PsiElement element) {
            JqlTerminalClause clause = (JqlTerminalClause)PsiTreeUtil.getParentOfType((PsiElement)element, JqlTerminalClause.class);
            if (clause == null || clause.getType() == null) {
                return false;
            }
            return clause.getType().isListOperator();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/jira/jql/codeinsight/JqlCompletionContributor$JqlFunctionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JqlKeywordCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final String[] myKeywords;

        private JqlKeywordCompletionProvider(String ... keywords) {
            this.myKeywords = keywords;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                JqlKeywordCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JqlKeywordCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JqlKeywordCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : this.myKeywords) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).withBoldness(true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/tasks/jira/jql/codeinsight/JqlCompletionContributor$JqlKeywordCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

