/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import icons.TasksCoreIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabTask
extends Task {
    private final GitlabIssue myIssue;
    private final GitlabRepository myRepository;
    private final GitlabProject myProject;

    public GitlabTask(@NotNull GitlabRepository repository, @NotNull GitlabIssue issue) {
        if (repository == null) {
            GitlabTask.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            GitlabTask.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
        this.myIssue = issue;
        GitlabProject project = null;
        for (GitlabProject p : this.myRepository.getProjects()) {
            if (p.getId() != this.myIssue.getProjectId()) continue;
            project = p;
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myIssue.getId());
        if (string == null) {
            GitlabTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getPresentableId() {
        String string = "#" + this.myIssue.getLocalId();
        if (string == null) {
            GitlabTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myIssue.getTitle();
        if (string == null) {
            GitlabTask.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public Comment @NotNull [] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            GitlabTask.$$$reportNull$$$0(5);
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksCoreIcons.Gitlab;
        if (icon == null) {
            GitlabTask.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.BUG;
        if (taskType == null) {
            GitlabTask.$$$reportNull$$$0(7);
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myIssue.getUpdatedAt();
    }

    @Nullable
    public Date getCreated() {
        return this.myIssue.getCreatedAt();
    }

    public boolean isClosed() {
        return this.myIssue.getState().equals("closed");
    }

    public boolean isIssue() {
        return true;
    }

    @NotNull
    public String getNumber() {
        String string = String.valueOf(this.myIssue.getLocalId());
        if (string == null) {
            GitlabTask.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getProject() {
        return this.myProject == null ? null : this.myProject.getName();
    }

    @Nullable
    public String getIssueUrl() {
        if (this.myProject != null) {
            return this.myProject.getWebUrl() + "/issues/" + this.myIssue.getLocalId();
        }
        return null;
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/gitlab/GitlabTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/gitlab/GitlabTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

