/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.lifetime;

import com.jetbrains.rd.util.BitHacksKt;
import com.jetbrains.rd.util.BitSlice;
import com.jetbrains.rd.util.BitSliceKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import com.jetbrains.rd.util.lifetime.LifetimeTerminationTimeoutKind;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.SpinWait;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 H2\u00020\u0001:\u0001HB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J5\u0010'\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0016\u00a2\u0006\u0002\u0010,J;\u0010-\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\"0.H\u0016\u00a2\u0006\u0002\u0010/J3\u00100\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0016\u00a2\u0006\u0002\u0010,J9\u00101\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\"0.H\u0016\u00a2\u0006\u0002\u0010/J\u0010\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020%H\u0002J'\u00104\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u00105\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0016\u00a2\u0006\u0002\u00106J%\u00107\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u00062\f\u00105\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0016\u00a2\u0006\u0002\u00106J\u0010\u00108\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u00109\u001a\u00020\"H\u0002J\u0016\u0010:\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0016J\u0014\u0010:\u001a\u00020\"2\n\u0010;\u001a\u00060<j\u0002`=H\u0016J\u0016\u0010>\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0016J\u0014\u0010>\u001a\u00020%2\n\u0010;\u001a\u00060<j\u0002`=H\u0016J\u0010\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020\u0006H\u0002J\u0010\u0010A\u001a\u00020%2\b\b\u0002\u0010B\u001a\u00020%J\b\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020%2\u0006\u00105\u001a\u00020\u0006H\u0002J,\u0010F\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\u0006\u0010\u0016\u001a\u00020\u00172\f\u00105\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0082\b\u00a2\u0006\u0002\u0010GR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006I"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "parent", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "()V", "id", "", "getId", "()Ljava/lang/Object;", "setId", "(Ljava/lang/Object;)V", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resCount", "", "resources", "", "[Ljava/lang/Object;", "state", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "status", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "getStatus", "()Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "value", "Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "terminationTimeoutKind", "getTerminationTimeoutKind", "()Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "setTerminationTimeoutKind", "(Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;)V", "attach", "", "child", "inheritTimeoutKind", "", "attach$rd_core", "bracketIfAlive", "T", "opening", "Lkotlin/Function0;", "terminationAction", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "bracketIfAliveEx", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bracketOrThrow", "bracketOrThrowEx", "destruct", "supportsRecursion", "executeIfAlive", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeOrThrow", "incrementStatusIfEqualTo", "markCancelingRecursively", "onTermination", "closeable", "Ljava/io/Closeable;", "Lcom/jetbrains/rd/util/Closeable;", "onTerminationIfAlive", "onTerminationImpl", "resource", "terminate", "supportsTerminationUnderExecuting", "toString", "", "tryAdd", "underMutexIfLessOrEqual", "(Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "rd-core"})
public final class LifetimeDefinition
extends Lifetime {
    private AtomicInteger state;
    private Object[] resources;
    private int resCount;
    @Nullable
    private Object id;
    @NotNull
    private static final LifetimeDefinition eternal;
    private static final Lazy log$delegate;
    private static final BitSlice.TypedBitSlice<Integer> executingSlice;
    private static final BitSlice.TypedBitSlice<LifetimeStatus> statusSlice;
    private static final BitSlice.TypedBitSlice<Boolean> mutexSlice;
    private static final BitSlice.TypedBitSlice<Boolean> logErrorAfterExecution;
    private static final BitSlice.TypedBitSlice<LifetimeTerminationTimeoutKind> terminationTimeoutKindSlice;
    @NotNull
    private static final LifetimeDefinition Terminated;
    @NotNull
    public static final String anonymousLifetimeId = "Anonymous";
    public static final Companion Companion;

    @NotNull
    public final Lifetime getLifetime() {
        return this;
    }

    @Override
    @NotNull
    public LifetimeStatus getStatus() {
        return BitSliceKt.get(statusSlice, this.state);
    }

    @Override
    @NotNull
    public LifetimeTerminationTimeoutKind getTerminationTimeoutKind() {
        return BitSliceKt.get(terminationTimeoutKindSlice, this.state);
    }

    public void setTerminationTimeoutKind(@NotNull LifetimeTerminationTimeoutKind value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        terminationTimeoutKindSlice.atomicUpdate(this.state, value2);
    }

    @Nullable
    public final Object getId() {
        return this.id;
    }

    public final void setId(@Nullable Object object) {
        this.id = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T executeIfAlive(@NotNull Function0<? extends T> action) {
        Object object;
        int s;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        do {
            if (statusSlice.get(s = this.state.get()) == LifetimeStatus.Alive) continue;
            return null;
        } while (!this.state.compareAndSet(s, s + 1));
        Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, 1);
        try {
            object = action.invoke();
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, -1);
        }
        catch (Throwable throwable) {
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, -1);
            this.state.decrementAndGet();
            if (BitSliceKt.get(logErrorAfterExecution, this.state).booleanValue()) {
                long terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
                Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                boolean $i$f$error = false;
                Logger $this$log$iv$iv = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    Logger logger2 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "executeIfAlive after termination of " + this + " took too much time (>" + terminationTimeoutMs + "ms)";
                    logger2.log(logLevel, string, null);
                }
            }
            throw throwable;
        }
        this.state.decrementAndGet();
        if (BitSliceKt.get(logErrorAfterExecution, this.state).booleanValue()) {
            void $this$log$iv$iv;
            long terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
            Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
            boolean $i$f$error = false;
            Logger logger3 = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_19 = $this$log$iv$iv;
                boolean bl = false;
                String string = "executeIfAlive after termination of " + this + " took too much time (>" + terminationTimeoutMs + "ms)";
                var11_19.log(logLevel, string, null);
            }
        }
        return (T)object;
    }

    @Override
    @NotNull
    public <T> T executeOrThrow(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        T t = this.executeIfAlive(action);
        if (t == null) {
            throw (Throwable)new CancellationException();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T underMutexIfLessOrEqual(LifetimeStatus status, Function0<? extends T> action) {
        int s;
        int $i$f$underMutexIfLessOrEqual = 0;
        do {
            s = this.state.get();
            if (((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s))).compareTo((Enum)status) <= 0) continue;
            return null;
        } while (((Boolean)LifetimeDefinition.mutexSlice.get(s)).booleanValue() || !this.state.compareAndSet(s, LifetimeDefinition.mutexSlice.updated(s, true)));
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            int s2;
            InlineMarker.finallyStart((int)1);
            do {
                s2 = this.state.get();
                PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s2));
            } while (!this.state.compareAndSet(s2, LifetimeDefinition.mutexSlice.updated(s2, false)));
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean tryAdd(Object action) {
        Boolean bl;
        block12: {
            void this_$iv;
            int s$iv;
            if (this.getLifetime() == eternal) {
                return true;
            }
            LifetimeDefinition lifetimeDefinition = this;
            LifetimeStatus status$iv = LifetimeStatus.Canceling;
            boolean $i$f$underMutexIfLessOrEqual = false;
            do {
                s$iv = ((LifetimeDefinition)this_$iv).state.get();
                if (((LifetimeStatus)((Object)LifetimeDefinition.statusSlice.get(s$iv))).compareTo((Enum)status$iv) <= 0) continue;
                bl = null;
                break block12;
            } while (((Boolean)LifetimeDefinition.mutexSlice.get(s$iv)).booleanValue() || !((LifetimeDefinition)this_$iv).state.compareAndSet(s$iv, LifetimeDefinition.mutexSlice.updated(s$iv, true)));
            try {
                boolean bl2 = false;
                Object[] localResources = this.resources;
                int n = localResources != null ? 1 : 0;
                int n2 = 0;
                int n3 = 0;
                if (n == 0) {
                    boolean bl3 = false;
                    String string = this + ": `resources` can't be null under mutex while status < Terminating";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                if (this.resCount == localResources.length) {
                    int countAfterCleaning = 0;
                    n2 = 0;
                    n3 = this.resCount;
                    while (n2 < n3) {
                        void i;
                        Object resource = localResources[i];
                        if (resource instanceof LifetimeDefinition && ((LifetimeDefinition)resource).getStatus().compareTo((Enum)LifetimeStatus.Terminating) >= 0) {
                            localResources[i] = null;
                        } else {
                            localResources[countAfterCleaning++] = resource;
                        }
                        ++i;
                    }
                    this.resCount = countAfterCleaning;
                    if (countAfterCleaning * 2 > localResources.length) {
                        Object[] newArray = new Object[countAfterCleaning * 2];
                        ArraysKt.copyInto((Object[])localResources, (Object[])newArray, (int)0, (int)0, (int)countAfterCleaning);
                        this.resources = newArray;
                    }
                }
                Intrinsics.checkNotNull((Object)this.resources);
                n = this.resCount;
                this.resCount = n + 1;
                this.resources[n] = action;
                Boolean bl4 = true;
                bl = bl4;
            }
            finally {
                int s$iv2;
                do {
                    s$iv2 = ((LifetimeDefinition)this_$iv).state.get();
                    PlatformDependentKt.assert((Boolean)LifetimeDefinition.mutexSlice.get(s$iv2));
                } while (!((LifetimeDefinition)this_$iv).state.compareAndSet(s$iv2, LifetimeDefinition.mutexSlice.updated(s$iv2, false)));
            }
        }
        return bl != null ? bl : false;
    }

    private final boolean incrementStatusIfEqualTo(LifetimeStatus status) {
        LifetimeStatus nextStatus;
        int newS;
        int s;
        boolean value$iv = this != eternal;
        boolean $i$f$assert = false;
        boolean bl = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl2 = false;
            String string = this + ": Trying to change eternal lifetime";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        do {
            if (statusSlice.get(s = this.state.get()) == status) continue;
            return false;
        } while (!this.state.compareAndSet(s, newS = statusSlice.updated(s, nextStatus = LifetimeStatus.values()[statusSlice.get(s).ordinal() + 1])));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void markCancelingRecursively() {
        boolean value$iv = this != eternal;
        int $i$f$assert = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl2 = false;
            String string = this + ": Trying to terminate eternal lifetime";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.incrementStatusIfEqualTo(LifetimeStatus.Alive)) {
            return;
        }
        if (this.resources == null) {
            return;
        }
        Object[] localResources = this.resources;
        int n = this.resCount;
        int n2 = localResources.length;
        boolean bl3 = false;
        $i$f$assert = Math.min(n, n2) - 1;
        bl = false;
        while ($i$f$assert >= 0) {
            void i;
            Object object = localResources[i];
            if (!(object instanceof LifetimeDefinition)) {
                object = null;
            }
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)object;
            if (lifetimeDefinition != null) {
                lifetimeDefinition.markCancelingRecursively();
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean terminate(boolean supportsTerminationUnderExecuting) {
        boolean bl;
        boolean $i$f$spinUntil5;
        SpinWait.Companion this_$iv$iv;
        boolean $i$f$spinUntil2;
        long terminationTimeoutMs;
        block10: {
            void this_$iv$iv$iv;
            if (RLifetimeKt.isEternal(this) || this.getStatus().compareTo((Enum)LifetimeStatus.Canceling) > 0) {
                return false;
            }
            if (((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue() > 0 && !supportsTerminationUnderExecuting) {
                String string = this + ": Can't terminate lifetime under `executeIfAlive` because termination doesn't support this. Use `terminate(true)`";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.markCancelingRecursively();
            terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
            $i$f$spinUntil2 = false;
            this_$iv$iv = SpinWait.Companion;
            $i$f$spinUntil5 = false;
            SpinWait.Companion companion = this_$iv$iv;
            Lifetime lifetime$iv$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil3 = false;
            void var10_16 = this_$iv$iv$iv;
            Duration duration = Duration.ofMillis(terminationTimeoutMs);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv$iv = duration;
            boolean $i$f$spinUntil4 = false;
            long start$iv$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv$iv = 0L;
            while (true) {
                boolean bl3 = false;
                if (((Number)BitSliceKt.get(executingSlice, this.state)).intValue() <= ((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue()) break;
                if (!RLifetimeKt.isAlive(lifetime$iv$iv$iv) || System.nanoTime() - start$iv$iv$iv$iv > duration$iv$iv$iv$iv.toNanos()) {
                    bl = false;
                    break block10;
                }
                long l = spins$iv$iv$iv$iv;
                spins$iv$iv$iv$iv = l + 1L;
                if (l < (long)100) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv$iv / (long)100);
            }
            bl = true;
        }
        if (!bl) {
            void $this$log$iv$iv;
            Logger $this$warn$iv = LifetimeDefinition.Companion.getLog();
            boolean $i$f$warn = false;
            Logger $i$f$spinUntil5 = $this$warn$iv;
            LogLevel level$iv$iv = LogLevel.Warn;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var20_25 = $this$log$iv$iv;
                boolean bl4 = false;
                String string = this + ": can't wait for `executeIfAlive` completed on other thread in " + terminationTimeoutMs + " ms. Keep termination." + System.lineSeparator() + "This may happen either because of the executeIfAlive failed to complete in a timely manner. In the case there will be following error messages." + System.lineSeparator() + "This is also possible if the thread waiting for the termination wasn't able to receive execution time during the wait in SpinWait.SpinUntil, so it has missed the fact that the lifetime was terminated in time.";
                var20_25.log(logLevel, string, null);
            }
            logErrorAfterExecution.atomicUpdate(this.state, true);
        }
        if (!this.incrementStatusIfEqualTo(LifetimeStatus.Canceling)) {
            return false;
        }
        $i$f$spinUntil2 = false;
        this_$iv$iv = SpinWait.Companion;
        $i$f$spinUntil5 = false;
        long spins$iv$iv = 0L;
        while (true) {
            boolean bl5 = false;
            if (BitSliceKt.get(mutexSlice, this.state) == false) break;
            long l = spins$iv$iv;
            spins$iv$iv = l + 1L;
            if (l < (long)100) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv / (long)100);
        }
        this.destruct(supportsTerminationUnderExecuting);
        return true;
    }

    public static /* synthetic */ boolean terminate$default(LifetimeDefinition lifetimeDefinition, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return lifetimeDefinition.terminate(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void destruct(boolean supportsRecursion) {
        boolean value$iv = this.getStatus() == LifetimeStatus.Terminating;
        int $i$f$assert = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean $i$a$-assert-LifetimeDefinition$destruct$32 = false;
            String $i$a$-assert-LifetimeDefinition$destruct$32 = "Bad status for destructuring start: " + this;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$destruct$32));
        }
        value$iv = BitSliceKt.get(mutexSlice, this.state) == false;
        $i$f$assert = 0;
        bl = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean $i$a$-assert-LifetimeDefinition$destruct$422 = false;
            String $i$a$-assert-LifetimeDefinition$destruct$422 = this + ": mutex must be released in this point";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-LifetimeDefinition$destruct$422));
        }
        Object[] localResources = this.resources;
        $i$f$assert = localResources != null ? 1 : 0;
        bl = false;
        boolean $i$a$-assert-LifetimeDefinition$destruct$422 = false;
        if ($i$f$assert == 0) {
            boolean bl2 = false;
            String $i$a$-assert-LifetimeDefinition$destruct$422 = this + ": `resources` can't be null on destructuring stage";
            throw (Throwable)new IllegalArgumentException($i$a$-assert-LifetimeDefinition$destruct$422.toString());
        }
        $i$f$assert = this.resCount - 1;
        bl = false;
        while ($i$f$assert >= 0) {
            void i;
            block15: {
                Object resource = localResources[i];
                try {
                    Object action;
                    Object bl2;
                    Object object;
                    Object object2 = resource;
                    if (!TypeIntrinsics.isFunctionOfArity((Object)object2, (int)0)) {
                        object2 = null;
                    }
                    if ((object = (Function0)object2) != null) {
                        bl2 = object;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        action = bl2;
                        boolean bl5 = false;
                        object = action.invoke();
                        if (object != null) break block15;
                    }
                    if ((bl2 = resource) instanceof Closeable) {
                        ((Closeable)resource).close();
                        object = Unit.INSTANCE;
                    } else if (bl2 instanceof LifetimeDefinition) {
                        object = ((LifetimeDefinition)resource).terminate(supportsRecursion);
                    } else {
                        void $this$log$iv$iv;
                        Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                        boolean $i$f$error = false;
                        action = $this$error$iv;
                        LogLevel level$iv$iv = LogLevel.Error;
                        boolean $i$f$log = false;
                        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var13_27 = $this$log$iv$iv;
                            boolean bl6 = false;
                            String string = this + ": Unknown termination resource: " + resource;
                            var13_27.log(logLevel, string, null);
                        }
                        object = Unit.INSTANCE;
                    }
                }
                catch (Throwable e) {
                    LoggerKt.error(LifetimeDefinition.Companion.getLog(), this + ": exception on termination of resource: " + resource, e);
                }
            }
            --i;
        }
        this.resources = null;
        this.resCount = 0;
        boolean bl7 = this.incrementStatusIfEqualTo(LifetimeStatus.Terminating);
        bl = false;
        boolean bl8 = false;
        if (!bl7) {
            boolean bl9 = false;
            String string = "Bad status for destructuring finish: " + this;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.tryAdd(action);
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Closeable closeable) {
        Intrinsics.checkNotNullParameter((Object)closeable, (String)"closeable");
        return this.tryAdd(closeable);
    }

    @Override
    public void onTermination(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.onTerminationImpl(action);
    }

    @Override
    public void onTermination(@NotNull Closeable closeable) {
        Intrinsics.checkNotNullParameter((Object)closeable, (String)"closeable");
        this.onTerminationImpl(closeable);
    }

    /*
     * WARNING - void declaration
     */
    private final void onTerminationImpl(Object resource) {
        block9: {
            if (this.tryAdd(resource)) {
                return;
            }
            try {
                Object action;
                Object object;
                Object object2;
                Object object3 = resource;
                if (!TypeIntrinsics.isFunctionOfArity((Object)object3, (int)0)) {
                    object3 = null;
                }
                if ((object2 = (Function0)object3) != null) {
                    object = object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    action = object;
                    boolean bl3 = false;
                    object2 = action.invoke();
                    if (object2 != null) break block9;
                }
                if ((object = resource) instanceof Closeable) {
                    ((Closeable)resource).close();
                    object2 = Unit.INSTANCE;
                } else {
                    void $this$log$iv$iv;
                    Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                    boolean $i$f$error = false;
                    action = $this$error$iv;
                    LogLevel level$iv$iv = LogLevel.Error;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var9_12 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = this + ": Unknown termination resource: " + resource;
                        var9_12.log(logLevel, string, null);
                    }
                    object2 = Unit.INSTANCE;
                }
            }
            catch (Throwable e) {
                LoggerKt.error(LifetimeDefinition.Companion.getLog(), this + ": exception on synchronous execute of action on terminated lifetime: " + resource, e);
            }
        }
        RLifetimeKt.access$badStatusForAddActions(this);
    }

    @Override
    public void attach$rd_core(@NotNull LifetimeDefinition child, boolean inheritTimeoutKind) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        boolean bl = !RLifetimeKt.isEternal(child);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = this + ": Can't attach eternal lifetime";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (RLifetimeKt.isNotAlive(child)) {
            return;
        }
        if (inheritTimeoutKind) {
            child.setTerminationTimeoutKind(this.getTerminationTimeoutKind());
        }
        if (!this.tryAdd(child)) {
            LifetimeDefinition.terminate$default(child, false, 1, null);
        }
    }

    @Override
    @Nullable
    public <T> T bracketIfAlive(@NotNull Function0<? extends T> opening, @NotNull Function0<Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        return this.executeIfAlive((Function0)new Function0<T>(this, opening, terminationAction){
            final /* synthetic */ LifetimeDefinition this$0;
            final /* synthetic */ Function0 $opening;
            final /* synthetic */ Function0 $terminationAction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final T invoke() {
                void var1_1;
                Object res = this.$opening.invoke();
                if (!LifetimeDefinition.access$tryAdd(this.this$0, this.$terminationAction)) {
                    this.$terminationAction.invoke();
                }
                return var1_1;
            }
            {
                this.this$0 = lifetimeDefinition;
                this.$opening = function0;
                this.$terminationAction = function02;
                super(0);
            }
        });
    }

    @Override
    @Nullable
    public <T> T bracketIfAliveEx(@NotNull Function0<? extends T> opening, @NotNull Function1<? super T, Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        return this.executeIfAlive((Function0)new Function0<T>(this, opening, terminationAction){
            final /* synthetic */ LifetimeDefinition this$0;
            final /* synthetic */ Function0 $opening;
            final /* synthetic */ Function1 $terminationAction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final T invoke() {
                void var1_1;
                Object res = this.$opening.invoke();
                if (!LifetimeDefinition.access$tryAdd(this.this$0, new Function0<Unit>(this, res){
                    final /* synthetic */ bracketIfAliveEx.1 this$0;
                    final /* synthetic */ Object $res;

                    public final void invoke() {
                        this.this$0.$terminationAction.invoke(this.$res);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$res = object;
                        super(0);
                    }
                })) {
                    this.$terminationAction.invoke(res);
                }
                return var1_1;
            }
            {
                this.this$0 = lifetimeDefinition;
                this.$opening = function0;
                this.$terminationAction = function1;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public <T> T bracketOrThrow(@NotNull Function0<? extends T> opening, @NotNull Function0<Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        T t = this.bracketIfAlive(opening, terminationAction);
        if (t == null) {
            throw (Throwable)new CancellationException();
        }
        return t;
    }

    @Override
    @NotNull
    public <T> T bracketOrThrowEx(@NotNull Function0<? extends T> opening, @NotNull Function1<? super T, Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        T t = this.bracketIfAliveEx(opening, terminationAction);
        if (t == null) {
            throw (Throwable)new CancellationException();
        }
        return t;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Lifetime `");
        Object object = this.id;
        if (object == null) {
            object = anonymousLifetimeId;
        }
        return stringBuilder.append(object).append("` [").append((Object)this.getStatus()).append(", executing=").append(((Number)BitSliceKt.get(executingSlice, this.state)).intValue()).append(", resources=").append(this.resCount).append(']').toString();
    }

    public LifetimeDefinition() {
        super(null);
        this.state = new AtomicInteger();
        this.resources = new Object[1];
    }

    public LifetimeDefinition(@NotNull Lifetime parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this();
        parent.attach$rd_core(this, true);
    }

    static {
        Companion = new Companion(null);
        Object object = new LifetimeDefinition();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        ((LifetimeDefinition)$this$apply).id = "Eternal";
        eternal = object;
        log$delegate = LazyKt.lazy((Function0)Companion.log.2.INSTANCE);
        executingSlice = BitSlice.Companion.int$default(BitSlice.Companion, 20, null, 2, null);
        object = BitSlice.Companion;
        BitSlice prev$iv = executingSlice;
        boolean $i$f$enum = false;
        Enum[] values$iv = LifetimeStatus.values();
        bl3 = values$iv.length >= 2;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "Bit slice for enums with " + values$iv + " values is meaningless";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        statusSlice = new BitSlice.TypedBitSlice<LifetimeStatus>(values$iv, prev$iv, BitSliceKt.nextSliceLow(prev$iv), BitHacksKt.log2ceil(values$iv.length)){
            final /* synthetic */ Enum[] $values;
            final /* synthetic */ BitSlice $prev;
            {
                this.$values = $captured_local_variable$0;
                this.$prev = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public LifetimeStatus get(int host) {
                return this.$values[this.getRaw(host)];
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int updated(int host, @NotNull Enum value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.updatedRaw(host, value2.ordinal());
            }
        };
        mutexSlice = BitSlice.Companion.bool(statusSlice);
        logErrorAfterExecution = BitSlice.Companion.bool(mutexSlice);
        BitSlice.Companion this_$iv = BitSlice.Companion;
        prev$iv = logErrorAfterExecution;
        $i$f$enum = false;
        values$iv = LifetimeTerminationTimeoutKind.values();
        bl3 = values$iv.length >= 2;
        bl4 = false;
        bl5 = false;
        if (!bl3) {
            boolean bl7 = false;
            String string = "Bit slice for enums with " + values$iv + " values is meaningless";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        terminationTimeoutKindSlice = new BitSlice.TypedBitSlice<LifetimeTerminationTimeoutKind>(values$iv, prev$iv, BitSliceKt.nextSliceLow(prev$iv), BitHacksKt.log2ceil(values$iv.length)){
            final /* synthetic */ Enum[] $values;
            final /* synthetic */ BitSlice $prev;
            {
                this.$values = $captured_local_variable$0;
                this.$prev = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public LifetimeTerminationTimeoutKind get(int host) {
                return this.$values[this.getRaw(host)];
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int updated(int host, @NotNull Enum value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.updatedRaw(host, value2.ordinal());
            }
        };
        object = new LifetimeDefinition();
        boolean bl8 = false;
        bl2 = false;
        $this$apply = object;
        boolean bl9 = false;
        ((LifetimeDefinition)$this$apply).id = "Terminated";
        Terminated = object;
        LifetimeDefinition.terminate$default(Terminated, false, 1, null);
    }

    public static final /* synthetic */ void access$setState$p(LifetimeDefinition $this, AtomicInteger atomicInteger) {
        $this.state = atomicInteger;
    }

    public static final /* synthetic */ boolean access$tryAdd(LifetimeDefinition $this, Object action) {
        return $this.tryAdd(action);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$Companion;", "", "()V", "Terminated", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getTerminated", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "anonymousLifetimeId", "", "eternal", "getEternal$rd_core", "executingSlice", "Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "", "log", "Lcom/jetbrains/rd/util/Logger;", "getLog", "()Lcom/jetbrains/rd/util/Logger;", "log$delegate", "Lkotlin/Lazy;", "logErrorAfterExecution", "", "mutexSlice", "statusSlice", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "terminationTimeoutKindSlice", "Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "rd-core"})
    public static final class Companion {
        @NotNull
        public final LifetimeDefinition getEternal$rd_core() {
            return eternal;
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final LifetimeDefinition getTerminated() {
            return Terminated;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

