/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.FeaturedPluginsInfoProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.TimeoutCachedValue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f\u001a\u0012\u0010\u0012\u001a\u00020\u00012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\f\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a\u0010\u0010\u001c\u001a\u00020\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\n\u001a\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u001a\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0018H\u0002\u001a\u0014\u0010#\u001a\u00020\u001f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0000\u001a\u001e\u0010$\u001a\u00020\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a\u001a\u0010%\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\r\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006&"}, d2={"builtFromSources", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "jvmCore", "notListedPlugin", "platformPlugin", "getPlatformPlugin", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "pluginIdsFromOfficialJbPluginRepo", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/extensions/PluginId;", "tbePluginId", "", "unknownPlugin", "getUnknownPlugin", "findPluginTypeByValue", "Lcom/intellij/internal/statistic/utils/PluginType;", "value", "getPluginInfo", "aClass", "Ljava/lang/Class;", "className", "getPluginInfoByDescriptor", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginInfoByDescriptorWithFeaturedPlugins", "featuredPlugins", "Lcom/intellij/internal/statistic/FeaturedPluginsInfoProvider;", "getPluginInfoById", "pluginId", "isClassFromCoreOrJetBrainsPlugin", "", "clazz", "isCoreOrJetBrainsPlugin", "descriptor", "isPlatformOrJetBrainsBundled", "isPluginFromOfficialJbPluginRepo", "isSafeToReportFrom", "intellij.platform.statistics"})
public final class PluginInfoDetectorKt {
    private static final String tbePluginId = "org.jetbrains.toolbox-enterprise-client";
    private static final PluginInfo jvmCore = new PluginInfo(PluginType.JVM_CORE, null, null);
    @NotNull
    private static final PluginInfo platformPlugin = new PluginInfo(PluginType.PLATFORM, null, null);
    @NotNull
    private static final PluginInfo unknownPlugin = new PluginInfo(PluginType.UNKNOWN, null, null);
    private static final PluginInfo notListedPlugin = new PluginInfo(PluginType.NOT_LISTED, null, null);
    private static final PluginInfo builtFromSources = new PluginInfo(PluginType.FROM_SOURCES, null, null);
    private static final Supplier<Set<PluginId>> pluginIdsFromOfficialJbPluginRepo = (Supplier)new TimeoutCachedValue(1L, TimeUnit.HOURS, (Supplier)pluginIdsFromOfficialJbPluginRepo.1.INSTANCE);

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull Class<?> aClass) {
        PluginInfo pluginInfo;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"classLoader.pluginDescriptor");
            pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor(pluginDescriptor);
        } else if (PluginManagerCore.isRunningFromSources()) {
            pluginInfo = builtFromSources;
        } else {
            String string = aClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aClass.name");
            pluginInfo = PluginInfoDetectorKt.getPluginInfo(string);
        }
        return pluginInfo;
    }

    public static final boolean isPlatformOrJetBrainsBundled(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"classLoader.pluginDescriptor");
            PluginDescriptor plugin = pluginDescriptor;
            return plugin.isBundled() && PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)plugin);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            return true;
        }
        return PluginManagerCore.getPluginDescriptorIfIdeaClassLoaderIsUsed(aClass) == null;
    }

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"groovy.", (boolean)false, (int)2, null)) {
            return jvmCore;
        }
        PluginDescriptor pluginDescriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)className);
        if (pluginDescriptor == null) {
            return unknownPlugin;
        }
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"PluginManagerCore.getPlu\u2026) ?: return unknownPlugin");
        PluginDescriptor plugin = pluginDescriptor;
        return PluginInfoDetectorKt.getPluginInfoByDescriptor(plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoById(@Nullable PluginId pluginId) {
        if (pluginId == null) {
            return unknownPlugin;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (plugin == null) {
            return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo$default(pluginId, null, 2, null) ? new PluginInfo(PluginType.LISTED, pluginId.getIdString(), null) : unknownPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptor(@NotNull PluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return PluginInfoDetectorKt.getPluginInfoByDescriptorWithFeaturedPlugins(plugin, null);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptorWithFeaturedPlugins(@NotNull PluginDescriptor plugin, @Nullable FeaturedPluginsInfoProvider featuredPlugins) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)plugin.getPluginId())) {
            return platformPlugin;
        }
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.pluginId.idString");
        String id = string;
        String version = plugin.getVersion();
        if (PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)plugin)) {
            PluginType pluginType = plugin.isBundled() ? PluginType.JB_BUNDLED : (PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) ? PluginType.JB_UPDATED_BUNDLED : PluginType.JB_NOT_BUNDLED);
            return new PluginInfo(pluginType, id, version);
        }
        boolean listed = !plugin.isBundled() && !PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) && PluginInfoDetectorKt.isSafeToReportFrom(plugin, featuredPlugins);
        return listed ? new PluginInfo(PluginType.LISTED, id, version) : notListedPlugin;
    }

    @Nullable
    public static final PluginType findPluginTypeByValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (PluginType type : PluginType.values()) {
            if (!Intrinsics.areEqual((Object)type.name(), (Object)value)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static final PluginInfo getPlatformPlugin() {
        return platformPlugin;
    }

    @NotNull
    public static final PluginInfo getUnknownPlugin() {
        return unknownPlugin;
    }

    private static final boolean isSafeToReportFrom(PluginDescriptor descriptor, FeaturedPluginsInfoProvider featuredPlugins) {
        return PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor) ? true : (descriptor.isBundled() ? false : PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(descriptor.getPluginId(), featuredPlugins));
    }

    private static final boolean isPluginFromOfficialJbPluginRepo(PluginId pluginId, FeaturedPluginsInfoProvider featuredPlugins) {
        if (ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            if (featuredPlugins != null && PluginInfoDetectorKt.isClassFromCoreOrJetBrainsPlugin(featuredPlugins.getClass()) && CollectionsKt.contains((Iterable)featuredPlugins.getFeaturedPluginsFromMarketplace(), (Object)pluginId)) {
                return true;
            }
            Set<PluginId> set = pluginIdsFromOfficialJbPluginRepo.get();
            Intrinsics.checkNotNullExpressionValue(set, (String)"pluginIdsFromOfficialJbPluginRepo.get()");
            return CollectionsKt.contains((Iterable)set, (Object)pluginId);
        }
        return false;
    }

    static /* synthetic */ boolean isPluginFromOfficialJbPluginRepo$default(PluginId pluginId, FeaturedPluginsInfoProvider featuredPluginsInfoProvider, int n, Object object) {
        if ((n & 2) != 0) {
            featuredPluginsInfoProvider = null;
        }
        return PluginInfoDetectorKt.isPluginFromOfficialJbPluginRepo(pluginId, featuredPluginsInfoProvider);
    }

    private static final boolean isClassFromCoreOrJetBrainsPlugin(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)loader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"(loader as PluginAwareCl\u2026sLoader).pluginDescriptor");
            return PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(pluginDescriptor);
        }
        PluginDescriptor descriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)clazz.getName());
        return descriptor != null && PluginInfoDetectorKt.isCoreOrJetBrainsPlugin(descriptor);
    }

    private static final boolean isCoreOrJetBrainsPlugin(PluginDescriptor descriptor) {
        return Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)descriptor.getPluginId()) || PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)descriptor);
    }
}

