/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.utils.EventDescriptor;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0006R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/utils/EventsIdentityWindowThrottle;", "", "threshold", "", "alertThreshold", "periodMs", "", "(IIJ)V", "keyToCount", "Ljava/util/HashMap;", "", "Lcom/intellij/internal/statistic/utils/EventDescriptor;", "Lkotlin/collections/HashMap;", "isAlert", "", "descriptor", "setAlertThreshold", "", "newThreshold", "setThreshold", "tryPass", "Lcom/intellij/internal/statistic/utils/EventRateThrottleResult;", "key", "now", "intellij.platform.statistics"})
public final class EventsIdentityWindowThrottle {
    private HashMap<String, EventDescriptor> keyToCount;
    private int threshold;
    private int alertThreshold;
    private final long periodMs;

    public final void setThreshold(int newThreshold) {
        this.threshold = newThreshold;
    }

    public final void setAlertThreshold(int newThreshold) {
        this.alertThreshold = newThreshold;
    }

    @NotNull
    public final synchronized EventRateThrottleResult tryPass(@NotNull String key, long now) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        long period = now / this.periodMs;
        EventDescriptor descriptor = this.keyToCount.get(key);
        if (descriptor == null) {
            ((Map)this.keyToCount).put(key, new EventDescriptor(0, period, 1, null));
            return EventRateThrottleResult.ACCEPT;
        }
        if (period != descriptor.getLastPeriod()) {
            descriptor.resetCounter(period);
            return EventRateThrottleResult.ACCEPT;
        }
        if (descriptor.getCount() < this.threshold) {
            boolean alert = this.isAlert(descriptor);
            descriptor.incrementCounter();
            return alert ? EventRateThrottleResult.ALERT : EventRateThrottleResult.ACCEPT;
        }
        if (descriptor.getCount() == this.threshold) {
            descriptor.incrementCounter();
            return EventRateThrottleResult.DENY_AND_REPORT;
        }
        return EventRateThrottleResult.DENY;
    }

    private final boolean isAlert(EventDescriptor descriptor) {
        return this.alertThreshold > 0 && descriptor.getCount() == this.alertThreshold;
    }

    public EventsIdentityWindowThrottle(int threshold, int alertThreshold, long periodMs) {
        this.threshold = threshold;
        this.alertThreshold = alertThreshold;
        this.periodMs = periodMs;
        this.keyToCount = new HashMap();
    }
}

