/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PayloadKey;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomValidationRule
extends PerformanceCareRule
implements FUSRule,
UtilValidationRule {
    public static final ExtensionPointName<CustomValidationRule> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.validation.customValidationRule");
    public static final PayloadKey<PluginInfo> PLUGIN_INFO = new PayloadKey("plugin_info");

    public boolean acceptRuleId(@Nullable @NonNls String ruleId) {
        return this.getRuleId().equals(ruleId);
    }

    @NotNull
    public String getRuleId() {
        throw new UnsupportedOperationException(String.format("The method getRuleId must be overridden in %s", ((Object)((Object)this)).getClass()));
    }

    public static <T extends CustomValidationRule> T getCustomValidationRuleInstance(Class<T> clazz) {
        Optional<CustomValidationRule> optionalCustomValidationRule = EP_NAME.getExtensionList().stream().filter(customValidationRule -> ((Object)customValidationRule).getClass() == clazz).findFirst();
        if (optionalCustomValidationRule.isEmpty()) {
            throw new IllegalStateException(String.format("CustomValidationRule instance is not found for class %s.", clazz.getName()));
        }
        return (T)((Object)optionalCustomValidationRule.get());
    }

    @NotNull
    protected static ValidationResultType acceptWhenReportedByPluginFromPluginRepository(@NotNull EventContext context) {
        Object pluginType;
        PluginType type;
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(0);
        }
        PluginType pluginType2 = type = (pluginType = context.eventData.get("plugin_type")) != null ? PluginInfoDetectorKt.findPluginTypeByValue(pluginType.toString()) : null;
        if (type == null || !type.isSafeToReport()) {
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                CustomValidationRule.$$$reportNull$$$0(1);
            }
            return validationResultType;
        }
        if (type.isPlatformOrJvm() || type == PluginType.FROM_SOURCES || CustomValidationRule.hasPluginField(context)) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                CustomValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = ValidationResultType.REJECTED;
        if (validationResultType == null) {
            CustomValidationRule.$$$reportNull$$$0(3);
        }
        return validationResultType;
    }

    @NotNull
    protected static ValidationResultType acceptWhenReportedByJetBrainsPlugin(@NotNull EventContext context) {
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(4);
        }
        ValidationResultType validationResultType = CustomValidationRule.isReportedByJetBrainsPlugin(context) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        if (validationResultType == null) {
            CustomValidationRule.$$$reportNull$$$0(5);
        }
        return validationResultType;
    }

    protected static boolean isReportedByJetBrainsPlugin(@NotNull EventContext context) {
        Object pluginType;
        PluginType type;
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(6);
        }
        PluginType pluginType2 = type = (pluginType = context.eventData.get("plugin_type")) != null ? PluginInfoDetectorKt.findPluginTypeByValue(pluginType.toString()) : null;
        if (type == null || !type.isDevelopedByJetBrains()) {
            return false;
        }
        return type.isPlatformOrJvm() || type == PluginType.FROM_SOURCES || CustomValidationRule.hasPluginField(context);
    }

    protected static boolean hasPluginField(@NotNull EventContext context) {
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(7);
        }
        if (context.eventData.containsKey("plugin")) {
            Object plugin = context.eventData.get("plugin");
            return plugin instanceof String && StringUtil.isNotEmpty((String)((String)plugin));
        }
        return false;
    }

    protected static boolean isThirdPartyValue(@NotNull String data) {
        if (data == null) {
            CustomValidationRule.$$$reportNull$$$0(8);
        }
        return ValidationResultType.THIRD_PARTY.getDescription().equals(data);
    }

    protected static boolean isPluginFromPluginRepository(@NotNull String plugin) {
        PluginId pluginId;
        if (plugin == null) {
            CustomValidationRule.$$$reportNull$$$0(9);
        }
        return (pluginId = PluginId.findId((String)plugin)) != null && PluginInfoDetectorKt.getPluginInfoById(pluginId).isSafeToReport();
    }

    @Nullable
    protected Language getLanguage(@NotNull EventContext context) {
        Object id;
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(10);
        }
        return (id = context.eventData.get("lang")) instanceof String ? Language.findLanguageByID((String)((String)id)) : null;
    }

    @Nullable
    protected String getEventDataField(@NotNull EventContext context, @NotNull String name) {
        if (context == null) {
            CustomValidationRule.$$$reportNull$$$0(11);
        }
        if (name == null) {
            CustomValidationRule.$$$reportNull$$$0(12);
        }
        return context.eventData.containsKey(name) ? context.eventData.get(name).toString() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptWhenReportedByPluginFromPluginRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptWhenReportedByJetBrainsPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptWhenReportedByPluginFromPluginRepository";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptWhenReportedByJetBrainsPlugin";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReportedByJetBrainsPlugin";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasPluginField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isThirdPartyValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPluginFromPluginRepository";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEventDataField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

