/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.config;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogOptions {
    public static final String DATA_THRESHOLD = "dataThreshold";
    public static final String GROUP_THRESHOLD = "groupDataThreshold";
    public static final String GROUP_ALERT_THRESHOLD = "groupAlertThreshold";
    public static final String MACHINE_ID_SALT = "id_salt";
    public static final String MACHINE_ID_SALT_REVISION = "id_salt_revision";
    public static final String MACHINE_ID_DISABLED = "disabled";
    public static final String MACHINE_ID_UNKNOWN = "unknown";
    public static final int DEFAULT_ID_REVISION = 0;
    private final Map<String, String> myOptions;

    public EventLogOptions(Map<String, String> options) {
        this.myOptions = options;
    }

    public int getThreshold() {
        return this.getOptionAsInt(DATA_THRESHOLD);
    }

    public int getGroupThreshold() {
        return this.getOptionAsInt(GROUP_THRESHOLD);
    }

    public int getGroupAlertThreshold() {
        return this.getOptionAsInt(GROUP_ALERT_THRESHOLD);
    }

    public int getMachineIdRevision() {
        return this.getOptionAsInt(MACHINE_ID_SALT_REVISION);
    }

    public String getMachineIdSalt() {
        return this.myOptions.get(MACHINE_ID_SALT);
    }

    private int getOptionAsInt(@NotNull String name) {
        if (name == null) {
            EventLogOptions.$$$reportNull$$$0(0);
        }
        return EventLogOptions.tryParseInt(this.myOptions.get(name));
    }

    public static int tryParseInt(@Nullable String value) {
        try {
            if (StatisticsStringUtil.isNotEmpty(value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/internal/statistic/config/EventLogOptions", "getOptionAsInt"));
    }
}

