/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SLRUMap<K, V> {
    private final LinkedHashMap<K, V> myProtectedQueue;
    private final LinkedHashMap<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits;
    private int protectedHits;
    private int misses;
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this(protectedQueueSize, probationalQueueSize, EqualityPolicy.CANONICAL);
    }

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, @NotNull EqualityPolicy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            SLRUMap.$$$reportNull$$$0(0);
        }
        this.myProtectedQueueSize = protectedQueueSize * FACTOR;
        this.myProbationalQueueSize = probationalQueueSize * FACTOR;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(key, value);
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProbationalQueueSize) {
                    SLRUMap.this.onDropFromCache(key, value);
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public V get(K key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.putToProtectedQueue(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    protected void putToProtectedQueue(K key, @NotNull V value) {
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(1);
        }
        this.myProtectedQueue.put(this.getStableKey(key), value);
    }

    public void put(K key, @NotNull V value) {
        V oldValue;
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(2);
        }
        if ((oldValue = this.myProtectedQueue.remove(key)) != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(this.getStableKey(key), value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, @NotNull V value) {
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(3);
        }
    }

    public boolean remove(K key) {
        V value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public void iterateKeys(Consumer<? super K> keyConsumer) {
        for (K key : this.myProtectedQueue.keySet()) {
            keyConsumer.consume(key);
        }
        for (K key : this.myProbationalQueue.keySet()) {
            keyConsumer.consume(key);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clearByCondition(@NotNull Condition<? super V> condition) {
        if (condition == null) {
            SLRUMap.$$$reportNull$$$0(4);
        }
        this.clearByCondition(condition, this.myProtectedQueue);
        this.clearByCondition(condition, this.myProbationalQueue);
    }

    private void clearByCondition(@NotNull Condition<? super V> condition, @NotNull LinkedHashMap<K, V> queue) {
        if (condition == null) {
            SLRUMap.$$$reportNull$$$0(5);
        }
        if (queue == null) {
            SLRUMap.$$$reportNull$$$0(6);
        }
        Iterator<Map.Entry<K, V>> iterator = queue.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!condition.value(entry.getValue())) continue;
            this.onDropFromCache(entry.getKey(), entry.getValue());
            iterator.remove();
        }
    }

    public void clear() {
        try {
            if (!this.myProtectedQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProtectedQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
            if (!this.myProbationalQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProbationalQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.myProtectedQueue.clear();
            this.myProbationalQueue.clear();
        }
    }

    private K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }

    @NotNull
    public String dumpStats() {
        String string = "probational hits = " + this.probationalHits + ", protected hits = " + this.protectedHits + ", misses = " + this.misses;
        if (string == null) {
            SLRUMap.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SLRUMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SLRUMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putToProtectedQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onDropFromCache";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearByCondition";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

