/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.cli;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.ivy.util.cli.ParseException;

public class Option {
    private String name;
    private String[] args;
    private String description;
    private boolean required;
    private boolean countArgs;
    private boolean deprecated;

    Option(String name2, String[] args, String description2, boolean required, boolean countArgs, boolean deprecated) {
        this.name = name2;
        this.args = args;
        this.description = description2;
        this.required = required;
        this.countArgs = countArgs;
        this.deprecated = deprecated;
        if (required) {
            throw new UnsupportedOperationException("required option not supported yet");
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCountArgs() {
        return this.countArgs;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    String[] parse(ListIterator<String> iterator2) throws ParseException {
        if (this.isCountArgs()) {
            String[] values2 = new String[this.args.length];
            for (int i = 0; i < values2.length; ++i) {
                if (!iterator2.hasNext()) {
                    this.missingArgument(i);
                }
                values2[i] = iterator2.next();
                if (!values2[i].startsWith("-")) continue;
                this.missingArgument(i);
            }
            return values2;
        }
        ArrayList<String> values3 = new ArrayList<String>();
        while (iterator2.hasNext()) {
            String value2 = iterator2.next();
            if (value2.startsWith("-")) {
                iterator2.previous();
                break;
            }
            values3.add(value2);
        }
        return values3.toArray(new String[values3.size()]);
    }

    private void missingArgument(int i) throws ParseException {
        if (i == 0) {
            throw new ParseException("no argument for: " + this.name);
        }
        throw new ParseException("missing argument for: " + this.name + ". Expected: " + this.getArgsSpec());
    }

    public String getSpec() {
        return "-" + this.name + " " + this.getArgsSpec();
    }

    private String getArgsSpec() {
        if (this.args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : this.args) {
            sb.append("<").append(arg).append("> ");
        }
        return sb.toString();
    }
}

