/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.StringUtils;

public class Configurator {
    private FileResolver fileResolver = FileResolver.DEFAULT;
    private Map<String, Class<?>> typedefs = new HashMap();
    private Map<String, MacroDef> macrodefs = new HashMap<String, MacroDef>();
    private Stack<ObjectDescriptor> objectStack = new Stack();
    private static final List<String> TRUE_VALUES = Arrays.asList("true", "yes", "on");

    public void typeDef(String name2, String className2) throws ClassNotFoundException {
        this.typeDef(name2, Class.forName(className2));
    }

    public void typeDef(String name2, Class<?> clazz) {
        this.typedefs.put(name2, clazz);
    }

    public void setRoot(Object root2) {
        if (root2 == null) {
            throw new NullPointerException();
        }
        this.objectStack.clear();
        this.setCurrent(root2, null);
    }

    public void clear() {
        this.objectStack.clear();
    }

    private void setCurrent(Object object, String name2) {
        this.objectStack.push(new ObjectDescriptor(object, name2));
    }

    public Object startCreateChild(String name2) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor parentOD = this.objectStack.peek();
        Object parent = parentOD.getObject();
        if (parent instanceof MacroDef && !"attribute".equals(name2) && !"element".equals(name2)) {
            MacroRecord record = ((MacroDef)parent).recordCreateChild(name2);
            this.setCurrent(record, name2);
            return record;
        }
        if (parent instanceof Macro) {
            MacroRecord record = ((Macro)parent).recordCreateChild(name2);
            this.setCurrent(record, name2);
            return record;
        }
        if (parent instanceof MacroRecord) {
            MacroRecord record = ((MacroRecord)parent).recordChild(name2);
            this.setCurrent(record, name2);
            return record;
        }
        HashMap child = null;
        MacroDef macrodef = this.macrodefs.get(name2);
        if (macrodef != null) {
            Macro macro = macrodef.createMacro();
            this.setCurrent(macro, name2);
            return macro;
        }
        Class<?> childClass = this.typedefs.get(name2);
        Method addChild = null;
        try {
            if (childClass != null) {
                return this.addChild(parentOD, childClass, name2, null);
            }
            addChild = parentOD.getCreateMethod(name2);
            if (addChild != null) {
                child = addChild.invoke(parent, new Object[0]);
                this.setCurrent(child, name2);
                return child;
            }
            addChild = parentOD.getAddMethod(name2);
            if (addChild != null) {
                childClass = addChild.getParameterTypes()[0];
                child = childClass.newInstance();
                addChild.invoke(parent, child);
                this.setCurrent(child, name2);
                return child;
            }
            addChild = parentOD.getAddConfiguredMethod(name2);
            if (addChild != null) {
                childClass = addChild.getParameterTypes()[0];
                child = Map.class == childClass ? new HashMap() : childClass.newInstance();
                this.setCurrent(child, name2);
                return child;
            }
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("no default constructor on " + childClass + " for adding " + name2 + " on " + parent.getClass());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad method found for " + name2 + " on " + parent.getClass(), ex);
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + name2 + " on " + parent.getClass());
    }

    public void addChild(String name2, Object child) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor parentOD = this.objectStack.peek();
        try {
            this.addChild(parentOD, child.getClass(), name2, child);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("no default constructor on " + child.getClass() + " for adding " + name2 + " on " + parentOD.getObject().getClass());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("bad method found for " + name2 + " on " + parentOD.getObject().getClass(), ex);
        }
    }

    private Object addChild(ObjectDescriptor parentOD, Class<?> childClass, String name2, Object child) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object parent = parentOD.getObject();
        if (parent instanceof MacroRecord) {
            MacroRecord record = (MacroRecord)parent;
            MacroRecord recordChild = record.recordChild(name2, child);
            this.setCurrent(recordChild, name2);
            return recordChild;
        }
        Method addChild = parentOD.getAddMethod(childClass);
        if (addChild != null) {
            if (child == null) {
                child = childClass.newInstance();
            }
            addChild.invoke(parent, child);
            this.setCurrent(child, name2);
            return child;
        }
        addChild = parentOD.getAddConfiguredMethod(childClass);
        if (addChild != null) {
            if (child == null) {
                child = Map.class == childClass ? new HashMap() : childClass.newInstance();
            }
            this.setCurrent(child, name2);
            return child;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + name2 + " on " + parent.getClass());
    }

    public boolean isTopLevelMacroRecord() {
        if (this.objectStack.isEmpty()) {
            return false;
        }
        ObjectDescriptor od = this.objectStack.peek();
        return od.getObject() instanceof MacroDef;
    }

    public void setAttribute(String attributeName, String value2) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before setting attribute");
        }
        ObjectDescriptor od = this.objectStack.peek();
        if (od.getObject() instanceof Macro) {
            ((Macro)od.getObject()).defineAttribute(attributeName, value2);
            return;
        }
        if (od.getObject() instanceof MacroRecord) {
            ((MacroRecord)od.getObject()).recordAttribute(attributeName, value2);
            return;
        }
        Method m2 = od.getSetMethod(attributeName);
        if (m2 == null) {
            if (od.getObject() instanceof Map) {
                ((Map)od.getObject()).put(attributeName, value2);
                return;
            }
            throw new IllegalArgumentException("no set method found for " + attributeName + " on " + od.getObject().getClass());
        }
        Object convertedValue = null;
        Class<?> paramClass = m2.getParameterTypes()[0];
        try {
            convertedValue = paramClass.equals(String.class) ? value2 : (paramClass.equals(Boolean.class) || paramClass.equals(Boolean.TYPE) ? Boolean.valueOf(TRUE_VALUES.contains(value2)) : (paramClass.equals(Character.class) || paramClass.equals(Character.TYPE) ? Character.valueOf(value2.length() > 0 ? value2.charAt(0) : (char)' ') : (paramClass.equals(Short.class) || paramClass.equals(Short.TYPE) ? Short.valueOf(value2) : (paramClass.equals(Integer.class) || paramClass.equals(Integer.TYPE) ? Integer.valueOf(value2) : (paramClass.equals(Long.class) || paramClass.equals(Long.TYPE) ? Long.valueOf(value2) : (paramClass.equals(Class.class) ? Class.forName(value2) : (paramClass.equals(File.class) ? this.fileResolver.resolveFile(value2, od.getObjectName() + "." + attributeName) : paramClass.getConstructor(String.class).newInstance(value2))))))));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("impossible to convert " + value2 + " to " + paramClass + " for setting " + attributeName + " on " + od.getObject().getClass() + ": " + ex.getMessage(), ex);
        }
        try {
            m2.invoke(od.getObject(), convertedValue);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("impossible to set " + attributeName + " to " + convertedValue + " on " + od.getObject().getClass(), ex);
        }
    }

    public void addText(String text2) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before adding text");
        }
        ObjectDescriptor od = this.objectStack.peek();
        try {
            od.getObject().getClass().getMethod("addText", String.class).invoke(od.getObject(), text2);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("impossible to add text on " + od.getObject().getClass(), ex);
        }
    }

    public Object endCreateChild() {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before ending child");
        }
        ObjectDescriptor od = this.objectStack.pop();
        if (this.objectStack.isEmpty()) {
            this.objectStack.push(od);
            throw new IllegalStateException("cannot end root");
        }
        if (od.getObject() instanceof Macro) {
            return ((Macro)od.getObject()).play(this);
        }
        ObjectDescriptor parentOD = this.objectStack.peek();
        String name2 = od.getObjectName();
        Class<?> childClass = this.typedefs.get(name2);
        Method m2 = childClass == null ? parentOD.getAddConfiguredMethod(name2) : parentOD.getAddConfiguredMethod(childClass);
        try {
            if (m2 != null) {
                m2.invoke(parentOD.getObject(), od.getObject());
            }
            return od.getObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("impossible to add configured child for " + name2 + " on " + parentOD.getObject().getClass() + ": " + StringUtils.getErrorMessage(ex), ex);
        }
    }

    public Object getCurrent() {
        return this.objectStack.isEmpty() ? null : this.objectStack.peek().getObject();
    }

    public int getDepth() {
        return this.objectStack.size();
    }

    public MacroDef startMacroDef(String macroName) {
        MacroDef macroDef = new MacroDef(macroName);
        this.setCurrent(macroDef, macroName);
        return macroDef;
    }

    public void addMacroAttribute(String attName, String attDefaultValue) {
        ((MacroDef)this.getCurrent()).addAttribute(attName, attDefaultValue);
    }

    public void addMacroElement(String elementName, boolean optional) {
        ((MacroDef)this.getCurrent()).addElement(elementName, optional);
    }

    public void endMacroDef() {
        this.addConfiguredMacrodef((MacroDef)this.getCurrent());
        this.objectStack.pop();
    }

    public void addConfiguredMacrodef(MacroDef macrodef) {
        this.macrodefs.put(macrodef.getName(), macrodef);
    }

    public Class<?> getTypeDef(String name2) {
        return this.typedefs.get(name2);
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        Checks.checkNotNull(fileResolver, "fileResolver");
        this.fileResolver = fileResolver;
    }

    private static class ObjectDescriptor {
        private Object obj;
        private String objName;
        private Map<String, Method> createMethods = new HashMap<String, Method>();
        private Map<String, Method> addMethods = new HashMap<String, Method>();
        private Map<String, Method> addConfiguredMethods = new HashMap<String, Method>();
        private Map<String, Method> setMethods = new HashMap<String, Method>();
        private Map<Class<?>, Method> typeAddMethods = new HashMap();
        private Map<Class<?>, Method> typeAddConfiguredMethods = new HashMap();

        public ObjectDescriptor(Object object, String objName) {
            this.obj = object;
            this.objName = objName;
            for (Method m2 : object.getClass().getMethods()) {
                String name2;
                if (m2.getName().startsWith("create") && m2.getParameterTypes().length == 0 && !Void.TYPE.equals(m2.getReturnType())) {
                    name2 = StringUtils.uncapitalize(m2.getName().substring("create".length()));
                    if (name2.length() == 0) continue;
                    this.addCreateMethod(name2, m2);
                    continue;
                }
                if (m2.getName().startsWith("addConfigured") && m2.getParameterTypes().length == 1 && Void.TYPE.equals(m2.getReturnType())) {
                    name2 = StringUtils.uncapitalize(m2.getName().substring("addConfigured".length()));
                    if (name2.length() == 0) {
                        this.addAddConfiguredMethod(m2);
                    }
                    this.addAddConfiguredMethod(name2, m2);
                    continue;
                }
                if (m2.getName().startsWith("add") && !m2.getName().startsWith("addConfigured") && m2.getParameterTypes().length == 1 && Void.TYPE.equals(m2.getReturnType())) {
                    name2 = StringUtils.uncapitalize(m2.getName().substring("add".length()));
                    if (name2.length() == 0) {
                        this.addAddMethod(m2);
                    }
                    this.addAddMethod(name2, m2);
                    continue;
                }
                if (!m2.getName().startsWith("set") || m2.getParameterTypes().length != 1 || !Void.TYPE.equals(m2.getReturnType()) || (name2 = StringUtils.uncapitalize(m2.getName().substring("set".length()))).length() == 0) continue;
                this.addSetMethod(name2, m2);
            }
        }

        public void addCreateMethod(String name2, Method m2) {
            this.createMethods.put(name2, m2);
        }

        public void addAddMethod(String name2, Method m2) {
            this.addMethods.put(name2, m2);
        }

        public void addAddConfiguredMethod(String name2, Method m2) {
            this.addConfiguredMethods.put(name2, m2);
        }

        private void addAddMethod(Method m2) {
            this.typeAddMethods.put(m2.getParameterTypes()[0], m2);
        }

        private void addAddConfiguredMethod(Method m2) {
            this.typeAddConfiguredMethods.put(m2.getParameterTypes()[0], m2);
        }

        public void addSetMethod(String name2, Method m2) {
            Method current2 = this.setMethods.get(name2);
            if (current2 != null && current2.getParameterTypes()[0] == String.class) {
                return;
            }
            this.setMethods.put(name2, m2);
        }

        public Object getObject() {
            return this.obj;
        }

        public Method getCreateMethod(String name2) {
            return this.createMethods.get(name2);
        }

        public Method getAddMethod(String name2) {
            return this.addMethods.get(name2);
        }

        public Method getAddConfiguredMethod(String name2) {
            return this.addConfiguredMethods.get(name2);
        }

        public Method getAddMethod(Class<?> type) {
            return this.getTypeMatchingMethod(type, this.typeAddMethods);
        }

        public Method getAddConfiguredMethod(Class<?> type) {
            return this.getTypeMatchingMethod(type, this.typeAddConfiguredMethods);
        }

        private Method getTypeMatchingMethod(Class<?> type, Map<Class<?>, Method> typeMethods) {
            Method m2 = typeMethods.get(type);
            if (m2 != null) {
                return m2;
            }
            for (Map.Entry<Class<?>, Method> method : typeMethods.entrySet()) {
                if (!method.getKey().isAssignableFrom(type)) continue;
                return method.getValue();
            }
            return null;
        }

        public Method getSetMethod(String name2) {
            return this.setMethods.get(name2);
        }

        public String getObjectName() {
            return this.objName;
        }
    }

    public static class MacroDef {
        private String name;
        private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
        private Map<String, Element> elements = new HashMap<String, Element>();
        private MacroRecord macroRecord;

        public MacroDef(String macroName) {
            this.name = macroName;
        }

        public Attribute getAttribute(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public Object play(Configurator conf, Map<String, String> attValues, Map<String, List<MacroRecord>> macroRecords) {
            for (Attribute att : this.attributes.values()) {
                String val = attValues.get(att.getName());
                if (val != null) continue;
                if (att.getDefault() == null) {
                    throw new IllegalArgumentException("attribute " + att.getName() + " is required in " + this.getName());
                }
                attValues.put(att.getName(), att.getDefault());
            }
            return this.play(conf, this.macroRecord, attValues, macroRecords);
        }

        private Object play(Configurator conf, MacroRecord macroRecord, Map<String, String> attValues, Map<String, List<MacroRecord>> childrenRecords) {
            if (macroRecord.getObject() != null) {
                conf.addChild(macroRecord.getName(), macroRecord.getObject());
                conf.endCreateChild();
                return macroRecord.getObject();
            }
            conf.startCreateChild(macroRecord.getName());
            for (Map.Entry<String, String> attribute : macroRecord.getAttributes().entrySet()) {
                conf.setAttribute(attribute.getKey(), this.replaceParam(attribute.getValue(), attValues));
            }
            for (MacroRecord child : macroRecord.getChildren()) {
                Element elt = this.elements.get(child.getName());
                if (elt != null) {
                    List<MacroRecord> elements2 = childrenRecords.get(child.getName());
                    if (elements2 != null) {
                        for (MacroRecord element : elements2) {
                            for (MacroRecord r : element.getChildren()) {
                                this.play(conf, r, attValues, Collections.emptyMap());
                            }
                        }
                        continue;
                    }
                    if (elt.isOptional()) continue;
                    throw new IllegalArgumentException("non optional element is not specified: " + elt.getName() + " in macro " + this.getName());
                }
                this.play(conf, child, attValues, childrenRecords);
            }
            return conf.endCreateChild();
        }

        private String replaceParam(String string2, Map<String, String> attValues) {
            return IvyPatternHelper.substituteParams(string2, attValues);
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguredAttribute(Attribute att) {
            this.attributes.put(att.getName(), att);
        }

        public void addConfiguredElement(Element elt) {
            this.elements.put(elt.getName(), elt);
        }

        public Macro createMacro() {
            return new Macro(this);
        }

        public void addAttribute(String attName, String attDefaultValue) {
            Attribute att = new Attribute();
            att.setName(attName);
            att.setDefault(attDefaultValue);
            this.addConfiguredAttribute(att);
        }

        public void addElement(String elementName, boolean optional) {
            Element elt = new Element();
            elt.setName(elementName);
            elt.setOptional(optional);
            this.addConfiguredElement(elt);
        }

        public MacroRecord recordCreateChild(String name2) {
            this.macroRecord = new MacroRecord(name2);
            return this.macroRecord;
        }
    }

    public static class MacroRecord {
        private String name;
        private Map<String, String> attributes = new LinkedHashMap<String, String>();
        private List<MacroRecord> children = new ArrayList<MacroRecord>();
        private Object object;

        public MacroRecord(String name2) {
            this.name = name2;
        }

        public String getName() {
            return this.name;
        }

        public void recordAttribute(String name2, String value2) {
            this.attributes.put(name2, value2);
        }

        public MacroRecord recordChild(String name2) {
            MacroRecord child = new MacroRecord(name2);
            this.children.add(child);
            return child;
        }

        public MacroRecord recordChild(String name2, Object object) {
            MacroRecord child = this.recordChild(name2);
            child.object = object;
            return child;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public List<MacroRecord> getChildren() {
            return this.children;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class Element {
        private String name;
        private boolean optional = false;

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDefault(String default1) {
            this.defaultValue = default1;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }
    }

    public static class Macro {
        private MacroDef macrodef;
        private Map<String, String> attValues = new HashMap<String, String>();
        private Map<String, List<MacroRecord>> macroRecords = new HashMap<String, List<MacroRecord>>();

        public Macro(MacroDef def) {
            this.macrodef = def;
        }

        public void defineAttribute(String attributeName, String value2) {
            if (this.macrodef.getAttribute(attributeName) == null) {
                throw new IllegalArgumentException("undeclared attribute " + attributeName + " on macro " + this.macrodef.getName());
            }
            this.attValues.put(attributeName, value2);
        }

        public MacroRecord recordCreateChild(String name2) {
            MacroRecord macroRecord = new MacroRecord(name2);
            List<MacroRecord> records2 = this.macroRecords.get(name2);
            if (records2 == null) {
                records2 = new ArrayList<MacroRecord>();
                this.macroRecords.put(name2, records2);
            }
            records2.add(macroRecord);
            return macroRecord;
        }

        public Object play(Configurator conf) {
            return this.macrodef.play(conf, this.attValues, this.macroRecords);
        }
    }
}

