/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.File;
import java.util.ArrayList;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.resolver.util.FileURLLister;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.tools.analyser.JarModule;
import org.apache.ivy.util.Message;

public class JarModuleFinder {
    private String pattern;
    private String filePattern;

    public JarModuleFinder(String pattern2) {
        this.pattern = "file:///" + pattern2;
        this.filePattern = pattern2;
    }

    public JarModule[] findJarModules() {
        ArrayList<JarModule> ret = new ArrayList<JarModule>();
        FileURLLister lister = new FileURLLister();
        try {
            for (String org : ResolverHelper.listTokenValues(lister, this.pattern, "organisation")) {
                String orgPattern = IvyPatternHelper.substituteToken(this.pattern, "organisation", org);
                for (String module2 : ResolverHelper.listTokenValues(lister, orgPattern, "module")) {
                    String modPattern = IvyPatternHelper.substituteToken(orgPattern, "module", module2);
                    for (String rev : ResolverHelper.listTokenValues(lister, modPattern, "revision")) {
                        File jar = new File(IvyPatternHelper.substitute(this.filePattern, org, module2, rev, module2, "jar", "jar"));
                        if (!jar.exists()) continue;
                        ret.add(new JarModule(ModuleRevisionId.newInstance(org, module2, rev), jar));
                    }
                }
            }
        }
        catch (Exception e) {
            Message.debug(e);
        }
        return ret.toArray(new JarModule[ret.size()]);
    }

    public static void main(String[] args) {
        JarModule[] mods;
        for (JarModule mod : mods = new JarModuleFinder("D:/temp/test2/ivyrep/[organisation]/[module]/[revision]/[artifact].[ext]").findJarModules()) {
            System.out.println(mod);
        }
    }
}

