/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.ivy.core.report.ArtifactDownloadReport;

public class RetrieveReport {
    private Collection<File> upToDateFiles = new HashSet<File>();
    private Collection<File> copiedFiles = new HashSet<File>();
    private Map<File, ArtifactDownloadReport> downloadReport = new HashMap<File, ArtifactDownloadReport>();
    private File retrieveRoot;

    public File getRetrieveRoot() {
        return this.retrieveRoot;
    }

    public void setRetrieveRoot(File retrieveRoot) {
        this.retrieveRoot = retrieveRoot;
    }

    public int getNbrArtifactsCopied() {
        return this.copiedFiles.size();
    }

    public int getNbrArtifactsUpToDate() {
        return this.upToDateFiles.size();
    }

    public void addCopiedFile(File file2, ArtifactDownloadReport report2) {
        this.copiedFiles.add(file2);
        this.downloadReport.put(file2, report2);
    }

    public void addUpToDateFile(File file2, ArtifactDownloadReport report2) {
        this.upToDateFiles.add(file2);
        this.downloadReport.put(file2, report2);
    }

    public Collection<File> getCopiedFiles() {
        return new ArrayList<File>(this.copiedFiles);
    }

    public Collection<File> getUpToDateFiles() {
        return new ArrayList<File>(this.upToDateFiles);
    }

    public Collection<File> getRetrievedFiles() {
        ArrayList<File> result2 = new ArrayList<File>(this.upToDateFiles.size() + this.copiedFiles.size());
        result2.addAll(this.upToDateFiles);
        result2.addAll(this.copiedFiles);
        return result2;
    }

    public Map<File, ArtifactDownloadReport> getDownloadReport() {
        return this.downloadReport;
    }
}

