/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;

public class MatcherLookup {
    private static final String DEFAULT = "{org:default, module:default}";
    private Map<String, List<MapMatcher>> lookup = new HashMap<String, List<MapMatcher>>();
    private List<MapMatcher> nonExactMatchers = new ArrayList<MapMatcher>();

    public void add(MapMatcher matcher2) {
        if (!(matcher2.getPatternMatcher() instanceof ExactPatternMatcher)) {
            this.nonExactMatchers.add(matcher2);
            return;
        }
        String key2 = this.key(matcher2.getAttributes());
        List<MapMatcher> exactMatchers = this.lookup.get(key2);
        if (exactMatchers == null) {
            exactMatchers = new ArrayList<MapMatcher>();
            this.lookup.put(key2, exactMatchers);
        }
        exactMatchers.add(matcher2);
    }

    public List<MapMatcher> get(Map<String, String> attrs) {
        List<MapMatcher> defaultExactMatchers;
        String key2;
        List<MapMatcher> exactMatchers;
        ArrayList<MapMatcher> matchers = new ArrayList<MapMatcher>();
        if (!this.nonExactMatchers.isEmpty()) {
            for (MapMatcher matcher2 : this.nonExactMatchers) {
                if (!matcher2.matches(attrs)) continue;
                matchers.add(matcher2);
            }
        }
        if ((exactMatchers = this.lookup.get(key2 = this.key(attrs))) != null) {
            for (MapMatcher matcher3 : exactMatchers) {
                if (!matcher3.matches(attrs)) continue;
                matchers.add(matcher3);
            }
        }
        if (!DEFAULT.equals(key2) && (defaultExactMatchers = this.lookup.get(DEFAULT)) != null) {
            for (MapMatcher matcher4 : defaultExactMatchers) {
                if (!matcher4.matches(attrs)) continue;
                matchers.add(matcher4);
            }
        }
        return matchers;
    }

    private String key(Map<String, String> attrs) {
        String org = attrs.get("organisation");
        String module2 = attrs.get("module");
        if (org == null || "*".equals(org) || module2 == null || "*".equals(module2)) {
            return DEFAULT;
        }
        return "{org:" + org + ", module:" + module2 + "}";
    }
}

