/*
 * Decompiled with CFR 0.152.
 */
package libraries.coroutines.extra;

import java.security.Permission;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.ThreadSecurityManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\u001f\u0010\r\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010\u001dR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R#\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Llibraries/coroutines/extra/ThreadSecurityManager;", "Ljava/lang/SecurityManager;", "()V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "errorCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "modifyThreadGroupPermission", "Ljava/lang/RuntimePermission;", "preventThreadCreation", "Ljava/lang/ThreadLocal;", "", "resetAndCheck", "getResetAndCheck", "rootGroup", "Ljava/lang/ThreadGroup;", "kotlin.jvm.PlatformType", "getRootGroup", "()Ljava/lang/ThreadGroup;", "rootGroup$delegate", "Lkotlin/Lazy;", "allowThreadCreation", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkPermission", "", "perm", "Ljava/security/Permission;", "context", "getThreadGroup", "libraries-coroutines-extra"})
public final class ThreadSecurityManager
extends SecurityManager {
    @NotNull
    public static final ThreadSecurityManager INSTANCE = new ThreadSecurityManager();
    @NotNull
    private static final RuntimePermission modifyThreadGroupPermission = new RuntimePermission("modifyThreadGroup");
    private static boolean enabled;
    @NotNull
    private static final AtomicInteger errorCount;
    @NotNull
    private static final ThreadLocal<Object> preventThreadCreation;
    @NotNull
    private static final Lazy rootGroup$delegate;

    private ThreadSecurityManager() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    private final ThreadGroup getRootGroup() {
        Lazy lazy = rootGroup$delegate;
        return (ThreadGroup)lazy.getValue();
    }

    public final boolean getResetAndCheck() {
        return errorCount.getAndSet(0) > 0;
    }

    @Override
    @NotNull
    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup = this.getRootGroup();
        Intrinsics.checkNotNullExpressionValue((Object)threadGroup, (String)"rootGroup");
        return threadGroup;
    }

    @Override
    public void checkPermission(@NotNull Permission perm) {
        Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
        if (enabled && Intrinsics.areEqual((Object)perm, (Object)modifyThreadGroupPermission) && preventThreadCreation.get() != null) {
            errorCount.incrementAndGet();
            throw new SecurityException("Creating threads during org init is prohibited");
        }
    }

    @Override
    public void checkPermission(@NotNull Permission perm, @Nullable Object context2) {
        Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
        this.checkPermission(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T preventThreadCreation(@NotNull Function0<? extends T> handler) {
        Object object;
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (enabled) {
            Object object2;
            try {
                preventThreadCreation.set(this);
                object2 = handler.invoke();
            }
            finally {
                preventThreadCreation.remove();
            }
            object = object2;
        } else {
            object = handler.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T allowThreadCreation(@NotNull Function0<? extends T> handler) {
        Object object;
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (enabled) {
            Object object2;
            Object oldValue = preventThreadCreation.get();
            try {
                if (oldValue != null) {
                    preventThreadCreation.remove();
                }
                object2 = handler.invoke();
            }
            finally {
                if (oldValue == null) {
                    preventThreadCreation.remove();
                } else {
                    preventThreadCreation.set(oldValue);
                }
            }
            object = object2;
        } else {
            object = handler.invoke();
        }
        return (T)object;
    }

    static {
        errorCount = new AtomicInteger();
        preventThreadCreation = new ThreadLocal();
        rootGroup$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)rootGroup.2.INSTANCE);
    }
}

