/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.space.vcs.chat.editor.SpaceChatFile;
import com.intellij.space.vcs.chat.model.api.SpaceChatCreationDetails;
import com.intellij.space.vcs.chat.ui.SpaceChatUiDetails;
import com.intellij.space.vcs.diff.SpaceDiffFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0007J>\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00072\b\b\u0001\u0010\u0016\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u00072\b\b\u0001\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0003\u0010\u001e\u001a\u00020\u0007Rj\u0010\u0005\u001a^\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t*-\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u000b\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\f\u001a^\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r \t*-\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\u000b\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/space/vcs/editor/SpaceVirtualFilesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "chatFiles", "", "", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "Lcom/intellij/space/vcs/chat/editor/SpaceChatFile;", "", "diffFiles", "Lcom/intellij/space/vcs/diff/SpaceDiffFile;", "sessionId", "dispose", "", "findChatFile", "id", "findDiffFile", "fileId", "findOrCreateChatFile", "path", "displayName", "tabTooltip", "chatCreationDetails", "Lcom/intellij/space/vcs/chat/model/api/SpaceChatCreationDetails;", "chatUiDetails", "Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;", "findOrCreateDiffFile", "fileName", "intellij.space.vcs"})
public final class SpaceVirtualFilesManager
implements Disposable {
    private final String sessionId;
    private final Map<String, SpaceChatFile> chatFiles;
    private final Map<String, SpaceDiffFile> diffFiles;
    private final Project project;

    @Nullable
    public final SpaceChatFile findChatFile(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.chatFiles.get(id);
    }

    @Nullable
    public final SpaceDiffFile findDiffFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return this.diffFiles.get(fileId);
    }

    @NotNull
    public final SpaceChatFile findOrCreateChatFile(@NlsSafe @NotNull String id, @NlsSafe @NotNull String path2, @NlsContexts.TabTitle @NotNull String displayName, @NlsContexts.Tooltip @NotNull String tabTooltip, @NotNull SpaceChatCreationDetails chatCreationDetails2, @NotNull SpaceChatUiDetails chatUiDetails) {
        SpaceChatFile spaceChatFile;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)tabTooltip, (String)"tabTooltip");
        Intrinsics.checkNotNullParameter((Object)chatCreationDetails2, (String)"chatCreationDetails");
        Intrinsics.checkNotNullParameter((Object)chatUiDetails, (String)"chatUiDetails");
        Map<String, SpaceChatFile> $this$getOrPut$iv = this.chatFiles;
        boolean $i$f$getOrPut = false;
        SpaceChatFile value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            String string2 = this.project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
            SpaceChatFile answer$iv = new SpaceChatFile(this.sessionId, string2, id, path2, displayName, tabTooltip, chatCreationDetails2, chatUiDetails);
            $this$getOrPut$iv.put(id, answer$iv);
            spaceChatFile = answer$iv;
        } else {
            spaceChatFile = value$iv;
        }
        return spaceChatFile;
    }

    @NotNull
    public final SpaceDiffFile findOrCreateDiffFile(@NotNull String fileId, @Nls @NotNull String fileName) {
        SpaceDiffFile spaceDiffFile;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Map<String, SpaceDiffFile> $this$getOrPut$iv = this.diffFiles;
        boolean $i$f$getOrPut = false;
        SpaceDiffFile value$iv = $this$getOrPut$iv.get(fileId);
        if (value$iv == null) {
            boolean bl = false;
            String string2 = this.project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
            SpaceDiffFile answer$iv = new SpaceDiffFile(this.sessionId, string2, fileId, fileName);
            $this$getOrPut$iv.put(fileId, answer$iv);
            spaceDiffFile = answer$iv;
        } else {
            spaceDiffFile = value$iv;
        }
        return spaceDiffFile;
    }

    public static /* synthetic */ SpaceDiffFile findOrCreateDiffFile$default(SpaceVirtualFilesManager spaceVirtualFilesManager, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string2;
        }
        return spaceVirtualFilesManager.findOrCreateDiffFile(string2, string3);
    }

    public void dispose() {
        this.chatFiles.clear();
        this.diffFiles.clear();
    }

    public SpaceVirtualFilesManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.sessionId = String.valueOf(System.currentTimeMillis());
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap<String, SpaceChatFile>()");
        this.chatFiles = map2;
        Map map3 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakValueMap<String, SpaceDiffFile>()");
        this.diffFiles = map3;
    }
}

