/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.ui.header;

import circlet.code.api.CodeReviewState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.space.vcs.chat.model.impl.SpaceChatReviewHeaderDetails;
import com.intellij.space.vcs.chat.ui.SpaceChatAvatarType;
import com.intellij.space.vcs.chat.ui.SpaceChatContentPanelKt;
import com.intellij.space.vcs.chat.ui.header.SpaceChatReviewHeaderComponent$WhenMappings;
import com.intellij.space.vcs.chat.ui.issues.IssueIdsProcessorKt;
import com.intellij.space.vcs.review.HtmlEditorPane;
import com.intellij.util.ui.JBUI;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/vcs/chat/ui/header/SpaceChatReviewHeaderComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "details", "Lcom/intellij/space/vcs/chat/model/impl/SpaceChatReviewHeaderDetails;", "(Lcom/intellij/openapi/project/Project;Llibraries/coroutines/extra/Lifetime;Lcom/intellij/space/vcs/chat/model/impl/SpaceChatReviewHeaderDetails;)V", "stateIconSize", "", "getStateIconSize", "()I", "getHeaderHtml", "", "title", "reviewKey", "reviewUrl", "getReviewStateIcon", "Ljavax/swing/JComponent;", "state", "Lcirclet/code/api/CodeReviewState;", "Companion", "intellij.space.vcs"})
public final class SpaceChatReviewHeaderComponent
extends JPanel {
    private static final double STATE_ICON_FACTOR = 0.6666666666666666;
    private static final double STATE_ICON_GAP_FACTOR = 0.5;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final int getStateIconSize() {
        return (int)((double)SpaceChatAvatarType.MAIN_CHAT.getSize() * 0.6666666666666666);
    }

    private final JComponent getReviewStateIcon(CodeReviewState state2) {
        Icon icon2;
        switch (SpaceChatReviewHeaderComponent$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
            case 1: {
                icon2 = CollaborationToolsIcons.PullRequestOpen;
                break;
            }
            case 2: 
            case 3: {
                icon2 = CollaborationToolsIcons.PullRequestClosed;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"when (state) {\n      Cod\u2026s.PullRequestClosed\n    }");
        Icon icon3 = icon2;
        return new JLabel(UtilitiesKt.resizeIcon(icon3, this.getStateIconSize()));
    }

    @Nls
    private final String getHeaderHtml(@Nls String title2, @NlsSafe String reviewKey, @NlsSafe String reviewUrl) {
        HtmlBuilder builder = new HtmlBuilder().appendRaw(title2);
        if (reviewKey != null) {
            String string2 = reviewUrl != null ? HtmlChunk.link((String)reviewUrl, (String)reviewKey).toString() : reviewKey;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (reviewUrl != null) {\u2026        reviewKey\n      }");
            String link = string2;
            builder.nbsp().appendRaw(SpaceChatContentPanelKt.getGrayTextHtml(link));
        }
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"builder.toString()");
        return string3;
    }

    public SpaceChatReviewHeaderComponent(final @NotNull Project project2, @NotNull Lifetime lifetime, final @NotNull SpaceChatReviewHeaderDetails details) {
        HtmlEditorPane htmlEditorPane;
        SpaceComponentWrapper $this$apply;
        MigLayout migLayout;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.setOpaque(false);
        MigLayout migLayout2 = migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
        SpaceChatReviewHeaderComponent spaceChatReviewHeaderComponent = this;
        boolean bl = false;
        $this$apply.setColumnConstraints("[][]");
        Unit unit = Unit.INSTANCE;
        spaceChatReviewHeaderComponent.setLayout((LayoutManager)migLayout);
        SpaceComponentWrapper $this$apply2 = $this$apply = new SpaceComponentWrapper(null, null, 3, null);
        boolean bl2 = false;
        $this$apply2.setBorder((Border)JBUI.Borders.emptyRight((int)((int)((double)this.getStateIconSize() * 0.5))));
        final SpaceComponentWrapper reviewStateIconPanel = $this$apply;
        HtmlEditorPane $this$apply3 = htmlEditorPane = new HtmlEditorPane();
        boolean bl3 = false;
        Font font = $this$apply3.getFont();
        Font font2 = $this$apply3.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
        $this$apply3.setFont(font.deriveFont((float)((double)font2.getSize() * 1.5)));
        final HtmlEditorPane headerContent = htmlEditorPane;
        this.add((Component)((Object)reviewStateIconPanel), new CC().pushY());
        this.add((Component)((Object)headerContent), new CC().pushX().alignY("center"));
        details.getTitle().forEach(lifetime, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String newTitle) {
                Intrinsics.checkNotNullParameter((Object)newTitle, (String)"newTitle");
                headerContent.setBody(this.getHeaderHtml(IssueIdsProcessorKt.processIssueIdsHtml(project2, newTitle), details.getReviewKey(), details.getReviewUrl()));
            }
        }));
        details.getState().forEach(lifetime, (Function1<CodeReviewState, Unit>)((Function1)new Function1<CodeReviewState, Unit>(){

            public final void invoke(@NotNull CodeReviewState newState) {
                Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
                reviewStateIconPanel.setContent(this.getReviewStateIcon(newState));
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/space/vcs/chat/ui/header/SpaceChatReviewHeaderComponent$Companion;", "", "()V", "STATE_ICON_FACTOR", "", "STATE_ICON_GAP_FACTOR", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

