/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.stats;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.settings.CloneType;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.stats.SpaceStatsStateCollector$$special$;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/space/stats/SpaceStatsStateCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.space"})
public final class SpaceStatsStateCollector
extends ProjectUsagesCollector {
    @JvmField
    @NotNull
    public static final EventLogGroup GROUP;
    @JvmField
    @NotNull
    public static final BooleanEventField IS_ASSOCIATED_WITH_SPACE_REPO;
    @JvmField
    @NotNull
    public static final BooleanEventField IS_PROBABLY_CONTAINS_SPACE_REPO;
    @JvmField
    @NotNull
    public static final BooleanEventField AUTOMATION_FILE_EXISTS;
    @JvmField
    @NotNull
    public static final EnumEventField<CloneType> GIT_CLONE_TYPE;
    @JvmField
    @NotNull
    public static final EventId1<SpaceStatsCounterCollector.LoginState> LOGIN_STATE;
    @JvmField
    @NotNull
    public static final EventId2<Boolean, Boolean> ASSOCIATED_REPOS_STATE;
    @JvmField
    @NotNull
    public static final EventId1<Boolean> AUTOMATION_FILE_STATE;
    @JvmField
    @NotNull
    public static final EventId1<CloneType> GIT_CLONE_TYPE_STATE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        SpaceWorkspaceComponent workspace2 = SpaceWorkspaceComponent.Companion.getInstance();
        result2.add(LOGIN_STATE.metric((Object)SpaceStatsCounterCollector.LoginState.Companion.convert(workspace2.getLoginState().getValue())));
        CloneType cloneType = SpaceSettings.Companion.getInstance().getCloneType();
        result2.add(GIT_CLONE_TYPE_STATE.metric((Object)cloneType));
        return result2;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("space.state", 1, null, 4, null);
        IS_ASSOCIATED_WITH_SPACE_REPO = EventFields.Boolean((String)"is_associated_with_space_repo");
        IS_PROBABLY_CONTAINS_SPACE_REPO = EventFields.Boolean((String)"is_probably_contains_space_repo");
        AUTOMATION_FILE_EXISTS = EventFields.Boolean((String)"automation_file_exists");
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "type";
        Function1 transform$iv = $special$$inlined$Enum$1.INSTANCE;
        boolean $i$f$Enum = false;
        GIT_CLONE_TYPE = new EnumEventField(name$iv, CloneType.class, transform$iv);
        LOGIN_STATE = GROUP.registerEvent("login_status", (EventField)SpaceStatsCounterCollector.LOGIN_STATUS);
        ASSOCIATED_REPOS_STATE = GROUP.registerEvent("associated_repos_state", (EventField)IS_ASSOCIATED_WITH_SPACE_REPO, (EventField)IS_PROBABLY_CONTAINS_SPACE_REPO);
        AUTOMATION_FILE_STATE = GROUP.registerEvent("automation_file_state", (EventField)AUTOMATION_FILE_EXISTS);
        GIT_CLONE_TYPE_STATE = GROUP.registerEvent("git_clone_type", (EventField)GIT_CLONE_TYPE);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/space/stats/SpaceStatsStateCollector$Companion;", "", "()V", "ASSOCIATED_REPOS_STATE", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "AUTOMATION_FILE_EXISTS", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "AUTOMATION_FILE_STATE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "GIT_CLONE_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/space/settings/CloneType;", "GIT_CLONE_TYPE_STATE", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "IS_ASSOCIATED_WITH_SPACE_REPO", "IS_PROBABLY_CONTAINS_SPACE_REPO", "LOGIN_STATE", "Lcom/intellij/space/stats/SpaceStatsCounterCollector$LoginState;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

