/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/intellij/space/promo/ImageLoader;", "", "()V", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.space"})
final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Image loadImage(@NotNull String path2, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path2));
            Image image2 = img;
            BufferedImage bufferedImage = img;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"img");
            image = (Image)new JBHiDPIScaledImage(image2, width, height, bufferedImage.getType());
        }
        catch (Exception e) {
            void this_$iv;
            Object $this$logger$iv = this;
            boolean $i$f$logger = false;
            $this$logger$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ImageLoader.class));
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                void var9_8 = this_$iv;
                boolean bl = false;
                String string2 = "Image " + path2 + " is not loaded";
                var9_8.error(string2);
            }
            image = null;
        }
        return image;
    }

    private ImageLoader() {
    }

    static {
        ImageLoader imageLoader;
        INSTANCE = imageLoader = new ImageLoader();
    }
}

