/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LinesUtil;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.StringsPool;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDataLoader {
    public static final int REPORT_VERSION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData loadLocked(File sessionDataFile) {
        ProjectData projectData;
        CoverageIOUtil.FileLock lock = null;
        try {
            lock = CoverageIOUtil.FileLock.lock(sessionDataFile);
            projectData = ProjectDataLoader.load(sessionDataFile);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CoverageIOUtil.FileLock.unlock(lock);
            throw throwable;
        }
        CoverageIOUtil.FileLock.unlock(lock);
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ProjectData load(File sessionDataFile) {
        ProjectData projectInfo;
        block21: {
            ClassData classInfo;
            int c;
            projectInfo = new ProjectData();
            FilterInputStream in = null;
            if (sessionDataFile.length() == 0L) {
                return projectInfo;
            }
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(sessionDataFile)));
            TIntObjectHashMap<ClassData> dict = new TIntObjectHashMap<ClassData>(1000, 0.99f);
            int classCount = CoverageIOUtil.readINT((DataInput)((Object)in));
            for (c = 0; c < classCount; ++c) {
                classInfo = projectInfo.getOrCreateClassData(StringsPool.getFromPool(CoverageIOUtil.readUTFFast((DataInput)((Object)in))));
                dict.put(c, classInfo);
            }
            for (c = 0; c < classCount; ++c) {
                classInfo = (ClassData)dict.get(CoverageIOUtil.readINT((DataInput)((Object)in)));
                int methCount = CoverageIOUtil.readINT((DataInput)((Object)in));
                TIntObjectHashMap<LineData> lines = new TIntObjectHashMap<LineData>(4, 0.99f);
                int maxLine = -1;
                for (int m = 0; m < methCount; ++m) {
                    String methodSig = ProjectDataLoader.expand((DataInputStream)in, dict);
                    int lineCount = CoverageIOUtil.readINT((DataInput)((Object)in));
                    for (int l = 0; l < lineCount; ++l) {
                        int line = CoverageIOUtil.readINT((DataInput)((Object)in));
                        LineData lineInfo = (LineData)lines.get(line);
                        if (lineInfo == null) {
                            lineInfo = new LineData(line, StringsPool.getFromPool(methodSig));
                            lines.put(line, lineInfo);
                            if (line > maxLine) {
                                maxLine = line;
                            }
                        }
                        classInfo.registerMethodSignature(lineInfo);
                        String testName = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                        if (testName != null && testName.length() > 0) {
                            lineInfo.setTestName(testName);
                        }
                        int hits = CoverageIOUtil.readINT((DataInput)((Object)in));
                        lineInfo.setHits(hits);
                        if (hits > 0) {
                            int jumpsNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
                            for (int j = 0; j < jumpsNumber; ++j) {
                                lineInfo.setTrueHits(j, CoverageIOUtil.readINT((DataInput)((Object)in)));
                                lineInfo.setFalseHits(j, CoverageIOUtil.readINT((DataInput)((Object)in)));
                            }
                            int switchesNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
                            for (int s = 0; s < switchesNumber; ++s) {
                                int defaultHit = CoverageIOUtil.readINT((DataInput)((Object)in));
                                int keysLength = CoverageIOUtil.readINT((DataInput)((Object)in));
                                int[] keys = new int[keysLength];
                                int[] keysHits = new int[keysLength];
                                for (int k = 0; k < keysLength; ++k) {
                                    keys[k] = CoverageIOUtil.readINT((DataInput)((Object)in));
                                    keysHits[k] = CoverageIOUtil.readINT((DataInput)((Object)in));
                                }
                                lineInfo.setDefaultHits(s, keys, defaultHit);
                                lineInfo.setSwitchHits(s, keys, keysHits);
                            }
                        }
                        lineInfo.fillArrays();
                    }
                }
                classInfo.setLines(LinesUtil.calcLineArray(maxLine, lines));
            }
            ProjectDataLoader.loadExtraInfo(projectInfo, (DataInputStream)in, dict);
            Object var27_28 = null;
            try {
                in.close();
            }
            catch (IOException e2) {
                ErrorReporter.reportError("Failed to close file: " + sessionDataFile.getAbsolutePath(), e2);
            }
            break block21;
            {
                catch (Exception e) {
                    ErrorReporter.reportError("Failed to load coverage data from file: " + sessionDataFile.getAbsolutePath(), e);
                    ProjectData projectData = projectInfo;
                    Object var27_29 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        ErrorReporter.reportError("Failed to close file: " + sessionDataFile.getAbsolutePath(), e2);
                    }
                    return projectData;
                }
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    ErrorReporter.reportError("Failed to close file: " + sessionDataFile.getAbsolutePath(), e2);
                }
                throw throwable;
            }
        }
        return projectInfo;
    }

    private static String expand(DataInputStream in, final TIntObjectHashMap<ClassData> dict) throws IOException {
        return CoverageIOUtil.processWithDictionary(CoverageIOUtil.readUTFFast(in), new CoverageIOUtil.Consumer(){

            protected String consume(String type) {
                if (type.length() > 0 && Character.isDigit(type.charAt(0))) {
                    try {
                        int typeIdx = Integer.parseInt(type);
                        return ((ClassData)dict.get(typeIdx)).getName();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return type;
            }
        });
    }

    private static void loadExtraInfo(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict) throws IOException {
        int version;
        try {
            version = CoverageIOUtil.readINT(in);
        }
        catch (EOFException e) {
            return;
        }
        if (version > 1) {
            ErrorReporter.reportError("Report version " + version + " is greater than agent maximum support version " + 1 + "\nPlease try to update coverage agent.");
            return;
        }
        String infoString = CoverageIOUtil.readUTFFast(in);
        ReportSectionsUtil.loadSections(projectData, in, dict);
    }
}

