/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.rules.ErrorCollector;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0003\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001aF\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0000\u001a\\\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u000bj\u0002`\u00192\u0006\u0010\u0015\u001a\u00020\fH\u0002\u001a\\\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b2\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u000bj\u0002`\u00192\u0006\u0010\u0015\u001a\u00020\fH\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\"\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u000fH\u0000\u001a,\u0010!\u001a\u00020\u0001*\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u000bj\u0002`\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\fH\u0002\u001a\u000e\u0010$\u001a\u0004\u0018\u00010\u0006*\u00020%H\u0002\u001a \u0010&\u001a\u00020\u0006*\u00020\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002*\"\u0010'\"\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u000b2\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u000b\u00a8\u0006("}, d2={"appendToString", "", "spec", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "result", "", "", "indent", "", "relativePath", "filePathFilter", "Lkotlin/Function1;", "", "assertContentUnderFileMatches", "file", "Ljava/nio/file/Path;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "errorCollector", "Lorg/junit/rules/ErrorCollector;", "expectedDataIsInSpec", "assertDirectoryContentMatches", "errorReporter", "", "Lcom/intellij/util/io/impl/ErrorReporter;", "assertDirectoryMatches", "createSpecByPath", "path", "originalFile", "fillSpecFromDirectory", "dir", "originalDir", "assertTrue", "errorMessage", "condition", "convertToText", "", "toString", "ErrorReporter", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    private static final String toString(DirectorySpecBase $this$toString, Function1<? super String, Boolean> filePathFilter) {
        ArrayList arrayList;
        ArrayList it = arrayList = new ArrayList();
        boolean bl = false;
        DirectoryContentSpecImplKt.appendToString($this$toString, it, 0, ".", filePathFilter);
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendToString(DirectorySpecBase spec, List<String> result, int indent, String relativePath, Function1<? super String, Boolean> filePathFilter) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Iterable iterable = spec.getChildren().entrySet();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getValue() instanceof FileSpec) || (Boolean)filePathFilter.invoke((Object)(relativePath + "/" + (String)it.getKey())) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$filter$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator((Comparator)$this$filter$iv){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Map.Entry it;
                Comparator comparator = this.$comparator;
                Map.Entry entry = (Map.Entry)a;
                Comparator comparator2 = comparator;
                boolean bl = false;
                String string = (String)it.getKey();
                it = (Map.Entry)b;
                bl = false;
                String string2 = (String)it.getKey();
                return comparator2.compare(string, string2);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            result.add(StringsKt.repeat((CharSequence)" ", (int)indent) + (String)it.getKey());
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)it.getValue();
            if (!(child instanceof DirectorySpec)) continue;
            DirectoryContentSpecImplKt.appendToString((DirectorySpecBase)child, result, indent + 2, relativePath + "/" + (String)it.getKey(), filePathFilter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertContentUnderFileMatches(@NotNull Path file2, @NotNull DirectoryContentSpecImpl spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ErrorCollector errorCollector, boolean expectedDataIsInSpec) {
        DirectoryContentSpecImpl actualSpec;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        if (spec instanceof DirectorySpecBase && (actualSpec = DirectoryContentSpecImplKt.createSpecByPath(file2, file2)) instanceof DirectorySpecBase) {
            void expected;
            String specString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)spec, filePathFilter);
            String dirString = DirectoryContentSpecImplKt.toString((DirectorySpecBase)actualSpec, filePathFilter);
            Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            String string = (String)pair.component1();
            String actual = (String)pair.component2();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        Function1 errorReporter2 = errorCollector != null ? (Function1)new Function1<Throwable, Unit>(errorCollector){

            public final void invoke(Throwable p1) {
                ((ErrorCollector)this.receiver).addError(p1);
            }
        } : (Function1)assertContentUnderFileMatches.errorReporter.2.INSTANCE;
        DirectoryContentSpecImplKt.assertDirectoryContentMatches(file2, spec, ".", fileTextMatcher, filePathFilter, (Function1<? super Throwable, Unit>)errorReporter2, expectedDataIsInSpec);
    }

    private static final void assertTrue(Function1<? super Throwable, Unit> $this$assertTrue, String errorMessage, boolean condition) {
        if (!condition) {
            $this$assertTrue.invoke((Object)new AssertionError((Object)errorMessage));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void assertDirectoryContentMatches(Path file2, DirectoryContentSpecImpl spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, Function1<? super Throwable, Unit> errorReporter2, boolean expectedDataIsInSpec) {
        block1: {
            Object place;
            block3: {
                void expectedPath;
                void expected;
                byte[] fileBytes;
                DirectoryContentSpecImpl directoryContentSpecImpl;
                block2: {
                    block0: {
                        DirectoryContentSpecImplKt.assertTrue(errorReporter2, file2 + " doesn't exist", PathKt.exists((Path)file2));
                        directoryContentSpecImpl = spec;
                        if (!(directoryContentSpecImpl instanceof DirectorySpec)) break block0;
                        DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter2, expectedDataIsInSpec);
                        break block1;
                    }
                    if (!(directoryContentSpecImpl instanceof ZipSpec)) break block2;
                    DirectoryContentSpecImplKt.assertTrue(errorReporter2, file2 + " is not a file", PathKt.isFile((Path)file2));
                    Path dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + PathsKt.getName((Path)file2)), null, (boolean)false).toPath();
                    ZipUtil.extract((Path)file2, (Path)dirForExtracted, null);
                    Path path = dirForExtracted;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dirForExtracted");
                    DirectoryContentSpecImplKt.assertDirectoryMatches(path, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter, errorReporter2, expectedDataIsInSpec);
                    FileUtil.delete((Path)dirForExtracted);
                    break block1;
                }
                if (!(directoryContentSpecImpl instanceof FileSpec)) break block1;
                DirectoryContentSpecImplKt.assertTrue(errorReporter2, file2 + " is not a file", PathKt.isFile((Path)file2));
                if (((FileSpec)spec).getContent() == null || Arrays.equals(fileBytes = PathKt.readBytes((Path)file2), ((FileSpec)spec).getContent())) break block1;
                String fileString = DirectoryContentSpecImplKt.convertToText(fileBytes);
                String specString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                Object object = place = Intrinsics.areEqual((Object)relativePath, (Object)".") ^ true ? " at " + relativePath : "";
                if (fileString == null || specString == null) break block3;
                if (fileTextMatcher.matches(fileString, specString)) break block1;
                Comparable<Path> comparable = spec.getOriginalFile();
                String specFilePath = comparable != null && (comparable = comparable.toFile()) != null ? ((File)comparable).getAbsolutePath() : null;
                Object object2 = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)fileString) : TuplesKt.to((Object)fileString, (Object)specString);
                String string = (String)object2.component1();
                String actual = (String)object2.component2();
                Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specFilePath, null) : TuplesKt.to(null, (Object)specFilePath);
                object2 = (String)pair.component1();
                String actualPath = (String)pair.component2();
                errorReporter2.invoke((Object)new FileComparisonFailure("File content mismatch" + (String)place + ":", (String)expected, actual, (String)expectedPath, actualPath));
                break block1;
            }
            errorReporter2.invoke((Object)new AssertionError((Object)("Binary file content mismatch" + (String)place)));
        }
    }

    private static final String convertToText(byte[] $this$convertToText) {
        Charset charset;
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[new CharsetToolkit($this$convertToText, Charsets.UTF_8, false).guessFromContent($this$convertToText.length).ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String($this$convertToText, charset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void assertDirectoryMatches(Path file2, DirectorySpecBase spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter, Function1<? super Throwable, Unit> errorReporter2, boolean expectedDataIsInSpec) {
        String dirString;
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        List list;
        Iterable iterable;
        Iterable children2;
        DirectoryContentSpecImplKt.assertTrue(errorReporter2, file2 + " is not a directory", PathKt.isDirectory((Path)file2));
        var $fun$childNameFilter$1 = new Function1<String, Boolean>(filePathFilter, relativePath){
            final /* synthetic */ Function1 $filePathFilter;
            final /* synthetic */ String $relativePath;

            public final boolean invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return (Boolean)this.$filePathFilter.invoke((Object)(this.$relativePath + "/" + name));
            }
            {
                this.$filePathFilter = function1;
                this.$relativePath = string;
                super(1);
            }
        };
        Path $this$directoryStreamIfExists$iv = file2;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Path it2;
                void $this$filterTo$iv$iv2;
                children2 = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$filter$iv = children2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it2 = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Path path = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    if (!(PathKt.isDirectory((Path)path) || $fun$childNameFilter$1.invoke(PathsKt.getName((Path)it2)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Path path = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    String string = PathsKt.getName((Path)path);
                    collection.add(string);
                }
                children2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                iterable = children2;
            }
            catch (Throwable children2) {
                throwable = children2;
                throw children2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = list = null;
        }
        if (iterable == null) {
            list = CollectionsKt.emptyList();
        }
        List childrenNamesInDir = list;
        Map<String, DirectoryContentSpecImpl> children3 = spec.getChildren();
        Iterable $this$filter$iv = children3.entrySet();
        boolean $i$f$filter = false;
        children2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() instanceof DirectorySpec || $fun$childNameFilter$1.invoke((String)it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            collection.add(string);
        }
        List childrenNamesInSpec = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        String specString = CollectionsKt.joinToString$default((Iterable)childrenNamesInSpec, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (Intrinsics.areEqual((Object)specString, (Object)(dirString = CollectionsKt.joinToString$default((Iterable)childrenNamesInDir, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))) ^ true) {
            void expected;
            Pair pair = expectedDataIsInSpec ? TuplesKt.to((Object)specString, (Object)dirString) : TuplesKt.to((Object)dirString, (Object)specString);
            $this$mapTo$iv$iv = (String)pair.component1();
            String actual = (String)pair.component2();
            errorReporter2.invoke((Object)new ComparisonFailure("Directory content mismatch" + (String)(Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "") + ":", (String)expected, actual));
        }
        for (String child : childrenNamesInDir) {
            Path path = file2.resolve(child);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.resolve(child)");
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(path, (DirectoryContentSpecImpl)MapsKt.getValue(children3, (Object)child), relativePath + "/" + child, fileTextMatcher, filePathFilter, errorReporter2, expectedDataIsInSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fillSpecFromDirectory(@NotNull DirectorySpecBase spec, @NotNull Path dir, @Nullable Path originalDir) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream children = (DirectoryStream)closeable;
                boolean bl = false;
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    Path path2 = originalDir;
                    spec.addChild(((Object)path.getFileName()).toString(), DirectoryContentSpecImplKt.createSpecByPath(it, path2 != null ? path2.resolve(it.getFileName()) : null));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
    }

    private static final DirectoryContentSpecImpl createSpecByPath(Path path, Path originalFile) {
        if (PathKt.isDirectory((Path)path)) {
            DirectorySpec directorySpec;
            DirectorySpec it = directorySpec = new DirectorySpec(originalFile);
            boolean bl = false;
            DirectoryContentSpecImplKt.fillSpecFromDirectory(it, path, originalFile);
            return directorySpec;
        }
        if (SetsKt.setOf((Object[])new String[]{"zip", "jar"}).contains(PathsKt.getExtension((Path)path))) {
            ZipSpec zipSpec;
            Path dirForExtracted = FileUtil.createTempDirectory((String)("extracted-" + PathsKt.getName((Path)path)), null, (boolean)false).toPath();
            ZipUtil.extract((Path)path, (Path)dirForExtracted, null);
            ZipSpec it = zipSpec = new ZipSpec();
            boolean bl = false;
            DirectorySpecBase directorySpecBase = it;
            Path path2 = dirForExtracted;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dirForExtracted");
            DirectoryContentSpecImplKt.fillSpecFromDirectory(directorySpecBase, path2, null);
            return zipSpec;
        }
        return new FileSpec(Files.readAllBytes(path), originalFile);
    }
}

