/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class MarkupSurroundTestBase
extends LightPlatformCodeInsightTestCase {
    protected static final String BASE_PATH = "/codeInsight/surroundWith/";

    private List<InvokeTemplateAction> buildSurroundersForFileTypeWithGivenExtension() {
        return ContainerUtil.map((Collection)TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier((TemplateActionContext)TemplateActionContext.surrounding((PsiFile)this.getFile(), (Editor)this.getEditor())), template -> new InvokeTemplateAction(template, this.getEditor(), this.getProject(), new HashSet()));
    }

    protected void doSurroundWithTagTest(String ext) {
        String baseName = this.getBaseName("tag");
        this.configureByFile(baseName + "." + ext);
        List<InvokeTemplateAction> actions = this.buildSurroundersForFileTypeWithGivenExtension();
        actions.get(0).perform();
        this.checkResultByFile(baseName + "_after." + ext);
    }

    protected void doSurroundWithCDataTest(String ext) {
        String baseName = this.getBaseName("");
        this.configureByFile(baseName + "." + ext);
        this.buildSurroundersForFileTypeWithGivenExtension().get(1).perform();
        this.checkResultByFile(baseName + "_after." + ext);
    }

    private String getBaseName(String dir) {
        Object baseName = BASE_PATH;
        if (!dir.isEmpty()) {
            baseName = (String)baseName + dir + "/";
        }
        baseName = (String)baseName + this.getTestName(false);
        return baseName;
    }
}

