/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.merge;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class Merge
extends JFrame {
    private HelpSet masterHS;
    private URL masterURL;
    private ClassLoader myLoader;
    private JList hsList;
    private Hashtable clTable;
    private HelpSet mainHS = null;
    private HelpBroker mainHB;
    private Font font;
    private static boolean on12;
    private JButton removeButton;
    private JButton addButton;
    private JButton displayButton;
    private JMenuItem add;
    private JMenuItem remove;
    private JMenuItem setfont;
    private JMenuItem menuHelp;
    private JDialog addDialog;
    private JTextField helpSetName;
    private JTextField helpSetURL;
    private JTextArea helpSetURLs;
    private static final boolean debug = false;

    public Merge() {
        super("HelpSet Merge Demo");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        try {
            ClassLoader classLoader = this.getMyLoader();
            URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)"Master");
            this.mainHS = new HelpSet(classLoader, uRL);
        }
        catch (Exception exception) {
            System.out.println("Help Set Master not found");
            return;
        }
        this.mainHB = this.mainHS.createHelpBroker();
        this.initializeMasterHS();
        this.initializeGUI();
    }

    private void initializeMasterHS() {
        this.myLoader = this.getMyLoader();
        this.masterURL = HelpSet.findHelpSet((ClassLoader)this.myLoader, (String)"Master");
        try {
            this.masterHS = new HelpSet(this.myLoader, this.masterURL);
        }
        catch (Exception exception) {
            System.err.println("Could not create the master HelpSet");
            exception.printStackTrace();
            System.exit(1);
        }
        if (on12) {
            this.clTable = new Hashtable();
        }
    }

    private String breakPath(String string) {
        StringBuffer stringBuffer = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private File findDemos() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            File file = new File(string2);
            File file2 = file.isAbsolute() ? file : new File(new File(System.getProperty("user.dir")), string2);
            String string3 = file2.getAbsolutePath();
            File file3 = new File(string3);
            while (file3 != null && !file3.getName().equals("demos")) {
                String string4 = file3.getParent();
                try {
                    file3 = new File(string4);
                }
                catch (Exception exception) {
                    file3 = null;
                }
            }
            if (file3 == null) continue;
            return file3;
        }
        return null;
    }

    private void initializeGUI() {
        JButton jButton;
        Box box = Box.createVerticalBox();
        this.hsList = new JList(new DefaultListModel());
        this.hsList.addListSelectionListener(new ListSelected());
        this.hsList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setListData(this.hsList, this.enumToArray(this.masterHS.getHelpSets()));
        JScrollPane jScrollPane = new JScrollPane(this.hsList);
        jScrollPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Merged HelpSets"));
        Box box2 = Box.createHorizontalBox();
        this.addButton = jButton = new JButton("Add");
        jButton.setEnabled(true);
        jButton.addActionListener(new AddAction());
        box2.add(jButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new RemoveAction());
        box2.add(this.removeButton);
        this.displayButton = new JButton("Display");
        this.displayButton.setEnabled(false);
        this.displayButton.addActionListener(new ShowAction());
        box2.add(this.displayButton);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(jScrollPane);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        Merge.debug("Creating Menus");
        this.setJMenuBar(this.createMenus());
        this.getContentPane().add(box);
    }

    public JMenuBar createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(this.getBackground());
        JMenu jMenu = new JMenu("File");
        CSH.setHelpIDString((Component)jMenu, (String)"menus.file");
        jMenu.setToolTipText("File operations");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = this.addMenuItem(jMenu, "Exit", "file.exit");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu = new JMenu("Edit");
        CSH.setHelpIDString((Component)jMenu, (String)"menus.edit");
        jMenuBar.add(jMenu);
        this.add = this.addMenuItem(jMenu, "Add", null);
        this.add.addActionListener(new AddAction());
        this.remove = this.addMenuItem(jMenu, "Remove", null);
        this.remove.addActionListener(new RemoveAction());
        this.remove.setEnabled(false);
        jMenu = new JMenu("Options");
        CSH.setHelpIDString((Component)jMenu, (String)"menus.option");
        jMenuBar.add(jMenu);
        this.setfont = this.addMenuItem(jMenu, "Set Font...", null);
        SetFontListener setFontListener = new SetFontListener();
        this.setfont.addActionListener(setFontListener);
        JMenu jMenu2 = new JMenu("Help");
        if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
            jMenuBar.add(Box.createGlue());
        }
        jMenuBar.add(jMenu2);
        this.menuHelp = new JMenuItem("Using Merge");
        CSH.setHelpIDString((Component)this.menuHelp, (String)"main");
        this.menuHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.mainHB));
        jMenu2.add(this.menuHelp);
        return jMenuBar;
    }

    private JMenuItem addMenuItem(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    private void createAddDialog() {
        Serializable serializable;
        Serializable serializable2;
        this.addDialog = new JDialog((Frame)this, "Add ...");
        this.addDialog.setSize(new Dimension(450, 400));
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box2.add(new JLabel("HelpSet Name: "));
        this.helpSetName = new JTextField("HolidayHistory.hs");
        this.helpSetName.setEditable(true);
        box2.add(this.helpSetName);
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        box2 = Box.createHorizontalBox();
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box2.add(new JLabel("HelpSet URL:  "));
        this.helpSetURL = new JTextField();
        box2.add(this.helpSetURL);
        box2.add(Box.createRigidArea(new Dimension(15, 0)));
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Current Values"));
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel("CLASSPATH: "));
        JTextArea jTextArea = new JTextArea(4, 40);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTextArea);
        box2.add(jScrollPane);
        jTextArea.insert(this.breakPath(System.getProperty("java.class.path")), 0);
        jTextArea.setEditable(false);
        jPanel.add(box2);
        jPanel.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Additional URLs: "));
        this.helpSetURLs = new JTextArea(5, 40);
        this.helpSetURLs.setEditable(false);
        jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.helpSetURLs);
        box2.add(jScrollPane);
        jPanel.add(box2);
        if (!on12) {
            this.helpSetURLs.append("Dynamic addition of URLs not available in 1.1");
            this.helpSetURL.setEnabled(false);
        } else {
            this.helpSetURL.setEnabled(true);
            serializable2 = this.findDemos();
            if (serializable2 == null) {
                this.helpSetURLs.append("Could not find demos directory");
            } else {
                try {
                    serializable = new File(new File((File)serializable2, "hs"), "idehelp");
                    this.helpSetURLs.append("file:" + ((File)serializable).getAbsolutePath() + File.separator);
                    this.helpSetURLs.append("\n");
                    serializable = new File(new File((File)serializable2, "hsjar"), "holidays.jar");
                    this.helpSetURLs.append("file:" + ((File)serializable).getAbsolutePath());
                    this.helpSetURLs.append("\n");
                }
                catch (Exception exception) {
                    this.helpSetURLs.setText("Caught exception: " + exception);
                }
            }
        }
        box.add(jPanel);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        serializable2 = Box.createHorizontalBox();
        serializable = new JButton("Add");
        ((AbstractButton)serializable).setEnabled(true);
        ((AbstractButton)serializable).addActionListener(new ListenAction());
        ((Container)serializable2).add((Component)serializable);
        ((Container)serializable2).add(Box.createRigidArea(new Dimension(15, 0)));
        serializable = new JButton("Cancel");
        ((AbstractButton)serializable).addActionListener(new CancelAction());
        ((Container)serializable2).add((Component)serializable);
        ((Container)serializable2).add(Box.createRigidArea(new Dimension(15, 0)));
        serializable = new JButton("Help");
        ((Container)serializable2).add((Component)serializable);
        CSH.setHelpIDString((Component)serializable, (String)"add");
        ((AbstractButton)serializable).addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.mainHB));
        box.add((Component)serializable2);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.addDialog.getContentPane().add(box);
    }

    private URL urlFromFileName(String string) throws MalformedURLException {
        URL uRL = new URL("file:" + System.getProperty("user.dir") + "/");
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("could not find file: " + file);
            return null;
        }
        String string2 = file.getAbsolutePath();
        URL uRL2 = (file = new File(string2)).isDirectory() ? (!string2.endsWith("/") ? new URL(uRL, string2 + "/") : new URL(uRL, string2)) : new URL(uRL, string2);
        return uRL2;
    }

    private URL[] parseURLs(String string) {
        Object[] objectArray;
        Vector<URL> vector = new Vector<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            try {
                URL uRL = new URL((String)objectArray);
                vector.addElement(uRL);
            }
            catch (Exception exception) {
                System.err.println("cannot create URL for " + (String)objectArray);
            }
        }
        objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ClassLoader getMyLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Merge.debug("current loader is " + classLoader);
        return classLoader;
    }

    private void addHelpSet(String string, String string2, String string3) {
        Merge.debug("Add HelpSet; name: " + string);
        Merge.debug("           ; url: " + string2);
        Merge.debug("           ; name: " + string3);
        try {
            HelpSet helpSet;
            URL uRL = new URL(string2);
            if (on12) {
                URL[] uRLArray = this.parseURLs(string3);
                Merge.debug("ursl[" + uRLArray.length + "]");
                for (int i = 0; i < uRLArray.length; ++i) {
                    Merge.debug(uRLArray[i] + "");
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                Merge.debug("ucl: " + uRLClassLoader);
                helpSet = new HelpSet((ClassLoader)uRLClassLoader, uRL);
                Merge.debug("hs: " + helpSet);
                this.clTable.put(helpSet, uRLClassLoader);
            } else {
                helpSet = new HelpSet(null, uRL);
            }
            this.masterHS.add(helpSet);
            this.setListData(this.hsList, this.enumToArray(this.masterHS.getHelpSets()));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Could not create URL from " + string2);
        }
        catch (HelpSetException helpSetException) {
            System.err.println("Could not create HelpSet for " + string2);
        }
    }

    private void removeHelpSet(HelpSet helpSet) {
        Merge.debug("Removing " + helpSet);
        if (!this.masterHS.remove(helpSet)) {
            System.err.println("Warning: could not remove HelpSet " + helpSet);
        }
        this.setListData(this.hsList, this.enumToArray(this.masterHS.getHelpSets()));
    }

    private Object[] enumToArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void setListData(JList jList, Object[] objectArray) {
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        try {
            defaultListModel.removeAllElements();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.remove.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.displayButton.setEnabled(false);
        }
        Merge.debug("setListData:");
        Merge.debug("  " + this.masterHS);
        defaultListModel.addElement(this.masterHS);
        for (int i = 0; i < objectArray.length; ++i) {
            Merge.debug("  " + objectArray[i]);
            defaultListModel.addElement(objectArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        Merge merge = new Merge();
        merge.setResizable(false);
        merge.pack();
        merge.show();
    }

    private static void debug(String string) {
    }

    static /* synthetic */ Font access$1802(Merge merge, Font font) {
        merge.font = font;
        return merge.font;
    }

    static {
        try {
            AccessControlException accessControlException = new AccessControlException("");
            on12 = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            on12 = false;
        }
    }

    private class MyFont {
        private Font f;

        public MyFont(Font font) {
            this.f = font;
        }

        public Font getFont() {
            return this.f;
        }

        public String toString() {
            String string = this.f.getFamily();
            String string2 = this.f.getFontName();
            String string3 = string2.substring(string.length());
            if (string3.length() == 0) {
                string3 = "Plain";
            }
            return string3;
        }
    }

    private class SetFontListener
    implements ActionListener,
    TreeSelectionListener,
    ItemListener {
        JDialog sfDialog = null;
        JComboBox cb;
        JTree fontTree;
        JTextArea preview;
        JButton okButton;
        JButton cancelButton;
        Font sffont;

        private SetFontListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                JOptionPane.showMessageDialog(null, "Setting Fonts on JDK1.1 not allowed", "Set Font...", 0);
                return;
            }
            if (this.sfDialog == null) {
                this.sfDialog = new JDialog(Merge.this, "Set Font...", false);
                this.initSetFontComponents();
                this.sfDialog.pack();
                this.cancelButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ SetFontListener this$1;
                    {
                        this.this$1 = setFontListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.sfDialog.setVisible(false);
                        this.this$1.sfDialog.dispose();
                    }
                });
                this.okButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ SetFontListener this$1;
                    {
                        this.this$1 = setFontListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Merge.access$1802(SetFontListener.access$2200(this.this$1), this.this$1.sffont);
                        Merge.access$1000("sffont=" + Merge.access$1800(SetFontListener.access$2200(this.this$1)));
                        this.this$1.sfDialog.setVisible(false);
                        this.this$1.sfDialog.dispose();
                    }
                });
            }
            this.sffont = Merge.this.font;
            if (this.sffont != null) {
                this.preview.setFont(this.sffont);
            }
            this.sfDialog.show();
        }

        private void initSetFontComponents() {
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            Serializable serializable2;
            Vector vector = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fontArray = graphicsEnvironment.getAllFonts();
            for (int i = 0; i < fontArray.length; ++i) {
                serializable2 = new DefaultMutableTreeNode(new MyFont(fontArray[i]));
                object3 = fontArray[i].getFamily();
                object2 = null;
                serializable = null;
                object = defaultMutableTreeNode.children();
                while (object.hasMoreElements() && ((String)(object2 = (String)((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)object.nextElement())).getUserObject())).compareTo((String)object3) != 0) {
                    serializable = null;
                }
                if (serializable == null) {
                    object = new DefaultMutableTreeNode(object3);
                    defaultMutableTreeNode.add((MutableTreeNode)object);
                    ((DefaultMutableTreeNode)object).add((MutableTreeNode)((Object)serializable2));
                    continue;
                }
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)((Object)serializable2));
            }
            Box box = Box.createVerticalBox();
            serializable2 = Box.createHorizontalBox();
            this.fontTree = new JTree(defaultMutableTreeNode);
            this.fontTree.setShowsRootHandles(true);
            this.fontTree.setRootVisible(false);
            object3 = this.fontTree.getSelectionModel();
            object3.addTreeSelectionListener(this);
            object2 = new JScrollPane();
            ((JScrollPane)object2).getViewport().add(this.fontTree);
            TitledBorder titledBorder = BorderFactory.createTitledBorder("Fonts");
            ((JComponent)object2).setBorder(titledBorder);
            ((Container)serializable2).add(Box.createHorizontalStrut(5));
            ((Container)serializable2).add((Component)object2);
            ((Container)serializable2).add(Box.createHorizontalStrut(5));
            serializable = Box.createHorizontalBox();
            this.cb = new JComboBox();
            titledBorder = BorderFactory.createTitledBorder("Size");
            this.cb.setBorder(titledBorder);
            this.cb.setEditable(true);
            this.cb.addItem("8");
            this.cb.addItem("9");
            this.cb.addItem("10");
            this.cb.addItem("11");
            this.cb.addItem("12");
            this.cb.addItem("13");
            this.cb.addItem("14");
            this.cb.addItem("16");
            this.cb.addItem("18");
            this.cb.addItem("20");
            this.cb.addItem("24");
            this.cb.addItem("28");
            this.cb.addItem("32");
            this.cb.addItem("36");
            this.cb.addItem("48");
            this.cb.addItem("72");
            this.cb.setSelectedItem("12");
            this.cb.addItemListener(this);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable).add(this.cb);
            ((Container)serializable).add(Box.createHorizontalStrut(5));
            ((Container)serializable2).add((Component)serializable);
            ((Container)serializable2).add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(10));
            box.add(Box.createVerticalStrut(5));
            box.add((Component)serializable2);
            object = Box.createHorizontalBox();
            JPanel jPanel = new JPanel();
            titledBorder = BorderFactory.createTitledBorder("Preview");
            jPanel.setBorder(titledBorder);
            this.preview = new JTextArea("\nAaBbCc...XxYyZz\n");
            jPanel.add(this.preview);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(jPanel);
            ((Container)object).add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(10));
            box.add((Component)object);
            Box box2 = Box.createHorizontalBox();
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            box2.add(this.okButton);
            box2.add(this.cancelButton);
            Box box3 = Box.createHorizontalBox();
            box3.add(Box.createHorizontalStrut(5));
            box3.add(new JSeparator());
            box3.add(Box.createHorizontalStrut(5));
            box.add(Box.createVerticalStrut(10));
            box.add(box3);
            box.add(box2);
            this.sfDialog.getContentPane().add(box);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Merge.debug("ValueChanged: " + treeSelectionEvent);
            TreePath treePath = this.fontTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof MyFont) {
                MyFont myFont = (MyFont)object;
                String string = (String)this.cb.getSelectedItem();
                this.sffont = myFont.getFont().deriveFont(Integer.valueOf(string).floatValue());
                this.preview.setFont(this.sffont);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Merge.debug("ValueChanged: " + itemEvent);
            String string = (String)this.cb.getSelectedItem();
            this.sffont = Merge.this.font.deriveFont(Integer.valueOf(string).floatValue());
            this.preview.setFont(this.sffont);
        }

        static /* synthetic */ Merge access$2200(SetFontListener setFontListener) {
            return setFontListener.Merge.this;
        }
    }

    private class ListSelected
    implements ListSelectionListener {
        private ListSelected() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Merge.debug("value changed: " + listSelectionEvent);
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            Merge.this.remove.setEnabled(false);
            Merge.this.removeButton.setEnabled(false);
            Merge.this.displayButton.setEnabled(false);
            int[] nArray = Merge.this.hsList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= 0) continue;
                Merge.this.remove.setEnabled(true);
                Merge.this.removeButton.setEnabled(true);
                break;
            }
            Merge.this.displayButton.setEnabled(true);
        }
    }

    private class ShowAction
    implements ActionListener {
        private ShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = Merge.this.hsList.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                System.err.println("No selected values");
            } else {
                Merge.debug("Showing... " + objectArray[0]);
                HelpSet helpSet = (HelpSet)objectArray[0];
                HelpBroker helpBroker = helpSet.createHelpBroker();
                if (Merge.this.font != null) {
                    Merge.debug("font=" + Merge.this.font);
                    helpBroker.setFont(Merge.this.font);
                }
                helpBroker.setDisplayed(true);
            }
        }
    }

    private class ListenAction
    implements ActionListener {
        private ListenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLClassLoader uRLClassLoader;
            URL[] uRLArray;
            String string = Merge.this.helpSetURL.getText();
            String string2 = Merge.this.helpSetURLs.getText();
            Merge.this.helpSetURLs.append(string);
            Merge.this.helpSetURLs.append("\n");
            String string3 = Merge.this.helpSetURLs.getText();
            String string4 = Merge.this.helpSetName.getText();
            if (on12) {
                uRLArray = Merge.this.parseURLs(string3);
                uRLClassLoader = new URLClassLoader(uRLArray);
            } else {
                uRLClassLoader = null;
            }
            uRLArray = HelpSet.findHelpSet(uRLClassLoader, (String)string4);
            if (uRLArray == null) {
                JOptionPane.showMessageDialog(Merge.this.addDialog, "HelpSet not found", "Error", 0);
                Merge.this.helpSetURLs.setText(string2);
                return;
            }
            String string5 = uRLArray.toExternalForm();
            Merge.debug("hs: " + string4);
            Merge.debug("url: " + string5);
            Merge.debug("path: " + string3);
            Merge.this.addHelpSet(string4, string5, string3);
            Merge.this.addDialog.setVisible(false);
        }
    }

    private class LocateAction
    implements ActionListener {
        private LocateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = Merge.this.hsList.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                System.err.println("No selected values");
            } else {
                Merge.debug("Removing... " + objectArray[0]);
                Merge.this.removeHelpSet((HelpSet)objectArray[0]);
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Merge.this.addDialog.setVisible(false);
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Merge.this.addDialog == null) {
                Merge.this.createAddDialog();
            }
            Merge.this.addDialog.show();
        }
    }
}

