"""Generated client library for anthosevents version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.anthosevents.v1 import anthosevents_v1_messages as messages


class AnthoseventsV1(base_api.BaseApiClient):
  """Generated client library for service anthosevents version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://anthosevents.googleapis.com/'
  MTLS_BASE_URL = 'https://anthosevents.mtls.googleapis.com/'

  _PACKAGE = 'anthosevents'
  _SCOPES = ['https://www.googleapis.com/auth/userinfo.email']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'AnthoseventsV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new anthosevents handle."""
    url = url or self.BASE_URL
    super(AnthoseventsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.api_v1_namespaces_configmaps = self.ApiV1NamespacesConfigmapsService(self)
    self.api_v1_namespaces_secrets = self.ApiV1NamespacesSecretsService(self)
    self.api_v1_namespaces_serviceaccounts = self.ApiV1NamespacesServiceaccountsService(self)
    self.api_v1_namespaces = self.ApiV1NamespacesService(self)
    self.api_v1 = self.ApiV1Service(self)
    self.api = self.ApiService(self)
    self.brokers = self.BrokersService(self)
    self.customresourcedefinitions = self.CustomresourcedefinitionsService(self)
    self.namespaces_brokers = self.NamespacesBrokersService(self)
    self.namespaces_cloudauditlogssources = self.NamespacesCloudauditlogssourcesService(self)
    self.namespaces_cloudpubsubsources = self.NamespacesCloudpubsubsourcesService(self)
    self.namespaces_cloudschedulersources = self.NamespacesCloudschedulersourcesService(self)
    self.namespaces_cloudstoragesources = self.NamespacesCloudstoragesourcesService(self)
    self.namespaces_triggers = self.NamespacesTriggersService(self)
    self.namespaces = self.NamespacesService(self)
    self.project_serviceaccounts = self.ProjectServiceaccountsService(self)
    self.project = self.ProjectService(self)
    self.projects_locations_configmaps = self.ProjectsLocationsConfigmapsService(self)
    self.projects_locations_namespaces_configmaps = self.ProjectsLocationsNamespacesConfigmapsService(self)
    self.projects_locations_namespaces_serviceaccounts = self.ProjectsLocationsNamespacesServiceaccountsService(self)
    self.projects_locations_namespaces = self.ProjectsLocationsNamespacesService(self)
    self.projects_locations_secrets = self.ProjectsLocationsSecretsService(self)
    self.projects_locations_serviceaccounts = self.ProjectsLocationsServiceaccountsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)
    self.triggers = self.TriggersService(self)

  class ApiV1NamespacesConfigmapsService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces_configmaps resource."""

    _NAME = 'api_v1_namespaces_configmaps'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesConfigmapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new config map.

      Args:
        request: (AnthoseventsApiV1NamespacesConfigmapsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/configmaps',
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.configmaps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='api/v1/{+parent}/configmaps',
        request_field='configMap',
        request_type_name='AnthoseventsApiV1NamespacesConfigmapsCreateRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to retrieve config map.

      Args:
        request: (AnthoseventsApiV1NamespacesConfigmapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/configmaps/{configmapsId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.configmaps.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesConfigmapsGetRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a ConfigMap.

      Args:
        request: (AnthoseventsApiV1NamespacesConfigmapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/configmaps/{configmapsId}',
        http_method='PATCH',
        method_id='anthosevents.api.v1.namespaces.configmaps.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='configMap',
        request_type_name='AnthoseventsApiV1NamespacesConfigmapsPatchRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

    def ReplaceConfigMap(self, request, global_params=None):
      r"""Rpc to replace a ConfigMap.

      Args:
        request: (AnthoseventsApiV1NamespacesConfigmapsReplaceConfigMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('ReplaceConfigMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceConfigMap.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/configmaps/{configmapsId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.configmaps.replaceConfigMap',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='configMap',
        request_type_name='AnthoseventsApiV1NamespacesConfigmapsReplaceConfigMapRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

  class ApiV1NamespacesSecretsService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces_secrets resource."""

    _NAME = 'api_v1_namespaces_secrets'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesSecretsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets',
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.secrets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='api/v1/{+parent}/secrets',
        request_field='secret',
        request_type_name='AnthoseventsApiV1NamespacesSecretsCreateRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='DELETE',
        method_id='anthosevents.api.v1.namespaces.secrets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.secrets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsGetRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list secrets.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSecretsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.secrets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='api/v1/{+parent}/secrets',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsListRequest',
        response_type_name='ListSecretsResponse',
        supports_download=False,
    )

    def ReplaceSecret(self, request, global_params=None):
      r"""Rpc to replace a secret. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('ReplaceSecret')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceSecret.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.secrets.replaceSecret',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='secret',
        request_type_name='AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest',
        response_type_name='Secret',
        supports_download=False,
    )

  class ApiV1NamespacesServiceaccountsService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces_serviceaccounts resource."""

    _NAME = 'api_v1_namespaces_serviceaccounts'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesServiceaccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new service account.

      Args:
        request: (AnthoseventsApiV1NamespacesServiceaccountsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/serviceaccounts',
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.serviceaccounts.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='api/v1/{+parent}/serviceaccounts',
        request_field='serviceAccount',
        request_type_name='AnthoseventsApiV1NamespacesServiceaccountsCreateRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to retrieve service account.

      Args:
        request: (AnthoseventsApiV1NamespacesServiceaccountsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/serviceaccounts/{serviceaccountsId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.serviceaccounts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesServiceaccountsGetRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list Service Accounts.

      Args:
        request: (AnthoseventsApiV1NamespacesServiceaccountsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/serviceaccounts',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.serviceaccounts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='api/v1/{+parent}/serviceaccounts',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesServiceaccountsListRequest',
        response_type_name='ListServiceAccountsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update Service Account.

      Args:
        request: (AnthoseventsApiV1NamespacesServiceaccountsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/serviceaccounts/{serviceaccountsId}',
        http_method='PATCH',
        method_id='anthosevents.api.v1.namespaces.serviceaccounts.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='serviceAccount',
        request_type_name='AnthoseventsApiV1NamespacesServiceaccountsPatchRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def ReplaceServiceAccount(self, request, global_params=None):
      r"""Rpc to replace a Service Account.

      Args:
        request: (AnthoseventsApiV1NamespacesServiceaccountsReplaceServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('ReplaceServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/serviceaccounts/{serviceaccountsId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.serviceaccounts.replaceServiceAccount',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='serviceAccount',
        request_type_name='AnthoseventsApiV1NamespacesServiceaccountsReplaceServiceAccountRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

  class ApiV1NamespacesService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces resource."""

    _NAME = 'api_v1_namespaces'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.create',
        ordered_params=[],
        path_params=[],
        query_params=['parent'],
        relative_path='api/v1/namespaces',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesCreateRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='anthosevents.api.v1.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesGetRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list namespaces.

      Args:
        request: (AnthoseventsApiV1NamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'parent', 'resourceVersion', 'watch'],
        relative_path='api/v1/namespaces',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesListRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='PATCH',
        method_id='anthosevents.api.v1.namespaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='api/v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesPatchRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def ReplaceNamespace(self, request, global_params=None):
      r"""Rpc to replace a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesReplaceNamespaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('ReplaceNamespace')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceNamespace.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.replaceNamespace',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesReplaceNamespaceRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

  class ApiV1Service(base_api.BaseApiService):
    """Service class for the api_v1 resource."""

    _NAME = 'api_v1'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1Service, self).__init__(client)
      self._upload_configs = {
          }

  class ApiService(base_api.BaseApiService):
    """Service class for the api resource."""

    _NAME = 'api'

    def __init__(self, client):
      super(AnthoseventsV1.ApiService, self).__init__(client)
      self._upload_configs = {
          }

  class BrokersService(base_api.BaseApiService):
    """Service class for the brokers resource."""

    _NAME = 'brokers'

    def __init__(self, client):
      super(AnthoseventsV1.BrokersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Rpc to list brokers in all namespaces.

      Args:
        request: (AnthoseventsBrokersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBrokersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.brokers.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'parent', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1/brokers',
        request_field='',
        request_type_name='AnthoseventsBrokersListRequest',
        response_type_name='ListBrokersResponse',
        supports_download=False,
    )

  class CustomresourcedefinitionsService(base_api.BaseApiService):
    """Service class for the customresourcedefinitions resource."""

    _NAME = 'customresourcedefinitions'

    def __init__(self, client):
      super(AnthoseventsV1.CustomresourcedefinitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a CustomResourceDefinition.

      Args:
        request: (AnthoseventsCustomresourcedefinitionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CustomResourceDefinition) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/apiextensions.k8s.io/v1/customresourcedefinitions/{customresourcedefinitionsId}',
        http_method='GET',
        method_id='anthosevents.customresourcedefinitions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/apiextensions.k8s.io/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsCustomresourcedefinitionsGetRequest',
        response_type_name='CustomResourceDefinition',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list custom resource definitions.

      Args:
        request: (AnthoseventsCustomresourcedefinitionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCustomResourceDefinitionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.customresourcedefinitions.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'parent', 'resourceVersion', 'watch'],
        relative_path='apis/apiextensions.k8s.io/v1/customresourcedefinitions',
        request_field='',
        request_type_name='AnthoseventsCustomresourcedefinitionsListRequest',
        response_type_name='ListCustomResourceDefinitionsResponse',
        supports_download=False,
    )

  class NamespacesBrokersService(base_api.BaseApiService):
    """Service class for the namespaces_brokers resource."""

    _NAME = 'namespaces_brokers'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesBrokersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a new broker.

      Args:
        request: (AnthoseventsNamespacesBrokersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Broker) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/brokers',
        http_method='POST',
        method_id='anthosevents.namespaces.brokers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+parent}/brokers',
        request_field='broker',
        request_type_name='AnthoseventsNamespacesBrokersCreateRequest',
        response_type_name='Broker',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a broker.

      Args:
        request: (AnthoseventsNamespacesBrokersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/brokers/{brokersId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.brokers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a Broker.

      Args:
        request: (AnthoseventsNamespacesBrokersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Broker) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/brokers/{brokersId}',
        http_method='GET',
        method_id='anthosevents.namespaces.brokers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersGetRequest',
        response_type_name='Broker',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list brokers.

      Args:
        request: (AnthoseventsNamespacesBrokersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBrokersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/brokers',
        http_method='GET',
        method_id='anthosevents.namespaces.brokers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1/{+parent}/brokers',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersListRequest',
        response_type_name='ListBrokersResponse',
        supports_download=False,
    )

  class NamespacesCloudauditlogssourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudauditlogssources resource."""

    _NAME = 'namespaces_cloudauditlogssources'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesCloudauditlogssourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudauditlogssources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudauditlogssources',
        request_field='cloudAuditLogsSource',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesCreateRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudauditlogssources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudauditlogssources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesGetRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudauditlogssources.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudAuditLogsSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudauditlogssources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudauditlogssources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesListRequest',
        response_type_name='ListCloudAuditLogsSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudAuditLogsSource(self, request, global_params=None):
      r"""Rpc to replace a cloudauditlogssource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesReplaceCloudAuditLogsSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudAuditLogsSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudAuditLogsSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudauditlogssources.replaceCloudAuditLogsSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='cloudAuditLogsSource',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesReplaceCloudAuditLogsSourceRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

  class NamespacesCloudpubsubsourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudpubsubsources resource."""

    _NAME = 'namespaces_cloudpubsubsources'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesCloudpubsubsourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudpubsubsources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudpubsubsources',
        request_field='cloudPubSubSource',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesCreateRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudpubsubsources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudpubsubsources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesGetRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudpubsubsources.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudPubSubSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudpubsubsources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudpubsubsources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesListRequest',
        response_type_name='ListCloudPubSubSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudPubSubSource(self, request, global_params=None):
      r"""Rpc to replace a cloudpubsubsource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesReplaceCloudPubSubSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudPubSubSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudPubSubSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudpubsubsources.replaceCloudPubSubSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='cloudPubSubSource',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesReplaceCloudPubSubSourceRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

  class NamespacesCloudschedulersourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudschedulersources resource."""

    _NAME = 'namespaces_cloudschedulersources'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesCloudschedulersourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudschedulersources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudschedulersources',
        request_field='cloudSchedulerSource',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesCreateRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudschedulersources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudschedulersources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesGetRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudschedulersources.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudSchedulerSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudschedulersources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudschedulersources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesListRequest',
        response_type_name='ListCloudSchedulerSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudSchedulerSource(self, request, global_params=None):
      r"""Rpc to replace a cloudschedulersource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudSchedulerSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudSchedulerSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudschedulersources.replaceCloudSchedulerSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='cloudSchedulerSource',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

  class NamespacesCloudstoragesourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudstoragesources resource."""

    _NAME = 'namespaces_cloudstoragesources'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesCloudstoragesourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudstoragesources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudstoragesources',
        request_field='cloudStorageSource',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesCreateRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudstoragesources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudstoragesources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesGetRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudstoragesources.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudStorageSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudstoragesources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1/{+parent}/cloudstoragesources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesListRequest',
        response_type_name='ListCloudStorageSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudStorageSource(self, request, global_params=None):
      r"""Rpc to replace a cloudstoragesource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudStorageSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudStorageSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudstoragesources.replaceCloudStorageSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1/{+name}',
        request_field='cloudStorageSource',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

  class NamespacesTriggersService(base_api.BaseApiService):
    """Service class for the namespaces_triggers resource."""

    _NAME = 'namespaces_triggers'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/triggers',
        http_method='POST',
        method_id='anthosevents.namespaces.triggers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+parent}/triggers',
        request_field='trigger',
        request_type_name='AnthoseventsNamespacesTriggersCreateRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.triggers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/eventing.knative.dev/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='GET',
        method_id='anthosevents.namespaces.triggers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersGetRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list triggers.

      Args:
        request: (AnthoseventsNamespacesTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/triggers',
        http_method='GET',
        method_id='anthosevents.namespaces.triggers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'pageSize', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1/{+parent}/triggers',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersListRequest',
        response_type_name='ListTriggersResponse',
        supports_download=False,
    )

    def ReplaceTrigger(self, request, global_params=None):
      r"""Rpc to replace a trigger. Only the spec and metadata labels and annotations are modifiable. After the Update request, Events for Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesTriggersReplaceTriggerRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('ReplaceTrigger')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceTrigger.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.triggers.replaceTrigger',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1/{+name}',
        request_field='trigger',
        request_type_name='AnthoseventsNamespacesTriggersReplaceTriggerRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = 'namespaces'

    def __init__(self, client):
      super(AnthoseventsV1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectServiceaccountsService(base_api.BaseApiService):
    """Service class for the project_serviceaccounts resource."""

    _NAME = 'project_serviceaccounts'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectServiceaccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new service account.

      Args:
        request: (AnthoseventsProjectServiceaccountsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/project/{projectId}/serviceaccounts',
        http_method='POST',
        method_id='anthosevents.project.serviceaccounts.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/serviceaccounts',
        request_field='serviceAccount',
        request_type_name='AnthoseventsProjectServiceaccountsCreateRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

  class ProjectService(base_api.BaseApiService):
    """Service class for the project resource."""

    _NAME = 'project'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsConfigmapsService(base_api.BaseApiService):
    """Service class for the projects_locations_configmaps resource."""

    _NAME = 'projects_locations_configmaps'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsConfigmapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new config map.

      Args:
        request: (AnthoseventsProjectsLocationsConfigmapsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/configmaps',
        http_method='POST',
        method_id='anthosevents.projects.locations.configmaps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/configmaps',
        request_field='configMap',
        request_type_name='AnthoseventsProjectsLocationsConfigmapsCreateRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to retrieve config map.

      Args:
        request: (AnthoseventsProjectsLocationsConfigmapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/configmaps/{configmapsId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.configmaps.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsConfigmapsGetRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

  class ProjectsLocationsNamespacesConfigmapsService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces_configmaps resource."""

    _NAME = 'projects_locations_namespaces_configmaps'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsNamespacesConfigmapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Patch(self, request, global_params=None):
      r"""Rpc to update a ConfigMap.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesConfigmapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/configmaps/{configmapsId}',
        http_method='PATCH',
        method_id='anthosevents.projects.locations.namespaces.configmaps.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='configMap',
        request_type_name='AnthoseventsProjectsLocationsNamespacesConfigmapsPatchRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

    def ReplaceConfigMap(self, request, global_params=None):
      r"""Rpc to replace a ConfigMap.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesConfigmapsReplaceConfigMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConfigMap) The response message.
      """
      config = self.GetMethodConfig('ReplaceConfigMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceConfigMap.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/configmaps/{configmapsId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.namespaces.configmaps.replaceConfigMap',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='configMap',
        request_type_name='AnthoseventsProjectsLocationsNamespacesConfigmapsReplaceConfigMapRequest',
        response_type_name='ConfigMap',
        supports_download=False,
    )

  class ProjectsLocationsNamespacesServiceaccountsService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces_serviceaccounts resource."""

    _NAME = 'projects_locations_namespaces_serviceaccounts'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsNamespacesServiceaccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Patch(self, request, global_params=None):
      r"""Rpc to update Service Account.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesServiceaccountsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/serviceaccounts/{serviceaccountsId}',
        http_method='PATCH',
        method_id='anthosevents.projects.locations.namespaces.serviceaccounts.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='serviceAccount',
        request_type_name='AnthoseventsProjectsLocationsNamespacesServiceaccountsPatchRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def ReplaceServiceAccount(self, request, global_params=None):
      r"""Rpc to replace a Service Account.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesServiceaccountsReplaceServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('ReplaceServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}/serviceaccounts/{serviceaccountsId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.namespaces.serviceaccounts.replaceServiceAccount',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='serviceAccount',
        request_type_name='AnthoseventsProjectsLocationsNamespacesServiceaccountsReplaceServiceAccountRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

  class ProjectsLocationsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces resource."""

    _NAME = 'projects_locations_namespaces'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='POST',
        method_id='anthosevents.projects.locations.namespaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/namespaces',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesCreateRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='anthosevents.projects.locations.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesGetRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list namespaces.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='GET',
        method_id='anthosevents.projects.locations.namespaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1/{+parent}/namespaces',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesListRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='PATCH',
        method_id='anthosevents.projects.locations.namespaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesPatchRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def ReplaceNamespace(self, request, global_params=None):
      r"""Rpc to replace a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('ReplaceNamespace')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceNamespace.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.namespaces.replaceNamespace',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

  class ProjectsLocationsSecretsService(base_api.BaseApiService):
    """Service class for the projects_locations_secrets resource."""

    _NAME = 'projects_locations_secrets'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsSecretsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets',
        http_method='POST',
        method_id='anthosevents.projects.locations.secrets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/secrets',
        request_field='secret',
        request_type_name='AnthoseventsProjectsLocationsSecretsCreateRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='DELETE',
        method_id='anthosevents.projects.locations.secrets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.secrets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsGetRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list secrets.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSecretsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets',
        http_method='GET',
        method_id='anthosevents.projects.locations.secrets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1/{+parent}/secrets',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsListRequest',
        response_type_name='ListSecretsResponse',
        supports_download=False,
    )

    def ReplaceSecret(self, request, global_params=None):
      r"""Rpc to replace a secret. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsReplaceSecretRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('ReplaceSecret')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceSecret.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.secrets.replaceSecret',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='secret',
        request_type_name='AnthoseventsProjectsLocationsSecretsReplaceSecretRequest',
        response_type_name='Secret',
        supports_download=False,
    )

  class ProjectsLocationsServiceaccountsService(base_api.BaseApiService):
    """Service class for the projects_locations_serviceaccounts resource."""

    _NAME = 'projects_locations_serviceaccounts'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsServiceaccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to retrieve service account.

      Args:
        request: (AnthoseventsProjectsLocationsServiceaccountsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/serviceaccounts/{serviceaccountsId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.serviceaccounts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsServiceaccountsGetRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list Service Accounts.

      Args:
        request: (AnthoseventsProjectsLocationsServiceaccountsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/serviceaccounts',
        http_method='GET',
        method_id='anthosevents.projects.locations.serviceaccounts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/serviceaccounts',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsServiceaccountsListRequest',
        response_type_name='ListServiceAccountsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class TriggersService(base_api.BaseApiService):
    """Service class for the triggers resource."""

    _NAME = 'triggers'

    def __init__(self, client):
      super(AnthoseventsV1.TriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Rpc to list triggers in all namespaces.

      Args:
        request: (AnthoseventsTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.triggers.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'pageSize', 'parent', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1/triggers',
        request_field='',
        request_type_name='AnthoseventsTriggersListRequest',
        response_type_name='ListTriggersResponse',
        supports_download=False,
    )
