/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.FontTable;
import org.pentaho.reporting.libraries.fonts.truetype.HorizontalHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.PostscriptInformationTable;

public class TrueTypeFont {
    private static final Logger logger = Logger.getLogger(TrueTypeFont.class.getName());
    private long offset;
    private String filename;
    private FontDataInputSource input;
    private transient byte[] readBuffer;
    private TableDirectoryEntry[] directory;
    private TrueTypeFontHeader header;
    private int collectionIndex;

    public TrueTypeFont(FontDataInputSource filename) throws IOException {
        this(filename, 0L, -1);
    }

    public TrueTypeFont(FontDataInputSource filename, long offset) throws IOException {
        this(filename, offset, -1);
    }

    public TrueTypeFont(FontDataInputSource filename, long offset, int collectionIndex) throws IOException {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.collectionIndex = collectionIndex;
        this.offset = offset;
        this.input = filename;
        this.filename = filename.getFileName();
        this.header = new TrueTypeFontHeader(this.readFully(offset, 12));
        this.directory = this.readTableDirectory();
    }

    public TrueTypeFont(File filename) throws IOException {
        this(filename, 0L, -1);
    }

    public TrueTypeFont(File filename, long offset) throws IOException {
        this(filename, offset, -1);
    }

    public TrueTypeFont(File filename, long offset, int collectionIndex) throws IOException {
        this(new FileFontDataInputSource(filename), offset, collectionIndex);
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    private TableDirectoryEntry[] readTableDirectory() throws IOException {
        int numTables = this.header.getNumTables();
        int directorySize = numTables * 16;
        byte[] directoryData = this.readFully(this.offset + 12L, directorySize);
        TableDirectoryEntry[] directory = new TableDirectoryEntry[numTables];
        for (int i = 0; i < this.header.getNumTables(); ++i) {
            int dirOffset = 16 * i;
            directory[i] = new TableDirectoryEntry(directoryData, dirOffset);
        }
        return directory;
    }

    protected byte[] readFully(long offset, int length) throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[Math.max(8192, length)];
        } else if (this.readBuffer.length < length) {
            this.readBuffer = new byte[length];
        }
        this.input.readFullyAt(offset, this.readBuffer, length);
        if (this.readBuffer.length - length > 0) {
            Arrays.fill(this.readBuffer, length, this.readBuffer.length, (byte)0);
        }
        return this.readBuffer;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getFilename() {
        return this.filename;
    }

    public FontTable getTable(long key) throws IOException {
        for (TableDirectoryEntry entry : this.directory) {
            if (entry.getTag() != key) continue;
            FontTable table = entry.getTable();
            if (table != null) {
                return table;
            }
            FontTable readTable = this.readTable(entry);
            if (readTable == null) {
                return null;
            }
            entry.setTable(readTable);
            return readTable;
        }
        return null;
    }

    protected FontTable readTable(TableDirectoryEntry table) throws IOException {
        if (table.getTag() == 1851878757L) {
            byte[] buffer = this.readFully(table.getOffset(), table.getLength());
            return new NameTable(buffer);
        }
        if (table.getTag() == 1751474532L) {
            byte[] buffer = this.readFully(table.getOffset(), table.getLength());
            return new FontHeaderTable(buffer);
        }
        if (table.getTag() == 1751672161L) {
            byte[] buffer = this.readFully(table.getOffset(), table.getLength());
            return new HorizontalHeaderTable(buffer);
        }
        if (table.getTag() == 1330851634L) {
            FontHeaderTable header = (FontHeaderTable)this.getTable(1751474532L);
            if (header == null) {
                logger.warning("The font '" + this.filename + "' does not have a 'head' table. The font file is not valid.");
                return null;
            }
            byte[] buffer = this.readFully(table.getOffset(), table.getLength());
            return new OS2Table(buffer, header.getUnitsPerEm());
        }
        if (table.getTag() == 1886352244L) {
            byte[] buffer = this.readFully(table.getOffset(), table.getLength());
            return new PostscriptInformationTable(buffer);
        }
        return null;
    }

    public void dispose() {
        this.input.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public FontDataInputSource getInputSource() {
        return this.input;
    }

    private static class TableDirectoryEntry {
        public static final int ENTRY_LENGTH = 16;
        private long tag;
        private long checkSum;
        private int offset;
        private int length;
        private FontTable table;

        protected TableDirectoryEntry(byte[] data, int offset) {
            this.tag = ByteAccessUtilities.readULong(data, offset);
            this.checkSum = ByteAccessUtilities.readULong(data, offset + 4);
            this.offset = (int)ByteAccessUtilities.readULong(data, offset + 8);
            this.length = (int)ByteAccessUtilities.readULong(data, offset + 12);
        }

        public long getTag() {
            return this.tag;
        }

        public long getCheckSum() {
            return this.checkSum;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public FontTable getTable() {
            return this.table;
        }

        public void setTable(FontTable table) {
            this.table = table;
        }

        public String toString() {
            char c1 = (char)(this.tag >> 24 & 0xFFL);
            char c2 = (char)(this.tag >> 16 & 0xFFL);
            char c3 = (char)(this.tag >> 8 & 0xFFL);
            char c4 = (char)(this.tag & 0xFFL);
            return "TableDirectoryEntry={" + c1 + c2 + c3 + c4 + ',' + this.table + '}';
        }
    }

    private static class TrueTypeFontHeader {
        public static final int ENTRY_LENGTH = 12;
        private long version;
        private int numTables;
        private int searchRange;
        private int entrySelector;
        private int rangeShift;

        protected TrueTypeFontHeader(byte[] data) {
            this.version = ByteAccessUtilities.readULong(data, 0);
            this.numTables = ByteAccessUtilities.readUShort(data, 4);
            this.searchRange = ByteAccessUtilities.readUShort(data, 6);
            this.entrySelector = ByteAccessUtilities.readUShort(data, 8);
            this.rangeShift = ByteAccessUtilities.readUShort(data, 10);
        }

        public long getVersion() {
            return this.version;
        }

        public int getNumTables() {
            return this.numTables;
        }

        public int getSearchRange() {
            return this.searchRange;
        }

        public int getEntrySelector() {
            return this.entrySelector;
        }

        public int getRangeShift() {
            return this.rangeShift;
        }
    }
}

