/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded url) {
        super(url);
    }

    public UrlEncoded() {
    }

    public UrlEncoded(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query, Charset charset) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, charset);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(Charset charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(Charset charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    public static String encode(MultiMap<String> map2, Charset charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : map2.entrySet()) {
            String key2 = (String)entry.getKey();
            List list = (List)entry.getValue();
            int s2 = list.size();
            if (delim) {
                result.append('&');
            }
            if (s2 == 0) {
                result.append(UrlEncoded.encodeString(key2, charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                for (int i = 0; i < s2; ++i) {
                    if (i > 0) {
                        result.append('&');
                    }
                    String val2 = (String)list.get(i);
                    result.append(UrlEncoded.encodeString(key2, charset));
                    if (val2 != null) {
                        String str2 = val2;
                        if (str2.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(str2, charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result.append('=');
                }
            }
            delim = true;
        }
        return result.toString();
    }

    public static void decodeTo(String content, MultiMap<String> map2, String charset) {
        UrlEncoded.decodeTo(content, map2, charset == null ? null : Charset.forName(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap<String> map2, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(content, 0, content.length(), map2);
            return;
        }
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String value;
            String key2 = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        int l = i - mark - 1;
                        value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1, i));
                        mark = i;
                        encoded = false;
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key2 != null) continue block9;
                        key2 = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key2 != null) {
                int l = content.length() - mark - 1;
                value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1));
                map2.add(key2, value);
            } else if (mark < content.length()) {
                String string2 = key2 = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                if (key2 != null && key2.length() > 0) {
                    map2.add(key2, "");
                }
            }
        }
    }

    public static void decodeUtf8To(String query, MultiMap<String> map2) {
        UrlEncoded.decodeUtf8To(query, 0, query.length(), map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map2) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String key2 = null;
            String value = null;
            int end = offset + length;
            block9: for (int i = offset; i < end; ++i) {
                char c = query.charAt(i);
                switch (c) {
                    case '&': {
                        value = buffer.toReplacedString();
                        buffer.reset();
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append(c);
                            continue block9;
                        }
                        key2 = buffer.toReplacedString();
                        buffer.reset();
                        continue block9;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i + 2 < end) {
                            char hi = query.charAt(++i);
                            char lo = query.charAt(++i);
                            buffer.append(UrlEncoded.decodeHexByte(hi, lo));
                            continue block9;
                        }
                        throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            if (key2 != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toReplacedString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            int b;
            StringBuilder buffer = new StringBuilder();
            String key2 = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        UrlEncoded.checkMaxKeys(map2, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append((char)b);
                            break;
                        }
                        key2 = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int code0 = in.read();
                        int code1 = in.read();
                        buffer.append(UrlEncoded.decodeHexChar(code0, code1));
                        break;
                    }
                    default: {
                        buffer.append((char)b);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            if (key2 != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toString(), "");
            }
            UrlEncoded.checkMaxKeys(map2, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            int b;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key2 = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.toReplacedString();
                        buffer.reset();
                        if (key2 != null) {
                            map2.add(key2, value);
                        } else if (value != null && value.length() > 0) {
                            map2.add(value, "");
                        }
                        key2 = null;
                        value = null;
                        UrlEncoded.checkMaxKeys(map2, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key2 != null) {
                            buffer.append((byte)b);
                            break;
                        }
                        key2 = buffer.toReplacedString();
                        buffer.reset();
                        break;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        char code0 = (char)in.read();
                        char code1 = (char)in.read();
                        buffer.append(UrlEncoded.decodeHexByte(code0, code1));
                        break;
                    }
                    default: {
                        buffer.append((byte)b);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            if (key2 != null) {
                value = buffer.toReplacedString();
                buffer.reset();
                map2.add(key2, value);
            } else if (buffer.length() > 0) {
                map2.add(buffer.toReplacedString(), "");
            }
            UrlEncoded.checkMaxKeys(map2, maxKeys);
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap<String> map2, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input = new InputStreamReader(in, StandardCharsets.UTF_16);
        StringWriter buf = new StringWriter(8192);
        IO.copy(input, buf, (long)maxLength);
        UrlEncoded.decodeTo(buf.getBuffer().toString(), map2, StandardCharsets.UTF_16);
    }

    public static void decodeTo(InputStream in, MultiMap<String> map2, String charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            if (ENCODING.equals(StandardCharsets.UTF_8)) {
                UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
            } else {
                UrlEncoded.decodeTo(in, map2, ENCODING, maxLength, maxKeys);
            }
        } else if ("utf-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
        } else if ("iso-8859-1".equalsIgnoreCase(charset)) {
            UrlEncoded.decode88591To(in, map2, maxLength, maxKeys);
        } else if ("utf-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map2, maxLength, maxKeys);
        } else {
            UrlEncoded.decodeTo(in, map2, Charset.forName(charset), maxLength, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap<String> map2, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, map2, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, map2, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, map2, maxLength, maxKeys);
            return;
        }
        MultiMap<String> multiMap = map2;
        synchronized (multiMap) {
            String key2 = null;
            String value = null;
            int totalLength = 0;
            try (ByteArrayOutputStream2 output = new ByteArrayOutputStream2();){
                int c;
                int size = 0;
                while ((c = in.read()) > 0) {
                    switch ((char)c) {
                        case '&': {
                            size = output.size();
                            value = size == 0 ? "" : output.toString(charset);
                            output.setCount(0);
                            if (key2 != null) {
                                map2.add(key2, value);
                            } else if (value != null && value.length() > 0) {
                                map2.add(value, "");
                            }
                            key2 = null;
                            value = null;
                            UrlEncoded.checkMaxKeys(map2, maxKeys);
                            break;
                        }
                        case '=': {
                            if (key2 != null) {
                                output.write(c);
                                break;
                            }
                            size = output.size();
                            key2 = size == 0 ? "" : output.toString(charset);
                            output.setCount(0);
                            break;
                        }
                        case '+': {
                            output.write(32);
                            break;
                        }
                        case '%': {
                            int code0 = in.read();
                            int code1 = in.read();
                            output.write(UrlEncoded.decodeHexChar(code0, code1));
                            break;
                        }
                        default: {
                            output.write(c);
                        }
                    }
                    UrlEncoded.checkMaxLength(++totalLength, maxLength);
                }
                size = output.size();
                if (key2 != null) {
                    value = size == 0 ? "" : output.toString(charset);
                    output.setCount(0);
                    map2.add(key2, value);
                } else if (size > 0) {
                    map2.add(output.toString(charset), "");
                }
                UrlEncoded.checkMaxKeys(map2, maxKeys);
            }
        }
    }

    private static void checkMaxKeys(MultiMap<String> map2, int maxKeys) {
        int size = map2.size();
        if (maxKeys >= 0 && size > maxKeys) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", size, maxKeys));
        }
    }

    private static void checkMaxLength(int length, int maxLength) {
        if (maxLength >= 0 && length > maxLength) {
            throw new IllegalStateException("Form is larger than max length " + maxLength);
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), ENCODING);
    }

    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable buffer = null;
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i);
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i);
                    }
                    if (i + 2 < length) {
                        int o = offset + i + 1;
                        i += 2;
                        byte b = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                        buffer.append(b);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                    i = length;
                    continue;
                }
                if (buffer == null) continue;
                ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(offset + i);
            if (c < '\u0000' || c > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i + 1);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i);
                }
                buffer.append(' ');
                continue;
            }
            if (c == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i);
                }
                byte[] ba = new byte[length];
                int n = 0;
                while (c >= '\u0000' && c <= '\u00ff') {
                    if (c == '%') {
                        if (i + 2 < length) {
                            int o = offset + i + 1;
                            i += 3;
                            ba[n] = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                            ++n;
                        } else {
                            ba[n++] = 63;
                            i = length;
                        }
                    } else if (c == '+') {
                        ba[n++] = 32;
                        ++i;
                    } else {
                        ba[n++] = (byte)c;
                        ++i;
                    }
                    if (i >= length) break;
                    c = encoded.charAt(offset + i);
                }
                --i;
                buffer.append(new String(ba, 0, n, charset));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        return buffer.toString();
    }

    private static char decodeHexChar(int hi, int lo) {
        try {
            return (char)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Not valid encoding '%" + (char)hi + (char)lo + "'");
        }
    }

    private static byte decodeHexByte(char hi, char lo) {
        try {
            return (byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Not valid encoding '%" + hi + lo + "'");
        }
    }

    public static String encodeString(String string2) {
        return UrlEncoded.encodeString(string2, ENCODING);
    }

    public static String encodeString(String string2, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes2 = null;
        bytes2 = string2.getBytes(charset);
        int len = bytes2.length;
        byte[] encoded = new byte[bytes2.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes2[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 45 || b == 46 || b == 95 || b == 126) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string2;
        }
        return new String(encoded, 0, n, charset);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset encoding2;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String charset = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset");
            encoding2 = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e2) {
            LOG.warn(e2);
            encoding2 = StandardCharsets.UTF_8;
        }
        ENCODING = encoding2;
    }
}

