# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2020 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vcenter.lcm.
#---------------------------------------------------------------------------

"""
The ``com.vmware.vcenter.lcm_client`` module provides classes for managing the
vCenter Server lifecycle.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Notification(VapiStruct):
    """
    The ``Notification`` class describes a notification that can be reported by
    the appliance task, which can be of type info, warning or errors.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 id=None,
                 time=None,
                 message=None,
                 resolution=None,
                ):
        """
        :type  id: :class:`str`
        :param id: The notification id.
        :type  time: :class:`datetime.datetime` or ``None``
        :param time: The time the notification was raised/found.
            Only if the time information is available.
        :type  message: :class:`com.vmware.vapi.std_client.LocalizableMessage`
        :param message: The notification message.
        :type  resolution: :class:`com.vmware.vapi.std_client.LocalizableMessage` or ``None``
        :param resolution: The resolution message, if any.
            Only :class:`set` for warnings and errors.
        """
        self.id = id
        self.time = time
        self.message = message
        self.resolution = resolution
        VapiStruct.__init__(self)


Notification._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.notification', {
        'id': type.StringType(),
        'time': type.OptionalType(type.DateTimeType()),
        'message': type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage'),
        'resolution': type.OptionalType(type.ReferenceType('com.vmware.vapi.std_client', 'LocalizableMessage')),
    },
    Notification,
    False,
    None))



class Notifications(VapiStruct):
    """
    The ``Notifications`` class contains info/warning/error messages that can
    be reported be the appliance task.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """




    def __init__(self,
                 info=None,
                 warnings=None,
                 errors=None,
                ):
        """
        :type  info: :class:`list` of :class:`Notification` or ``None``
        :param info: Info notification messages reported.
            Only :class:`set` if an info was reported by the appliance task.
        :type  warnings: :class:`list` of :class:`Notification` or ``None``
        :param warnings: Warning notification messages reported.
            Only :class:`set` if an warning was reported by the appliance task.
        :type  errors: :class:`list` of :class:`Notification` or ``None``
        :param errors: Error notification messages reported.
            Only :class:`set` if an error was reported by the appliance task.
        """
        self.info = info
        self.warnings = warnings
        self.errors = errors
        VapiStruct.__init__(self)


Notifications._set_binding_type(type.StructType(
    'com.vmware.vcenter.lcm.notifications', {
        'info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Notification'))),
        'warnings': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Notification'))),
        'errors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Notification'))),
    },
    Notifications,
    False,
    None))



class Reports(VapiInterface):
    """
    The ``Report`` class provides an method to download the report generated by
    the interop and precheck operations. To download a report, you must use the
    ``get`` method. A ``Report.Location`` class represents the location of the
    file which has ``Report.Token`` class which represents the token ID
    (\\\\@name String) and the expiration time of the token
    ``Report.Token.expiry`` DateTime. ``Report.Location`` class also has the
    URI for the file which needs to be downloaded.
    """

    _VAPI_SERVICE_ID = 'com.vmware.vcenter.lcm.reports'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ReportsStub)
        self._VAPI_OPERATION_IDS = {}

    class Token(VapiStruct):
        """
        The ``Reports.Token`` class contains information about the token required
        in the HTTP GET request to generate the report.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     token=None,
                     expiry=None,
                    ):
            """
            :type  token: :class:`str`
            :param token: A one-time, short-lived token required in the HTTP header of the
                request to the url. This token needs to be passed in as a header
                with the name "session-id".
            :type  expiry: :class:`datetime.datetime`
            :param expiry: Expiry time of the token
            """
            self.token = token
            self.expiry = expiry
            VapiStruct.__init__(self)


    Token._set_binding_type(type.StructType(
        'com.vmware.vcenter.lcm.reports.token', {
            'token': type.StringType(),
            'expiry': type.DateTimeType(),
        },
        Token,
        False,
        None))


    class Location(VapiStruct):
        """
        The ``Reports.Location`` class contains the URI location to download the
        report from, as well as a token required (as a header on the HTTP request)
        to get the bundle. The validity of the token is 5 minutes as best attempt.
        After the token expires, any attempt to call the URI with said token will
        fail.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     uri=None,
                     download_file_token=None,
                    ):
            """
            :type  uri: :class:`str`
            :param uri: Report Download URI.
            :type  download_file_token: :class:`Reports.Token`
            :param download_file_token: Information about the token required in the HTTP GET request to
                retrieve the report
            """
            self.uri = uri
            self.download_file_token = download_file_token
            VapiStruct.__init__(self)


    Location._set_binding_type(type.StructType(
        'com.vmware.vcenter.lcm.reports.location', {
            'uri': type.URIType(),
            'download_file_token': type.ReferenceType(__name__, 'Reports.Token'),
        },
        Location,
        False,
        None))



    def get(self,
            report,
            ):
        """
        Returns the location :class:`Reports.Location` information for
        downloading the report for the specified file name. 
        
         Retrieving a report involves two steps: 
        
        * Step 1: Invoke the :func:`Reports.get` method to provision a token
          and a URI.
        * Step 2: Make an HTTP GET request by using the URI and the token
          returned in step 1 to retrieve the report.
        
         
        
         The HTTP GET request will: 
        
        * Return 401 (Not Authorized) if the download URI is recognized, but
          the token is invalid, 404 if the URL is not recognized otherwise return
          200 (OK)
        * Provide the CSV contents as the output of the request. The API
          accepts the file name as input, reads the contents of that CSV file,
          and returns this text as the result of the API.

        :type  report: :class:`str`
        :param report: 
            The parameter must be an identifier for the resource type:
            ``com.vmware.vcenter.lcm.report``.
        :rtype: :class:`Reports.Location`
        :return: 
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            if the user can not be authenticated.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            If there is no file associated with ``report`` in the system.
        :raise: :class:`com.vmware.vapi.std.errors_client.Error` 
            If there is some unknown internal error. The accompanying error
            message will give more details about the failure.
        """
        return self._invoke('get',
                            {
                            'report': report,
                            })
class _ReportsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'report': type.IdType(resource_types='com.vmware.vcenter.lcm.report'),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),
            'com.vmware.vapi.std.errors.error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Error'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vcenter/lcm/reports/{report}',
            path_variables={
                'report': 'report',
            },
            query_parameters={
            },
            dispatch_parameters={
            },
            header_parameters={
            },
            dispatch_header_parameters={
            }
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'Reports.Location'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vcenter.lcm.reports',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Reports': Reports,
        'discovery': 'com.vmware.vcenter.lcm.discovery_client.StubFactory',
        'update': 'com.vmware.vcenter.lcm.update_client.StubFactory',
    }

