(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/41#stream-type
    (make-struct-type
     'std/srfi/41#stream-type
     '#f
     '1
     'stream-type
     '((fields: box))
     '#f))
  (define std/srfi/41#stream? (make-struct-predicate std/srfi/41#stream-type))
  (define std/srfi/41#stream-promise
    (make-struct-field-accessor std/srfi/41#stream-type '0))
  (define std/srfi/41#stream-promise!
    (make-struct-field-mutator std/srfi/41#stream-type '0))
  (define std/srfi/41#make-stream
    (lambda (_box3584_)
      (make-struct-instance std/srfi/41#stream-type _box3584_)))
  (define std/srfi/41#stream-eager
    (lambda (_expr3582_)
      (let ((__tmp7691 (cons 'eager _expr3582_)))
        (declare (not safe))
        (##structure std/srfi/41#stream-type __tmp7691))))
  (define std/srfi/41#stream-force
    (lambda (_promise3570_)
      (let* ((_content3572_
              (##structure-ref _promise3570_ '1 std/srfi/41#stream-type '#f))
             (_$e3574_ (car _content3572_)))
        (if (eq? 'eager _$e3574_)
            (cdr _content3572_)
            (if (eq? 'lazy _$e3574_)
                (let* ((_promise*3577_ ((cdr _content3572_)))
                       (_content3579_
                        (##structure-ref
                         _promise3570_
                         '1
                         std/srfi/41#stream-type
                         '#f)))
                  (if (not (eqv? (car _content3579_) 'eager))
                      (begin
                        (set-car!
                         _content3579_
                         (car (##structure-ref
                               _promise*3577_
                               '1
                               std/srfi/41#stream-type
                               '#f)))
                        (set-cdr!
                         _content3579_
                         (cdr (##structure-ref
                               _promise*3577_
                               '1
                               std/srfi/41#stream-type
                               '#f)))
                        (##structure-set!
                         _promise*3577_
                         _content3579_
                         '1
                         std/srfi/41#stream-type
                         '#f))
                      '#!void)
                  (std/srfi/41#stream-force _promise3570_))
                '#!void)))))
  (define std/srfi/41#stream-null
    (let ((__tmp7692
           (cons 'lazy
                 (lambda () (std/srfi/41#stream-eager (cons 'stream 'null))))))
      (declare (not safe))
      (##structure std/srfi/41#stream-type __tmp7692)))
  (define std/srfi/41#stream-pare-type
    (make-struct-type
     'std/srfi/41#stream-pare-type
     '#f
     '2
     'stream-pare-type
     '((fields: kar kdr))
     '#f))
  (define std/srfi/41#stream-pare?
    (make-struct-predicate std/srfi/41#stream-pare-type))
  (define std/srfi/41#stream-kar
    (make-struct-field-accessor std/srfi/41#stream-pare-type '0))
  (define std/srfi/41#stream-kdr
    (make-struct-field-accessor std/srfi/41#stream-pare-type '1))
  (define std/srfi/41#make-stream-pare
    (lambda (_kar3566_ _kdr3567_)
      (make-struct-instance std/srfi/41#stream-pare-type _kar3566_ _kdr3567_)))
  (define std/srfi/41#stream-pair?
    (lambda (_obj3564_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj3564_ 'std/srfi/41#stream-type))
          (let ((__tmp7693 (std/srfi/41#stream-force _obj3564_)))
            (declare (not safe))
            (##structure-instance-of? __tmp7693 'std/srfi/41#stream-pare-type))
          '#f)))
  (define std/srfi/41#stream-null?
    (lambda (_obj3562_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj3562_ 'std/srfi/41#stream-type))
          (eqv? (std/srfi/41#stream-force _obj3562_)
                (std/srfi/41#stream-force std/srfi/41#stream-null))
          '#f)))
  (define std/srfi/41#stream-car
    (lambda (_strm3560_)
      (if (not (let ()
                 (declare (not safe))
                 (##structure-instance-of?
                  _strm3560_
                  'std/srfi/41#stream-type)))
          (error 'stream-car '"non-stream")
          (if (std/srfi/41#stream-null? _strm3560_)
              (error 'stream-car '"null stream")
              (std/srfi/41#stream-force
               (##structure-ref
                (std/srfi/41#stream-force _strm3560_)
                '1
                std/srfi/41#stream-pare-type
                '#f))))))
  (define std/srfi/41#stream-cdr
    (lambda (_strm3558_)
      (if (not (let ()
                 (declare (not safe))
                 (##structure-instance-of?
                  _strm3558_
                  'std/srfi/41#stream-type)))
          (error 'stream-cdr '"non-stream")
          (if (std/srfi/41#stream-null? _strm3558_)
              (error 'stream-cdr '"null stream")
              (##structure-ref
               (std/srfi/41#stream-force _strm3558_)
               '2
               std/srfi/41#stream-pare-type
               '#f)))))
  (define std/srfi/41#exists
    (lambda (_pred?3552_ . _lists3553_)
      (if (not (null? (car _lists3553_)))
          (let ((_$e3555_ (apply _pred?3552_ (map car _lists3553_))))
            (if _$e3555_
                _$e3555_
                (apply std/srfi/41#exists _pred?3552_ (map cdr _lists3553_))))
          '#f)))
  (define std/srfi/41#list->stream
    (lambda (_objs3542_)
      (letrec ((_list->stream3544_
                (lambda (_objs3546_)
                  (let ((__tmp7694
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (null? _objs3546_)
                                       std/srfi/41#stream-null
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7697
                                               (let ((__tmp7698
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               (car _objs3546_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7698)))
                                              (__tmp7695
                                               (let ((__tmp7696
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_list->stream3544_
                                                               (cdr _objs3546_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7696))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7697
                                           __tmp7695)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7694)))))
        (if (not (list? _objs3542_))
            (error 'list->stream '"non-list argument")
            (_list->stream3544_ _objs3542_)))))
  (define std/srfi/41#port->stream
    (lambda _port3528_
      (letrec ((_port->stream3530_
                (lambda (_p3534_)
                  (let ((__tmp7699
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (let ((_c3538_ (read-char _p3534_)))
                                     (if (eof-object? _c3538_)
                                         std/srfi/41#stream-null
                                         (std/srfi/41#stream-eager
                                          (let ((__tmp7702
                                                 (let ((__tmp7703
                                                        (cons 'lazy
                                                              (lambda ()
                                                                (std/srfi/41#stream-eager
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _c3538_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (declare (not safe))
                                                   (##structure
                                                    std/srfi/41#stream-type
                                                    __tmp7703)))
                                                (__tmp7700
                                                 (let ((__tmp7701
                                                        (cons 'lazy
                                                              (lambda ()
                                                                (_port->stream3530_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _p3534_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (declare (not safe))
                                                   (##structure
                                                    std/srfi/41#stream-type
                                                    __tmp7701))))
                                            (declare (not safe))
                                            (##structure
                                             std/srfi/41#stream-pare-type
                                             __tmp7702
                                             __tmp7700))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7699)))))
        (let ((_p3532_ (if (null? _port3528_)
                           (current-input-port)
                           (car _port3528_))))
          (if (not (input-port? _p3532_))
              (error 'port->stream '"non-input-port argument")
              (_port->stream3530_ _p3532_))))))
  (define std/srfi/41#stream->list
    (lambda _args3515_
      (let ((_n3517_ (if (= '1 (length _args3515_)) '#f (car _args3515_)))
            (_strm3518_
             (if (= '1 (length _args3515_))
                 (car _args3515_)
                 (cadr _args3515_))))
        (if (not (let ()
                   (declare (not safe))
                   (##structure-instance-of?
                    _strm3518_
                    'std/srfi/41#stream-type)))
            (error 'stream->list '"non-stream argument")
            (if (and _n3517_ (not (integer? _n3517_)))
                (error 'stream->list '"non-integer count")
                (if (and _n3517_ (negative? _n3517_))
                    (error 'stream->list '"negative count")
                    (let _loop3520_ ((_n3522_ (if _n3517_ _n3517_ '-1))
                                     (_strm3523_ _strm3518_))
                      (if (or (zero? _n3522_)
                              (std/srfi/41#stream-null? _strm3523_))
                          '()
                          (cons (std/srfi/41#stream-car _strm3523_)
                                (_loop3520_
                                 (- _n3522_ '1)
                                 (std/srfi/41#stream-cdr _strm3523_)))))))))))
  (define std/srfi/41#stream-append
    (lambda _strms3503_
      (letrec ((_stream-append3505_
                (lambda (_strms3509_)
                  (let ((__tmp7704
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (null? (cdr _strms3509_))
                                       (car _strms3509_)
                                       (if (std/srfi/41#stream-null?
                                            (car _strms3509_))
                                           (_stream-append3505_
                                            (cdr _strms3509_))
                                           (std/srfi/41#stream-eager
                                            (let ((__tmp7707
                                                   (let ((__tmp7708
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (std/srfi/41#stream-eager
                           (std/srfi/41#stream-car (car _strms3509_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7708)))
                                                  (__tmp7705
                                                   (let ((__tmp7706
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (_stream-append3505_
                           (cons (std/srfi/41#stream-cdr (car _strms3509_))
                                 (cdr _strms3509_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7706))))
                                              (declare (not safe))
                                              (##structure
                                               std/srfi/41#stream-pare-type
                                               __tmp7707
                                               __tmp7705))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7704)))))
        (if (null? _strms3503_)
            std/srfi/41#stream-null
            (if (std/srfi/41#exists
                 (lambda (_x3507_)
                   (not (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _x3507_
                           'std/srfi/41#stream-type))))
                 _strms3503_)
                (error 'stream-append '"non-stream argument")
                (_stream-append3505_ _strms3503_))))))
  (define std/srfi/41#stream-concat
    (lambda (_strms3491_)
      (letrec ((_stream-concat3493_
                (lambda (_strms3495_)
                  (let ((__tmp7709
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#stream-null? _strms3495_)
                                       std/srfi/41#stream-null
                                       (if (not (let ((__tmp7710
                                                       (std/srfi/41#stream-car
                                                        _strms3495_)))
                                                  (declare (not safe))
                                                  (##structure-instance-of?
                                                   __tmp7710
                                                   'std/srfi/41#stream-type)))
                                           (error 'stream-concat
                                                  '"non-stream object in input stream")
                                           (if (std/srfi/41#stream-null?
                                                (std/srfi/41#stream-car
                                                 _strms3495_))
                                               (_stream-concat3493_
                                                (std/srfi/41#stream-cdr
                                                 _strms3495_))
                                               (std/srfi/41#stream-eager
                                                (let ((__tmp7717
                                                       (let ((__tmp7718
                                                              (cons 'lazy
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            (lambda ()
                              (std/srfi/41#stream-eager
                               (std/srfi/41#stream-car
                                (std/srfi/41#stream-car _strms3495_)))))))
                 (declare (not safe))
                 (##structure std/srfi/41#stream-type __tmp7718)))
              (__tmp7711
               (let ((__tmp7712
                      (cons 'lazy
                            (lambda ()
                              (_stream-concat3493_
                               (std/srfi/41#stream-eager
                                (let ((__tmp7715
                                       (let ((__tmp7716
                                              (cons 'lazy
                                                    (lambda ()
                                                      (std/srfi/41#stream-eager
                                                       (std/srfi/41#stream-cdr
                                                        (std/srfi/41#stream-car
                                                         _strms3495_)))))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7716)))
                                      (__tmp7713
                                       (let ((__tmp7714
                                              (cons 'lazy
                                                    (lambda ()
                                                      (std/srfi/41#stream-cdr
                                                       _strms3495_)))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7714))))
                                  (declare (not safe))
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   __tmp7715
                                   __tmp7713))))))))
                 (declare (not safe))
                 (##structure std/srfi/41#stream-type __tmp7712))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (declare (not safe))
                                                  (##structure
                                                   std/srfi/41#stream-pare-type
                                                   __tmp7717
                                                   __tmp7711)))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7709)))))
        (if (not (let ()
                   (declare (not safe))
                   (##structure-instance-of?
                    _strms3491_
                    'std/srfi/41#stream-type)))
            (error 'stream-concat '"non-stream argument")
            (_stream-concat3493_ _strms3491_)))))
  (define std/srfi/41#stream-constant
    (lambda _objs3483_
      (let ((__tmp7719
             (cons 'lazy
                   (lambda ()
                     (let ()
                       (if (null? _objs3483_)
                           std/srfi/41#stream-null
                           (if (null? (cdr _objs3483_))
                               (std/srfi/41#stream-eager
                                (let ((__tmp7722
                                       (let ((__tmp7723
                                              (cons 'lazy
                                                    (lambda ()
                                                      (std/srfi/41#stream-eager
                                                       (car _objs3483_))))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7723)))
                                      (__tmp7720
                                       (let ((__tmp7721
                                              (cons 'lazy
                                                    (lambda ()
                                                      (std/srfi/41#stream-constant
                                                       (car _objs3483_))))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7721))))
                                  (declare (not safe))
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   __tmp7722
                                   __tmp7720)))
                               (std/srfi/41#stream-eager
                                (let ((__tmp7726
                                       (let ((__tmp7727
                                              (cons 'lazy
                                                    (lambda ()
                                                      (std/srfi/41#stream-eager
                                                       (car _objs3483_))))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7727)))
                                      (__tmp7724
                                       (let ((__tmp7725
                                              (cons 'lazy
                                                    (lambda ()
                                                      (apply std/srfi/41#stream-constant
                                                             (append (cdr _objs3483_)
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             (list (car _objs3483_))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-type
                                          __tmp7725))))
                                  (declare (not safe))
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   __tmp7726
                                   __tmp7724))))))))))
        (declare (not safe))
        (##structure std/srfi/41#stream-type __tmp7719))))
  (define std/srfi/41#stream-drop
    (lambda (_n3470_ _strm3471_)
      (letrec ((_stream-drop3473_
                (lambda (_n3475_ _strm3476_)
                  (let ((__tmp7728
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (or (zero? _n3475_)
                                           (std/srfi/41#stream-null?
                                            _strm3476_))
                                       _strm3476_
                                       (_stream-drop3473_
                                        (- _n3475_ '1)
                                        (std/srfi/41#stream-cdr
                                         _strm3476_))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7728)))))
        (if (not (integer? _n3470_))
            (error 'stream-drop '"non-integer argument")
            (if (negative? _n3470_)
                (error 'stream-drop '"negative argument")
                (if (not (let ()
                           (declare (not safe))
                           (##structure-instance-of?
                            _strm3471_
                            'std/srfi/41#stream-type)))
                    (error 'stream-drop '"non-stream argument")
                    (_stream-drop3473_ _n3470_ _strm3471_)))))))
  (define std/srfi/41#stream-drop-while
    (lambda (_pred?3461_ _strm3462_)
      (letrec ((_stream-drop-while3464_
                (lambda (_strm3466_)
                  (let ((__tmp7729
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (and (std/srfi/41#stream-pair?
                                             _strm3466_)
                                            (_pred?3461_
                                             (std/srfi/41#stream-car
                                              _strm3466_)))
                                       (_stream-drop-while3464_
                                        (std/srfi/41#stream-cdr _strm3466_))
                                       _strm3466_))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7729)))))
        (if (not (procedure? _pred?3461_))
            (error 'stream-drop-while '"non-procedural argument")
            (if (not (let ()
                       (declare (not safe))
                       (##structure-instance-of?
                        _strm3462_
                        'std/srfi/41#stream-type)))
                (error 'stream-drop-while '"non-stream argument")
                (_stream-drop-while3464_ _strm3462_))))))
  (define std/srfi/41#stream-filter
    (lambda (_pred?3450_ _strm3451_)
      (letrec ((_stream-filter3453_
                (lambda (_strm3455_)
                  (let ((__tmp7730
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#stream-null? _strm3455_)
                                       std/srfi/41#stream-null
                                       (if (_pred?3450_
                                            (std/srfi/41#stream-car
                                             _strm3455_))
                                           (std/srfi/41#stream-eager
                                            (let ((__tmp7733
                                                   (let ((__tmp7734
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (std/srfi/41#stream-eager
                           (std/srfi/41#stream-car _strm3455_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7734)))
                                                  (__tmp7731
                                                   (let ((__tmp7732
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (_stream-filter3453_
                           (std/srfi/41#stream-cdr _strm3455_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7732))))
                                              (declare (not safe))
                                              (##structure
                                               std/srfi/41#stream-pare-type
                                               __tmp7733
                                               __tmp7731)))
                                           (_stream-filter3453_
                                            (std/srfi/41#stream-cdr
                                             _strm3455_)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7730)))))
        (if (not (procedure? _pred?3450_))
            (error 'stream-filter '"non-procedural argument")
            (if (not (let ()
                       (declare (not safe))
                       (##structure-instance-of?
                        _strm3451_
                        'std/srfi/41#stream-type)))
                (error 'stream-filter '"non-stream argument")
                (_stream-filter3453_ _strm3451_))))))
  (define std/srfi/41#stream-fold
    (lambda (_proc3441_ _base3442_ _strm3443_)
      (if (not (procedure? _proc3441_))
          (error 'stream-fold '"non-procedural argument")
          (if (not (let ()
                     (declare (not safe))
                     (##structure-instance-of?
                      _strm3443_
                      'std/srfi/41#stream-type)))
              (error 'stream-fold '"non-stream argument")
              (let _loop3445_ ((_base3447_ _base3442_) (_strm3448_ _strm3443_))
                (if (std/srfi/41#stream-null? _strm3448_)
                    _base3447_
                    (_loop3445_
                     (_proc3441_
                      _base3447_
                      (std/srfi/41#stream-car _strm3448_))
                     (std/srfi/41#stream-cdr _strm3448_))))))))
  (define std/srfi/41#stream-for-each
    (lambda (_proc3432_ . _strms3433_)
      (letrec ((_stream-for-each3435_
                (lambda (_strms3439_)
                  (if (not (std/srfi/41#exists
                            std/srfi/41#stream-null?
                            _strms3439_))
                      (begin
                        (apply _proc3432_
                               (map std/srfi/41#stream-car _strms3439_))
                        (_stream-for-each3435_
                         (map std/srfi/41#stream-cdr _strms3439_)))
                      '#!void))))
        (if (not (procedure? _proc3432_))
            (error 'stream-for-each '"non-procedural argument")
            (if (null? _strms3433_)
                (error 'stream-for-each '"no stream arguments")
                (if (std/srfi/41#exists
                     (lambda (_x3437_)
                       (not (let ()
                              (declare (not safe))
                              (##structure-instance-of?
                               _x3437_
                               'std/srfi/41#stream-type))))
                     _strms3433_)
                    (error 'stream-for-each '"non-stream argument")
                    (_stream-for-each3435_ _strms3433_)))))))
  (define std/srfi/41#stream-from
    (lambda (_first3418_ . _step3419_)
      (letrec ((_stream-from3421_
                (lambda (_first3425_ _delta3426_)
                  (let ((__tmp7735
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (std/srfi/41#stream-eager
                                    (let ((__tmp7738
                                           (let ((__tmp7739
                                                  (cons 'lazy
                                                        (lambda ()
                                                          (std/srfi/41#stream-eager
                                                           _first3425_)))))
                                             (declare (not safe))
                                             (##structure
                                              std/srfi/41#stream-type
                                              __tmp7739)))
                                          (__tmp7736
                                           (let ((__tmp7737
                                                  (cons 'lazy
                                                        (lambda ()
                                                          (_stream-from3421_
                                                           (+ _first3425_
                                                              _delta3426_)
                                                           _delta3426_)))))
                                             (declare (not safe))
                                             (##structure
                                              std/srfi/41#stream-type
                                              __tmp7737))))
                                      (declare (not safe))
                                      (##structure
                                       std/srfi/41#stream-pare-type
                                       __tmp7738
                                       __tmp7736))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7735)))))
        (let ((_delta3423_ (if (null? _step3419_) '1 (car _step3419_))))
          (if (not (number? _first3418_))
              (error 'stream-from '"non-numeric starting number")
              (if (not (number? _delta3423_))
                  (error 'stream-from '"non-numeric step size")
                  (_stream-from3421_ _first3418_ _delta3423_)))))))
  (define std/srfi/41#stream-iterate
    (lambda (_proc3407_ _base3408_)
      (letrec ((_stream-iterate3410_
                (lambda (_base3412_)
                  (let ((__tmp7740
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (std/srfi/41#stream-eager
                                    (let ((__tmp7743
                                           (let ((__tmp7744
                                                  (cons 'lazy
                                                        (lambda ()
                                                          (std/srfi/41#stream-eager
                                                           _base3412_)))))
                                             (declare (not safe))
                                             (##structure
                                              std/srfi/41#stream-type
                                              __tmp7744)))
                                          (__tmp7741
                                           (let ((__tmp7742
                                                  (cons 'lazy
                                                        (lambda ()
                                                          (_stream-iterate3410_
                                                           (_proc3407_
                                                            _base3412_))))))
                                             (declare (not safe))
                                             (##structure
                                              std/srfi/41#stream-type
                                              __tmp7742))))
                                      (declare (not safe))
                                      (##structure
                                       std/srfi/41#stream-pare-type
                                       __tmp7743
                                       __tmp7741))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7740)))))
        (if (not (procedure? _proc3407_))
            (error 'stream-iterate '"non-procedural argument")
            (_stream-iterate3410_ _base3408_)))))
  (define std/srfi/41#stream-length
    (lambda (_strm3400_)
      (if (not (let ()
                 (declare (not safe))
                 (##structure-instance-of?
                  _strm3400_
                  'std/srfi/41#stream-type)))
          (error 'stream-length '"non-stream argument")
          (let _loop3402_ ((_len3404_ '0) (_strm3405_ _strm3400_))
            (if (std/srfi/41#stream-null? _strm3405_)
                _len3404_
                (_loop3402_
                 (+ _len3404_ '1)
                 (std/srfi/41#stream-cdr _strm3405_)))))))
  (define std/srfi/41#stream-map
    (lambda (_proc3387_ . _strms3388_)
      (letrec ((_stream-map3390_
                (lambda (_strms3394_)
                  (let ((__tmp7745
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#exists
                                        std/srfi/41#stream-null?
                                        _strms3394_)
                                       std/srfi/41#stream-null
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7748
                                               (let ((__tmp7749
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               (apply _proc3387_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                              (map std/srfi/41#stream-car _strms3394_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7749)))
                                              (__tmp7746
                                               (let ((__tmp7747
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-map3390_
                                                               (map std/srfi/41#stream-cdr
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _strms3394_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7747))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7748
                                           __tmp7746)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7745)))))
        (if (not (procedure? _proc3387_))
            (error 'stream-map '"non-procedural argument")
            (if (null? _strms3388_)
                (error 'stream-map '"no stream arguments")
                (if (std/srfi/41#exists
                     (lambda (_x3392_)
                       (not (let ()
                              (declare (not safe))
                              (##structure-instance-of?
                               _x3392_
                               'std/srfi/41#stream-type))))
                     _strms3388_)
                    (error 'stream-map '"non-stream argument")
                    (_stream-map3390_ _strms3388_)))))))
  (define std/srfi/41#stream-range
    (lambda (_first3368_ _past3369_ . _step3370_)
      (letrec ((_stream-range3372_
                (lambda (_first3378_ _past3379_ _delta3380_ _lt?3381_)
                  (let ((__tmp7750
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (_lt?3381_ _first3378_ _past3379_)
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7753
                                               (let ((__tmp7754
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               _first3378_)))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7754)))
                                              (__tmp7751
                                               (let ((__tmp7752
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-range3372_
                                                               (+ _first3378_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _delta3380_)
                       _past3379_
                       _delta3380_
                       _lt?3381_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7752))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7753
                                           __tmp7751)))
                                       std/srfi/41#stream-null))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7750)))))
        (if (not (number? _first3368_))
            (error 'stream-range '"non-numeric starting number")
            (if (not (number? _past3369_))
                (error 'stream-range '"non-numeric ending number")
                (let ((_delta3374_
                       (if (pair? _step3370_)
                           (car _step3370_)
                           (if (< _first3368_ _past3369_) '1 '-1))))
                  (if (not (number? _delta3374_))
                      (error 'stream-range '"non-numeric step size")
                      (let ((_lt?3376_ (if (< '0 _delta3374_) < >)))
                        (_stream-range3372_
                         _first3368_
                         _past3369_
                         _delta3374_
                         _lt?3376_)))))))))
  (define std/srfi/41#stream-ref
    (lambda (_strm3360_ _n3361_)
      (if (not (let ()
                 (declare (not safe))
                 (##structure-instance-of?
                  _strm3360_
                  'std/srfi/41#stream-type)))
          (error 'stream-ref '"non-stream argument")
          (if (not (integer? _n3361_))
              (error 'stream-ref '"non-integer argument")
              (if (negative? _n3361_)
                  (error 'stream-ref '"negative argument")
                  (let _loop3363_ ((_strm3365_ _strm3360_) (_n3366_ _n3361_))
                    (if (std/srfi/41#stream-null? _strm3365_)
                        (error 'stream-ref '"beyond end of stream")
                        (if (zero? _n3366_)
                            (std/srfi/41#stream-car _strm3365_)
                            (_loop3363_
                             (std/srfi/41#stream-cdr _strm3365_)
                             (- _n3366_ '1))))))))))
  (define std/srfi/41#stream-reverse
    (lambda (_strm3349_)
      (letrec ((_stream-reverse3351_
                (lambda (_strm3353_ _rev3354_)
                  (let ((__tmp7755
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#stream-null? _strm3353_)
                                       _rev3354_
                                       (_stream-reverse3351_
                                        (std/srfi/41#stream-cdr _strm3353_)
                                        (std/srfi/41#stream-eager
                                         (let ((__tmp7758
                                                (let ((__tmp7759
                                                       (cons 'lazy
                                                             (lambda ()
                                                               (std/srfi/41#stream-eager
                                                                (std/srfi/41#stream-car
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _strm3353_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (declare (not safe))
                                                  (##structure
                                                   std/srfi/41#stream-type
                                                   __tmp7759)))
                                               (__tmp7756
                                                (let ((__tmp7757
                                                       (cons 'lazy
                                                             (lambda ()
                                                               _rev3354_))))
                                                  (declare (not safe))
                                                  (##structure
                                                   std/srfi/41#stream-type
                                                   __tmp7757))))
                                           (declare (not safe))
                                           (##structure
                                            std/srfi/41#stream-pare-type
                                            __tmp7758
                                            __tmp7756))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7755)))))
        (if (not (let ()
                   (declare (not safe))
                   (##structure-instance-of?
                    _strm3349_
                    'std/srfi/41#stream-type)))
            (error 'stream-reverse '"non-stream argument")
            (_stream-reverse3351_ _strm3349_ std/srfi/41#stream-null)))))
  (define std/srfi/41#stream-scan
    (lambda (_proc3334_ _base3335_ _strm3336_)
      (letrec ((_stream-scan3338_
                (lambda (_base3340_ _strm3341_)
                  (let ((__tmp7760
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#stream-null? _strm3341_)
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7763
                                               (let ((__tmp7764
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               _base3340_)))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7764)))
                                              (__tmp7761
                                               (let ((__tmp7762
                                                      (cons 'lazy
                                                            (lambda ()
                                                              std/srfi/41#stream-null))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7762))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7763
                                           __tmp7761)))
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7767
                                               (let ((__tmp7768
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               _base3340_)))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7768)))
                                              (__tmp7765
                                               (let ((__tmp7766
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-scan3338_
                                                               (_proc3334_
                                                                _base3340_
                                                                (std/srfi/41#stream-car
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _strm3341_))
                       (std/srfi/41#stream-cdr _strm3341_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7766))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7767
                                           __tmp7765)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7760)))))
        (if (not (procedure? _proc3334_))
            (error 'stream-scan '"non-procedural argument")
            (if (not (let ()
                       (declare (not safe))
                       (##structure-instance-of?
                        _strm3336_
                        'std/srfi/41#stream-type)))
                (error 'stream-scan '"non-stream argument")
                (_stream-scan3338_ _base3335_ _strm3336_))))))
  (define std/srfi/41#stream-take
    (lambda (_n3319_ _strm3320_)
      (letrec ((_stream-take3322_
                (lambda (_n3324_ _strm3325_)
                  (let ((__tmp7769
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (or (std/srfi/41#stream-null?
                                            _strm3325_)
                                           (zero? _n3324_))
                                       std/srfi/41#stream-null
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7772
                                               (let ((__tmp7773
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               (std/srfi/41#stream-car
                                                                _strm3325_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7773)))
                                              (__tmp7770
                                               (let ((__tmp7771
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-take3322_
                                                               (- _n3324_ '1)
                                                               (std/srfi/41#stream-cdr
                                                                _strm3325_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7771))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7772
                                           __tmp7770)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7769)))))
        (if (not (let ()
                   (declare (not safe))
                   (##structure-instance-of?
                    _strm3320_
                    'std/srfi/41#stream-type)))
            (error 'stream-take '"non-stream argument")
            (if (not (integer? _n3319_))
                (error 'stream-take '"non-integer argument")
                (if (negative? _n3319_)
                    (error 'stream-take '"negative argument")
                    (_stream-take3322_ _n3319_ _strm3320_)))))))
  (define std/srfi/41#stream-take-while
    (lambda (_pred?3308_ _strm3309_)
      (letrec ((_stream-take-while3311_
                (lambda (_strm3313_)
                  (let ((__tmp7774
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#stream-null? _strm3313_)
                                       std/srfi/41#stream-null
                                       (if (_pred?3308_
                                            (std/srfi/41#stream-car
                                             _strm3313_))
                                           (std/srfi/41#stream-eager
                                            (let ((__tmp7777
                                                   (let ((__tmp7778
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (std/srfi/41#stream-eager
                           (std/srfi/41#stream-car _strm3313_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7778)))
                                                  (__tmp7775
                                                   (let ((__tmp7776
                                                          (cons 'lazy
                                                                (lambda ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (_stream-take-while3311_
                           (std/srfi/41#stream-cdr _strm3313_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (declare (not safe))
                                                     (##structure
                                                      std/srfi/41#stream-type
                                                      __tmp7776))))
                                              (declare (not safe))
                                              (##structure
                                               std/srfi/41#stream-pare-type
                                               __tmp7777
                                               __tmp7775)))
                                           std/srfi/41#stream-null)))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7774)))))
        (if (not (let ()
                   (declare (not safe))
                   (##structure-instance-of?
                    _strm3309_
                    'std/srfi/41#stream-type)))
            (error 'stream-take-while '"non-stream argument")
            (if (not (procedure? _pred?3308_))
                (error 'stream-take-while '"non-procedural argument")
                (_stream-take-while3311_ _strm3309_))))))
  (define std/srfi/41#stream-unfold
    (lambda (_mapper3295_ _pred?3296_ _generator3297_ _base3298_)
      (letrec ((_stream-unfold3300_
                (lambda (_base3302_)
                  (let ((__tmp7779
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (_pred?3296_ _base3302_)
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7782
                                               (let ((__tmp7783
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               (_mapper3295_
                                                                _base3302_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7783)))
                                              (__tmp7780
                                               (let ((__tmp7781
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-unfold3300_
                                                               (_generator3297_
                                                                _base3302_))))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7781))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7782
                                           __tmp7780)))
                                       std/srfi/41#stream-null))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7779)))))
        (if (not (procedure? _mapper3295_))
            (error 'stream-unfold '"non-procedural mapper")
            (if (not (procedure? _pred?3296_))
                (error 'stream-unfold '"non-procedural pred?")
                (if (not (procedure? _generator3297_))
                    (error 'stream-unfold '"non-procedural generator")
                    (_stream-unfold3300_ _base3298_)))))))
  (define std/srfi/41#stream-unfolds
    (lambda (_gen3254_ _seed3255_)
      (letrec ((_len-values3257_
                (lambda (_gen3289_ _seed3290_)
                  (call-with-values
                   (lambda () (_gen3289_ _seed3290_))
                   (lambda _vs3293_ (- (length _vs3293_) '1)))))
               (_unfold-result-stream3258_
                (lambda (_gen3278_ _seed3279_)
                  (let ((__tmp7784
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (call-with-values
                                    (lambda () (_gen3278_ _seed3279_))
                                    (lambda (_next3284_ . _results3285_)
                                      (std/srfi/41#stream-eager
                                       (let ((__tmp7787
                                              (let ((__tmp7788
                                                     (cons 'lazy
                                                           (lambda ()
                                                             (std/srfi/41#stream-eager
                                                              _results3285_)))))
                                                (declare (not safe))
                                                (##structure
                                                 std/srfi/41#stream-type
                                                 __tmp7788)))
                                             (__tmp7785
                                              (let ((__tmp7786
                                                     (cons 'lazy
                                                           (lambda ()
                                                             (_unfold-result-stream3258_
                                                              _gen3278_
                                                              _next3284_)))))
                                                (declare (not safe))
                                                (##structure
                                                 std/srfi/41#stream-type
                                                 __tmp7786))))
                                         (declare (not safe))
                                         (##structure
                                          std/srfi/41#stream-pare-type
                                          __tmp7787
                                          __tmp7785))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7784))))
               (_result-stream->output-stream3259_
                (lambda (_result-stream3269_ _i3270_)
                  (let ((__tmp7789
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (let ((_result3274_
                                          (list-ref
                                           (std/srfi/41#stream-car
                                            _result-stream3269_)
                                           (- _i3270_ '1))))
                                     (if (pair? _result3274_)
                                         (std/srfi/41#stream-eager
                                          (let ((__tmp7792
                                                 (let ((__tmp7793
                                                        (cons 'lazy
                                                              (lambda ()
                                                                (std/srfi/41#stream-eager
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (car _result3274_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (declare (not safe))
                                                   (##structure
                                                    std/srfi/41#stream-type
                                                    __tmp7793)))
                                                (__tmp7790
                                                 (let ((__tmp7791
                                                        (cons 'lazy
                                                              (lambda ()
                                                                (_result-stream->output-stream3259_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (std/srfi/41#stream-cdr _result-stream3269_)
                         _i3270_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (declare (not safe))
                                                   (##structure
                                                    std/srfi/41#stream-type
                                                    __tmp7791))))
                                            (declare (not safe))
                                            (##structure
                                             std/srfi/41#stream-pare-type
                                             __tmp7792
                                             __tmp7790)))
                                         (if (not _result3274_)
                                             (_result-stream->output-stream3259_
                                              (std/srfi/41#stream-cdr
                                               _result-stream3269_)
                                              _i3270_)
                                             (if (null? _result3274_)
                                                 std/srfi/41#stream-null
                                                 (error 'stream-unfolds
                                                        '"can't happen"))))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7789))))
               (_result-stream->output-streams3260_
                (lambda (_result-stream3262_)
                  (let _loop3264_ ((_i3266_ (_len-values3257_
                                             _gen3254_
                                             _seed3255_))
                                   (_outputs3267_ '()))
                    (if (zero? _i3266_)
                        (apply values _outputs3267_)
                        (_loop3264_
                         (- _i3266_ '1)
                         (cons (_result-stream->output-stream3259_
                                _result-stream3262_
                                _i3266_)
                               _outputs3267_)))))))
        (if (not (procedure? _gen3254_))
            (error 'stream-unfolds '"non-procedural argument")
            (_result-stream->output-streams3260_
             (_unfold-result-stream3258_ _gen3254_ _seed3255_))))))
  (define std/srfi/41#stream-zip
    (lambda _strms3242_
      (letrec ((_stream-zip3244_
                (lambda (_strms3248_)
                  (let ((__tmp7794
                         (cons 'lazy
                               (lambda ()
                                 (let ()
                                   (if (std/srfi/41#exists
                                        std/srfi/41#stream-null?
                                        _strms3248_)
                                       std/srfi/41#stream-null
                                       (std/srfi/41#stream-eager
                                        (let ((__tmp7797
                                               (let ((__tmp7798
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (std/srfi/41#stream-eager
                                                               (map std/srfi/41#stream-car
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _strms3248_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7798)))
                                              (__tmp7795
                                               (let ((__tmp7796
                                                      (cons 'lazy
                                                            (lambda ()
                                                              (_stream-zip3244_
                                                               (map std/srfi/41#stream-cdr
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _strms3248_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (declare (not safe))
                                                 (##structure
                                                  std/srfi/41#stream-type
                                                  __tmp7796))))
                                          (declare (not safe))
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           __tmp7797
                                           __tmp7795)))))))))
                    (declare (not safe))
                    (##structure std/srfi/41#stream-type __tmp7794)))))
        (if (null? _strms3242_)
            (error 'stream-zip '"no stream arguments")
            (if (std/srfi/41#exists
                 (lambda (_x3246_)
                   (not (let ()
                          (declare (not safe))
                          (##structure-instance-of?
                           _x3246_
                           'std/srfi/41#stream-type))))
                 _strms3242_)
                (error 'stream-zip '"non-stream argument")
                (_stream-zip3244_ _strms3242_)))))))
