(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/request#request::t
    (make-struct-type
     'std/net#request::t
     '#f
     '8
     'request
     '()
     ':init!
     '(port url history status status-text headers body encoding)))
  (define std/net/request#request?
    (make-struct-predicate std/net/request#request::t))
  (define std/net/request#make-request
    (lambda _$args1612_
      (apply make-struct-instance std/net/request#request::t _$args1612_)))
  (define std/net/request#request-port
    (make-struct-field-accessor std/net/request#request::t '0))
  (define std/net/request#request-url
    (make-struct-field-accessor std/net/request#request::t '1))
  (define std/net/request#request-history
    (make-struct-field-accessor std/net/request#request::t '2))
  (define std/net/request#request-status
    (make-struct-field-accessor std/net/request#request::t '3))
  (define std/net/request#request-status-text
    (make-struct-field-accessor std/net/request#request::t '4))
  (define std/net/request#request-headers
    (make-struct-field-accessor std/net/request#request::t '5))
  (define std/net/request#request-body
    (make-struct-field-accessor std/net/request#request::t '6))
  (define std/net/request#request-encoding
    (make-struct-field-accessor std/net/request#request::t '7))
  (define std/net/request#request-port-set!
    (make-struct-field-mutator std/net/request#request::t '0))
  (define std/net/request#request-url-set!
    (make-struct-field-mutator std/net/request#request::t '1))
  (define std/net/request#request-history-set!
    (make-struct-field-mutator std/net/request#request::t '2))
  (define std/net/request#request-status-set!
    (make-struct-field-mutator std/net/request#request::t '3))
  (define std/net/request#request-status-text-set!
    (make-struct-field-mutator std/net/request#request::t '4))
  (define std/net/request#request-headers-set!
    (make-struct-field-mutator std/net/request#request::t '5))
  (define std/net/request#request-body-set!
    (make-struct-field-mutator std/net/request#request::t '6))
  (define std/net/request#request-encoding-set!
    (make-struct-field-mutator std/net/request#request::t '7))
  (define std/net/request#request:::init!
    (lambda (_self1607_ _port1608_ _url1609_ _history1610_)
      (if (let ((__tmp5270
                 (let () (declare (not safe)) (##vector-length _self1607_))))
            (declare (not safe))
            (##fx< '3 __tmp5270))
          (begin
            (let ()
              (declare (not safe))
              (##vector-set! _self1607_ '1 _port1608_))
            (let ()
              (declare (not safe))
              (##vector-set! _self1607_ '2 _url1609_))
            (let ()
              (declare (not safe))
              (##vector-set! _self1607_ '3 _history1610_)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self1607_))))
  (bind-method!
   std/net/request#request::t
   ':init!
   std/net/request#request:::init!
   '#f)
  (define std/net/request#url-target-e
    (lambda (_url1482_ _params1483_)
      (if _params1483_
          (string-append
           _url1482_
           '"?"
           (std/net/uri#form-url-encode__% _params1483_ '#f))
          _url1482_)))
  (define std/net/request#header-string-e
    (lambda (_str1480_)
      (if (string? _str1480_)
          _str1480_
          (if (symbol? _str1480_)
              (symbol->string _str1480_)
              (if (keyword? _str1480_)
                  (keyword->string _str1480_)
                  (error '"bad header key" _str1480_))))))
  (define std/net/request#make-http/1.1-headers
    (lambda (_headers1473_ _cookies1474_ _auth1475_)
      (std/net/request#http-headers-cons!
       _headers1473_
       (std/net/request#http-headers-cons
        (std/net/request#http-headers-cons
         std/net/request#http/1.1-base-headers
         (std/net/request#http-headers-cookies
          (let ((_$e1477_ _cookies1474_)) (if _$e1477_ _$e1477_ '()))))
        (std/net/request#http-headers-auth _auth1475_)))))
  (define std/net/request#http/1.1-base-headers
    '(("User-Agent" . "Mozilla/5.0 (compatible; gerbil/1.0)")
      ("Connection" . "close")
      ("Accept" . "*/*")
      ("Accept-Encoding" . "gzip, deflate, identity")))
  (define std/net/request#http-headers-auth
    (lambda (_auth1401_)
      (letrec ((_basic-auth-header1403_
                (lambda (_user1467_ _password1468_)
                  (let ((_credentials1471_
                         (std/text/base64#u8vector->base64-string
                          (with-output-to-u8vector
                           (lambda ()
                             (display _user1467_)
                             (display '":")
                             (display _password1468_))))))
                    (cons '"Authorization"
                          (string-append '"Basic " _credentials1471_))))))
        (let* ((_auth14041419_ _auth1401_)
               (_E14081423_
                (lambda () (error '"No clause matching" _auth14041419_))))
          (let ((_K14111445_
                 (lambda (_password1442_ _user1443_)
                   (cons (_basic-auth-header1403_ _user1443_ _password1442_)
                         '())))
                (_K14101436_ (lambda () '()))
                (_K14091428_
                 (lambda () (error '"unknown auth value" _auth1401_))))
            (let ((_try-match14061439_
                   (lambda ()
                     (if (let ()
                           (declare (not safe))
                           (##eq? _auth14041419_ '#f))
                         (_K14101436_)
                         (_K14091428_)))))
              (if (let () (declare (not safe)) (##pair? _auth14041419_))
                  (let ((_tl14131450_
                         (let () (declare (not safe)) (##cdr _auth14041419_)))
                        (_hd14121448_
                         (let () (declare (not safe)) (##car _auth14041419_))))
                    (if (let ()
                          (declare (not safe))
                          (##eq? _hd14121448_ 'basic:))
                        (if (let ()
                              (declare (not safe))
                              (##pair? _tl14131450_))
                            (let ((_tl14151455_
                                   (let ()
                                     (declare (not safe))
                                     (##cdr _tl14131450_)))
                                  (_hd14141453_
                                   (let ()
                                     (declare (not safe))
                                     (##car _tl14131450_))))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _tl14151455_))
                                  (let ((_tl14171462_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _tl14151455_)))
                                        (_hd14161460_
                                         (let ()
                                           (declare (not safe))
                                           (##car _tl14151455_))))
                                    (if (let ()
                                          (declare (not safe))
                                          (##null? _tl14171462_))
                                        (let ((_user1458_ _hd14141453_)
                                              (_password1465_ _hd14161460_))
                                          (_K14111445_
                                           _password1465_
                                           _user1458_))
                                        (_try-match14061439_)))
                                  (_try-match14061439_)))
                            (_try-match14061439_))
                        (_try-match14061439_)))
                  (_try-match14061439_))))))))
  (define std/net/request#http-headers-cookies
    (lambda (_cookies1366_)
      (letrec ((_fold-e1368_
                (lambda (_cookie1370_ _str1371_)
                  (let* ((_cookie13721379_ _cookie1370_)
                         (_E13741383_
                          (lambda ()
                            (error '"No clause matching" _cookie13721379_)))
                         (_K13751389_
                          (lambda (_value1386_ _key1387_)
                            (if (string-empty? _str1371_)
                                (std/format#format
                                 '"~a=~a"
                                 _key1387_
                                 _value1386_)
                                (std/format#format
                                 '"~a; ~a=~a"
                                 _str1371_
                                 _key1387_
                                 _value1386_)))))
                    (if (let ()
                          (declare (not safe))
                          (##pair? _cookie13721379_))
                        (let ((_hd13761392_
                               (let ()
                                 (declare (not safe))
                                 (##car _cookie13721379_)))
                              (_tl13771394_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _cookie13721379_))))
                          (let* ((_key1397_ _hd13761392_)
                                 (_value1399_ _tl13771394_))
                            (_K13751389_ _value1399_ _key1397_)))
                        (_E13741383_))))))
        (if (null? _cookies1366_)
            '()
            (cons (cons '"Cookie" (foldr1 _fold-e1368_ _cookies1366_ '""))
                  '())))))
  (define std/net/request#http-headers-cons
    (lambda (_new-headers1326_ _headers1327_)
      (letrec ((_fold-e1329_
                (lambda (_header1331_ _headers1332_)
                  (let* ((_header13331340_ _header1331_)
                         (_E13351344_
                          (lambda ()
                            (error '"No clause matching" _header13331340_)))
                         (_K13361354_
                          (lambda (_value1347_ _key1348_)
                            (let ((_key1350_
                                   (std/srfi/13#string-titlecase__0
                                    (std/net/request#header-string-e
                                     _key1348_))))
                              (if (assoc _key1350_ _headers1332_)
                                  _headers1332_
                                  (let ((_value1352_
                                         (std/format#format
                                          '"~a"
                                          _value1347_)))
                                    (cons (cons _key1350_ _value1352_)
                                          _headers1332_)))))))
                    (if (let ()
                          (declare (not safe))
                          (##pair? _header13331340_))
                        (let ((_hd13371357_
                               (let ()
                                 (declare (not safe))
                                 (##car _header13331340_)))
                              (_tl13381359_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _header13331340_))))
                          (let* ((_key1362_ _hd13371357_)
                                 (_value1364_ _tl13381359_))
                            (_K13361354_ _value1364_ _key1362_)))
                        (_E13351344_))))))
        (foldr1 _fold-e1329_ _headers1327_ _new-headers1326_))))
  (define std/net/request#http-headers-cons!
    (lambda (_new-headers1282_ _headers1283_)
      (letrec ((_fold-e1285_
                (lambda (_header1287_ _headers1288_)
                  (let* ((_header12891296_ _header1287_)
                         (_E12911300_
                          (lambda ()
                            (error '"No clause matching" _header12891296_)))
                         (_K12921314_
                          (lambda (_value1303_ _key1304_)
                            (let ((_key1306_
                                   (std/srfi/13#string-titlecase__0
                                    (std/net/request#header-string-e
                                     _key1304_)))
                                  (_value1307_
                                   (std/format#format '"~a" _value1303_)))
                              (let ((_$e1309_ (assoc _key1306_ _headers1288_)))
                                (if _$e1309_
                                    ((lambda (_pair1312_)
                                       (set-cdr! _pair1312_ _value1307_)
                                       _headers1288_)
                                     _$e1309_)
                                    (cons (cons _key1306_ _value1307_)
                                          _headers1288_)))))))
                    (if (let ()
                          (declare (not safe))
                          (##pair? _header12891296_))
                        (let ((_hd12931317_
                               (let ()
                                 (declare (not safe))
                                 (##car _header12891296_)))
                              (_tl12941319_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _header12891296_))))
                          (let* ((_key1322_ _hd12931317_)
                                 (_value1324_ _tl12941319_))
                            (_K12921314_ _value1324_ _key1322_)))
                        (_E12911300_))))))
        (foldr1 _fold-e1285_ _headers1283_ _new-headers1282_))))
  (define std/net/request#http-get__%
    (lambda (_g5271_
             _redirect12361243_
             _headers12371245_
             _cookies12381247_
             _params12391249_
             _auth12401251_
             _url1253_)
      (let* ((_redirect1255_
              (if (eq? _redirect12361243_ absent-value)
                  '#t
                  _redirect12361243_))
             (_headers1257_
              (if (eq? _headers12371245_ absent-value) '#f _headers12371245_))
             (_cookies1259_
              (if (eq? _cookies12381247_ absent-value) '#f _cookies12381247_))
             (_params1261_
              (if (eq? _params12391249_ absent-value) '#f _params12391249_))
             (_auth1263_
              (if (eq? _auth12401251_ absent-value) '#f _auth12401251_)))
        (let ((_url1265_ (std/net/request#url-target-e _url1253_ _params1261_))
              (_headers1266_
               (std/net/request#make-http/1.1-headers
                _headers1257_
                _cookies1259_
                _auth1263_)))
          (std/net/request#http-request
           'GET
           _url1265_
           _headers1266_
           '#f
           '()
           _redirect1255_)))))
  (define std/net/request#http-get__@
    (lambda (_keys12351271_ . _args1273_)
      (apply std/net/request#http-get__%
             _keys12351271_
             (table-ref _keys12351271_ 'redirect: absent-value)
             (table-ref _keys12351271_ 'headers: absent-value)
             (table-ref _keys12351271_ 'cookies: absent-value)
             (table-ref _keys12351271_ 'params: absent-value)
             (table-ref _keys12351271_ 'auth: absent-value)
             _args1273_)))
  (define std/net/request#http-get
    (lambda _args12411279_
      (apply keyword-dispatch
             '#(cookies:
                auth:
                #f
                headers:
                #f
                #f
                redirect:
                #f
                #f
                #f
                #f
                #f
                #f
                params:
                #f)
             std/net/request#http-get__@
             _args12411279_)))
  (define std/net/request#http-head__%
    (lambda (_g5272_
             _redirect11881195_
             _headers11891197_
             _cookies11901199_
             _params11911201_
             _auth11921203_
             _url1205_)
      (let* ((_redirect1207_
              (if (eq? _redirect11881195_ absent-value)
                  '#t
                  _redirect11881195_))
             (_headers1209_
              (if (eq? _headers11891197_ absent-value) '#f _headers11891197_))
             (_cookies1211_
              (if (eq? _cookies11901199_ absent-value) '#f _cookies11901199_))
             (_params1213_
              (if (eq? _params11911201_ absent-value) '#f _params11911201_))
             (_auth1215_
              (if (eq? _auth11921203_ absent-value) '#f _auth11921203_)))
        (let ((_url1217_ (std/net/request#url-target-e _url1205_ _params1213_))
              (_headers1218_
               (std/net/request#make-http/1.1-headers
                _headers1209_
                _cookies1211_
                _auth1215_)))
          (std/net/request#http-request
           'HEAD
           _url1217_
           _headers1218_
           '#f
           '()
           _redirect1207_)))))
  (define std/net/request#http-head__@
    (lambda (_keys11871223_ . _args1225_)
      (apply std/net/request#http-head__%
             _keys11871223_
             (table-ref _keys11871223_ 'redirect: absent-value)
             (table-ref _keys11871223_ 'headers: absent-value)
             (table-ref _keys11871223_ 'cookies: absent-value)
             (table-ref _keys11871223_ 'params: absent-value)
             (table-ref _keys11871223_ 'auth: absent-value)
             _args1225_)))
  (define std/net/request#http-head
    (lambda _args11931231_
      (apply keyword-dispatch
             '#(cookies:
                auth:
                #f
                headers:
                #f
                #f
                redirect:
                #f
                #f
                #f
                #f
                #f
                #f
                params:
                #f)
             std/net/request#http-head__@
             _args11931231_)))
  (define std/net/request#http-post__%
    (lambda (_g5273_
             _redirect11331141_
             _headers11341143_
             _cookies11351145_
             _params11361147_
             _data11371149_
             _auth11381151_
             _url1153_)
      (let* ((_redirect1155_
              (if (eq? _redirect11331141_ absent-value)
                  '#t
                  _redirect11331141_))
             (_headers1157_
              (if (eq? _headers11341143_ absent-value) '#f _headers11341143_))
             (_cookies1159_
              (if (eq? _cookies11351145_ absent-value) '#f _cookies11351145_))
             (_params1161_
              (if (eq? _params11361147_ absent-value) '#f _params11361147_))
             (_data1163_
              (if (eq? _data11371149_ absent-value) '#f _data11371149_))
             (_auth1165_
              (if (eq? _auth11381151_ absent-value) '#f _auth11381151_))
             (_g5274_ (if _params1161_
                          (let ((_form-data1167_
                                 (std/net/uri#form-url-encode__%
                                  _params1161_
                                  '#t)))
                            (values (std/net/request#http-headers-cons
                                     '(("Content-Type"
                                        .
                                        "application/x-www-form-urlencoded"))
                                     (std/net/request#make-http/1.1-headers
                                      _headers1157_
                                      _cookies1159_
                                      _auth1165_))
                                    _form-data1167_))
                          (values (std/net/request#make-http/1.1-headers
                                   _headers1157_
                                   _cookies1159_
                                   _auth1165_)
                                  _data1163_))))
        (begin
          #!void
          (let ((_headers1169_
                 (let () (declare (not safe)) (##vector-ref _g5274_ 0)))
                (_data1170_
                 (let () (declare (not safe)) (##vector-ref _g5274_ 1))))
            (std/net/request#http-request
             'POST
             _url1153_
             _headers1169_
             _data1170_
             '()
             _redirect1155_))))))
  (define std/net/request#http-post__@
    (lambda (_keys11321175_ . _args1177_)
      (apply std/net/request#http-post__%
             _keys11321175_
             (table-ref _keys11321175_ 'redirect: absent-value)
             (table-ref _keys11321175_ 'headers: absent-value)
             (table-ref _keys11321175_ 'cookies: absent-value)
             (table-ref _keys11321175_ 'params: absent-value)
             (table-ref _keys11321175_ 'data: absent-value)
             (table-ref _keys11321175_ 'auth: absent-value)
             _args1177_)))
  (define std/net/request#http-post
    (lambda _args11391183_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                data:
                #f
                #f
                #f
                headers:
                #f
                params:
                #f
                redirect:
                #f
                #f
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                auth:
                #f
                #f
                #f
                #f)
             std/net/request#http-post__@
             _args11391183_)))
  (define std/net/request#http-put__%
    (lambda (_g5275_
             _redirect10801088_
             _headers10811090_
             _cookies10821092_
             _params10831094_
             _data10841096_
             _auth10851098_
             _url1100_)
      (let* ((_redirect1102_
              (if (eq? _redirect10801088_ absent-value)
                  '#t
                  _redirect10801088_))
             (_headers1104_
              (if (eq? _headers10811090_ absent-value) '#f _headers10811090_))
             (_cookies1106_
              (if (eq? _cookies10821092_ absent-value) '#f _cookies10821092_))
             (_params1108_
              (if (eq? _params10831094_ absent-value) '#f _params10831094_))
             (_data1110_
              (if (eq? _data10841096_ absent-value) '#f _data10841096_))
             (_auth1112_
              (if (eq? _auth10851098_ absent-value) '#f _auth10851098_)))
        (let ((_url1114_ (std/net/request#url-target-e _url1100_ _params1108_))
              (_headers1115_
               (std/net/request#make-http/1.1-headers
                _headers1104_
                _cookies1106_
                _auth1112_)))
          (std/net/request#http-request
           'PUT
           _url1114_
           _headers1115_
           _data1110_
           '()
           _redirect1102_)))))
  (define std/net/request#http-put__@
    (lambda (_keys10791120_ . _args1122_)
      (apply std/net/request#http-put__%
             _keys10791120_
             (table-ref _keys10791120_ 'redirect: absent-value)
             (table-ref _keys10791120_ 'headers: absent-value)
             (table-ref _keys10791120_ 'cookies: absent-value)
             (table-ref _keys10791120_ 'params: absent-value)
             (table-ref _keys10791120_ 'data: absent-value)
             (table-ref _keys10791120_ 'auth: absent-value)
             _args1122_)))
  (define std/net/request#http-put
    (lambda _args10861128_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                data:
                #f
                #f
                #f
                headers:
                #f
                params:
                #f
                redirect:
                #f
                #f
                cookies:
                #f
                #f
                #f
                #f
                #f
                #f
                auth:
                #f
                #f
                #f
                #f)
             std/net/request#http-put__@
             _args10861128_)))
  (define std/net/request#http-delete__%
    (lambda (_g5276_
             _redirect10321039_
             _headers10331041_
             _cookies10341043_
             _params10351045_
             _auth10361047_
             _url1049_)
      (let* ((_redirect1051_
              (if (eq? _redirect10321039_ absent-value)
                  '#t
                  _redirect10321039_))
             (_headers1053_
              (if (eq? _headers10331041_ absent-value) '#f _headers10331041_))
             (_cookies1055_
              (if (eq? _cookies10341043_ absent-value) '#f _cookies10341043_))
             (_params1057_
              (if (eq? _params10351045_ absent-value) '#f _params10351045_))
             (_auth1059_
              (if (eq? _auth10361047_ absent-value) '#f _auth10361047_)))
        (let ((_url1061_ (std/net/request#url-target-e _url1049_ _params1057_))
              (_headers1062_
               (std/net/request#make-http/1.1-headers
                _headers1053_
                _cookies1055_
                _auth1059_)))
          (std/net/request#http-request
           'DELETE
           _url1061_
           _headers1062_
           '#f
           '()
           _redirect1051_)))))
  (define std/net/request#http-delete__@
    (lambda (_keys10311067_ . _args1069_)
      (apply std/net/request#http-delete__%
             _keys10311067_
             (table-ref _keys10311067_ 'redirect: absent-value)
             (table-ref _keys10311067_ 'headers: absent-value)
             (table-ref _keys10311067_ 'cookies: absent-value)
             (table-ref _keys10311067_ 'params: absent-value)
             (table-ref _keys10311067_ 'auth: absent-value)
             _args1069_)))
  (define std/net/request#http-delete
    (lambda _args10371075_
      (apply keyword-dispatch
             '#(cookies:
                auth:
                #f
                headers:
                #f
                #f
                redirect:
                #f
                #f
                #f
                #f
                #f
                #f
                params:
                #f)
             std/net/request#http-delete__@
             _args10371075_)))
  (define std/net/request#http-options__%
    (lambda (_g5277_
             _headers989995_
             _cookies990997_
             _params991999_
             _auth9921001_
             _url1003_)
      (let* ((_headers1005_
              (if (eq? _headers989995_ absent-value) '#f _headers989995_))
             (_cookies1007_
              (if (eq? _cookies990997_ absent-value) '#f _cookies990997_))
             (_params1009_
              (if (eq? _params991999_ absent-value) '#f _params991999_))
             (_auth1011_
              (if (eq? _auth9921001_ absent-value) '#f _auth9921001_)))
        (let ((_url1013_ (std/net/request#url-target-e _url1003_ _params1009_))
              (_headers1014_
               (std/net/request#make-http/1.1-headers
                _headers1005_
                _cookies1007_
                _auth1011_)))
          (std/net/request#http-request
           'HEAD
           _url1013_
           _headers1014_
           '#f
           '()
           '#f)))))
  (define std/net/request#http-options__@
    (lambda (_keys9881019_ . _args1021_)
      (apply std/net/request#http-options__%
             _keys9881019_
             (table-ref _keys9881019_ 'headers: absent-value)
             (table-ref _keys9881019_ 'cookies: absent-value)
             (table-ref _keys9881019_ 'params: absent-value)
             (table-ref _keys9881019_ 'auth: absent-value)
             _args1021_)))
  (define std/net/request#http-options
    (lambda _args9931027_
      (apply keyword-dispatch
             '#(#f #f #f headers: params: #f cookies: auth: #f)
             std/net/request#http-options__@
             _args9931027_)))
  (define std/net/request#url-rx
    (std/pregexp#pregexp '"(?:(https?)://)?([^/:]+)(:[0-9]+)?(/.*)?"))
  (define std/net/request#+tls-context+
    (make-promise (lambda () (make-tls-context))))
  (define std/net/request#http-request
    (lambda (_method854_
             _url855_
             _user-headers856_
             _body857_
             _history858_
             _redirect859_)
      (let* ((_g860875_
              (std/pregexp#pregexp-match std/net/request#url-rx _url855_))
             (_E862879_ (lambda () (error '"No clause matching" _g860875_)))
             (_K863952_
              (lambda (_target882_ _port883_ _host884_ _scheme885_)
                (let* ((_scheme890_
                        (let ((_$e887_ _scheme885_))
                          (if _$e887_ _$e887_ '"http")))
                       (_port892_
                        (if _port883_
                            (string->number
                             (substring
                              _port883_
                              '1
                              (string-length _port883_)))
                            (if (equal? _scheme890_ '"https") '443 '80)))
                       (_target897_
                        (let ((_$e894_ _target882_))
                          (if _$e894_ _$e894_ '"/")))
                       (_host-header905_
                        (let ((_$e899_ _port892_))
                          (if (or (eq? '80 _$e899_) (eq? '443 _$e899_))
                              _host884_
                              (std/format#format
                               '"~a:~a"
                               _host884_
                               _port892_))))
                       (_headers907_
                        (std/net/request#http-headers-cons
                         (cons (cons '"Host" _host-header905_) '())
                         _user-headers856_))
                       (_body909_
                        (if (not _body857_)
                            '#f
                            (if (u8vector? _body857_)
                                _body857_
                                (if (string? _body857_)
                                    (std/text/utf8#string->utf8__0 _body857_)
                                    (error '"bad request body" _body857_)))))
                       (_headers911_
                        (if _body909_
                            (std/net/request#http-headers-cons!
                             (cons (cons '"Content-Length"
                                         (u8vector-length _body909_))
                                   '())
                             _headers907_)
                            _headers907_))
                       (_tcp-client-options913_
                        (cons 'server-address:
                              (cons _host884_
                                    (cons 'port-number:
                                          (cons _port892_
                                                (cons 'eol-encoding:
                                                      (cons 'cr-lf '())))))))
                       (_tcp-client-options915_
                        (if (equal? _scheme890_ '"https")
                            (cons 'tls-context:
                                  (cons (force std/net/request#+tls-context+)
                                        _tcp-client-options913_))
                            _tcp-client-options913_))
                       (_sock917_ (open-tcp-client _tcp-client-options915_))
                       (_req919_
                        (let ((__obj5269
                               (make-object std/net/request#request::t '8)))
                          (if (let ((__tmp5278
                                     (let ()
                                       (declare (not safe))
                                       (##vector-length __obj5269))))
                                (declare (not safe))
                                (##fx< '3 __tmp5278))
                              (begin
                                (let ()
                                  (declare (not safe))
                                  (##vector-set! __obj5269 '1 _sock917_))
                                (let ()
                                  (declare (not safe))
                                  (##vector-set! __obj5269 '2 _url855_))
                                (let ()
                                  (declare (not safe))
                                  (##vector-set! __obj5269 '3 _history858_)))
                              (error '"struct-instance-init!: too many arguments for struct"
                                     __obj5269))
                          __obj5269)))
                  (std/net/request#http-request-write
                   _sock917_
                   _method854_
                   _target897_
                   _headers911_
                   _body909_)
                  (std/net/request#http-request-read-response! _req919_)
                  (let ((_$e922_ (if _redirect859_
                                     (if (memv (##structure-ref
                                                _req919_
                                                '4
                                                std/net/request#request::t
                                                '#f)
                                               '(301 302 303 307))
                                         (if (memq _method854_ '(GET HEAD))
                                             (assoc '"Location"
                                                    (##structure-ref
                                                     _req919_
                                                     '6
                                                     std/net/request#request::t
                                                     '#f))
                                             '#f)
                                         '#f)
                                     '#f)))
                    (if _$e922_
                        ((lambda (_e924926_)
                           (let* ((_g928935_ _e924926_)
                                  (_E930939_
                                   (lambda ()
                                     (error '"No clause matching" _g928935_)))
                                  (_K931944_
                                   (lambda (_new-url942_)
                                     (if (member _new-url942_ _history858_)
                                         (error '"URL redirection loop"
                                                _url855_)
                                         (begin
                                           (std/net/request#request-close
                                            _req919_)
                                           (std/net/request#http-request
                                            _method854_
                                            _new-url942_
                                            _user-headers856_
                                            _body909_
                                            (cons _url855_ _history858_)
                                            '#t))))))
                             (if (let ()
                                   (declare (not safe))
                                   (##pair? _g928935_))
                                 (let* ((_tl933947_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _g928935_)))
                                        (_new-url950_ _tl933947_))
                                   (_K931944_ _new-url950_))
                                 (_E930939_))))
                         _$e922_)
                        _req919_))))))
        (if (let () (declare (not safe)) (##pair? _g860875_))
            (let ((_tl865955_ (let () (declare (not safe)) (##cdr _g860875_))))
              (if (let () (declare (not safe)) (##pair? _tl865955_))
                  (let ((_hd866958_
                         (let () (declare (not safe)) (##car _tl865955_)))
                        (_tl867960_
                         (let () (declare (not safe)) (##cdr _tl865955_))))
                    (let ((_scheme963_ _hd866958_))
                      (if (let () (declare (not safe)) (##pair? _tl867960_))
                          (let ((_hd868965_
                                 (let ()
                                   (declare (not safe))
                                   (##car _tl867960_)))
                                (_tl869967_
                                 (let ()
                                   (declare (not safe))
                                   (##cdr _tl867960_))))
                            (let ((_host970_ _hd868965_))
                              (if (let ()
                                    (declare (not safe))
                                    (##pair? _tl869967_))
                                  (let ((_hd870972_
                                         (let ()
                                           (declare (not safe))
                                           (##car _tl869967_)))
                                        (_tl871974_
                                         (let ()
                                           (declare (not safe))
                                           (##cdr _tl869967_))))
                                    (let ((_port977_ _hd870972_))
                                      (if (let ()
                                            (declare (not safe))
                                            (##pair? _tl871974_))
                                          (let ((_hd872979_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##car _tl871974_)))
                                                (_tl873981_
                                                 (let ()
                                                   (declare (not safe))
                                                   (##cdr _tl871974_))))
                                            (let ((_target984_ _hd872979_))
                                              (if (let ()
                                                    (declare (not safe))
                                                    (##null? _tl873981_))
                                                  (_K863952_
                                                   _target984_
                                                   _port977_
                                                   _host970_
                                                   _scheme963_)
                                                  (_E862879_))))
                                          (_E862879_))))
                                  (_E862879_))))
                          (_E862879_))))
                  (_E862879_)))
            (_E862879_)))))
  (define std/net/request#http-request-write
    (lambda (_port816_ _method817_ _target818_ _headers819_ _body820_)
      (std/format#fprintf
       _port816_
       '"~a ~a HTTP/1.1~n"
       _method817_
       _target818_)
      (for-each
       (lambda (_e821823_)
         (let* ((_g825832_ _e821823_)
                (_E827836_ (lambda () (error '"No clause matching" _g825832_)))
                (_K828842_
                 (lambda (_val839_ _key840_)
                   (std/format#fprintf
                    _port816_
                    '"~a: ~a~n"
                    _key840_
                    _val839_))))
           (if (let () (declare (not safe)) (##pair? _g825832_))
               (let ((_hd829845_
                      (let () (declare (not safe)) (##car _g825832_)))
                     (_tl830847_
                      (let () (declare (not safe)) (##cdr _g825832_))))
                 (let* ((_key850_ _hd829845_) (_val852_ _tl830847_))
                   (_K828842_ _val852_ _key850_)))
               (_E827836_))))
       _headers819_)
      (newline _port816_)
      (if _body820_
          (begin
            (write-subu8vector
             _body820_
             '0
             (u8vector-length _body820_)
             _port816_)
            (newline _port816_))
          '#!void)
      (force-output _port816_)))
  (define std/net/request#status-line-rx
    (std/pregexp#pregexp '"([0-9]{3})\\s+(.*)"))
  (define std/net/request#header-line-rx
    (std/pregexp#pregexp '"([^:]+):\\s*(.*)?"))
  (define std/net/request#http-request-read-response!
    (lambda (_req713_)
      (let* ((_port715_
              (##structure-ref _req713_ '1 std/net/request#request::t '#f))
             (_status-line717_ (std/net/request#read-response-line _port715_)))
        (let* ((_g719731_
                (std/pregexp#pregexp-match
                 std/net/request#status-line-rx
                 _status-line717_))
               (_else721739_
                (lambda ()
                  (std/error#raise-io-error
                   'http-request-read-response!
                   '"malformed status line"
                   _port715_
                   _status-line717_)))
               (_K723796_
                (lambda (_status-text742_ _status743_)
                  (##structure-set!
                   _req713_
                   (string->number _status743_)
                   '4
                   std/net/request#request::t
                   '#f)
                  (##structure-set!
                   _req713_
                   (std/srfi/13#string-trim-both__0 _status-text742_)
                   '5
                   std/net/request#request::t
                   '#f)
                  (let _lp745_ ((_headers747_ '()))
                    (let ((_next749_
                           (std/net/request#read-response-line _port715_)))
                      (if (string-empty? _next749_)
                          (##structure-set!
                           _req713_
                           (reverse _headers747_)
                           '6
                           std/net/request#request::t
                           '#f)
                          (let* ((_g750762_
                                  (std/pregexp#pregexp-match
                                   std/net/request#header-line-rx
                                   _next749_))
                                 (_else752770_
                                  (lambda ()
                                    (std/error#raise-io-error
                                     'http-request-read-response!
                                     '"Malformed header"
                                     _port715_
                                     _next749_)))
                                 (_K754776_
                                  (lambda (_value773_ _key774_)
                                    (_lp745_ (cons (cons (std/srfi/13#string-titlecase__0
                                                          _key774_)
                                                         (std/srfi/13#string-trim-both__0
                                                          _value773_))
                                                   _headers747_)))))
                            (if (let ()
                                  (declare (not safe))
                                  (##pair? _g750762_))
                                (let ((_tl756779_
                                       (let ()
                                         (declare (not safe))
                                         (##cdr _g750762_))))
                                  (if (let ()
                                        (declare (not safe))
                                        (##pair? _tl756779_))
                                      (let ((_hd757782_
                                             (let ()
                                               (declare (not safe))
                                               (##car _tl756779_)))
                                            (_tl758784_
                                             (let ()
                                               (declare (not safe))
                                               (##cdr _tl756779_))))
                                        (let ((_key787_ _hd757782_))
                                          (if (let ()
                                                (declare (not safe))
                                                (##pair? _tl758784_))
                                              (let ((_hd759789_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##car _tl758784_)))
                                                    (_tl760791_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##cdr _tl758784_))))
                                                (let ((_value794_ _hd759789_))
                                                  (if (let ()
                                                        (declare (not safe))
                                                        (##null? _tl760791_))
                                                      (_K754776_
                                                       _value794_
                                                       _key787_)
                                                      (_else752770_))))
                                              (_else752770_))))
                                      (_else752770_)))
                                (_else752770_)))))))))
          (if (let () (declare (not safe)) (##pair? _g719731_))
              (let ((_tl725799_
                     (let () (declare (not safe)) (##cdr _g719731_))))
                (if (let () (declare (not safe)) (##pair? _tl725799_))
                    (let ((_hd726802_
                           (let () (declare (not safe)) (##car _tl725799_)))
                          (_tl727804_
                           (let () (declare (not safe)) (##cdr _tl725799_))))
                      (let ((_status807_ _hd726802_))
                        (if (let () (declare (not safe)) (##pair? _tl727804_))
                            (let ((_hd728809_
                                   (let ()
                                     (declare (not safe))
                                     (##car _tl727804_)))
                                  (_tl729811_
                                   (let ()
                                     (declare (not safe))
                                     (##cdr _tl727804_))))
                              (let ((_status-text814_ _hd728809_))
                                (if (let ()
                                      (declare (not safe))
                                      (##null? _tl729811_))
                                    (_K723796_ _status-text814_ _status807_)
                                    (_else721739_))))
                            (_else721739_))))
                    (_else721739_)))
              (_else721739_))))))
  (define std/net/request#http-request-read-body
    (lambda (_port698_ _headers699_)
      (letrec ((_length-e701_
                (lambda (_headers708_)
                  (let ((_$e710_ (assget '"Content-Length" _headers708_)))
                    (if _$e710_ (string->number _$e710_) '#f)))))
        (let ((_$e703_ (assget '"Transfer-Encoding" _headers699_)))
          (if _$e703_
              ((lambda (_tenc706_)
                 (if (not (equal? '"identity" _tenc706_))
                     (std/net/request#http-request-read-chunked-body _port698_)
                     (std/net/request#http-request-read-simple-body
                      _port698_
                      (_length-e701_ _headers699_))))
               _$e703_)
              (std/net/request#http-request-read-simple-body
               _port698_
               (_length-e701_ _headers699_)))))))
  (define std/net/request#http-request-read-chunked-body
    (lambda (_port682_)
      (let _lp684_ ((_chunks686_ '()))
        (let* ((_line688_ (std/net/request#read-response-line _port682_))
               (_clen690_
                (string->number (car (string-split _line688_ '#\space)) '16)))
          (if (fxzero? _clen690_)
              (append-u8vectors (reverse _chunks686_))
              (let* ((_chunk693_ (make-u8vector _clen690_))
                     (_rd695_ (read-subu8vector
                               _chunk693_
                               '0
                               _clen690_
                               _port682_)))
                (if (let () (declare (not safe)) (##fx< _rd695_ _clen690_))
                    (std/error#raise-io-error
                     'http-request-read-body
                     '"error reading chunk; premature end of port")
                    '#!void)
                (std/net/request#read-response-line _port682_)
                (_lp684_ (cons _chunk693_ _chunks686_))))))))
  (define std/net/request#http-request-read-simple-body
    (lambda (_port655_ _length656_)
      (letrec ((_read/length658_
                (lambda (_port674_ _length675_)
                  (let* ((_data677_ (make-u8vector _length675_))
                         (_rd679_ (read-subu8vector
                                   _data677_
                                   '0
                                   _length675_
                                   _port674_)))
                    (if (let ()
                          (declare (not safe))
                          (##fx< _rd679_ _length675_))
                        (begin (u8vector-shrink! _data677_ _rd679_) _data677_)
                        _data677_))))
               (_read/end659_
                (lambda (_port661_)
                  (let _lp663_ ((_chunks665_ '()))
                    (let* ((_buflen667_ '4096)
                           (_buf669_ (make-u8vector _buflen667_))
                           (_rd671_ (read-subu8vector
                                     _buf669_
                                     '0
                                     _buflen667_
                                     _port661_)))
                      (if (let () (declare (not safe)) (##fxzero? _rd671_))
                          (append-u8vectors (reverse _chunks665_))
                          (if (let ()
                                (declare (not safe))
                                (##fx< _rd671_ _buflen667_))
                              (begin
                                (u8vector-shrink! _buf669_ _rd671_)
                                (append-u8vectors
                                 (reverse (cons _buf669_ _chunks665_))))
                              (_lp663_ (cons _buf669_ _chunks665_)))))))))
        (if _length656_
            (_read/length658_ _port655_ _length656_)
            (_read/end659_ _port655_)))))
  (define std/net/request#cr (char->integer '#\return))
  (define std/net/request#lf (char->integer '#\newline))
  (define std/net/request#crlf
    (u8vector std/net/request#cr std/net/request#lf))
  (define std/net/request#read-response-line
    (lambda (_port645_)
      (let _lp647_ ((_r649_ '()))
        (let ((_next651_ (read-u8 _port645_)))
          (if (eof-object? _next651_)
              (std/error#raise-io-error
               'request-read-response-line
               '"Incomplete response; connection closed"
               _port645_)
              (if (eq? _next651_ std/net/request#cr)
                  (let ((_next653_ (read-u8 _port645_)))
                    (if (eof-object? _next653_)
                        (std/error#raise-io-error
                         'request-read-response-line
                         '"Incomplete response; connection closed"
                         _port645_)
                        (if (eq? _next653_ std/net/request#lf)
                            (std/text/utf8#utf8->string__0
                             (list->u8vector (reverse _r649_)))
                            (_lp647_ (cons _next653_
                                           (cons std/net/request#cr
                                                 _r649_))))))
                  (_lp647_ (cons _next651_ _r649_))))))))
  (define std/net/request#request-close
    (lambda (_req636_)
      (let ((_port637639_
             (##structure-ref _req636_ '1 std/net/request#request::t '#f)))
        (if _port637639_
            (let ((_port642_ _port637639_))
              (with-exception-catcher void (lambda () (close-port _port642_)))
              (##structure-set!
               _req636_
               '#f
               '1
               std/net/request#request::t
               '#f))
            '#f))))
  (define std/net/request#request::destroy std/net/request#request-close)
  (bind-method!
   std/net/request#request::t
   'destroy
   std/net/request#request::destroy
   '#f)
  (define std/net/request#request-content
    (lambda (_req482_)
      (let ((_$e484_ (##structure-ref
                      _req482_
                      '7
                      std/net/request#request::t
                      '#f)))
        (if _$e484_
            (values _$e484_)
            (let ((_$e487_ (##structure-ref
                            _req482_
                            '1
                            std/net/request#request::t
                            '#f)))
              (if _$e487_
                  ((lambda (_port490_)
                     (let ((_headers492_
                            (##structure-ref
                             _req482_
                             '6
                             std/net/request#request::t
                             '#f)))
                       (with-unwind-protect
                        (lambda ()
                          (let* ((_body495_
                                  (std/net/request#http-request-read-body
                                   _port490_
                                   _headers492_))
                                 (_body508_
                                  (let ((_$e497_ (assoc '"Content-Encoding"
                                                        _headers492_)))
                                    (if _$e497_
                                        ((lambda (_enc500_)
                                           (let ((_$e502_ (cdr _enc500_)))
                                             (if (or (equal? '"gzip" _$e502_)
                                                     (equal? '"deflate"
                                                             _$e502_))
                                                 (std/text/zlib#uncompress
                                                  _body495_)
                                                 (if (equal? '"identity"
                                                             _$e502_)
                                                     _body495_
                                                     (error '"Unsupported content encoding"
                                                            _enc500_)))))
                                         _$e497_)
                                        _body495_))))
                            (##structure-set!
                             _req482_
                             _body508_
                             '7
                             std/net/request#request::t
                             '#f)
                            _body508_))
                        (lambda ()
                          (close-port _port490_)
                          (##structure-set!
                           _req482_
                           '#f
                           '1
                           std/net/request#request::t
                           '#f)))))
                   _$e487_)
                  '#f))))))
  (define std/net/request#request-text
    (lambda (_req473_)
      (letrec ((_get-text475_
                (lambda (_enc480_)
                  (if (eq? _enc480_ 'UTF-8)
                      (std/text/utf8#utf8->string__0
                       (std/net/request#request-content _req473_))
                      (bytes->string
                       (std/net/request#request-content _req473_)
                       _enc480_)))))
        (let ((_$e477_ (##structure-ref
                        _req473_
                        '8
                        std/net/request#request::t
                        '#f)))
          (if _$e477_ (_get-text475_ _$e477_) (_get-text475_ 'UTF-8))))))
  (define std/net/request#request-json
    (lambda (_req471_)
      (std/text/json#string->json-object
       (std/net/request#request-text _req471_))))
  (define std/net/request#request-cookies
    (lambda (_req401_)
      (let _lp403_ ((_rest405_
                     (##structure-ref
                      _req401_
                      '6
                      std/net/request#request::t
                      '#f))
                    (_cookies406_ '()))
        (let* ((_rest407415_ _rest405_)
               (_else409423_ (lambda () (reverse _cookies406_)))
               (_K411459_
                (lambda (_rest426_ _hd427_)
                  (let* ((_hd428436_ _hd427_)
                         (_else430444_
                          (lambda () (_lp403_ _rest426_ _cookies406_)))
                         (_K432449_
                          (lambda (_cookie447_)
                            (_lp403_ _rest426_
                                     (cons _cookie447_ _cookies406_)))))
                    (if (let () (declare (not safe)) (##pair? _hd428436_))
                        (let ((_hd433452_
                               (let ()
                                 (declare (not safe))
                                 (##car _hd428436_)))
                              (_tl434454_
                               (let ()
                                 (declare (not safe))
                                 (##cdr _hd428436_))))
                          (if (equal? _hd433452_ '"Set-Cookie")
                              (let ((_cookie457_ _tl434454_))
                                (_K432449_ _cookie457_))
                              (_else430444_)))
                        (_else430444_))))))
          (if (let () (declare (not safe)) (##pair? _rest407415_))
              (let ((_hd412462_
                     (let () (declare (not safe)) (##car _rest407415_)))
                    (_tl413464_
                     (let () (declare (not safe)) (##cdr _rest407415_))))
                (let* ((_hd467_ _hd412462_) (_rest469_ _tl413464_))
                  (_K411459_ _rest469_ _hd467_)))
              (_else409423_)))))))
