(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/net/httpd/handler#http-request::t
    (make-struct-type
     'std/net/httpd/handler#http-request::t
     '#f
     '9
     'http-request
     '((final: . #t))
     '#f
     '(buf client method url path params proto headers data)))
  (define std/net/httpd/handler#http-request?
    (make-struct-predicate std/net/httpd/handler#http-request::t))
  (define std/net/httpd/handler#make-http-request
    (lambda _$args1480_
      (apply make-struct-instance
             std/net/httpd/handler#http-request::t
             _$args1480_)))
  (define std/net/httpd/handler#http-request-buf
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '0))
  (define std/net/httpd/handler#http-request-client
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '1))
  (define std/net/httpd/handler#http-request-method
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '2))
  (define std/net/httpd/handler#http-request-url
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '3))
  (define std/net/httpd/handler#http-request-path
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '4))
  (define std/net/httpd/handler#http-request-params
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '5))
  (define std/net/httpd/handler#http-request-proto
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '6))
  (define std/net/httpd/handler#http-request-headers
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '7))
  (define std/net/httpd/handler#http-request-data
    (make-struct-field-accessor std/net/httpd/handler#http-request::t '8))
  (define std/net/httpd/handler#http-request-buf-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '0))
  (define std/net/httpd/handler#http-request-client-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '1))
  (define std/net/httpd/handler#http-request-method-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '2))
  (define std/net/httpd/handler#http-request-url-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '3))
  (define std/net/httpd/handler#http-request-path-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '4))
  (define std/net/httpd/handler#http-request-params-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '5))
  (define std/net/httpd/handler#http-request-proto-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '6))
  (define std/net/httpd/handler#http-request-headers-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '7))
  (define std/net/httpd/handler#http-request-data-set!
    (make-struct-field-mutator std/net/httpd/handler#http-request::t '8))
  (define std/net/httpd/handler#&http-request-buf
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '0))
  (define std/net/httpd/handler#&http-request-client
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '1))
  (define std/net/httpd/handler#&http-request-method
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '2))
  (define std/net/httpd/handler#&http-request-url
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '3))
  (define std/net/httpd/handler#&http-request-path
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '4))
  (define std/net/httpd/handler#&http-request-params
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '5))
  (define std/net/httpd/handler#&http-request-proto
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '6))
  (define std/net/httpd/handler#&http-request-headers
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '7))
  (define std/net/httpd/handler#&http-request-data
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-request::t
     '8))
  (define std/net/httpd/handler#&http-request-buf-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '0))
  (define std/net/httpd/handler#&http-request-client-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '1))
  (define std/net/httpd/handler#&http-request-method-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '2))
  (define std/net/httpd/handler#&http-request-url-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '3))
  (define std/net/httpd/handler#&http-request-path-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '4))
  (define std/net/httpd/handler#&http-request-params-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '5))
  (define std/net/httpd/handler#&http-request-proto-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '6))
  (define std/net/httpd/handler#&http-request-headers-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '7))
  (define std/net/httpd/handler#&http-request-data-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-request::t
     '8))
  (define std/net/httpd/handler#http-response::t
    (make-struct-type
     'std/net/httpd/handler#http-response::t
     '#f
     '3
     'http-response
     '((final: . #t))
     '#f
     '(buf output close?)))
  (define std/net/httpd/handler#http-response?
    (make-struct-predicate std/net/httpd/handler#http-response::t))
  (define std/net/httpd/handler#make-http-response
    (lambda _$args1477_
      (apply make-struct-instance
             std/net/httpd/handler#http-response::t
             _$args1477_)))
  (define std/net/httpd/handler#http-response-buf
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '0))
  (define std/net/httpd/handler#http-response-output
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '1))
  (define std/net/httpd/handler#http-response-close?
    (make-struct-field-accessor std/net/httpd/handler#http-response::t '2))
  (define std/net/httpd/handler#http-response-buf-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '0))
  (define std/net/httpd/handler#http-response-output-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '1))
  (define std/net/httpd/handler#http-response-close?-set!
    (make-struct-field-mutator std/net/httpd/handler#http-response::t '2))
  (define std/net/httpd/handler#&http-response-buf
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-response::t
     '0))
  (define std/net/httpd/handler#&http-response-output
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-response::t
     '1))
  (define std/net/httpd/handler#&http-response-close?
    (make-struct-field-unchecked-accessor
     std/net/httpd/handler#http-response::t
     '2))
  (define std/net/httpd/handler#&http-response-buf-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-response::t
     '0))
  (define std/net/httpd/handler#&http-response-output-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-response::t
     '1))
  (define std/net/httpd/handler#&http-response-close?-set!
    (make-struct-field-unchecked-mutator
     std/net/httpd/handler#http-response::t
     '2))
  (define std/net/httpd/handler#http-request-handler
    (lambda (_get-handler1408_ _sock1409_ _addr1410_)
      (letrec* ((_ibuf1412_
                 (std/net/httpd/handler#get-input-buffer _sock1409_))
                (_obuf1413_
                 (std/net/httpd/handler#get-output-buffer _sock1409_))
                (_loop1414_
                 (lambda ()
                   (let ((_req1426_
                          (##structure
                           std/net/httpd/handler#http-request::t
                           _ibuf1412_
                           _addr1410_
                           '#f
                           '#f
                           '#f
                           '#f
                           '#f
                           '#f
                           '#!void))
                         (_res1427_
                          (##structure
                           std/net/httpd/handler#http-response::t
                           _obuf1413_
                           '#f
                           '#f)))
                     (std/net/socket/buffer#ssocket-input-buffer-timeout-set!
                      _ibuf1412_
                      std/net/httpd/handler#request-timeout)
                     (std/net/socket/buffer#ssocket-output-buffer-timeout-set!
                      _obuf1413_
                      std/net/httpd/handler#response-timeout)
                     (with-exception-catcher
                      (lambda (_g14281430_)
                        (if ((lambda (_$obj1433_)
                               (##structure-instance-of?
                                _$obj1433_
                                'std/error#timeout-error::t))
                             _g14281430_)
                            (let ((_e1436_ _g14281430_))
                              (std/logger#log-error '"request error" _e1436_)
                              (##unchecked-structure-set!
                               _res1427_
                               '#t
                               '3
                               std/net/httpd/handler#http-response::t
                               '#f)
                              (std/net/httpd/handler#http-response-write
                               _res1427_
                               '408
                               '()
                               '#f)
                              (raise 'abort))
                            (if ((lambda (_$obj1438_)
                                   (##structure-instance-of?
                                    _$obj1438_
                                    'std/error#io-error::t))
                                 _g14281430_)
                                (let ((_e1441_ _g14281430_))
                                  (std/logger#log-error
                                   '"request error"
                                   _e1441_)
                                  (##unchecked-structure-set!
                                   _res1427_
                                   '#t
                                   '3
                                   std/net/httpd/handler#http-response::t
                                   '#f)
                                  (std/net/httpd/handler#http-response-write
                                   _res1427_
                                   '400
                                   '()
                                   '#f)
                                  (raise 'abort))
                                (raise _g14281430_))))
                      (lambda ()
                        (std/net/httpd/handler#read-request! _req1426_)))
                     (let* ((_method1444_
                             (##unchecked-structure-ref
                              _req1426_
                              '3
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_path1446_
                             (##unchecked-structure-ref
                              _req1426_
                              '5
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_proto1448_
                             (##unchecked-structure-ref
                              _req1426_
                              '7
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_headers1450_
                             (##unchecked-structure-ref
                              _req1426_
                              '8
                              std/net/httpd/handler#http-request::t
                              '#f))
                            (_host1452_
                             (std/net/httpd/handler#header-e
                              '"Host"
                              _headers1450_))
                            (_close?1457_
                             (let ((_$e1454_ _proto1448_))
                               (if (equal? '"HTTP/1.1" _$e1454_)
                                   (equal? (std/net/httpd/handler#header-e
                                            '"Connection"
                                            _headers1450_)
                                           '"close")
                                   (if (equal? '"HTTP/1.0" _$e1454_)
                                       (not (equal? (std/net/httpd/handler#header-e
                                                     '"Connection"
                                                     _headers1450_)
                                                    '"Keep-Alive"))
                                       '#t)))))
                       (if _close?1457_
                           (##unchecked-structure-set!
                            _res1427_
                            '#t
                            '3
                            std/net/httpd/handler#http-response::t
                            '#f)
                           '#!void)
                       (if (not (member _proto1448_ '("HTTP/1.1" "HTTP/1.0")))
                           (std/net/httpd/handler#http-response-write
                            _res1427_
                            '505
                            '()
                            '#f)
                           (if (not (symbol? _method1444_))
                               (std/net/httpd/handler#http-response-write
                                _res1427_
                                '501
                                '()
                                '#f)
                               (if (and (eq? _method1444_ 'OPTIONS)
                                        (equal? _path1446_ '"*"))
                                   (std/net/httpd/handler#http-response-write
                                    _res1427_
                                    '200
                                    '()
                                    '#f)
                                   (if (eq? _method1444_ 'TRACE)
                                       (std/net/httpd/handler#http-response-trace
                                        _res1427_
                                        _req1426_)
                                       (let ((_$e1460_
                                              (_get-handler1408_
                                               _host1452_
                                               _path1446_)))
                                         (if _$e1460_
                                             ((lambda (_handler1463_)
                                                (if (procedure? _handler1463_)
                                                    (with-exception-catcher
                                                     (lambda (_g14641466_)
                                                       (if ((lambda (_$obj1469_)
                                                              (##structure-instance-of?
                                                               _$obj1469_
                                                               'std/error#io-error::t))
                                                            _g14641466_)
                                                           (let ((_e1472_ _g14641466_))
                                                             (std/logger#log-error
                                                              '"request i/o error"
                                                              _e1472_)
                                                             (if (##unchecked-structure-ref
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _res1427_
                          '2
                          std/net/httpd/handler#http-response::t
                          '#f)
                         '#!void
                         (begin
                           (##unchecked-structure-set!
                            _res1427_
                            '#t
                            '3
                            std/net/httpd/handler#http-response::t
                            '#f)
                           (std/net/httpd/handler#http-response-write
                            _res1427_
                            '500
                            '()
                            '#f)))
                     (raise 'abort))
                   (if '#t
                       (let ((_e1474_ _g14641466_))
                         (std/logger#log-error
                          '"request handler error"
                          _e1474_)
                         (if (##unchecked-structure-ref
                              _res1427_
                              '2
                              std/net/httpd/handler#http-response::t
                              '#f)
                             (raise 'abort)
                             (std/net/httpd/handler#http-response-write
                              _res1427_
                              '500
                              '()
                              '#f)))
                       (raise _g14641466_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (lambda ()
                                                       (_handler1463_
                                                        _req1426_
                                                        _res1427_)))
                                                    (begin
                                                      (std/logger#warning
                                                       '"request handler is not a procedure: ~a ~a ~a"
                                                       _host1452_
                                                       _path1446_
                                                       _handler1463_)
                                                      (std/net/httpd/handler#http-response-write
                                                       _res1427_
                                                       '500
                                                       '()
                                                       '#f))))
                                              _$e1460_)
                                             (std/net/httpd/handler#http-response-write
                                              _res1427_
                                              '404
                                              '()
                                              '#f)))))))
                       (if _close?1457_
                           '#!void
                           (begin
                             (std/net/httpd/handler#http-request-skip-body
                              _req1426_)
                             (_loop1414_))))))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g14151418_)
              (if '#t
                  (let ((_e1421_ _g14151418_))
                    (if (memq _e1421_ '(abort eof))
                        '#!void
                        (begin
                          (std/logger#log-error '"unhandled exception" _e1421_)
                          (raise _e1421_)))
                    _e1421_)
                  (raise _g14151418_)))
            (lambda () (_loop1414_))))
         (lambda ()
           (std/net/socket/api#ssocket-close _sock1409_)
           (std/net/httpd/handler#put-input-buffer! _ibuf1412_)
           (std/net/httpd/handler#put-output-buffer! _obuf1413_))))))
  (define std/net/httpd/handler#http-request-body
    (lambda (_req1335_)
      (let* ((_req13361350_ _req1335_)
             (_E13381354_
              (lambda () (error '"No clause matching" _req13361350_)))
             (_K13391370_
              (lambda (_data1357_ _headers1358_ _method1359_ _ibuf1360_)
                (if (eq? _data1357_ '#!void)
                    (let ((_$e1362_ _method1359_))
                      (if (or (eq? 'POST _$e1362_) (eq? 'PUT _$e1362_))
                          (let ((_data1368_
                                 (std/net/httpd/handler#read-request-body
                                  _ibuf1360_
                                  _headers1358_)))
                            (##unchecked-structure-set!
                             _req1335_
                             _data1368_
                             '9
                             std/net/httpd/handler#http-request::t
                             '#f)
                            _data1368_)
                          (begin
                            (std/net/httpd/handler#http-request-skip-body
                             _req1335_)
                            '#f)))
                    _data1357_))))
        (if (##structure-direct-instance-of?
             _req13361350_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e13401373_ (##vector-ref _req13361350_ '1))
                   (_ibuf1376_ _e13401373_)
                   (_e13411378_ (##vector-ref _req13361350_ '2))
                   (_e13421381_ (##vector-ref _req13361350_ '3))
                   (_method1384_ _e13421381_)
                   (_e13431386_ (##vector-ref _req13361350_ '4))
                   (_e13441389_ (##vector-ref _req13361350_ '5))
                   (_e13451392_ (##vector-ref _req13361350_ '6))
                   (_e13461395_ (##vector-ref _req13361350_ '7))
                   (_e13471398_ (##vector-ref _req13361350_ '8))
                   (_headers1401_ _e13471398_)
                   (_e13481403_ (##vector-ref _req13361350_ '9))
                   (_data1406_ _e13481403_))
              (_K13391370_ _data1406_ _headers1401_ _method1384_ _ibuf1376_))
            (_E13381354_)))))
  (define std/net/httpd/handler#http-request-timeout-set!
    (lambda (_req1310_ _timeo1311_)
      (let* ((_req13121318_ _req1310_)
             (_E13141322_
              (lambda () (error '"No clause matching" _req13121318_)))
             (_K13151327_
              (lambda (_ibuf1325_)
                (std/net/socket/buffer#ssocket-input-buffer-timeout-set!
                 _ibuf1325_
                 _timeo1311_))))
        (if (##structure-direct-instance-of?
             _req13121318_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e13161330_ (##vector-ref _req13121318_ '1))
                   (_ibuf1333_ _e13161330_))
              (_K13151327_ _ibuf1333_))
            (_E13141322_)))))
  (define std/net/httpd/handler#http-response-write
    (lambda (_res1260_ _status1261_ _headers1262_ _body1263_)
      (let* ((_res12641272_ _res1260_)
             (_E12661276_
              (lambda () (error '"No clause matching" _res12641272_)))
             (_K12671292_
              (lambda (_close?1279_ _output1280_ _obuf1281_)
                (if _output1280_
                    (error '"duplicate response" _res1260_)
                    '#!void)
                (##unchecked-structure-set!
                 _res1260_
                 'END
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (let* ((_len1283_
                        (if (u8vector? _body1263_)
                            (u8vector-length _body1263_)
                            (if (string? _body1263_)
                                (std/text/utf8#string-utf8-length__0
                                 _body1263_)
                                (if (not _body1263_)
                                    '0
                                    (error '"Bad response body; expected string, u8vector, or #f"
                                           _body1263_)))))
                       (_headers1285_
                        (cons (cons '"Content-Length"
                                    (number->string _len1283_))
                              _headers1262_))
                       (_headers1287_
                        (if _close?1279_
                            (cons '("Connection" . "close") _headers1285_)
                            _headers1285_))
                       (_headers1289_
                        (cons (cons '"Date" (std/net/httpd/handler#http-date))
                              _headers1287_)))
                  (std/net/httpd/handler#write-response-line
                   _obuf1281_
                   _status1261_)
                  (std/net/httpd/handler#write-response-headers
                   _obuf1281_
                   _headers1289_)
                  (std/net/httpd/handler#write-crlf _obuf1281_)
                  (if (u8vector? _body1263_)
                      (std/net/bio/output#bio-write-bytes
                       _body1263_
                       _obuf1281_)
                      (if (string? _body1263_)
                          (std/net/bio/output#bio-write-string
                           _body1263_
                           _obuf1281_)
                          '#!void))
                  (std/net/bio/output#bio-force-output _obuf1281_)))))
        (if (##structure-direct-instance-of?
             _res12641272_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e12681295_ (##vector-ref _res12641272_ '1))
                   (_obuf1298_ _e12681295_)
                   (_e12691300_ (##vector-ref _res12641272_ '2))
                   (_output1303_ _e12691300_)
                   (_e12701305_ (##vector-ref _res12641272_ '3))
                   (_close?1308_ _e12701305_))
              (_K12671292_ _close?1308_ _output1303_ _obuf1298_))
            (_E12661276_)))))
  (define std/net/httpd/handler#http-response-begin
    (lambda (_res1213_ _status1214_ _headers1215_)
      (let* ((_res12161224_ _res1213_)
             (_E12181228_
              (lambda () (error '"No clause matching" _res12161224_)))
             (_K12191242_
              (lambda (_close?1231_ _output1232_ _obuf1233_)
                (if _output1232_
                    (error '"duplicate response" _res1213_)
                    '#!void)
                (##unchecked-structure-set!
                 _res1213_
                 'CHUNK
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (let* ((_headers1235_
                        (cons '("Transfer-Encoding" . "chunked")
                              _headers1215_))
                       (_headers1237_
                        (if _close?1231_
                            (cons '("Connection" . "close") _headers1235_)
                            _headers1235_))
                       (_headers1239_
                        (cons (cons '"Date" (std/net/httpd/handler#http-date))
                              _headers1237_)))
                  (std/net/httpd/handler#write-response-line
                   _obuf1233_
                   _status1214_)
                  (std/net/httpd/handler#write-response-headers
                   _obuf1233_
                   _headers1239_)
                  (std/net/httpd/handler#write-crlf _obuf1233_)))))
        (if (##structure-direct-instance-of?
             _res12161224_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e12201245_ (##vector-ref _res12161224_ '1))
                   (_obuf1248_ _e12201245_)
                   (_e12211250_ (##vector-ref _res12161224_ '2))
                   (_output1253_ _e12211250_)
                   (_e12221255_ (##vector-ref _res12161224_ '3))
                   (_close?1258_ _e12221255_))
              (_K12191242_ _close?1258_ _output1253_ _obuf1248_))
            (_E12181228_)))))
  (define std/net/httpd/handler#http-response-chunk__%
    (lambda (_res1158_ _chunk1159_ _start1160_ _end1161_)
      (let* ((_res11621169_ _res1158_)
             (_E11641173_
              (lambda () (error '"No clause matching" _res11621169_)))
             (_K11651179_
              (lambda (_output1176_ _obuf1177_)
                (if (eq? _output1176_ 'CHUNK)
                    '#!void
                    (error '"illegal response; not writing chunks"
                           _res1158_
                           _output1176_))
                (std/net/httpd/handler#write-chunk
                 _obuf1177_
                 _chunk1159_
                 _start1160_
                 _end1161_))))
        (if (##structure-direct-instance-of?
             _res11621169_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e11661182_ (##vector-ref _res11621169_ '1))
                   (_obuf1185_ _e11661182_)
                   (_e11671187_ (##vector-ref _res11621169_ '2))
                   (_output1190_ _e11671187_))
              (_K11651179_ _output1190_ _obuf1185_))
            (_E11641173_)))))
  (define std/net/httpd/handler#http-response-chunk__0
    (lambda (_res1195_ _chunk1196_)
      (let* ((_start1198_ '0) (_end1200_ '#f))
        (std/net/httpd/handler#http-response-chunk__%
         _res1195_
         _chunk1196_
         _start1198_
         _end1200_))))
  (define std/net/httpd/handler#http-response-chunk__1
    (lambda (_res1202_ _chunk1203_ _start1204_)
      (let ((_end1206_ '#f))
        (std/net/httpd/handler#http-response-chunk__%
         _res1202_
         _chunk1203_
         _start1204_
         _end1206_))))
  (define std/net/httpd/handler#http-response-chunk
    (lambda _g6580_
      (let ((_g6579_ (##length _g6580_)))
        (cond ((##fx= _g6579_ 2)
               (apply std/net/httpd/handler#http-response-chunk__0 _g6580_))
              ((##fx= _g6579_ 3)
               (apply std/net/httpd/handler#http-response-chunk__1 _g6580_))
              ((##fx= _g6579_ 4)
               (apply std/net/httpd/handler#http-response-chunk__% _g6580_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#http-response-chunk
                _g6580_))))))
  (define std/net/httpd/handler#http-response-end
    (lambda (_res1126_)
      (let* ((_res11271134_ _res1126_)
             (_E11291138_
              (lambda () (error '"No clause matching" _res11271134_)))
             (_K11301144_
              (lambda (_output1141_ _obuf1142_)
                (if (eq? _output1141_ 'CHUNK)
                    '#!void
                    (error '"illegal response; not writing chunks"
                           _res1126_
                           _output1141_))
                (##unchecked-structure-set!
                 _res1126_
                 'END
                 '2
                 std/net/httpd/handler#http-response::t
                 '#f)
                (std/net/httpd/handler#write-last-chunk _obuf1142_)
                (std/net/bio/output#bio-force-output _obuf1142_))))
        (if (##structure-direct-instance-of?
             _res11271134_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e11311147_ (##vector-ref _res11271134_ '1))
                   (_obuf1150_ _e11311147_)
                   (_e11321152_ (##vector-ref _res11271134_ '2))
                   (_output1155_ _e11321152_))
              (_K11301144_ _output1155_ _obuf1150_))
            (_E11291138_)))))
  (define std/net/httpd/handler#http-response-force-output
    (lambda (_res1124_)
      (std/net/bio/output#bio-force-output
       (##direct-structure-ref
        _res1124_
        '1
        std/net/httpd/handler#http-response::t
        '#f))))
  (define std/net/httpd/handler#http-response-timeout-set!
    (lambda (_res1099_ _timeo1100_)
      (let* ((_res11011107_ _res1099_)
             (_E11031111_
              (lambda () (error '"No clause matching" _res11011107_)))
             (_K11041116_
              (lambda (_obuf1114_)
                (std/net/socket/buffer#ssocket-output-buffer-timeout-set!
                 _obuf1114_
                 _timeo1100_))))
        (if (##structure-direct-instance-of?
             _res11011107_
             'std/net/httpd/handler#http-response::t)
            (let* ((_e11051119_ (##vector-ref _res11011107_ '1))
                   (_obuf1122_ _e11051119_))
              (_K11041116_ _obuf1122_))
            (_E11031111_)))))
  (define std/net/httpd/handler#header-e
    (lambda (_key1059_ _lst1060_)
      (let _lp1062_ ((_rest1064_ _lst1060_))
        (let* ((_rest10651073_ _rest1064_)
               (_else10671081_ (lambda () '#f))
               (_K10691087_
                (lambda (_rest1084_ _hd1085_)
                  (if (##string-equal? _key1059_ (car _hd1085_))
                      (cdr _hd1085_)
                      (_lp1062_ _rest1084_)))))
          (if (##pair? _rest10651073_)
              (let ((_hd10701090_ (##car _rest10651073_))
                    (_tl10711092_ (##cdr _rest10651073_)))
                (let* ((_hd1095_ _hd10701090_) (_rest1097_ _tl10711092_))
                  (_K10691087_ _rest1097_ _hd1095_)))
              (_else10671081_))))))
  (define std/net/httpd/handler#http-request-skip-body
    (lambda (_req1057_)
      (if (eq? (##unchecked-structure-ref
                _req1057_
                '9
                std/net/httpd/handler#http-request::t
                '#f)
               '#!void)
          (begin
            (##unchecked-structure-set!
             _req1057_
             '#f
             '9
             std/net/httpd/handler#http-request::t
             '#f)
            (std/net/httpd/handler#skip-request-body
             (##unchecked-structure-ref
              _req1057_
              '1
              std/net/httpd/handler#http-request::t
              '#f)
             (##unchecked-structure-ref
              _req1057_
              '8
              std/net/httpd/handler#http-request::t
              '#f)))
          '#!void)))
  (define std/net/httpd/handler#http-response-trace
    (lambda (_res987_ _req988_)
      (let* ((_req9891002_ _req988_)
             (_E9911006_
              (lambda () (error '"No clause matching" _req9891002_)))
             (_K9921022_
              (lambda (_headers1009_ _proto1010_ _url1011_ _method1012_)
                (let ((_xbuf1014_
                       (std/net/bio/buffer#open-chunked-output-buffer__0)))
                  (std/net/bio/output#bio-write-string
                   (symbol->string _method1012_)
                   _xbuf1014_)
                  (std/net/bio/output#bio-write-u8
                   std/net/httpd/handler#SPC
                   _xbuf1014_)
                  (std/net/bio/output#bio-write-string _url1011_ _xbuf1014_)
                  (std/net/bio/output#bio-write-u8
                   std/net/httpd/handler#SPC
                   _xbuf1014_)
                  (std/net/bio/output#bio-write-string _proto1010_ _xbuf1014_)
                  (std/net/httpd/handler#write-crlf _xbuf1014_)
                  (std/net/httpd/handler#write-response-headers
                   _xbuf1014_
                   _headers1009_)
                  (std/net/httpd/handler#write-crlf _xbuf1014_)
                  (let ((_chunks1016_
                         (std/net/bio/buffer#chunked-output-chunks
                          _xbuf1014_)))
                    (std/net/httpd/handler#http-response-begin
                     _res987_
                     '200
                     '(("Content-Type" . "message/http")))
                    (for-each
                     (lambda (_g10171019_)
                       (std/net/httpd/handler#http-response-chunk__0
                        _res987_
                        _g10171019_))
                     _chunks1016_)
                    (std/net/httpd/handler#http-response-end _res987_))))))
        (if (##structure-direct-instance-of?
             _req9891002_
             'std/net/httpd/handler#http-request::t)
            (let* ((_e9931025_ (##vector-ref _req9891002_ '1))
                   (_e9941028_ (##vector-ref _req9891002_ '2))
                   (_e9951031_ (##vector-ref _req9891002_ '3))
                   (_method1034_ _e9951031_)
                   (_e9961036_ (##vector-ref _req9891002_ '4))
                   (_url1039_ _e9961036_)
                   (_e9971041_ (##vector-ref _req9891002_ '5))
                   (_e9981044_ (##vector-ref _req9891002_ '6))
                   (_e9991047_ (##vector-ref _req9891002_ '7))
                   (_proto1050_ _e9991047_)
                   (_e10001052_ (##vector-ref _req9891002_ '8))
                   (_headers1055_ _e10001052_))
              (_K9921022_ _headers1055_ _proto1050_ _url1039_ _method1034_))
            (_E9911006_)))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/net/httpd/handler#" http-date))
  (c-declare
   "#include <time.h>\n#include <string.h>\n__thread char buf[64];\nstatic char *ffi_httpd_date () {\n struct tm tm;\n time_t t = time(NULL);\n asctime_r (gmtime_r (&t, &tm), buf);\n // clobber newline\n buf[strlen(buf)-1] = 0;\n return buf;\n}")
  (define-c-lambda http-date () char-string "ffi_httpd_date")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif")
  (define std/net/httpd/handler#request-timeout '60)
  (define std/net/httpd/handler#response-timeout '120)
  (define std/net/httpd/handler#max-request-headers '256)
  (define std/net/httpd/handler#max-token-length '1024)
  (define std/net/httpd/handler#max-request-body-length (expt '2 '20))
  (define std/net/httpd/handler#input-buffer-size '4096)
  (define std/net/httpd/handler#output-buffer-size '4096)
  (define std/net/httpd/handler#set-httpd-request-timeout!
    (lambda (_val978_)
      (if (or (not _val978_) (real? _val978_) (time? _val978_))
          (set! std/net/httpd/handler#request-timeout _val978_)
          (error '"Cannot set httpd parameter; Bad argument" _val978_))))
  (define std/net/httpd/handler#set-httpd-response-timeout!
    (lambda (_val969_)
      (if (or (not _val969_) (real? _val969_) (time? _val969_))
          (set! std/net/httpd/handler#response-timeout _val969_)
          (error '"Cannot set httpd parameter; Bad argument" _val969_))))
  (define std/net/httpd/handler#set-httpd-max-request-headers!
    (lambda (_val966_)
      (if (and (fixnum? _val966_) (fxpositive? _val966_))
          (set! std/net/httpd/handler#max-request-headers _val966_)
          (error '"Cannot set httpd parameter; Bad argument" _val966_))))
  (define std/net/httpd/handler#set-httpd-max-token-length!
    (lambda (_val963_)
      (if (and (fixnum? _val963_) (fxpositive? _val963_))
          (set! std/net/httpd/handler#max-token-length _val963_)
          (error '"Cannot set httpd parameter; Bad argument" _val963_))))
  (define std/net/httpd/handler#set-httpd-max-request-body-length!
    (lambda (_val960_)
      (if (and (fixnum? _val960_) (fxpositive? _val960_))
          (set! std/net/httpd/handler#max-request-body-length _val960_)
          (error '"Cannot set httpd parameter; Bad argument" _val960_))))
  (define std/net/httpd/handler#set-httpd-input-buffer-size!
    (lambda (_val957_)
      (if (and (fixnum? _val957_) (fxpositive? _val957_))
          (set! std/net/httpd/handler#input-buffer-size _val957_)
          (error '"Cannot set httpd parameter; Bad argument" _val957_))))
  (define std/net/httpd/handler#set-httpd-output-buffer-size!
    (lambda (_val954_)
      (if (and (fixnum? _val954_) (fxpositive? _val954_))
          (set! std/net/httpd/handler#output-buffer-size _val954_)
          (error '"Cannot set httpd parameter; Bad argument" _val954_))))
  (define std/net/httpd/handler#read-request!
    (lambda (_req940_)
      (let* ((_ibuf942_
              (##unchecked-structure-ref
               _req940_
               '1
               std/net/httpd/handler#http-request::t
               '#f))
             (_g6581_ (std/net/httpd/handler#read-request-line _ibuf942_)))
        (begin
          (let ((_g6582_ (if (##values? _g6581_) (##vector-length _g6581_) 1)))
            (if (not (##fx= _g6582_ 3))
                (error "Context expects 3 values" _g6582_)))
          (let ((_method944_ (##vector-ref _g6581_ 0))
                (_url945_ (##vector-ref _g6581_ 1))
                (_proto946_ (##vector-ref _g6581_ 2)))
            (let ((_g6583_ (std/net/httpd/handler#split-request-url _url945_)))
              (begin
                (let ((_g6584_ (if (##values? _g6583_)
                                   (##vector-length _g6583_)
                                   1)))
                  (if (not (##fx= _g6584_ 2))
                      (error "Context expects 2 values" _g6584_)))
                (let ((_path948_ (##vector-ref _g6583_ 0))
                      (_params949_ (##vector-ref _g6583_ 1)))
                  (let ((_headers951_
                         (std/net/httpd/handler#read-request-headers
                          _ibuf942_)))
                    (##unchecked-structure-set!
                     _req940_
                     _method944_
                     '3
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##unchecked-structure-set!
                     _req940_
                     _url945_
                     '4
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##unchecked-structure-set!
                     _req940_
                     _path948_
                     '5
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##unchecked-structure-set!
                     _req940_
                     _params949_
                     '6
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##unchecked-structure-set!
                     _req940_
                     _proto946_
                     '7
                     std/net/httpd/handler#http-request::t
                     '#f)
                    (##unchecked-structure-set!
                     _req940_
                     _headers951_
                     '8
                     std/net/httpd/handler#http-request::t
                     '#f))))))))))
  (define std/net/httpd/handler#split-request-url-rx
    (std/pregexp#pregexp '"^[^/]+://[^/]*(/.*)$"))
  (define std/net/httpd/handler#split-request-url
    (lambda (_url893_)
      (let ((_$e895_ (string-index _url893_ '#\:)))
        (if _$e895_
            ((lambda (_ix898_)
               (let* ((_g899909_
                       (std/pregexp#pregexp-match
                        std/net/httpd/handler#split-request-url-rx
                        _url893_))
                      (_else901917_
                       (lambda ()
                         (std/error#raise-io-error
                          'http-read-request
                          '"invalid url"
                          _url893_)))
                      (_K903922_
                       (lambda (_base920_)
                         (std/net/httpd/handler#split-request-url _base920_))))
                 (if (##pair? _g899909_)
                     (let ((_tl905925_ (##cdr _g899909_)))
                       (if (##pair? _tl905925_)
                           (let ((_hd906928_ (##car _tl905925_))
                                 (_tl907930_ (##cdr _tl905925_)))
                             (let ((_base933_ _hd906928_))
                               (if (##null? _tl907930_)
                                   (std/net/httpd/handler#split-request-url
                                    _base933_)
                                   (_else901917_))))
                           (_else901917_)))
                     (_else901917_))))
             _$e895_)
            (let ((_$e935_ (string-index _url893_ '#\?)))
              (if _$e935_
                  ((lambda (_ix938_)
                     (values (substring _url893_ '0 _ix938_)
                             (substring
                              _url893_
                              (fx+ _ix938_ '1)
                              (string-length _url893_))))
                   _$e935_)
                  (values _url893_ '#f)))))))
  (define std/net/httpd/handler#read-request-line
    (lambda (_ibuf877_)
      (let* ((_g6585_ (std/net/httpd/handler#read-skip*__1
                       _ibuf877_
                       std/net/httpd/handler#CR
                       std/net/httpd/handler#LF))
             (_method880_
              (std/net/httpd/handler#read-token
               _ibuf877_
               std/net/httpd/handler#SPC))
             (_url882_
              (std/net/httpd/handler#read-token
               _ibuf877_
               std/net/httpd/handler#SPC))
             (_proto884_
              (std/net/httpd/handler#read-token
               _ibuf877_
               std/net/httpd/handler#CR))
             (_g6586_ (std/net/httpd/handler#read-skip__0
                       _ibuf877_
                       std/net/httpd/handler#LF))
             (_method890_
              (let ((_$e887_ (table-ref
                              std/net/httpd/handler#+http-request-methods+
                              _method880_
                              '#f)))
                (if _$e887_ _$e887_ _method880_))))
        (values _method890_ _url882_ _proto884_))))
  (define std/net/httpd/handler#read-request-headers
    (lambda (_ibuf866_)
      (let _lp868_ ((_headers870_ '()) (_count871_ '0))
        (let ((_next873_ (std/net/bio/input#bio-peek-u8 _ibuf866_)))
          (if (eof-object? _next873_)
              (raise 'eof)
              (if (eq? _next873_ std/net/httpd/handler#CR)
                  (begin
                    (std/net/httpd/handler#read-skip__1
                     _ibuf866_
                     std/net/httpd/handler#CR
                     std/net/httpd/handler#LF)
                    (std/srfi/1#reverse! _headers870_))
                  (if (fx< _count871_
                           std/net/httpd/handler#max-request-headers)
                      (let ((_hdr875_
                             (std/net/httpd/handler#read-header _ibuf866_)))
                        (_lp868_ (cons _hdr875_ _headers870_)
                                 (fx+ _count871_ '1)))
                      (std/error#raise-io-error
                       'http-read-request
                       '"too many headers"
                       _count871_))))))))
  (define std/net/httpd/handler#read-header
    (lambda (_ibuf856_)
      (let* ((_key858_
              (std/net/httpd/handler#read-token
               _ibuf856_
               std/net/httpd/handler#COL))
             (_g6587_ (std/net/httpd/handler#header-titlecase! _key858_))
             (_g6588_ (std/net/httpd/handler#read-skip*__0
                       _ibuf856_
                       std/net/httpd/handler#SPC))
             (_val862_
              (std/net/httpd/handler#read-token
               _ibuf856_
               std/net/httpd/handler#CR))
             (_g6589_ (std/net/httpd/handler#read-skip__0
                       _ibuf856_
                       std/net/httpd/handler#LF)))
        (cons _key858_ _val862_))))
  (define std/net/httpd/handler#header-titlecase!
    (lambda (_str838_)
      (let ((_len840_ (string-length _str838_)))
        (let _lp842_ ((_i844_ '0) (_upcase?845_ '#t))
          (if (fx< _i844_ _len840_)
              (let* ((_char847_ (string-ref _str838_ _i844_))
                     (_int849_ (char->integer _char847_)))
                (if (fx<= '97 _int849_ '122)
                    (begin
                      (if _upcase?845_
                          (let ((_char852_ (integer->char (fx- _int849_ '32))))
                            (string-set! _str838_ _i844_ _char852_))
                          '#!void)
                      (_lp842_ (fx+ _i844_ '1) '#f))
                    (if (fx<= '65 _int849_ '90)
                        (begin
                          (if _upcase?845_
                              '#!void
                              (let ((_char854_
                                     (integer->char (fx+ _int849_ '32))))
                                (string-set! _str838_ _i844_ _char854_)))
                          (_lp842_ (fx+ _i844_ '1) '#f))
                        (_lp842_ (fx+ _i844_ '1) '#t))))
              _str838_)))))
  (define std/net/httpd/handler#read-token
    (lambda (_ibuf823_ _sep824_)
      (letrec* ((_tbuf826_ (std/net/httpd/handler#get-token-buffer)))
        (let _lp828_ ((_count830_ '0))
          (let ((_next832_ (std/net/bio/input#bio-read-u8 _ibuf823_)))
            (if (eof-object? _next832_)
                (begin
                  (std/net/httpd/handler#put-token-buffer! _tbuf826_)
                  (raise 'eof))
                (if (eq? _next832_ _sep824_)
                    (let ((_token834_ (##substring _tbuf826_ '0 _count830_)))
                      (std/net/httpd/handler#put-token-buffer! _tbuf826_)
                      _token834_)
                    (if (fx< _count830_ std/net/httpd/handler#max-token-length)
                        (let ((_char836_ (integer->char _next832_)))
                          (string-set! _tbuf826_ _count830_ _char836_)
                          (_lp828_ (fx+ _count830_ '1)))
                        (begin
                          (std/net/httpd/handler#put-token-buffer! _tbuf826_)
                          (std/error#raise-io-error
                           'http-read-request
                           '"Maximum token length exceeded"
                           _count830_))))))))))
  (define std/net/httpd/handler#read-skip__0
    (lambda (_ibuf814_ _c815_)
      (let ((_next817_ (std/net/bio/input#bio-read-u8 _ibuf814_)))
        (if (eq? _c815_ _next817_)
            '#!void
            (std/error#raise-io-error
             'http-read-request
             '"Unexpected character"
             _next817_)))))
  (define std/net/httpd/handler#read-skip__1
    (lambda (_ibuf819_ _c1820_ _c2821_)
      (std/net/httpd/handler#read-skip__0 _ibuf819_ _c1820_)
      (std/net/httpd/handler#read-skip__0 _ibuf819_ _c2821_)))
  (define std/net/httpd/handler#read-skip
    (lambda _g6591_
      (let ((_g6590_ (##length _g6591_)))
        (cond ((##fx= _g6590_ 2)
               (apply std/net/httpd/handler#read-skip__0 _g6591_))
              ((##fx= _g6590_ 3)
               (apply std/net/httpd/handler#read-skip__1 _g6591_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#read-skip
                _g6591_))))))
  (define std/net/httpd/handler#read-skip*__0
    (lambda (_ibuf797_ _c798_)
      (let _lp800_ ()
        (let ((_next803_ (std/net/bio/input#bio-peek-u8 _ibuf797_)))
          (if (eq? _next803_ _c798_)
              (begin (std/net/bio/input#bio-read-u8 _ibuf797_) (_lp800_))
              '#!void)))))
  (define std/net/httpd/handler#read-skip*__1
    (lambda (_ibuf805_ _c1806_ _c2807_)
      (let _lp809_ ()
        (let ((_next812_ (std/net/bio/input#bio-peek-u8 _ibuf805_)))
          (if (eq? _next812_ _c1806_)
              (begin
                (std/net/bio/input#bio-read-u8 _ibuf805_)
                (std/net/httpd/handler#read-skip__0 _ibuf805_ _c2807_)
                (_lp809_))
              '#!void)))))
  (define std/net/httpd/handler#read-skip*
    (lambda _g6593_
      (let ((_g6592_ (##length _g6593_)))
        (cond ((##fx= _g6592_ 2)
               (apply std/net/httpd/handler#read-skip*__0 _g6593_))
              ((##fx= _g6592_ 3)
               (apply std/net/httpd/handler#read-skip*__1 _g6593_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/httpd/handler#read-skip*
                _g6593_))))))
  (define std/net/httpd/handler#read-request-body
    (lambda (_ibuf775_ _headers776_)
      (letrec ((_read-simple-body778_
                (lambda ()
                  (let ((_$e786_ (std/net/httpd/handler#header-e
                                  '"Content-Length"
                                  _headers776_)))
                    (if _$e786_
                        ((lambda (_len789_)
                           (let* ((_len791_ (string->number _len789_))
                                  (_g6594_ (if (fx<= _len791_
                                                     std/net/httpd/handler#max-request-body-length)
                                               '#!void
                                               (std/error#raise-io-error
                                                'http-request-body
                                                '"Maximum body length exceeded"
                                                _len791_)))
                                  (_bytes794_ (make-u8vector _len791_)))
                             (std/net/bio/input#bio-read-bytes
                              _bytes794_
                              _ibuf775_)
                             _bytes794_))
                         _$e786_)
                        '#f)))))
        (let ((_$e780_ (std/net/httpd/handler#header-e
                        '"Transfer-Encoding"
                        _headers776_)))
          (if _$e780_
              ((lambda (_tenc783_)
                 (if (not (equal? '"identity" _tenc783_))
                     (std/net/httpd/handler#read-request-chunks _ibuf775_)
                     (_read-simple-body778_)))
               _$e780_)
              (_read-simple-body778_))))))
  (define std/net/httpd/handler#read-request-chunks
    (lambda (_ibuf758_)
      (let _lp760_ ((_chunks762_ '()) (_count763_ '0))
        (let* ((_next765_
                (std/net/httpd/handler#read-token
                 _ibuf758_
                 std/net/httpd/handler#CR))
               (_g6595_ (std/net/httpd/handler#read-skip__0
                         _ibuf758_
                         std/net/httpd/handler#LF))
               (_len768_ (string->number _next765_ '16)))
          (if (fx> _len768_ '0)
              (let ((_count771_ (fx+ _count763_ _len768_)))
                (if (fx<= _count771_
                          std/net/httpd/handler#max-request-body-length)
                    (let ((_chunk773_ (make-u8vector _len768_)))
                      (std/net/bio/input#bio-read-bytes _chunk773_ _ibuf758_)
                      (std/net/httpd/handler#read-skip__1
                       _ibuf758_
                       std/net/httpd/handler#CR
                       std/net/httpd/handler#LF)
                      (_lp760_ (cons _chunk773_ _chunks762_) _count771_))
                    (std/error#raise-io-error
                     'http-request-body
                     '"Maximum body length exceeded"
                     _count771_
                     _len768_)))
              (append-u8vectors (std/srfi/1#reverse! _chunks762_)))))))
  (define std/net/httpd/handler#skip-request-body
    (lambda (_ibuf739_ _headers740_)
      (letrec ((_skip-simple-body742_
                (lambda ()
                  (let ((_clen749751_
                         (std/net/httpd/handler#header-e
                          '"Content-Length"
                          _headers740_)))
                    (if _clen749751_
                        (let* ((_clen754_ _clen749751_)
                               (_len756_ (string->number _clen754_)))
                          (if (fixnum? _len756_)
                              (std/net/bio/input#bio-input-skip
                               _len756_
                               _ibuf739_)
                              (std/error#raise-io-error
                               'http-request-skip-body
                               '"Illegal body length"
                               _clen754_)))
                        '#f)))))
        (let ((_$e744_ (std/net/httpd/handler#header-e
                        '"Transfer-Encoding"
                        _headers740_)))
          (if _$e744_
              ((lambda (_tenc747_)
                 (if (not (equal? '"identity" _tenc747_))
                     (std/net/httpd/handler#skip-request-chunks _ibuf739_)
                     (_skip-simple-body742_)))
               _$e744_)
              (_skip-simple-body742_))))))
  (define std/net/httpd/handler#skip-request-chunks
    (lambda (_ibuf731_)
      (let* ((_next733_
              (std/net/httpd/handler#read-token
               _ibuf731_
               std/net/httpd/handler#CR))
             (_g6596_ (std/net/httpd/handler#read-skip__0
                       _ibuf731_
                       std/net/httpd/handler#LF))
             (_len736_ (string->number _next733_ '16)))
        (if (fx> _len736_ '0)
            (begin
              (std/net/bio/input#bio-input-skip _len736_ _ibuf731_)
              (std/net/httpd/handler#read-skip__1
               _ibuf731_
               std/net/httpd/handler#CR
               std/net/httpd/handler#LF)
              (std/net/httpd/handler#skip-request-chunks _ibuf731_))
            '#!void))))
  (define std/net/httpd/handler#write-response-line
    (lambda (_obuf723_ _status724_)
      (let ((_text729_
             (let ((_$e726_ (table-ref
                             std/net/httpd/handler#+http-response-codes+
                             _status724_
                             '#f)))
               (if _$e726_ (values _$e726_) '"Gremlins!"))))
        (std/net/bio/output#bio-write-string '"HTTP/1.1" _obuf723_)
        (std/net/bio/output#bio-write-u8 std/net/httpd/handler#SPC _obuf723_)
        (std/net/bio/output#bio-write-string
         (number->string _status724_)
         _obuf723_)
        (std/net/bio/output#bio-write-u8 std/net/httpd/handler#SPC _obuf723_)
        (std/net/bio/output#bio-write-string _text729_ _obuf723_)
        (std/net/httpd/handler#write-crlf _obuf723_))))
  (define std/net/httpd/handler#write-response-headers
    (lambda (_obuf688_ _headers689_)
      (letrec ((_write-header691_
                (lambda (_hdr693_)
                  (let* ((_hdr694701_ _hdr693_)
                         (_E696705_
                          (lambda ()
                            (error '"No clause matching" _hdr694701_)))
                         (_K697711_
                          (lambda (_val708_ _key709_)
                            (if (string? _key709_)
                                (if (string? _val708_)
                                    (begin
                                      (std/net/bio/output#bio-write-string
                                       _key709_
                                       _obuf688_)
                                      (std/net/bio/output#bio-write-u8
                                       std/net/httpd/handler#COL
                                       _obuf688_)
                                      (std/net/bio/output#bio-write-u8
                                       std/net/httpd/handler#SPC
                                       _obuf688_)
                                      (std/net/bio/output#bio-write-string
                                       _val708_
                                       _obuf688_)
                                      (std/net/httpd/handler#write-crlf
                                       _obuf688_))
                                    (error '"Bad header value; expected string"
                                           _hdr693_
                                           _val708_))
                                (error '"Bad header key; expected string"
                                       _hdr693_
                                       _key709_)))))
                    (if (##pair? _hdr694701_)
                        (let ((_hd698714_ (##car _hdr694701_))
                              (_tl699716_ (##cdr _hdr694701_)))
                          (let* ((_key719_ _hd698714_) (_val721_ _tl699716_))
                            (_K697711_ _val721_ _key719_)))
                        (_E696705_))))))
        (for-each _write-header691_ _headers689_))))
  (define std/net/httpd/handler#write-crlf
    (lambda (_obuf686_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#CR _obuf686_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#LF _obuf686_)))
  (define std/net/httpd/handler#write-chunk
    (lambda (_obuf676_ _chunk677_ _start678_ _end679_)
      (let* ((_end681_
              (if _end679_
                  _end679_
                  (if (u8vector? _chunk677_)
                      (u8vector-length _chunk677_)
                      (if (string? _chunk677_)
                          (string-length _chunk677_)
                          (if (not _chunk677_)
                              '0
                              (error '"Bad chunk; expected u8vector or string"
                                     _chunk677_))))))
             (_len683_
              (if (u8vector? _chunk677_)
                  (fx- _end681_ _start678_)
                  (if (string? _chunk677_)
                      (std/text/utf8#string-utf8-length__%
                       _chunk677_
                       _start678_
                       _end681_)
                      '0))))
        (if (fx> _len683_ '0)
            (begin
              (std/net/bio/output#bio-write-string
               (number->string _len683_ '16)
               _obuf676_)
              (std/net/httpd/handler#write-crlf _obuf676_)
              (if (u8vector? _chunk677_)
                  (std/net/bio/output#bio-write-subu8vector
                   _chunk677_
                   _start678_
                   _end681_
                   _obuf676_)
                  (if (string? _chunk677_)
                      (std/net/bio/output#bio-write-substring
                       _chunk677_
                       _start678_
                       _end681_
                       _obuf676_)
                      '#!void))
              (std/net/httpd/handler#write-crlf _obuf676_))
            '#!void))))
  (define std/net/httpd/handler#write-last-chunk
    (lambda (_obuf674_)
      (std/net/bio/output#bio-write-u8 std/net/httpd/handler#C0 _obuf674_)
      (std/net/httpd/handler#write-crlf _obuf674_)
      (std/net/httpd/handler#write-crlf _obuf674_)))
  (define std/net/httpd/handler#C0 (char->integer '#\0))
  (define std/net/httpd/handler#CR (char->integer '#\return))
  (define std/net/httpd/handler#LF (char->integer '#\newline))
  (define std/net/httpd/handler#COL (char->integer '#\:))
  (define std/net/httpd/handler#SPC (char->integer '#\space))
  (define std/net/httpd/handler#QMARK (char->integer '#\?))
  (define std/net/httpd/handler#+http-request-methods+
    (let ((_ht671_ (make-table 'size: '7)))
      (table-set! _ht671_ '"GET" 'GET)
      (table-set! _ht671_ '"HEAD" 'HEAD)
      (table-set! _ht671_ '"POST" 'POST)
      (table-set! _ht671_ '"PUT" 'PUT)
      (table-set! _ht671_ '"DELETE" 'DELETE)
      (table-set! _ht671_ '"TRACE" 'TRACE)
      (table-set! _ht671_ '"OPTIONS" 'OPTIONS)
      _ht671_))
  (define std/net/httpd/handler#+http-response-codes+
    (let ((_ht668_ (make-table 'test: eq? 'size: '40)))
      (table-set! _ht668_ '100 '"Continue")
      (table-set! _ht668_ '101 '"Switching Protocols")
      (table-set! _ht668_ '200 '"OK")
      (table-set! _ht668_ '201 '"Created")
      (table-set! _ht668_ '202 '"Accepted")
      (table-set! _ht668_ '203 '"Non-Authoritative Information")
      (table-set! _ht668_ '204 '"No Content")
      (table-set! _ht668_ '205 '"Reset Content")
      (table-set! _ht668_ '206 '"Partial Content")
      (table-set! _ht668_ '300 '"Multiple Choices")
      (table-set! _ht668_ '301 '"Moved Permanently")
      (table-set! _ht668_ '302 '"Found")
      (table-set! _ht668_ '303 '"See Other")
      (table-set! _ht668_ '304 '"Not Modified")
      (table-set! _ht668_ '305 '"Use Proxy")
      (table-set! _ht668_ '307 '"Temporary Redirect")
      (table-set! _ht668_ '400 '"Bad Request")
      (table-set! _ht668_ '401 '"Unauthorized")
      (table-set! _ht668_ '402 '"Payment Required")
      (table-set! _ht668_ '403 '"Forbidden")
      (table-set! _ht668_ '404 '"Not Found")
      (table-set! _ht668_ '405 '"Method Not Allowed")
      (table-set! _ht668_ '406 '"Not Acceptable")
      (table-set! _ht668_ '407 '"Proxy Authentication Required")
      (table-set! _ht668_ '408 '"Request Timeout")
      (table-set! _ht668_ '409 '"Conflict")
      (table-set! _ht668_ '410 '"Gone")
      (table-set! _ht668_ '411 '"Length Required")
      (table-set! _ht668_ '412 '"Precondition Failed")
      (table-set! _ht668_ '413 '"Request Entity Too Large")
      (table-set! _ht668_ '414 '"Request-URI Too Long")
      (table-set! _ht668_ '415 '"Unsupported Media Type")
      (table-set! _ht668_ '416 '"Requested Range Not Satisfiable")
      (table-set! _ht668_ '417 '"Expectation Failed")
      (table-set! _ht668_ '500 '"Internal Server Error")
      (table-set! _ht668_ '501 '"Not Implemented")
      (table-set! _ht668_ '502 '"Bad Gateway")
      (table-set! _ht668_ '503 '"Service Unavailable")
      (table-set! _ht668_ '504 '"Gateway Timeout")
      (table-set! _ht668_ '505 '"HTTP Version Not Supported")
      _ht668_))
  (define std/net/httpd/handler#+input-buffers+ '())
  (define std/net/httpd/handler#+output-buffers+ '())
  (define std/net/httpd/handler#+token-buffers+ '())
  (define std/net/httpd/handler#get-input-buffer
    (lambda (_sock632_)
      (declare (not interrupts-enabled))
      (let* ((_+input-buffers+634642_ std/net/httpd/handler#+input-buffers+)
             (_else636650_
              (lambda ()
                (std/net/socket/buffer#open-ssocket-input-buffer__%
                 _sock632_
                 std/net/httpd/handler#input-buffer-size)))
             (_K638656_
              (lambda (_rest653_ _buf654_)
                (set! std/net/httpd/handler#+input-buffers+ _rest653_)
                (std/net/socket/buffer#ssocket-input-buffer-reset!
                 _buf654_
                 _sock632_)
                _buf654_)))
        (if (##pair? _+input-buffers+634642_)
            (let ((_hd639659_ (##car _+input-buffers+634642_))
                  (_tl640661_ (##cdr _+input-buffers+634642_)))
              (let* ((_buf664_ _hd639659_) (_rest666_ _tl640661_))
                (_K638656_ _rest666_ _buf664_)))
            (_else636650_)))))
  (define std/net/httpd/handler#put-input-buffer!
    (lambda (_buf629_)
      (declare (not interrupts-enabled))
      (begin
        (std/net/socket/buffer#ssocket-input-buffer-release! _buf629_)
        (set! std/net/httpd/handler#+input-buffers+
              (cons _buf629_ std/net/httpd/handler#+input-buffers+)))))
  (define std/net/httpd/handler#get-output-buffer
    (lambda (_sock593_)
      (declare (not interrupts-enabled))
      (let* ((_+output-buffers+595603_ std/net/httpd/handler#+output-buffers+)
             (_else597611_
              (lambda ()
                (std/net/socket/buffer#open-ssocket-output-buffer__%
                 _sock593_
                 std/net/httpd/handler#output-buffer-size)))
             (_K599617_
              (lambda (_rest614_ _buf615_)
                (set! std/net/httpd/handler#+output-buffers+ _rest614_)
                (std/net/socket/buffer#ssocket-output-buffer-reset!
                 _buf615_
                 _sock593_)
                _buf615_)))
        (if (##pair? _+output-buffers+595603_)
            (let ((_hd600620_ (##car _+output-buffers+595603_))
                  (_tl601622_ (##cdr _+output-buffers+595603_)))
              (let* ((_buf625_ _hd600620_) (_rest627_ _tl601622_))
                (_K599617_ _rest627_ _buf625_)))
            (_else597611_)))))
  (define std/net/httpd/handler#put-output-buffer!
    (lambda (_buf590_)
      (declare (not interrupts-enabled))
      (begin
        (std/net/socket/buffer#ssocket-output-buffer-release! _buf590_)
        (set! std/net/httpd/handler#+output-buffers+
              (cons _buf590_ std/net/httpd/handler#+output-buffers+)))))
  (define std/net/httpd/handler#get-token-buffer
    (lambda ()
      (declare (not interrupts-enabled))
      (let* ((_+token-buffers+556564_ std/net/httpd/handler#+token-buffers+)
             (_else558572_
              (lambda () (make-string std/net/httpd/handler#max-token-length)))
             (_K560578_
              (lambda (_rest575_ _buf576_)
                (set! std/net/httpd/handler#+token-buffers+ _rest575_)
                _buf576_)))
        (if (##pair? _+token-buffers+556564_)
            (let ((_hd561581_ (##car _+token-buffers+556564_))
                  (_tl562583_ (##cdr _+token-buffers+556564_)))
              (let* ((_buf586_ _hd561581_) (_rest588_ _tl562583_))
                (_K560578_ _rest588_ _buf586_)))
            (_else558572_)))))
  (define std/net/httpd/handler#put-token-buffer!
    (lambda (_buf552_)
      (declare (not interrupts-enabled))
      (set! std/net/httpd/handler#+token-buffers+
            (cons _buf552_ std/net/httpd/handler#+token-buffers+)))))
