/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.PainlessError;
import org.elasticsearch.painless.PainlessExplainError;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.ir.BinaryImplNode;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.CatchNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.DeclarationNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.ir.InvokeCallMemberNode;
import org.elasticsearch.painless.ir.InvokeCallNode;
import org.elasticsearch.painless.ir.LoadFieldMemberNode;
import org.elasticsearch.painless.ir.LoadVariableNode;
import org.elasticsearch.painless.ir.NullNode;
import org.elasticsearch.painless.ir.ReturnNode;
import org.elasticsearch.painless.ir.StaticNode;
import org.elasticsearch.painless.ir.ThrowNode;
import org.elasticsearch.painless.ir.TryNode;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.phase.DefaultUserTreeToIRTreePhase;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.script.ScriptException;
import org.objectweb.asm.commons.Method;

public class PainlessUserTreeToIRTreePhase
extends DefaultUserTreeToIRTreePhase {
    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String functionName = userFunctionNode.getFunctionName();
        if ("execute".equals(functionName)) {
            ScriptClassInfo scriptClassInfo = scriptScope.getScriptClassInfo();
            FunctionTable.LocalFunction localFunction = scriptScope.getFunctionTable().getFunction(functionName, scriptClassInfo.getExecuteArguments().size());
            Class<?> returnType = localFunction.getReturnType();
            boolean methodEscape = scriptScope.getCondition(userFunctionNode, Decorations.MethodEscape.class);
            BlockNode irBlockNode = (BlockNode)this.visit(userFunctionNode.getBlockNode(), scriptScope);
            if (!methodEscape) {
                ExpressionNode irExpressionNode;
                if (returnType == Void.TYPE) {
                    irExpressionNode = null;
                } else if (returnType.isPrimitive()) {
                    ConstantNode irConstantNode = new ConstantNode(userFunctionNode.getLocation());
                    irConstantNode.setExpressionType(returnType);
                    if (returnType == Boolean.TYPE) {
                        irConstantNode.setConstant(false);
                    } else if (returnType == Byte.TYPE || returnType == Character.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE) {
                        irConstantNode.setConstant(0);
                    } else if (returnType == Long.TYPE) {
                        irConstantNode.setConstant(0L);
                    } else if (returnType == Float.TYPE) {
                        irConstantNode.setConstant(Float.valueOf(0.0f));
                    } else if (returnType == Double.TYPE) {
                        irConstantNode.setConstant(0.0);
                    } else {
                        throw userFunctionNode.createError(new IllegalStateException("illegal tree structure"));
                    }
                    irExpressionNode = irConstantNode;
                } else {
                    irExpressionNode = new NullNode(userFunctionNode.getLocation());
                    irExpressionNode.setExpressionType(returnType);
                }
                ReturnNode irReturnNode = new ReturnNode(userFunctionNode.getLocation());
                irReturnNode.setExpressionNode(irExpressionNode);
                irBlockNode.addStatementNode(irReturnNode);
            }
            ArrayList<String> parameterNames = new ArrayList<String>(scriptClassInfo.getExecuteArguments().size());
            for (ScriptClassInfo.MethodArgument methodArgument : scriptClassInfo.getExecuteArguments()) {
                parameterNames.add(methodArgument.getName());
            }
            FunctionNode irFunctionNode = new FunctionNode(userFunctionNode.getLocation());
            irFunctionNode.setBlockNode(irBlockNode);
            irFunctionNode.setName("execute");
            irFunctionNode.setReturnType(returnType);
            irFunctionNode.getTypeParameters().addAll(localFunction.getTypeParameters());
            irFunctionNode.getParameterNames().addAll(parameterNames);
            irFunctionNode.setStatic(false);
            irFunctionNode.setVarArgs(false);
            irFunctionNode.setSynthetic(false);
            irFunctionNode.setMaxLoopCounter(scriptScope.getCompilerSettings().getMaxLoopCounter());
            this.injectStaticFieldsAndGetters();
            this.injectGetsDeclarations(irBlockNode, scriptScope);
            this.injectNeedsMethods(scriptScope);
            this.injectSandboxExceptions(irFunctionNode);
            scriptScope.putDecoration(userFunctionNode, new Decorations.IRNodeDecoration(irFunctionNode));
        } else {
            super.visitFunction(userFunctionNode, scriptScope);
        }
    }

    protected void injectStaticFieldsAndGetters() {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectStaticFieldsAndGetters", 0);
        int modifiers = 9;
        FieldNode irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(String.class);
        irFieldNode.setName("$NAME");
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(String.class);
        irFieldNode.setName("$SOURCE");
        this.irClassNode.addFieldNode(irFieldNode);
        irFieldNode = new FieldNode(internalLocation);
        irFieldNode.setModifiers(modifiers);
        irFieldNode.setFieldType(BitSet.class);
        irFieldNode.setName("$STATEMENTS");
        this.irClassNode.addFieldNode(irFieldNode);
        FunctionNode irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.setName("getName");
        irFunctionNode.setReturnType(String.class);
        irFunctionNode.setStatic(false);
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(true);
        irFunctionNode.setMaxLoopCounter(0);
        this.irClassNode.addFunctionNode(irFunctionNode);
        BlockNode irBlockNode = new BlockNode(internalLocation);
        irBlockNode.setAllEscape(true);
        irFunctionNode.setBlockNode(irBlockNode);
        ReturnNode irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.setExpressionType(String.class);
        irLoadFieldMemberNode.setName("$NAME");
        irLoadFieldMemberNode.setStatic(true);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
        irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.setName("getSource");
        irFunctionNode.setReturnType(String.class);
        irFunctionNode.setStatic(false);
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(true);
        irFunctionNode.setMaxLoopCounter(0);
        this.irClassNode.addFunctionNode(irFunctionNode);
        irBlockNode = new BlockNode(internalLocation);
        irBlockNode.setAllEscape(true);
        irFunctionNode.setBlockNode(irBlockNode);
        irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.setExpressionType(String.class);
        irLoadFieldMemberNode.setName("$SOURCE");
        irLoadFieldMemberNode.setStatic(true);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
        irFunctionNode = new FunctionNode(internalLocation);
        irFunctionNode.setName("getStatements");
        irFunctionNode.setReturnType(BitSet.class);
        irFunctionNode.setStatic(false);
        irFunctionNode.setVarArgs(false);
        irFunctionNode.setSynthetic(true);
        irFunctionNode.setMaxLoopCounter(0);
        this.irClassNode.addFunctionNode(irFunctionNode);
        irBlockNode = new BlockNode(internalLocation);
        irBlockNode.setAllEscape(true);
        irFunctionNode.setBlockNode(irBlockNode);
        irReturnNode = new ReturnNode(internalLocation);
        irBlockNode.addStatementNode(irReturnNode);
        irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
        irLoadFieldMemberNode.setExpressionType(BitSet.class);
        irLoadFieldMemberNode.setName("$STATEMENTS");
        irLoadFieldMemberNode.setStatic(true);
        irReturnNode.setExpressionNode(irLoadFieldMemberNode);
    }

    protected void injectGetsDeclarations(BlockNode irBlockNode, ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectGetsDeclarations", 0);
        for (int i = 0; i < scriptScope.getScriptClassInfo().getGetMethods().size(); ++i) {
            Method getMethod = scriptScope.getScriptClassInfo().getGetMethods().get(i);
            String name = getMethod.getName().substring(3);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            if (!scriptScope.getUsedVariables().contains(name)) continue;
            Class<?> returnType = scriptScope.getScriptClassInfo().getGetReturns().get(i);
            DeclarationNode irDeclarationNode = new DeclarationNode(internalLocation);
            irDeclarationNode.setName(name);
            irDeclarationNode.setDeclarationType(returnType);
            irBlockNode.getStatementsNodes().add(0, irDeclarationNode);
            InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
            irInvokeCallMemberNode.setExpressionType(irDeclarationNode.getDeclarationType());
            irInvokeCallMemberNode.setLocalFunction(new FunctionTable.LocalFunction(getMethod.getName(), returnType, Collections.emptyList(), true, false));
            irDeclarationNode.setExpressionNode(irInvokeCallMemberNode);
        }
    }

    protected void injectNeedsMethods(ScriptScope scriptScope) {
        Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectNeedsMethods", 0);
        for (Method needsMethod : scriptScope.getScriptClassInfo().getNeedsMethods()) {
            String name = needsMethod.getName();
            name = name.substring(5);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            FunctionNode irFunctionNode = new FunctionNode(internalLocation);
            irFunctionNode.setName(needsMethod.getName());
            irFunctionNode.setReturnType(Boolean.TYPE);
            irFunctionNode.setStatic(false);
            irFunctionNode.setVarArgs(false);
            irFunctionNode.setSynthetic(true);
            irFunctionNode.setMaxLoopCounter(0);
            this.irClassNode.addFunctionNode(irFunctionNode);
            BlockNode irBlockNode = new BlockNode(internalLocation);
            irBlockNode.setAllEscape(true);
            irFunctionNode.setBlockNode(irBlockNode);
            ReturnNode irReturnNode = new ReturnNode(internalLocation);
            irBlockNode.addStatementNode(irReturnNode);
            ConstantNode irConstantNode = new ConstantNode(internalLocation);
            irConstantNode.setExpressionType(Boolean.TYPE);
            irConstantNode.setConstant(scriptScope.getUsedVariables().contains(name));
            irReturnNode.setExpressionNode(irConstantNode);
        }
    }

    protected void injectSandboxExceptions(FunctionNode irFunctionNode) {
        try {
            Location internalLocation = new Location("$internal$ScriptInjectionPhase$injectSandboxExceptions", 0);
            BlockNode irBlockNode = irFunctionNode.getBlockNode();
            TryNode irTryNode = new TryNode(internalLocation);
            irTryNode.setBlockNode(irBlockNode);
            CatchNode irCatchNode = new CatchNode(internalLocation);
            irCatchNode.setExceptionType(PainlessExplainError.class);
            irCatchNode.setSymbol("#painlessExplainError");
            irTryNode.addCatchNode(irCatchNode);
            BlockNode irCatchBlockNode = new BlockNode(internalLocation);
            irCatchBlockNode.setAllEscape(true);
            irCatchNode.setBlockNode(irCatchBlockNode);
            ThrowNode irThrowNode = new ThrowNode(internalLocation);
            irCatchBlockNode.addStatementNode(irThrowNode);
            InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
            irInvokeCallMemberNode.setExpressionType(ScriptException.class);
            irInvokeCallMemberNode.setLocalFunction(new FunctionTable.LocalFunction("convertToScriptException", ScriptException.class, Arrays.asList(Throwable.class, Map.class), true, false));
            irThrowNode.setExpressionNode(irInvokeCallMemberNode);
            LoadVariableNode irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(ScriptException.class);
            irLoadVariableNode.setName("#painlessExplainError");
            irInvokeCallMemberNode.addArgumentNode(irLoadVariableNode);
            BinaryImplNode irBinaryImplNode = new BinaryImplNode(internalLocation);
            irBinaryImplNode.setExpressionType(Map.class);
            irInvokeCallMemberNode.addArgumentNode(irBinaryImplNode);
            irLoadVariableNode = new LoadVariableNode(internalLocation);
            irLoadVariableNode.setExpressionType(PainlessExplainError.class);
            irLoadVariableNode.setName("#painlessExplainError");
            irBinaryImplNode.setLeftNode(irLoadVariableNode);
            InvokeCallNode irInvokeCallNode = new InvokeCallNode(internalLocation);
            irInvokeCallNode.setExpressionType(Map.class);
            irInvokeCallNode.setBox(PainlessExplainError.class);
            irInvokeCallNode.setMethod(new PainlessMethod(PainlessExplainError.class.getMethod("getHeaders", PainlessLookup.class), PainlessExplainError.class, null, Collections.emptyList(), null, null, null));
            irBinaryImplNode.setRightNode(irInvokeCallNode);
            LoadFieldMemberNode irLoadFieldMemberNode = new LoadFieldMemberNode(internalLocation);
            irLoadFieldMemberNode.setExpressionType(PainlessLookup.class);
            irLoadFieldMemberNode.setName("$DEFINITION");
            irLoadFieldMemberNode.setStatic(true);
            irInvokeCallNode.addArgumentNode(irLoadFieldMemberNode);
            for (Class throwable : new Class[]{PainlessError.class, BootstrapMethodError.class, OutOfMemoryError.class, StackOverflowError.class, Exception.class}) {
                String name = throwable.getSimpleName();
                name = "#" + Character.toLowerCase(name.charAt(0)) + name.substring(1);
                irCatchNode = new CatchNode(internalLocation);
                irCatchNode.setExceptionType(throwable);
                irCatchNode.setSymbol(name);
                irTryNode.addCatchNode(irCatchNode);
                irCatchBlockNode = new BlockNode(internalLocation);
                irCatchBlockNode.setAllEscape(true);
                irCatchNode.setBlockNode(irCatchBlockNode);
                irThrowNode = new ThrowNode(internalLocation);
                irCatchBlockNode.addStatementNode(irThrowNode);
                irInvokeCallMemberNode = new InvokeCallMemberNode(internalLocation);
                irInvokeCallMemberNode.setExpressionType(ScriptException.class);
                irInvokeCallMemberNode.setLocalFunction(new FunctionTable.LocalFunction("convertToScriptException", ScriptException.class, Arrays.asList(Throwable.class, Map.class), true, false));
                irThrowNode.setExpressionNode(irInvokeCallMemberNode);
                irLoadVariableNode = new LoadVariableNode(internalLocation);
                irLoadVariableNode.setExpressionType(ScriptException.class);
                irLoadVariableNode.setName(name);
                irInvokeCallMemberNode.addArgumentNode(irLoadVariableNode);
                irBinaryImplNode = new BinaryImplNode(internalLocation);
                irBinaryImplNode.setExpressionType(Map.class);
                irInvokeCallMemberNode.addArgumentNode(irBinaryImplNode);
                StaticNode irStaticNode = new StaticNode(internalLocation);
                irStaticNode.setExpressionType(Collections.class);
                irBinaryImplNode.setLeftNode(irStaticNode);
                irInvokeCallNode = new InvokeCallNode(internalLocation);
                irInvokeCallNode.setExpressionType(Map.class);
                irInvokeCallNode.setBox(Collections.class);
                irInvokeCallNode.setMethod(new PainlessMethod(Collections.class.getMethod("emptyMap", new Class[0]), Collections.class, null, Collections.emptyList(), null, null, null));
                irBinaryImplNode.setRightNode(irInvokeCallNode);
            }
            irBlockNode = new BlockNode(internalLocation);
            irBlockNode.setAllEscape(true);
            irBlockNode.addStatementNode(irTryNode);
            irFunctionNode.setBlockNode(irBlockNode);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, ScriptScope scriptScope) {
        super.visitExpression(userExpressionNode, scriptScope);
        this.injectConverter(userExpressionNode, scriptScope);
    }

    @Override
    public void visitReturn(SReturn userReturnNode, ScriptScope scriptScope) {
        super.visitReturn(userReturnNode, scriptScope);
        this.injectConverter(userReturnNode, scriptScope);
    }

    public void injectConverter(AStatement userStatementNode, ScriptScope scriptScope) {
        Decorations.Converter converter = scriptScope.getDecoration(userStatementNode, Decorations.Converter.class);
        if (converter == null) {
            return;
        }
        Decorations.IRNodeDecoration irNodeDecoration = scriptScope.getDecoration(userStatementNode, Decorations.IRNodeDecoration.class);
        IRNode irNode = irNodeDecoration.getIRNode();
        if (!(irNode instanceof ReturnNode)) {
            throw userStatementNode.createError(new IllegalStateException("illegal tree structure"));
        }
        ReturnNode returnNode = (ReturnNode)irNode;
        InvokeCallMemberNode irInvokeCallMemberNode = new InvokeCallMemberNode(userStatementNode.getLocation());
        irInvokeCallMemberNode.setLocalFunction(converter.getConverter());
        ExpressionNode returnExpression = returnNode.getExpressionNode();
        returnNode.setExpressionNode(irInvokeCallMemberNode);
        irInvokeCallMemberNode.addArgumentNode(returnExpression);
    }
}

