#! /bin/bash

if [ "$#" -ge "1" ]; then
    cd "$1"
    if [ $? -ne "0" ]; then
        echo "(inaccessible)"
        exit
    fi
fi

git_output=$(git status -b --porcelain=v2 2>/dev/null)

if [ "$?" -ne 0 ]; then
    echo "directory"
else
    branch=$(echo "$git_output" | grep branch.head | cut -c15-)
    echo "directory (git $branch)"
fi
