/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Conditional;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.StopWatch;
import com.github.cereda.arara.utils.CommonUtils;
import com.github.cereda.arara.utils.ConfigurationUtils;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayUtils {
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(DisplayUtils.class);

    private static void buildShortEntry(String name, String task) {
        int width = DisplayUtils.getWidth();
        int result = DisplayUtils.getLongestMatch();
        if (result >= width) {
            result = 10;
        }
        int space = width - result - 1;
        StringBuilder entry = new StringBuilder();
        entry.append("(").append(name).append(") ");
        entry.append(task).append(" ");
        String line = StringUtils.abbreviate(entry.toString(), space - 4);
        entry = new StringBuilder();
        entry.append(StringUtils.rightPad(line, space, ".")).append(" ");
        System.out.print(entry);
    }

    private static void buildShortResult(boolean value) {
        int result = DisplayUtils.getLongestMatch();
        System.out.println(StringUtils.leftPad(DisplayUtils.getResult(value), result));
    }

    public static void printEntryResult(boolean value) {
        ConfigurationController.getInstance().put("display.line", false);
        ConfigurationController.getInstance().put("display.result", true);
        ConfigurationController.getInstance().put("execution.status", value ? 0 : 1);
        logger.info(messages.getMessage(Messages.LOG_INFO_TASK_RESULT).concat(" ").concat(DisplayUtils.getResult(value)));
        if (!DisplayUtils.isDryRunMode()) {
            if (!DisplayUtils.isVerboseMode()) {
                DisplayUtils.buildShortResult(value);
            } else {
                DisplayUtils.buildLongResult(value);
            }
        }
    }

    private static void buildLongResult(boolean value) {
        int width = DisplayUtils.getWidth();
        System.out.println("\n".concat(StringUtils.leftPad(" ".concat(DisplayUtils.getResult(value)), width, "-")));
    }

    public static void printEntry(String name, String task) {
        logger.info(messages.getMessage(Messages.LOG_INFO_INTERPRET_TASK, task, name));
        ConfigurationController.getInstance().put("display.line", true);
        ConfigurationController.getInstance().put("display.result", false);
        if (!DisplayUtils.isDryRunMode()) {
            if (!DisplayUtils.isVerboseMode()) {
                DisplayUtils.buildShortEntry(name, task);
            } else {
                DisplayUtils.buildLongEntry(name, task);
            }
        } else {
            DisplayUtils.buildDryRunEntry(name, task);
        }
    }

    private static int getLongestMatch() {
        String[] values = new String[]{messages.getMessage(Messages.INFO_LABEL_ON_SUCCESS), messages.getMessage(Messages.INFO_LABEL_ON_FAILURE), messages.getMessage(Messages.INFO_LABEL_ON_ERROR)};
        int max = values[0].length();
        for (String value : values) {
            if (max >= value.length()) continue;
            max = value.length();
        }
        return max;
    }

    private static void buildLongEntry(String name, String task) {
        if (ConfigurationController.getInstance().contains("display.rolling")) {
            DisplayUtils.addNewLine();
        } else {
            ConfigurationController.getInstance().put("display.rolling", true);
        }
        StringBuilder line = new StringBuilder();
        line.append("(").append(name).append(") ");
        line.append(task);
        System.out.println(DisplayUtils.displaySeparator());
        System.out.println(StringUtils.abbreviate(line.toString(), DisplayUtils.getWidth()));
        System.out.println(DisplayUtils.displaySeparator());
    }

    private static void buildDryRunEntry(String name, String task) {
        if (ConfigurationController.getInstance().contains("display.rolling")) {
            DisplayUtils.addNewLine();
        } else {
            ConfigurationController.getInstance().put("display.rolling", true);
        }
        StringBuilder line = new StringBuilder();
        line.append("[DR] (").append(name).append(") ");
        line.append(task);
        System.out.println(StringUtils.abbreviate(line.toString(), DisplayUtils.getWidth()));
        System.out.println(DisplayUtils.displaySeparator());
    }

    public static void printException(AraraException exception) {
        ConfigurationController.getInstance().put("display.exception", true);
        ConfigurationController.getInstance().put("execution.status", 2);
        boolean display = false;
        if (ConfigurationController.getInstance().contains("display.line")) {
            display = (Boolean)ConfigurationController.getInstance().get("display.line");
        }
        if (ConfigurationController.getInstance().contains("display.result") && ((Boolean)ConfigurationController.getInstance().get("display.result")).booleanValue()) {
            DisplayUtils.addNewLine();
        }
        if (display && !DisplayUtils.isDryRunMode()) {
            if (!DisplayUtils.isVerboseMode()) {
                DisplayUtils.buildShortError();
            } else {
                DisplayUtils.buildLongError();
            }
            DisplayUtils.addNewLine();
        }
        String text = exception.hasException() ? exception.getMessage().concat(" ").concat(messages.getMessage(Messages.INFO_DISPLAY_EXCEPTION_MORE_DETAILS)) : exception.getMessage();
        logger.error(text);
        DisplayUtils.wrapText(text);
        if (exception.hasException()) {
            DisplayUtils.addNewLine();
            DisplayUtils.displayDetailsLine();
            String details = exception.getException().getMessage();
            logger.error(details);
            DisplayUtils.wrapText(details);
        }
    }

    private static String getResult(boolean value) {
        return value ? messages.getMessage(Messages.INFO_LABEL_ON_SUCCESS) : messages.getMessage(Messages.INFO_LABEL_ON_FAILURE);
    }

    private static void buildShortError() {
        int result = DisplayUtils.getLongestMatch();
        System.out.println(StringUtils.leftPad(messages.getMessage(Messages.INFO_LABEL_ON_ERROR), result));
    }

    private static void buildLongError() {
        String line = StringUtils.leftPad(" ".concat(messages.getMessage(Messages.INFO_LABEL_ON_ERROR)), DisplayUtils.getWidth(), "-");
        System.out.println(line);
    }

    private static int getWidth() {
        return (Integer)ConfigurationController.getInstance().get("application.width");
    }

    public static void wrapText(String text) {
        System.out.println(WordUtils.wrap(text, DisplayUtils.getWidth()));
    }

    private static boolean isDryRunMode() {
        return (Boolean)ConfigurationController.getInstance().get("execution.dryrun");
    }

    private static boolean isVerboseMode() {
        return (Boolean)ConfigurationController.getInstance().get("execution.verbose");
    }

    public static void printAuthors(List<String> authors) {
        StringBuilder line = new StringBuilder();
        line.append(authors.size() == 1 ? messages.getMessage(Messages.INFO_LABEL_AUTHOR) : messages.getMessage(Messages.INFO_LABEL_AUTHORS));
        String text = authors.isEmpty() ? messages.getMessage(Messages.INFO_LABEL_NO_AUTHORS) : CommonUtils.getCollectionElements(CommonUtils.trimSpaces(authors), "", "", ", ");
        line.append(" ").append(text);
        DisplayUtils.wrapText(line.toString());
    }

    public static void printConditional(Conditional conditional) {
        if (conditional.getType() != Conditional.ConditionalType.NONE) {
            StringBuilder line = new StringBuilder();
            line.append(messages.getMessage(Messages.INFO_LABEL_CONDITIONAL));
            line.append(" (");
            line.append(String.valueOf((Object)conditional.getType()));
            line.append(") ").append(conditional.getCondition());
            DisplayUtils.wrapText(line.toString());
        }
    }

    public static void printFileInformation() {
        File file = (File)ConfigurationController.getInstance().get("execution.reference");
        String version = (String)ConfigurationController.getInstance().get("application.version");
        String revision = (String)ConfigurationController.getInstance().get("application.revision");
        String line = messages.getMessage(Messages.INFO_DISPLAY_FILE_INFORMATION, file.getName(), CommonUtils.calculateFileSize(file), CommonUtils.getLastModifiedInformation(file));
        logger.info(messages.getMessage(Messages.LOG_INFO_WELCOME_MESSAGE, version, revision));
        logger.info(DisplayUtils.displaySeparator());
        logger.info(String.format("::: arara @ %s", DisplayUtils.getApplicationPath()));
        logger.info(String.format("::: Java %s, %s", CommonUtils.getSystemProperty("java.version", "[unknown version]"), CommonUtils.getSystemProperty("java.vendor", "[unknown vendor]")));
        logger.info(String.format("::: %s", CommonUtils.getSystemProperty("java.home", "[unknown location]")));
        logger.info(String.format("::: %s, %s, %s", CommonUtils.getSystemProperty("os.name", "[unknown OS name]"), CommonUtils.getSystemProperty("os.arch", "[unknown OS arch]"), CommonUtils.getSystemProperty("os.version", "[unknown OS version]")));
        logger.info(String.format("::: user.home @ %s", CommonUtils.getSystemProperty("user.home", "[unknown user's home directory]")));
        logger.info(String.format("::: user.dir @ %s", CommonUtils.getSystemProperty("user.dir", "[unknown user's working directory]")));
        logger.info(String.format("::: CF @ %s", (String)ConfigurationController.getInstance().get("execution.configuration.name")));
        logger.info(DisplayUtils.displaySeparator());
        logger.info(line);
        DisplayUtils.wrapText(line);
        DisplayUtils.addNewLine();
    }

    public static void printTime() {
        if (ConfigurationController.getInstance().contains("display.time")) {
            if (ConfigurationController.getInstance().contains("display.line") || ConfigurationController.getInstance().contains("display.exception")) {
                DisplayUtils.addNewLine();
            }
            String text = messages.getMessage(Messages.INFO_DISPLAY_EXECUTION_TIME, StopWatch.getTime());
            logger.info(text);
            DisplayUtils.wrapText(text);
        }
    }

    public static void printLogo() {
        StringBuilder builder = new StringBuilder();
        builder.append("  __ _ _ __ __ _ _ __ __ _ ").append("\n");
        builder.append(" / _` | '__/ _` | '__/ _` |").append("\n");
        builder.append("| (_| | | | (_| | | | (_| |").append("\n");
        builder.append(" \\__,_|_|  \\__,_|_|  \\__,_|");
        System.out.println(builder.toString());
        DisplayUtils.addNewLine();
    }

    private static void addNewLine() {
        System.out.println();
    }

    private static void displayDetailsLine() {
        String line = messages.getMessage(Messages.INFO_LABEL_ON_DETAILS).concat(" ");
        line = StringUtils.rightPad(StringUtils.abbreviate(line, DisplayUtils.getWidth()), DisplayUtils.getWidth(), "-");
        System.out.println(line);
    }

    public static String displayOutputSeparator(String message) {
        return StringUtils.center(" ".concat(message).concat(" "), DisplayUtils.getWidth(), "-");
    }

    public static String displaySeparator() {
        return StringUtils.repeat("-", DisplayUtils.getWidth());
    }

    private static String getApplicationPath() {
        try {
            return ConfigurationUtils.getApplicationPath();
        }
        catch (AraraException ae) {
            return "[unknown application path]";
        }
    }
}

