(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/14#%latin1->char integer->char)
  (define std/srfi/14#%char->latin1 char->integer)
  (define std/srfi/14#:char-set
    (make-struct-type
     'std/srfi/14#:char-set
     '#f
     '1
     ':char-set
     '((fields: s))
     '#f))
  (define std/srfi/14#char-set? (make-struct-predicate std/srfi/14#:char-set))
  (define std/srfi/14#char-set:s
    (make-struct-field-accessor std/srfi/14#:char-set '0))
  (define std/srfi/14#make-char-set
    (lambda (_s45275_) (make-struct-instance std/srfi/14#:char-set _s45275_)))
  (define std/srfi/14#%string-copy
    (lambda (_s45273_) (substring _s45273_ '0 (string-length _s45273_))))
  (define std/srfi/14#%default-base
    (lambda (_maybe-base45267_ _proc45268_)
      (if (pair? _maybe-base45267_)
          (let ((_bcs45270_ (car _maybe-base45267_))
                (_tail45271_ (cdr _maybe-base45267_)))
            (if (null? _tail45271_)
                (if (##structure-instance-of?
                     _bcs45270_
                     'std/srfi/14#:char-set)
                    (std/srfi/14#%string-copy
                     (##structure-ref _bcs45270_ '1 std/srfi/14#:char-set '#f))
                    (error '"BASE-CS parameter not a char-set"
                           _proc45268_
                           _bcs45270_))
                (error '"Expected final base char set -- too many parameters"
                       _proc45268_
                       _maybe-base45267_)))
          (make-string '256 (std/srfi/14#%latin1->char '0)))))
  (define std/srfi/14#%char-set:s/check
    (lambda (_cs45260_ _proc45261_)
      (let _lp45263_ ((_cs45265_ _cs45260_))
        (if (##structure-instance-of? _cs45265_ 'std/srfi/14#:char-set)
            (##structure-ref _cs45265_ '1 std/srfi/14#:char-set '#f)
            (_lp45263_ (error '"Not a char-set" _cs45265_ _proc45261_))))))
  (define std/srfi/14#si=0?
    (lambda (_s45257_ _i45258_)
      (zero? (std/srfi/14#%char->latin1 (string-ref _s45257_ _i45258_)))))
  (define std/srfi/14#si=1?
    (lambda (_s45254_ _i45255_) (not (std/srfi/14#si=0? _s45254_ _i45255_))))
  (define std/srfi/14#c0 (std/srfi/14#%latin1->char '0))
  (define std/srfi/14#c1 (std/srfi/14#%latin1->char '1))
  (define std/srfi/14#si
    (lambda (_s45251_ _i45252_)
      (std/srfi/14#%char->latin1 (string-ref _s45251_ _i45252_))))
  (define std/srfi/14#%set0!
    (lambda (_s45248_ _i45249_)
      (string-set! _s45248_ _i45249_ std/srfi/14#c0)))
  (define std/srfi/14#%set1!
    (lambda (_s45245_ _i45246_)
      (string-set! _s45245_ _i45246_ std/srfi/14#c1)))
  (define std/srfi/14#setv!
    (lambda (_s45241_ _i45242_ _v45243_)
      (string-set! _s45241_ _i45242_ (std/srfi/14#%latin1->char _v45243_))))
  (define std/srfi/14#%not!
    (lambda (_s45237_ _i45238_ _v45239_)
      (std/srfi/14#setv! _s45237_ _i45238_ (- '1 _v45239_))))
  (define std/srfi/14#%and!
    (lambda (_s45233_ _i45234_ _v45235_)
      (if (zero? _v45235_) (std/srfi/14#%set0! _s45233_ _i45234_) '#!void)))
  (define std/srfi/14#%or!
    (lambda (_s45229_ _i45230_ _v45231_)
      (if (not (zero? _v45231_))
          (std/srfi/14#%set1! _s45229_ _i45230_)
          '#!void)))
  (define std/srfi/14#%minus!
    (lambda (_s45225_ _i45226_ _v45227_)
      (if (not (zero? _v45227_))
          (std/srfi/14#%set0! _s45225_ _i45226_)
          '#!void)))
  (define std/srfi/14#%xor!
    (lambda (_s45221_ _i45222_ _v45223_)
      (if (not (zero? _v45223_))
          (std/srfi/14#setv!
           _s45221_
           _i45222_
           (- '1 (std/srfi/14#si _s45221_ _i45222_)))
          '#!void)))
  (define std/srfi/14#char-set-copy
    (lambda (_cs45219_)
      (##structure
       std/srfi/14#:char-set
       (std/srfi/14#%string-copy
        (std/srfi/14#%char-set:s/check _cs45219_ std/srfi/14#char-set-copy)))))
  (define std/srfi/14#char-set=
    (lambda _rest45200_
      (let ((_$e45202_ (null? _rest45200_)))
        (if _$e45202_
            _$e45202_
            (let* ((_cs145205_ (car _rest45200_))
                   (_rest45207_ (cdr _rest45200_))
                   (_s145209_
                    (std/srfi/14#%char-set:s/check
                     _cs145205_
                     std/srfi/14#char-set=)))
              (let _lp45212_ ((_rest45214_ _rest45207_))
                (let ((_$e45216_ (not (pair? _rest45214_))))
                  (if _$e45216_
                      _$e45216_
                      (if (string=?
                           _s145209_
                           (std/srfi/14#%char-set:s/check
                            (car _rest45214_)
                            std/srfi/14#char-set=))
                          (_lp45212_ (cdr _rest45214_))
                          '#f)))))))))
  (define std/srfi/14#char-set<=
    (lambda _rest45177_
      (let ((_$e45179_ (null? _rest45177_)))
        (if _$e45179_
            _$e45179_
            (let ((_cs145182_ (car _rest45177_))
                  (_rest45183_ (cdr _rest45177_)))
              (let _lp45185_ ((_s145187_
                               (std/srfi/14#%char-set:s/check
                                _cs145182_
                                std/srfi/14#char-set<=))
                              (_rest45188_ _rest45183_))
                (let ((_$e45190_ (not (pair? _rest45188_))))
                  (if _$e45190_
                      _$e45190_
                      (let ((_s245193_
                             (std/srfi/14#%char-set:s/check
                              (car _rest45188_)
                              std/srfi/14#char-set<=))
                            (_rest45194_ (cdr _rest45188_)))
                        (if (eq? _s145187_ _s245193_)
                            (_lp45185_ _s245193_ _rest45194_)
                            (let _lp245196_ ((_i45198_ '255))
                              (if (< _i45198_ '0)
                                  (_lp45185_ _s245193_ _rest45194_)
                                  (if (<= (std/srfi/14#si _s145187_ _i45198_)
                                          (std/srfi/14#si _s245193_ _i45198_))
                                      (_lp245196_ (- _i45198_ '1))
                                      '#f)))))))))))))
  (define std/srfi/14#char-set-hash
    (lambda (_cs45148_ . _maybe-bound45149_)
      (let* ((_bound45159_
              (let ((_maybe-arg45151_ _maybe-bound45149_))
                (if (null? _maybe-arg45151_)
                    '4194304
                    (if (null? (cdr _maybe-arg45151_))
                        (let ((_val45154_ (car _maybe-arg45151_)))
                          (if ((lambda (_n45157_)
                                 (and (integer? _n45157_)
                                      (exact? _n45157_)
                                      (<= '0 _n45157_)))
                               _val45154_)
                              _val45154_
                              (error '"argument out of domain" _val45154_)))
                        (error '"too many optional arguments"
                               _maybe-arg45151_)))))
             (_bound45161_ (if (zero? _bound45159_) '4194304 _bound45159_))
             (_s45163_
              (std/srfi/14#%char-set:s/check
               _cs45148_
               std/srfi/14#char-set-hash))
             (_mask45169_
              (let _lp45165_ ((_i45167_ '65536))
                (if (>= _i45167_ _bound45161_)
                    (- _i45167_ '1)
                    (_lp45165_ (+ _i45167_ _i45167_))))))
        (let _lp45172_ ((_i45174_ '255) (_ans45175_ '0))
          (if (< _i45174_ '0)
              (modulo _ans45175_ _bound45161_)
              (_lp45172_
               (- _i45174_ '1)
               (if (std/srfi/14#si=0? _s45163_ _i45174_)
                   _ans45175_
                   (bitwise-and
                    _mask45169_
                    (+ (* '37 _ans45175_) _i45174_)))))))))
  (define std/srfi/14#char-set-contains?
    (lambda (_cs45145_ _char45146_)
      (std/srfi/14#si=1?
       (std/srfi/14#%char-set:s/check _cs45145_ std/srfi/14#char-set-contains?)
       (std/srfi/14#%char->latin1
        (if (char? _char45146_)
            _char45146_
            (error '"Bad argument" _char45146_ 'char? 'char-set-contains?))))))
  (define std/srfi/14#char-set-size
    (lambda (_cs45136_)
      (let ((_s45138_
             (std/srfi/14#%char-set:s/check
              _cs45136_
              std/srfi/14#char-set-size)))
        (let _lp45140_ ((_i45142_ '255) (_size45143_ '0))
          (if (< _i45142_ '0)
              _size45143_
              (_lp45140_
               (- _i45142_ '1)
               (+ _size45143_ (std/srfi/14#si _s45138_ _i45142_))))))))
  (define std/srfi/14#char-set-count
    (lambda (_pred45126_ _cset45127_)
      (if (procedure? _pred45126_)
          _pred45126_
          (error '"Bad argument" _pred45126_ 'procedure? 'char-set-count))
      (let ((_s45129_
             (std/srfi/14#%char-set:s/check
              _cset45127_
              std/srfi/14#char-set-count)))
        (let _lp45131_ ((_i45133_ '255) (_count45134_ '0))
          (if (< _i45133_ '0)
              _count45134_
              (_lp45131_
               (- _i45133_ '1)
               (if (and (std/srfi/14#si=1? _s45129_ _i45133_)
                        (_pred45126_ (std/srfi/14#%latin1->char _i45133_)))
                   (+ _count45134_ '1)
                   _count45134_)))))))
  (define std/srfi/14#%set-char-set
    (lambda (_set45117_ _proc45118_ _cs45119_ _chars45120_)
      (let ((_s45122_
             (std/srfi/14#%string-copy
              (std/srfi/14#%char-set:s/check _cs45119_ _proc45118_))))
        (for-each
         (lambda (_c45124_)
           (_set45117_ _s45122_ (std/srfi/14#%char->latin1 _c45124_)))
         _chars45120_)
        (##structure std/srfi/14#:char-set _s45122_))))
  (define std/srfi/14#%set-char-set!
    (lambda (_set45108_ _proc45109_ _cs45110_ _chars45111_)
      (let ((_s45113_ (std/srfi/14#%char-set:s/check _cs45110_ _proc45109_)))
        (for-each
         (lambda (_c45115_)
           (_set45108_ _s45113_ (std/srfi/14#%char->latin1 _c45115_)))
         _chars45111_))
      _cs45110_))
  (define std/srfi/14#char-set-adjoin
    (lambda (_cs45105_ . _chars45106_)
      (std/srfi/14#%set-char-set
       std/srfi/14#%set1!
       std/srfi/14#char-set-adjoin
       _cs45105_
       _chars45106_)))
  (define std/srfi/14#char-set-adjoin!
    (lambda (_cs45102_ . _chars45103_)
      (std/srfi/14#%set-char-set!
       std/srfi/14#%set1!
       std/srfi/14#char-set-adjoin!
       _cs45102_
       _chars45103_)))
  (define std/srfi/14#char-set-delete
    (lambda (_cs45099_ . _chars45100_)
      (std/srfi/14#%set-char-set
       std/srfi/14#%set0!
       std/srfi/14#char-set-delete
       _cs45099_
       _chars45100_)))
  (define std/srfi/14#char-set-delete!
    (lambda (_cs45096_ . _chars45097_)
      (std/srfi/14#%set-char-set!
       std/srfi/14#%set0!
       std/srfi/14#char-set-delete!
       _cs45096_
       _chars45097_)))
  (define std/srfi/14#char-set-cursor
    (lambda (_cset45094_)
      (std/srfi/14#%char-set-cursor-next
       _cset45094_
       '256
       std/srfi/14#char-set-cursor)))
  (define std/srfi/14#end-of-char-set?
    (lambda (_cursor45092_) (< _cursor45092_ '0)))
  (define std/srfi/14#char-set-ref
    (lambda (_cset45089_ _cursor45090_)
      (std/srfi/14#%latin1->char _cursor45090_)))
  (define std/srfi/14#char-set-cursor-next
    (lambda (_cset45084_ _cursor45085_)
      (if ((lambda (_i45087_)
             (and (integer? _i45087_) (exact? _i45087_) (<= '0 _i45087_ '255)))
           _cursor45085_)
          _cursor45085_
          (error '"Bad argument"
                 _cursor45085_
                 '(lambda (i) (and (integer? i) (exact? i) (<= 0 i 255)))
                 'char-set-cursor-next))
      (std/srfi/14#%char-set-cursor-next
       _cset45084_
       _cursor45085_
       std/srfi/14#char-set-cursor-next)))
  (define std/srfi/14#%char-set-cursor-next
    (lambda (_cset45069_ _cursor45070_ _proc45071_)
      (let ((_s45073_ (std/srfi/14#%char-set:s/check _cset45069_ _proc45071_)))
        (let _lp45075_ ((_cur45077_ _cursor45070_))
          (let ((_cur45079_ (- _cur45077_ '1)))
            (if (or (< _cur45079_ '0) (std/srfi/14#si=1? _s45073_ _cur45079_))
                _cur45079_
                (_lp45075_ _cur45079_)))))))
  (define std/srfi/14#char-set-for-each
    (lambda (_proc45060_ _cs45061_)
      (if (procedure? _proc45060_)
          _proc45060_
          (error '"Bad argument" _proc45060_ 'procedure? 'char-set-for-each))
      (let ((_s45063_
             (std/srfi/14#%char-set:s/check
              _cs45061_
              std/srfi/14#char-set-for-each)))
        (let _lp45065_ ((_i45067_ '255))
          (if (>= _i45067_ '0)
              (begin
                (if (std/srfi/14#si=1? _s45063_ _i45067_)
                    (_proc45060_ (std/srfi/14#%latin1->char _i45067_))
                    '#!void)
                (_lp45065_ (- _i45067_ '1)))
              '#!void)))))
  (define std/srfi/14#char-set-map
    (lambda (_proc45050_ _cs45051_)
      (if (procedure? _proc45050_)
          _proc45050_
          (error '"Bad argument" _proc45050_ 'procedure? 'char-set-map))
      (let ((_s45053_
             (std/srfi/14#%char-set:s/check
              _cs45051_
              std/srfi/14#char-set-map))
            (_ans45054_ (make-string '256 std/srfi/14#c0)))
        (let _lp45056_ ((_i45058_ '255))
          (if (>= _i45058_ '0)
              (begin
                (if (std/srfi/14#si=1? _s45053_ _i45058_)
                    (std/srfi/14#%set1!
                     _ans45054_
                     (std/srfi/14#%char->latin1
                      (_proc45050_ (std/srfi/14#%latin1->char _i45058_))))
                    '#!void)
                (_lp45056_ (- _i45058_ '1)))
              '#!void))
        (##structure std/srfi/14#:char-set _ans45054_))))
  (define std/srfi/14#char-set-fold
    (lambda (_kons45039_ _knil45040_ _cs45041_)
      (if (procedure? _kons45039_)
          _kons45039_
          (error '"Bad argument" _kons45039_ 'procedure? 'char-set-fold))
      (let ((_s45043_
             (std/srfi/14#%char-set:s/check
              _cs45041_
              std/srfi/14#char-set-fold)))
        (let _lp45045_ ((_i45047_ '255) (_ans45048_ _knil45040_))
          (if (< _i45047_ '0)
              _ans45048_
              (_lp45045_
               (- _i45047_ '1)
               (if (std/srfi/14#si=0? _s45043_ _i45047_)
                   _ans45048_
                   (_kons45039_
                    (std/srfi/14#%latin1->char _i45047_)
                    _ans45048_))))))))
  (define std/srfi/14#char-set-every
    (lambda (_pred45024_ _cs45025_)
      (if (procedure? _pred45024_)
          _pred45024_
          (error '"Bad argument" _pred45024_ 'procedure? 'char-set-every))
      (let ((_s45027_
             (std/srfi/14#%char-set:s/check
              _cs45025_
              std/srfi/14#char-set-every)))
        (let _lp45029_ ((_i45031_ '255))
          (let ((_$e45033_ (< _i45031_ '0)))
            (if _$e45033_
                _$e45033_
                (if (or (std/srfi/14#si=0? _s45027_ _i45031_)
                        (_pred45024_ (std/srfi/14#%latin1->char _i45031_)))
                    (_lp45029_ (- _i45031_ '1))
                    '#f)))))))
  (define std/srfi/14#char-set-any
    (lambda (_pred45012_ _cs45013_)
      (if (procedure? _pred45012_)
          _pred45012_
          (error '"Bad argument" _pred45012_ 'procedure? 'char-set-any))
      (let ((_s45015_
             (std/srfi/14#%char-set:s/check
              _cs45013_
              std/srfi/14#char-set-any)))
        (let _lp45017_ ((_i45019_ '255))
          (if (>= _i45019_ '0)
              (let ((_$e45021_
                     (if (std/srfi/14#si=1? _s45015_ _i45019_)
                         (_pred45012_ (std/srfi/14#%latin1->char _i45019_))
                         '#f)))
                (if _$e45021_ _$e45021_ (_lp45017_ (- _i45019_ '1))))
              '#f)))))
  (define std/srfi/14#%char-set-unfold!
    (lambda (_proc45001_ _p45002_ _f45003_ _g45004_ _s45005_ _seed45006_)
      (if (procedure? _p45002_)
          _p45002_
          (error '"Bad argument" _p45002_ 'procedure? 'proc))
      (if (procedure? _f45003_)
          _f45003_
          (error '"Bad argument" _f45003_ 'procedure? 'proc))
      (if (procedure? _g45004_)
          _g45004_
          (error '"Bad argument" _g45004_ 'procedure? 'proc))
      (let _lp45008_ ((_seed45010_ _seed45006_))
        (if (not (_p45002_ _seed45010_))
            (begin
              (std/srfi/14#%set1!
               _s45005_
               (std/srfi/14#%char->latin1 (_f45003_ _seed45010_)))
              (_lp45008_ (_g45004_ _seed45010_)))
            '#!void))))
  (define std/srfi/14#char-set-unfold
    (lambda (_p44993_ _f44994_ _g44995_ _seed44996_ . _maybe-base44997_)
      (let ((_bs44999_
             (std/srfi/14#%default-base
              _maybe-base44997_
              std/srfi/14#char-set-unfold)))
        (std/srfi/14#%char-set-unfold!
         std/srfi/14#char-set-unfold
         _p44993_
         _f44994_
         _g44995_
         _bs44999_
         _seed44996_)
        (##structure std/srfi/14#:char-set _bs44999_))))
  (define std/srfi/14#char-set-unfold!
    (lambda (_p44987_ _f44988_ _g44989_ _seed44990_ _base-cset44991_)
      (std/srfi/14#%char-set-unfold!
       std/srfi/14#char-set-unfold!
       _p44987_
       _f44988_
       _g44989_
       (std/srfi/14#%char-set:s/check
        _base-cset44991_
        std/srfi/14#char-set-unfold!)
       _seed44990_)
      _base-cset44991_))
  (define std/srfi/14#%list->char-set!
    (lambda (_chars44982_ _s44983_)
      (for-each
       (lambda (_char44985_)
         (std/srfi/14#%set1! _s44983_ (std/srfi/14#%char->latin1 _char44985_)))
       _chars44982_)))
  (define std/srfi/14#char-set
    (lambda _chars44978_
      (let ((_s44980_ (make-string '256 std/srfi/14#c0)))
        (std/srfi/14#%list->char-set! _chars44978_ _s44980_)
        (##structure std/srfi/14#:char-set _s44980_))))
  (define std/srfi/14#list->char-set
    (lambda (_chars44973_ . _maybe-base44974_)
      (let ((_bs44976_
             (std/srfi/14#%default-base
              _maybe-base44974_
              std/srfi/14#list->char-set)))
        (std/srfi/14#%list->char-set! _chars44973_ _bs44976_)
        (##structure std/srfi/14#:char-set _bs44976_))))
  (define std/srfi/14#list->char-set!
    (lambda (_chars44970_ _base-cs44971_)
      (std/srfi/14#%list->char-set!
       _chars44970_
       (std/srfi/14#%char-set:s/check
        _base-cs44971_
        std/srfi/14#list->char-set!))
      _base-cs44971_))
  (define std/srfi/14#char-set->list
    (lambda (_cs44961_)
      (let ((_s44963_
             (std/srfi/14#%char-set:s/check
              _cs44961_
              std/srfi/14#char-set->list)))
        (let _lp44965_ ((_i44967_ '255) (_ans44968_ '()))
          (if (< _i44967_ '0)
              _ans44968_
              (_lp44965_
               (- _i44967_ '1)
               (if (std/srfi/14#si=0? _s44963_ _i44967_)
                   _ans44968_
                   (cons (std/srfi/14#%latin1->char _i44967_)
                         _ans44968_))))))))
  (define std/srfi/14#%string->char-set!
    (lambda (_str44952_ _bs44953_ _proc44954_)
      (if (string? _str44952_)
          _str44952_
          (error '"Bad argument" _str44952_ 'string? 'proc))
      (let _$loop44956_ ((_i44959_ (- (string-length _str44952_) '1)))
        (if (< _i44959_ '0)
            '#!void
            (begin
              (std/srfi/14#%set1!
               _bs44953_
               (std/srfi/14#%char->latin1 (string-ref _str44952_ _i44959_)))
              (_$loop44956_ (- _i44959_ '1)))))))
  (define std/srfi/14#string->char-set
    (lambda (_str44947_ . _maybe-base44948_)
      (let ((_bs44950_
             (std/srfi/14#%default-base
              _maybe-base44948_
              std/srfi/14#string->char-set)))
        (std/srfi/14#%string->char-set!
         _str44947_
         _bs44950_
         std/srfi/14#string->char-set)
        (##structure std/srfi/14#:char-set _bs44950_))))
  (define std/srfi/14#string->char-set!
    (lambda (_str44944_ _base-cs44945_)
      (std/srfi/14#%string->char-set!
       _str44944_
       (std/srfi/14#%char-set:s/check
        _base-cs44945_
        std/srfi/14#string->char-set!)
       std/srfi/14#string->char-set!)
      _base-cs44945_))
  (define std/srfi/14#char-set->string
    (lambda (_cs44930_)
      (let* ((_s44932_
              (std/srfi/14#%char-set:s/check
               _cs44930_
               std/srfi/14#char-set->string))
             (_ans44934_ (make-string (std/srfi/14#char-set-size _cs44930_))))
        (let _lp44937_ ((_i44939_ '255) (_j44940_ '0))
          (if (< _i44939_ '0)
              _ans44934_
              (let ((_j44942_
                     (if (std/srfi/14#si=0? _s44932_ _i44939_)
                         _j44940_
                         (begin
                           (string-set!
                            _ans44934_
                            _j44940_
                            (std/srfi/14#%latin1->char _i44939_))
                           (+ _j44940_ '1)))))
                (_lp44937_ (- _i44939_ '1) _j44942_)))))))
  (define std/srfi/14#%ucs-range->char-set!
    (lambda (_lower44916_ _upper44917_ _error?44918_ _bs44919_ _proc44920_)
      (if ((lambda (_x44922_)
             (and (integer? _x44922_) (exact? _x44922_) (<= '0 _x44922_)))
           _lower44916_)
          _lower44916_
          (error '"Bad argument"
                 _lower44916_
                 '(lambda (x) (and (integer? x) (exact? x) (<= 0 x)))
                 'proc))
      (if ((lambda (_x44924_)
             (and (integer? _x44924_)
                  (exact? _x44924_)
                  (<= _lower44916_ _x44924_)))
           _upper44917_)
          _upper44917_
          (error '"Bad argument"
                 _upper44917_
                 '(lambda (x) (and (integer? x) (exact? x) (<= lower x)))
                 'proc))
      (if (and (< _lower44916_ _upper44917_)
               (< '256 _upper44917_)
               _error?44918_)
          (error '"Requested UCS range contains unavailable characters -- this implementation only supports Latin-1"
                 _proc44920_
                 _lower44916_
                 _upper44917_)
          '#!void)
      (let _lp44926_ ((_i44928_ (- (min _upper44917_ '256) '1)))
        (if (<= _lower44916_ _i44928_)
            (begin
              (std/srfi/14#%set1! _bs44919_ _i44928_)
              (_lp44926_ (- _i44928_ '1)))
            '#!void))))
  (define std/srfi/14#ucs-range->char-set
    (lambda (_lower44900_ _upper44901_ . _rest44902_)
      (let ((_rest44904_ _rest44902_))
        (call-with-values
         (lambda ()
           (if (null? _rest44904_)
               (values '#f '())
               (values (car _rest44904_) (cdr _rest44904_))))
         (lambda (_error?44908_ _rest44909_)
           (if '#t
               (let* ((_rest44912_ _rest44909_)
                      (_bs44914_
                       (std/srfi/14#%default-base
                        _rest44912_
                        std/srfi/14#ucs-range->char-set)))
                 (std/srfi/14#%ucs-range->char-set!
                  _lower44900_
                  _upper44901_
                  _error?44908_
                  _bs44914_
                  std/srfi/14#ucs-range->char-set)
                 (##structure std/srfi/14#:char-set _bs44914_))
               (error '"argument out of domain" _error?44908_)))))))
  (define std/srfi/14#ucs-range->char-set!
    (lambda (_lower44895_ _upper44896_ _error?44897_ _base-cs44898_)
      (std/srfi/14#%ucs-range->char-set!
       _lower44895_
       _upper44896_
       _error?44897_
       (std/srfi/14#%char-set:s/check
        _base-cs44898_
        std/srfi/14#ucs-range->char-set!)
       std/srfi/14#ucs-range->char-set)
      _base-cs44898_))
  (define std/srfi/14#%char-set-filter!
    (lambda (_pred44886_ _ds44887_ _bs44888_ _proc44889_)
      (if (procedure? _pred44886_)
          _pred44886_
          (error '"Bad argument" _pred44886_ 'procedure? 'proc))
      (let _lp44891_ ((_i44893_ '255))
        (if (>= _i44893_ '0)
            (begin
              (if (and (std/srfi/14#si=1? _ds44887_ _i44893_)
                       (_pred44886_ (std/srfi/14#%latin1->char _i44893_)))
                  (std/srfi/14#%set1! _bs44888_ _i44893_)
                  '#!void)
              (_lp44891_ (- _i44893_ '1)))
            '#!void))))
  (define std/srfi/14#char-set-filter
    (lambda (_predicate44880_ _domain44881_ . _maybe-base44882_)
      (let ((_bs44884_
             (std/srfi/14#%default-base
              _maybe-base44882_
              std/srfi/14#char-set-filter)))
        (std/srfi/14#%char-set-filter!
         _predicate44880_
         (std/srfi/14#%char-set:s/check
          _domain44881_
          std/srfi/14#char-set-filter!)
         _bs44884_
         std/srfi/14#char-set-filter)
        (##structure std/srfi/14#:char-set _bs44884_))))
  (define std/srfi/14#char-set-filter!
    (lambda (_predicate44876_ _domain44877_ _base-cs44878_)
      (std/srfi/14#%char-set-filter!
       _predicate44876_
       (std/srfi/14#%char-set:s/check
        _domain44877_
        std/srfi/14#char-set-filter!)
       (std/srfi/14#%char-set:s/check
        _base-cs44878_
        std/srfi/14#char-set-filter!)
       std/srfi/14#char-set-filter!)
      _base-cs44878_))
  (define std/srfi/14#->char-set
    (lambda (_x44874_)
      (if (##structure-instance-of? _x44874_ 'std/srfi/14#:char-set)
          _x44874_
          (if (string? _x44874_)
              (std/srfi/14#string->char-set _x44874_)
              (if (char? _x44874_)
                  (std/srfi/14#char-set _x44874_)
                  (error '"->char-set: Not a charset, string or char."
                         _x44874_))))))
  (define std/srfi/14#%string-iter
    (lambda (_p44867_ _s44868_)
      (let _lp44870_ ((_i44872_ (- (string-length _s44868_) '1)))
        (if (>= _i44872_ '0)
            (begin
              (_p44867_
               _i44872_
               (std/srfi/14#%char->latin1 (string-ref _s44868_ _i44872_)))
              (_lp44870_ (- _i44872_ '1)))
            '#!void))))
  (define std/srfi/14#%char-set-algebra
    (lambda (_s44854_ _csets44855_ _op44856_ _proc44857_)
      (for-each
       (lambda (_cset44859_)
         (let ((_s244861_
                (std/srfi/14#%char-set:s/check _cset44859_ _proc44857_)))
           (let _lp44863_ ((_i44865_ '255))
             (if (>= _i44865_ '0)
                 (begin
                   (_op44856_
                    _s44854_
                    _i44865_
                    (std/srfi/14#si _s244861_ _i44865_))
                   (_lp44863_ (- _i44865_ '1)))
                 '#!void))))
       _csets44855_)))
  (define std/srfi/14#char-set-complement
    (lambda (_cs44846_)
      (let ((_s44848_
             (std/srfi/14#%char-set:s/check
              _cs44846_
              std/srfi/14#char-set-complement))
            (_ans44849_ (make-string '256)))
        (std/srfi/14#%string-iter
         (lambda (_i44851_ _v44852_)
           (std/srfi/14#%not! _ans44849_ _i44851_ _v44852_))
         _s44848_)
        (##structure std/srfi/14#:char-set _ans44849_))))
  (define std/srfi/14#char-set-complement!
    (lambda (_cset44839_)
      (let ((_s44841_
             (std/srfi/14#%char-set:s/check
              _cset44839_
              std/srfi/14#char-set-complement!)))
        (std/srfi/14#%string-iter
         (lambda (_i44843_ _v44844_)
           (std/srfi/14#%not! _s44841_ _i44843_ _v44844_))
         _s44841_))
      _cset44839_))
  (define std/srfi/14#char-set-union!
    (lambda (_cset144836_ . _csets44837_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check _cset144836_ std/srfi/14#char-set-union!)
       _csets44837_
       std/srfi/14#%or!
       std/srfi/14#char-set-union!)
      _cset144836_))
  (define std/srfi/14#char-set-union
    (lambda _csets44832_
      (if (pair? _csets44832_)
          (let ((_s44834_
                 (std/srfi/14#%string-copy
                  (std/srfi/14#%char-set:s/check
                   (car _csets44832_)
                   std/srfi/14#char-set-union))))
            (std/srfi/14#%char-set-algebra
             _s44834_
             (cdr _csets44832_)
             std/srfi/14#%or!
             std/srfi/14#char-set-union)
            (##structure std/srfi/14#:char-set _s44834_))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:empty))))
  (define std/srfi/14#char-set-intersection!
    (lambda (_cset144829_ . _csets44830_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check
        _cset144829_
        std/srfi/14#char-set-intersection!)
       _csets44830_
       std/srfi/14#%and!
       std/srfi/14#char-set-intersection!)
      _cset144829_))
  (define std/srfi/14#char-set-intersection
    (lambda _csets44825_
      (if (pair? _csets44825_)
          (let ((_s44827_
                 (std/srfi/14#%string-copy
                  (std/srfi/14#%char-set:s/check
                   (car _csets44825_)
                   std/srfi/14#char-set-intersection))))
            (std/srfi/14#%char-set-algebra
             _s44827_
             (cdr _csets44825_)
             std/srfi/14#%and!
             std/srfi/14#char-set-intersection)
            (##structure std/srfi/14#:char-set _s44827_))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:full))))
  (define std/srfi/14#char-set-difference!
    (lambda (_cset144822_ . _csets44823_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check
        _cset144822_
        std/srfi/14#char-set-difference!)
       _csets44823_
       std/srfi/14#%minus!
       std/srfi/14#char-set-difference!)
      _cset144822_))
  (define std/srfi/14#char-set-difference
    (lambda (_cs144817_ . _csets44818_)
      (if (pair? _csets44818_)
          (let ((_s44820_
                 (std/srfi/14#%string-copy
                  (std/srfi/14#%char-set:s/check
                   _cs144817_
                   std/srfi/14#char-set-difference))))
            (std/srfi/14#%char-set-algebra
             _s44820_
             _csets44818_
             std/srfi/14#%minus!
             std/srfi/14#char-set-difference)
            (##structure std/srfi/14#:char-set _s44820_))
          (std/srfi/14#char-set-copy _cs144817_))))
  (define std/srfi/14#char-set-xor!
    (lambda (_cset144814_ . _csets44815_)
      (std/srfi/14#%char-set-algebra
       (std/srfi/14#%char-set:s/check _cset144814_ std/srfi/14#char-set-xor!)
       _csets44815_
       std/srfi/14#%xor!
       std/srfi/14#char-set-xor!)
      _cset144814_))
  (define std/srfi/14#char-set-xor
    (lambda _csets44810_
      (if (pair? _csets44810_)
          (let ((_s44812_
                 (std/srfi/14#%string-copy
                  (std/srfi/14#%char-set:s/check
                   (car _csets44810_)
                   std/srfi/14#char-set-xor))))
            (std/srfi/14#%char-set-algebra
             _s44812_
             (cdr _csets44810_)
             std/srfi/14#%xor!
             std/srfi/14#char-set-xor)
            (##structure std/srfi/14#:char-set _s44812_))
          (std/srfi/14#char-set-copy std/srfi/14#char-set:empty))))
  (define std/srfi/14#%char-set-diff+intersection!
    (lambda (_diff44800_ _int44801_ _csets44802_ _proc44803_)
      (for-each
       (lambda (_cs44805_)
         (std/srfi/14#%string-iter
          (lambda (_i44807_ _v44808_)
            (if (not (zero? _v44808_))
                (if (std/srfi/14#si=1? _diff44800_ _i44807_)
                    (begin
                      (std/srfi/14#%set0! _diff44800_ _i44807_)
                      (std/srfi/14#%set1! _int44801_ _i44807_))
                    '#!void)
                '#!void))
          (std/srfi/14#%char-set:s/check _cs44805_ _proc44803_)))
       _csets44802_)))
  (define std/srfi/14#char-set-diff+intersection!
    (lambda (_cs144790_ _cs244791_ . _csets44792_)
      (let ((_s144794_
             (std/srfi/14#%char-set:s/check
              _cs144790_
              std/srfi/14#char-set-diff+intersection!))
            (_s244795_
             (std/srfi/14#%char-set:s/check
              _cs244791_
              std/srfi/14#char-set-diff+intersection!)))
        (std/srfi/14#%string-iter
         (lambda (_i44797_ _v44798_)
           (if (zero? _v44798_)
               (std/srfi/14#%set0! _s244795_ _i44797_)
               (if (std/srfi/14#si=1? _s244795_ _i44797_)
                   (std/srfi/14#%set0! _s144794_ _i44797_)
                   '#!void)))
         _s144794_)
        (std/srfi/14#%char-set-diff+intersection!
         _s144794_
         _s244795_
         _csets44792_
         std/srfi/14#char-set-diff+intersection!))
      (values _cs144790_ _cs244791_)))
  (define std/srfi/14#char-set-diff+intersection
    (lambda (_cs144784_ . _csets44785_)
      (let ((_diff44787_
             (string-copy
              (std/srfi/14#%char-set:s/check
               _cs144784_
               std/srfi/14#char-set-diff+intersection)))
            (_int44788_ (make-string '256 std/srfi/14#c0)))
        (std/srfi/14#%char-set-diff+intersection!
         _diff44787_
         _int44788_
         _csets44785_
         std/srfi/14#char-set-diff+intersection)
        (values (##structure std/srfi/14#:char-set _diff44787_)
                (##structure std/srfi/14#:char-set _int44788_)))))
  (define std/srfi/14#char-set:empty (std/srfi/14#char-set))
  (define std/srfi/14#char-set:full
    (std/srfi/14#char-set-complement std/srfi/14#char-set:empty))
  (define std/srfi/14#char-set:lower-case
    (let* ((_a-z44777_ (std/srfi/14#ucs-range->char-set '97 '123))
           (_latin144779_
            (std/srfi/14#ucs-range->char-set! '223 '247 '#t _a-z44777_))
           (_latin244781_
            (std/srfi/14#ucs-range->char-set! '248 '256 '#t _latin144779_)))
      (std/srfi/14#char-set-adjoin!
       _latin244781_
       (std/srfi/14#%latin1->char '181))))
  (define std/srfi/14#char-set:upper-case
    (let ((_A-Z44775_ (std/srfi/14#ucs-range->char-set '65 '91)))
      (std/srfi/14#ucs-range->char-set!
       '216
       '223
       '#t
       (std/srfi/14#ucs-range->char-set! '192 '215 '#t _A-Z44775_))))
  (define std/srfi/14#char-set:title-case std/srfi/14#char-set:empty)
  (define std/srfi/14#char-set:letter
    (let ((_u/l44773_
           (std/srfi/14#char-set-union
            std/srfi/14#char-set:upper-case
            std/srfi/14#char-set:lower-case)))
      (std/srfi/14#char-set-adjoin!
       _u/l44773_
       (std/srfi/14#%latin1->char '170)
       (std/srfi/14#%latin1->char '186))))
  (define std/srfi/14#char-set:digit
    (std/srfi/14#string->char-set '"0123456789"))
  (define std/srfi/14#char-set:hex-digit
    (std/srfi/14#string->char-set '"0123456789abcdefABCDEF"))
  (define std/srfi/14#char-set:letter+digit
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:letter
     std/srfi/14#char-set:digit))
  (define std/srfi/14#char-set:punctuation
    (let ((_ascii44770_
           (std/srfi/14#string->char-set '"!\"#%&'()*,-./:;?@[\\]_{}"))
          (_latin-1-chars44771_
           (map std/srfi/14#%latin1->char '(161 171 173 183 187 191))))
      (std/srfi/14#list->char-set! _latin-1-chars44771_ _ascii44770_)))
  (define std/srfi/14#char-set:symbol
    (let ((_ascii44767_ (std/srfi/14#string->char-set '"$+<=>^`|~"))
          (_latin-1-chars44768_
           (map std/srfi/14#%latin1->char
                '(162
                  163
                  164
                  165
                  166
                  167
                  168
                  169
                  172
                  174
                  175
                  176
                  177
                  180
                  182
                  184
                  215
                  247))))
      (std/srfi/14#list->char-set! _latin-1-chars44768_ _ascii44767_)))
  (define std/srfi/14#char-set:graphic
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:letter+digit
     std/srfi/14#char-set:punctuation
     std/srfi/14#char-set:symbol))
  (define std/srfi/14#char-set:whitespace
    (std/srfi/14#list->char-set
     (map std/srfi/14#%latin1->char '(9 10 11 12 13 32 160))))
  (define std/srfi/14#char-set:printing
    (std/srfi/14#char-set-union
     std/srfi/14#char-set:whitespace
     std/srfi/14#char-set:graphic))
  (define std/srfi/14#char-set:blank
    (std/srfi/14#list->char-set (map std/srfi/14#%latin1->char '(9 32 160))))
  (define std/srfi/14#char-set:iso-control
    (std/srfi/14#ucs-range->char-set!
     '127
     '160
     '#t
     (std/srfi/14#ucs-range->char-set '0 '32)))
  (define std/srfi/14#char-set:ascii
    (std/srfi/14#ucs-range->char-set '0 '128)))
