(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/db/postgresql#postgresql-connection::t
    (make-struct-type
     'std/db/postgresql#postgresql-connection::t
     std/db/dbi#connection::t
     '0
     'postgresql-connection
     '((final: . #t))
     '#f
     '()))
  (define std/db/postgresql#postgresql-connection?
    (make-struct-predicate std/db/postgresql#postgresql-connection::t))
  (define std/db/postgresql#make-postgresql-connection
    (lambda _$args219320_
      (apply make-struct-instance
             std/db/postgresql#postgresql-connection::t
             _$args219320_)))
  (define std/db/postgresql#postgresql-statement::t
    (make-struct-type
     'std/db/postgresql#postgresql-statement::t
     std/db/dbi#statement::t
     '7
     'postgresql-statement
     '((final: . #t))
     ':init!
     '(conn params cols bind row inp token)))
  (define std/db/postgresql#postgresql-statement?
    (make-struct-predicate std/db/postgresql#postgresql-statement::t))
  (define std/db/postgresql#make-postgresql-statement
    (lambda _$args219317_
      (apply make-struct-instance
             std/db/postgresql#postgresql-statement::t
             _$args219317_)))
  (define std/db/postgresql#postgresql-statement-conn
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '0))
  (define std/db/postgresql#postgresql-statement-params
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '1))
  (define std/db/postgresql#postgresql-statement-cols
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '2))
  (define std/db/postgresql#postgresql-statement-bind
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '3))
  (define std/db/postgresql#postgresql-statement-row
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '4))
  (define std/db/postgresql#postgresql-statement-inp
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '5))
  (define std/db/postgresql#postgresql-statement-token
    (make-struct-field-accessor std/db/postgresql#postgresql-statement::t '6))
  (define std/db/postgresql#postgresql-statement-conn-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '0))
  (define std/db/postgresql#postgresql-statement-params-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '1))
  (define std/db/postgresql#postgresql-statement-cols-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '2))
  (define std/db/postgresql#postgresql-statement-bind-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '3))
  (define std/db/postgresql#postgresql-statement-row-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '4))
  (define std/db/postgresql#postgresql-statement-inp-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '5))
  (define std/db/postgresql#postgresql-statement-token-set!
    (make-struct-field-mutator std/db/postgresql#postgresql-statement::t '6))
  (define std/db/postgresql#postgresql-statement:::init!
    (lambda (_self219311_
             _name219312_
             _conn219313_
             _params219314_
             _cols219315_)
      (if (##fx< '4 (##vector-length _self219311_))
          (begin
            (##vector-set! _self219311_ '1 _name219312_)
            (##vector-set! _self219311_ '2 _conn219313_)
            (##vector-set! _self219311_ '3 _params219314_)
            (##vector-set! _self219311_ '4 _cols219315_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self219311_))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   ':init!
   std/db/postgresql#postgresql-statement:::init!
   '#f)
  (define std/db/postgresql#postgresql-connect__%
    (lambda (_g219376_
             _host219145219152_
             _port219146219154_
             _user219147219156_
             _passwd219148219158_
             _db219149219160_)
      (let* ((_host219163_
              (if (eq? _host219145219152_ absent-value)
                  '"127.0.0.1"
                  _host219145219152_))
             (_port219165_
              (if (eq? _port219146219154_ absent-value)
                  '5432
                  _port219146219154_))
             (_user219167_
              (if (eq? _user219147219156_ absent-value)
                  (error '"Missing required keyword argument" 'user:)
                  _user219147219156_))
             (_passwd219169_
              (if (eq? _passwd219148219158_ absent-value)
                  (error '"Missing required keyword argument" 'passwd:)
                  _passwd219148219158_))
             (_db219171_
              (if (eq? _db219149219160_ absent-value) '#f _db219149219160_))
             (_driver219173_
              (std/db/postgresql-driver#postgresql-connect!
               _host219163_
               _port219165_
               _user219167_
               _passwd219169_
               _db219171_)))
        (make-struct-instance
         std/db/postgresql#postgresql-connection::t
         _driver219173_))))
  (define std/db/postgresql#postgresql-connect__@
    (lambda (_keys219144219178_ . _args219180_)
      (apply std/db/postgresql#postgresql-connect__%
             _keys219144219178_
             (table-ref _keys219144219178_ 'host: absent-value)
             (table-ref _keys219144219178_ 'port: absent-value)
             (table-ref _keys219144219178_ 'user: absent-value)
             (table-ref _keys219144219178_ 'passwd: absent-value)
             (table-ref _keys219144219178_ 'db: absent-value)
             _args219180_)))
  (define std/db/postgresql#postgresql-connect
    (lambda _args219150219186_
      (apply keyword-dispatch
             '#(#f passwd: #f #f port: host: user: #f #f db:)
             std/db/postgresql#postgresql-connect__@
             _args219150219186_)))
  (define std/db/postgresql#postgresql-connection::close
    (lambda (_self219141_)
      (std/db/postgresql-driver#postgresql-close! _self219141_)))
  (bind-method!
   std/db/postgresql#postgresql-connection::t
   'close
   std/db/postgresql#postgresql-connection::close
   '#f)
  (define std/db/postgresql#postgresql-connection::prepare
    (lambda (_self219010_ _sql219011_)
      (let* ((_name219013_ (symbol->string (gensym 'stmt)))
             (_g219377_
              (std/db/postgresql-driver#postgresql-prepare-statement!
               _self219010_
               _name219013_
               _sql219011_)))
        (begin
          (let ((_g219378_
                 (if (##values? _g219377_) (##vector-length _g219377_) 1)))
            (if (not (##fx= _g219378_ 2))
                (error "Context expects 2 values" _g219378_)))
          (let ((_params219015_ (##vector-ref _g219377_ 0))
                (_cols219016_ (##vector-ref _g219377_ 1)))
            (let ()
              (let ((__obj219374
                     (make-object
                      std/db/postgresql#postgresql-statement::t
                      '8)))
                (if (##fx< '4 (##vector-length __obj219374))
                    (begin
                      (##vector-set! __obj219374 '1 _name219013_)
                      (##vector-set! __obj219374 '2 _self219010_)
                      (##vector-set! __obj219374 '3 _params219015_)
                      (##vector-set! __obj219374 '4 _cols219016_))
                    (error '"struct-instance-init!: too many arguments for struct"
                           __obj219374))
                __obj219374)))))))
  (bind-method!
   std/db/postgresql#postgresql-connection::t
   'prepare
   std/db/postgresql#postgresql-connection::prepare
   '#f)
  (define std/db/postgresql#postgresql-statement::finalize
    (lambda (_self218857_)
      (let* ((_self218858218865_ _self218857_)
             (_E218860218869_
              (lambda () (error '"No clause matching" _self218858218865_)))
             (_K218861218875_
              (lambda (_conn218872_ _name218873_)
                (std/db/postgresql#postgresql-statement::reset _self218857_)
                (std/db/postgresql-driver#postgresql-close-statement!
                 _conn218872_
                 _name218873_))))
        (if (##structure-direct-instance-of?
             _self218858218865_
             'std/db/postgresql#postgresql-statement::t)
            (let* ((_e218862218878_ (##vector-ref _self218858218865_ '1))
                   (_name218881_ _e218862218878_)
                   (_e218863218883_ (##vector-ref _self218858218865_ '2))
                   (_conn218886_ _e218863218883_))
              (_K218861218875_ _conn218886_ _name218881_))
            (_E218860218869_)))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'finalize
   std/db/postgresql#postgresql-statement::finalize
   '#f)
  (define std/db/postgresql#postgresql-statement::bind
    (lambda (_self218715_ . _args218716_)
      (letrec ((_value->binding218718_
                (lambda (_type-oid218725_ _arg218726_)
                  (if (not _arg218726_)
                      (if (fx= _type-oid218725_ '16)
                          (std/db/postgresql#serialize-boolean _arg218726_)
                          '#f)
                      (if (string? _arg218726_)
                          _arg218726_
                          (let ((_$e218728_
                                 (std/db/postgresql#catalog-serializer
                                  (std/db/postgresql#current-catalog)
                                  _type-oid218725_)))
                            (if _$e218728_
                                ((lambda (_g218730218732_)
                                   (_g218730218732_ _arg218726_))
                                 _$e218728_)
                                (error '"Cannot bind; unknown parameter type"
                                       _type-oid218725_
                                       _arg218726_))))))))
        (let* ((_params218720_
                (##direct-structure-ref
                 _self218715_
                 '3
                 std/db/postgresql#postgresql-statement::t
                 '#f))
               (_bind218722_
                (map _value->binding218718_ _params218720_ _args218716_)))
          (##direct-structure-set!
           _self218715_
           _bind218722_
           '5
           std/db/postgresql#postgresql-statement::t
           '#f)
          '#!void))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'bind
   std/db/postgresql#postgresql-statement::bind
   '#f)
  (define std/db/postgresql#postgresql-statement::clear
    (lambda (_self218591_)
      (##direct-structure-set!
       _self218591_
       '#f
       '5
       std/db/postgresql#postgresql-statement::t
       '#f)))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'clear
   std/db/postgresql#postgresql-statement::clear
   '#f)
  (define std/db/postgresql#postgresql-statement::reset
    (lambda (_self218461_)
      (let ((_token218462218464_
             (##direct-structure-ref
              _self218461_
              '8
              std/db/postgresql#postgresql-statement::t
              '#f)))
        (if _token218462218464_
            (let ((_token218467_ _token218462218464_))
              (std/db/postgresql-driver#postgresql-reset!
               (##direct-structure-ref
                _self218461_
                '2
                std/db/postgresql#postgresql-statement::t
                '#f)
               _token218467_)
              (##direct-structure-set!
               _self218461_
               '#f
               '8
               std/db/postgresql#postgresql-statement::t
               '#f)
              (##direct-structure-set!
               _self218461_
               '#f
               '7
               std/db/postgresql#postgresql-statement::t
               '#f)
              (##direct-structure-set!
               _self218461_
               '#f
               '6
               std/db/postgresql#postgresql-statement::t
               '#f))
            '#f))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'reset
   std/db/postgresql#postgresql-statement::reset
   '#f)
  (define std/db/postgresql#postgresql-statement::exec
    (lambda (_self218290_)
      (let* ((_self218291218301_ _self218290_)
             (_E218293218305_
              (lambda () (error '"No clause matching" _self218291218301_)))
             (_K218294218315_
              (lambda (_bind218308_ _conn218309_ _name218310_)
                (std/db/postgresql-driver#postgresql-exec!
                 _conn218309_
                 _name218310_
                 (let ((_$e218312_ _bind218308_))
                   (if _$e218312_ _$e218312_ '()))))))
        (if (##structure-direct-instance-of?
             _self218291218301_
             'std/db/postgresql#postgresql-statement::t)
            (let* ((_e218295218318_ (##vector-ref _self218291218301_ '1))
                   (_name218321_ _e218295218318_)
                   (_e218296218323_ (##vector-ref _self218291218301_ '2))
                   (_conn218326_ _e218296218323_)
                   (_e218297218328_ (##vector-ref _self218291218301_ '3))
                   (_e218298218331_ (##vector-ref _self218291218301_ '4))
                   (_e218299218334_ (##vector-ref _self218291218301_ '5))
                   (_bind218337_ _e218299218334_))
              (_K218294218315_ _bind218337_ _conn218326_ _name218321_))
            (_E218293218305_)))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'exec
   std/db/postgresql#postgresql-statement::exec
   '#f)
  (define std/db/postgresql#postgresql-statement::query-start
    (lambda (_self218116_)
      (let* ((_self218117218127_ _self218116_)
             (_E218119218131_
              (lambda () (error '"No clause matching" _self218117218127_)))
             (_K218120218144_
              (lambda (_bind218134_ _conn218135_ _name218136_)
                (let ((_g219379_
                       (std/db/postgresql-driver#postgresql-query!
                        _conn218135_
                        _name218136_
                        (let ((_$e218138_ _bind218134_))
                          (if _$e218138_ _$e218138_ '())))))
                  (begin
                    (let ((_g219380_
                           (if (##values? _g219379_)
                               (##vector-length _g219379_)
                               1)))
                      (if (not (##fx= _g219380_ 2))
                          (error "Context expects 2 values" _g219380_)))
                    (let ((_inp218141_ (##vector-ref _g219379_ 0))
                          (_token218142_ (##vector-ref _g219379_ 1)))
                      (begin
                        (##direct-structure-set!
                         _self218116_
                         _token218142_
                         '8
                         std/db/postgresql#postgresql-statement::t
                         '#f)
                        (##direct-structure-set!
                         _self218116_
                         _inp218141_
                         '7
                         std/db/postgresql#postgresql-statement::t
                         '#f)
                        (##direct-structure-set!
                         _self218116_
                         '#f
                         '6
                         std/db/postgresql#postgresql-statement::t
                         '#f))))))))
        (if (##structure-direct-instance-of?
             _self218117218127_
             'std/db/postgresql#postgresql-statement::t)
            (let* ((_e218121218147_ (##vector-ref _self218117218127_ '1))
                   (_name218150_ _e218121218147_)
                   (_e218122218152_ (##vector-ref _self218117218127_ '2))
                   (_conn218155_ _e218122218152_)
                   (_e218123218157_ (##vector-ref _self218117218127_ '3))
                   (_e218124218160_ (##vector-ref _self218117218127_ '4))
                   (_e218125218163_ (##vector-ref _self218117218127_ '5))
                   (_bind218166_ _e218125218163_))
              (_K218120218144_ _bind218166_ _conn218155_ _name218150_))
            (_E218119218131_)))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'query-start
   std/db/postgresql#postgresql-statement::query-start
   '#f)
  (define std/db/postgresql#postgresql-statement::query-fetch
    (lambda (_self217957_)
      (letrec ((_result->row217959_
                (lambda (_cols217990_)
                  (let ((_res217992_
                         (map _result->value217960_
                              _cols217990_
                              (##direct-structure-ref
                               _self217957_
                               '4
                               std/db/postgresql#postgresql-statement::t
                               '#f))))
                    (if (null? _res217992_)
                        '#f
                        (if (null? (cdr _res217992_))
                            (car _res217992_)
                            (list->vector _res217992_))))))
               (_result->value217960_
                (lambda (_res217985_ _col217986_)
                  (if _res217985_
                      (let ((_type-oid217988_ (list-ref _col217986_ '3)))
                        (_value-e217961_ _res217985_ _type-oid217988_))
                      '#f)))
               (_value-e217961_
                (lambda (_res217975_ _type-oid217976_)
                  (let ((_$e217978_
                         (std/db/postgresql#catalog-deserializer
                          (std/db/postgresql#current-catalog)
                          _type-oid217976_)))
                    (if _$e217978_
                        ((lambda (_g217980217982_)
                           (_g217980217982_ _res217975_))
                         _$e217978_)
                        _res217975_)))))
        (let ((_$e217963_
               (##direct-structure-ref
                _self217957_
                '7
                std/db/postgresql#postgresql-statement::t
                '#f)))
          (if _$e217963_
              ((lambda (_inp217966_)
                 (let _again217968_ ()
                   (let ((_next217971_
                          (std/misc/channel#channel-get__0 _inp217966_)))
                     (if (eof-object? _next217971_)
                         (begin
                           (##direct-structure-set!
                            _self217957_
                            '#f
                            '8
                            std/db/postgresql#postgresql-statement::t
                            '#f)
                           (##direct-structure-set!
                            _self217957_
                            '#f
                            '7
                            std/db/postgresql#postgresql-statement::t
                            '#f)
                           (##direct-structure-set!
                            _self217957_
                            '#f
                            '6
                            std/db/postgresql#postgresql-statement::t
                            '#f)
                           std/iter#iter-end)
                         (if (exception? _next217971_)
                             (raise _next217971_)
                             (if (##structure-direct-instance-of?
                                  _next217971_
                                  'std/actor/proto#!token::t)
                                 (begin
                                   (std/db/postgresql-driver#postgresql-continue!
                                    (##direct-structure-ref
                                     _self217957_
                                     '2
                                     std/db/postgresql#postgresql-statement::t
                                     '#f)
                                    _next217971_)
                                   (_again217968_))
                                 (let ((_row217973_
                                        (_result->row217959_ _next217971_)))
                                   (##direct-structure-set!
                                    _self217957_
                                    _row217973_
                                    '6
                                    std/db/postgresql#postgresql-statement::t
                                    '#f)
                                   '#!void)))))))
               _$e217963_)
              std/iter#iter-end)))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'query-fetch
   std/db/postgresql#postgresql-statement::query-fetch
   '#f)
  (define std/db/postgresql#postgresql-statement::query-row
    (lambda (_self217833_)
      (##direct-structure-ref
       _self217833_
       '6
       std/db/postgresql#postgresql-statement::t
       '#f)))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'query-row
   std/db/postgresql#postgresql-statement::query-row
   '#f)
  (define std/db/postgresql#postgresql-statement::query-fini
    std/db/postgresql#postgresql-statement::reset)
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'query-fini
   std/db/postgresql#postgresql-statement::query-fini
   '#f)
  (define std/db/postgresql#postgresql-statement::columns
    (lambda (_self217587_)
      (map car
           (##direct-structure-ref
            _self217587_
            '4
            std/db/postgresql#postgresql-statement::t
            '#f))))
  (bind-method!
   std/db/postgresql#postgresql-statement::t
   'columns
   std/db/postgresql#postgresql-statement::columns
   '#f)
  (define std/db/postgresql#catalog::t
    (make-struct-type
     'std/db/postgresql#catalog::t
     '#f
     '2
     'catalog
     '((final: . #t))
     ':init!
     '(s d)))
  (define std/db/postgresql#catalog?
    (make-struct-predicate std/db/postgresql#catalog::t))
  (define std/db/postgresql#make-catalog
    (lambda _$args217462_
      (apply make-struct-instance std/db/postgresql#catalog::t _$args217462_)))
  (define std/db/postgresql#catalog-s
    (make-struct-field-accessor std/db/postgresql#catalog::t '0))
  (define std/db/postgresql#catalog-d
    (make-struct-field-accessor std/db/postgresql#catalog::t '1))
  (define std/db/postgresql#catalog-s-set!
    (make-struct-field-mutator std/db/postgresql#catalog::t '0))
  (define std/db/postgresql#catalog-d-set!
    (make-struct-field-mutator std/db/postgresql#catalog::t '1))
  (define std/db/postgresql#catalog:::init!
    (lambda (_self217454_ . _mixin217455_)
      (let ((_s217457_ (make-table 'test: eq?))
            (_d217458_ (make-table 'test: eq?)))
        (for-each
         (lambda (_mixin217460_)
           (hash-merge!
            _s217457_
            (##direct-structure-ref
             _mixin217460_
             '1
             std/db/postgresql#catalog::t
             '#f))
           (hash-merge!
            _d217458_
            (##direct-structure-ref
             _mixin217460_
             '2
             std/db/postgresql#catalog::t
             '#f)))
         _mixin217455_)
        (if (##fx< '2 (##vector-length _self217454_))
            (begin
              (##vector-set! _self217454_ '1 _s217457_)
              (##vector-set! _self217454_ '2 _d217458_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self217454_)))))
  (bind-method!
   std/db/postgresql#catalog::t
   ':init!
   std/db/postgresql#catalog:::init!
   '#f)
  (define std/db/postgresql#catalog-serializer
    (lambda (_c217329_ _oid217330_)
      (table-ref
       (##direct-structure-ref _c217329_ '1 std/db/postgresql#catalog::t '#f)
       _oid217330_
       '#f)))
  (define std/db/postgresql#catalog-deserializer
    (lambda (_c217326_ _oid217327_)
      (table-ref
       (##direct-structure-ref _c217326_ '2 std/db/postgresql#catalog::t '#f)
       _oid217327_
       '#f)))
  (define std/db/postgresql#serialize-boolean
    (lambda (_arg217324_) (if _arg217324_ '"t" '"f")))
  (define std/db/postgresql#deserialize-boolean
    (lambda (_str217322_)
      (if (member _str217322_ '("t" "true" "TRUE" "y" "yes" "on" "1"))
          '#t
          '#f)))
  (define std/db/postgresql#serialize-date
    (lambda (_date217320_)
      (std/srfi/19#date->string _date217320_ '"~Y-~m-~d")))
  (define std/db/postgresql#deserialize-date
    (lambda (_str217318_) (std/srfi/19#string->date _str217318_ '"~Y-~m-~d")))
  (define std/db/postgresql#serialize-timestamp
    (lambda (_date217316_)
      (std/srfi/19#date->string _date217316_ '"~Y-~m-~d ~H:~M:~S")))
  (define std/db/postgresql#deserialize-timestamp
    (lambda (_str217314_)
      (std/srfi/19#string->date _str217314_ '"~Y-~m-~d ~H:~M:~S")))
  (define std/db/postgresql#serialize-timestamptz
    (lambda (_date217312_)
      (std/srfi/19#date->string _date217312_ '"~Y-~m-~d ~H:~M:~S~z")))
  (define std/db/postgresql#deserialize-timestamptz
    (lambda (_str217310_)
      (std/srfi/19#string->date _str217310_ '"~Y-~m-~d ~H:~M:~S~z")))
  (define std/db/postgresql#identity-string
    (lambda (_obj217308_)
      (if (string? _obj217308_)
          _obj217308_
          (error '"Bad argument; expected string" _obj217308_))))
  (define std/db/postgresql#default-catalog
    (let ((__obj219375 (make-object std/db/postgresql#catalog::t '2)))
      (std/db/postgresql#catalog:::init! __obj219375)
      __obj219375))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '16
   std/db/postgresql#serialize-boolean)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '16
   std/db/postgresql#deserialize-boolean)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '20
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '21
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '23
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '700
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '701
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1700
   number->string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '20
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '21
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '23
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '700
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '701
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1700
   string->number)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '18
   std/db/postgresql#identity-string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '25
   std/db/postgresql#identity-string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1042
   std/db/postgresql#identity-string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1043
   std/db/postgresql#identity-string)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '18
   identity)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '25
   identity)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1042
   identity)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1043
   identity)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1082
   std/db/postgresql#serialize-date)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1082
   std/db/postgresql#deserialize-date)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1114
   std/db/postgresql#serialize-timestamp)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1114
   std/db/postgresql#deserialize-timestamp)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '1
    std/db/postgresql#catalog::t
    '#f)
   '1184
   std/db/postgresql#serialize-timestamptz)
  (table-set!
   (##direct-structure-ref
    std/db/postgresql#default-catalog
    '2
    std/db/postgresql#catalog::t
    '#f)
   '1184
   std/db/postgresql#deserialize-timestamptz)
  (define std/db/postgresql#current-catalog
    (make-parameter std/db/postgresql#default-catalog)))
